/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.scale;

import com.dev63.restoran.scale.IMeasurement;
import com.dev63.restoran.scale.IScale;
import com.dev63.restoran.scale.overfolder.OverFolderScale;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScaleProvider {
    public static IScale getScale(ScaleProtocol protocol, Object ... params) {
        if (protocol == null) {
            return null;
        }
        switch (protocol) {
            case OVER_FOLDER: {
                try {
                    String folder = params.length > 0 && params[0] instanceof String ? (String)params[0] : null;
                    return folder == null ? OverFolderScale.getInstance() : OverFolderScale.getInstance(folder);
                }
                catch (IOException ex) {
                    Logger.getLogger(ScaleProvider.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    return null;
                }
            }
        }
        return null;
    }

    public static IScale getScale(String protocolNameOrAlias, Object ... params) {
        ScaleProtocol protocol = ScaleProtocol.findProtocol(protocolNameOrAlias);
        return ScaleProvider.getScale(protocol, params);
    }

    public static void main(String ... args) throws InterruptedException, Exception {
        try (IScale scale = ScaleProvider.getScale(ScaleProtocol.OVER_FOLDER, "C:\\Barmaster\\scale");){
            final FutureTask<? extends IMeasurement> measure = scale.measure();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    measure.cancel(true);
                }
            });
            t.start();
            boolean success = false;
            do {
                try {
                    System.out.println(measure.get(5L, TimeUnit.SECONDS).getMeasurment().toPlainString());
                    success = true;
                }
                catch (CancellationException cex) {
                    System.out.println("Measurement cancelled");
                    break;
                }
                catch (TimeoutException ex) {
                    System.out.println("Still waiting : " + ex.getMessage());
                }
            } while (!success);
        }
    }

    public static enum ScaleProtocol {
        OVER_FOLDER("folder", "Folder", "FOLDER");

        private String[] protocolAliases;

        private ScaleProtocol(String ... protocolAliases) {
            this.protocolAliases = protocolAliases;
        }

        public static ScaleProtocol findProtocol(String nameOrAlias) {
            for (ScaleProtocol protocol : ScaleProtocol.values()) {
                if (protocol.name().equals(nameOrAlias)) {
                    return protocol;
                }
                for (String alias : protocol.protocolAliases) {
                    if (!alias.equals(nameOrAlias)) continue;
                    return protocol;
                }
            }
            return null;
        }
    }
}

