/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.scale;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.scale.IMeasurement;
import com.dev63.restoran.scale.IScale;
import com.dev63.restoran.scale.ScaleProvider;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ScaleMeasuringInitiationWindow
extends Window {
    private static final Logger log = Logger.getLogger(ScaleMeasuringInitiationWindow.class.getName());
    private volatile IScale scale;
    private volatile IMeasurement result;
    private Thread thread;

    public ScaleMeasuringInitiationWindow(IShellProvider shellProvider, IScale scale) {
        super(shellProvider);
        this.setUp(scale);
    }

    public ScaleMeasuringInitiationWindow(Shell parentShell, IScale scale) {
        super(parentShell);
        this.setUp(scale);
    }

    private void setUp(IScale scale) {
        this.setBlockOnOpen(true);
        this.scale = scale;
    }

    protected Layout getLayout() {
        return super.getLayout();
    }

    protected int getShellStyle() {
        return 8;
    }

    protected Control createContents(Composite parent) {
        Font buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        Color buttCol = new Color((Device)this.getShell().getDisplay(), BMTerminalSettings.getFOTheme().getButtonFontColor());
        Composite child = new Composite(parent, 2048);
        child.setLayout((Layout)new GridLayout());
        Label label = new Label(child, 0x1000000);
        label.setFont(buttFont);
        label.setForeground(buttCol);
        label.setText("Molimo sa\u010dekajte, merenje je u toku");
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        ProgressBar pb = new ProgressBar(child, 2);
        pb.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ImageButton b = new ImageButton(child, 72);
        b.setText("Otka\u017ei");
        b.setFont(buttFont);
        b.setForeground(buttCol);
        b.setLayoutData(new GridData(4, 0x1000000, true, true));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaleMeasuringInitiationWindow.this.close();
            }
        });
        return child;
    }

    public boolean close() {
        this.interruptMeasurement();
        return super.close();
    }

    private void interruptMeasurement() {
        if (this.thread != null && this.thread.isAlive() && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    public void reset() {
        this.result = null;
        this.thread = null;
    }

    public int open() {
        this.reset();
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.thread = new Thread((Runnable)new MeasurmentRunner(), "Measurment Runner");
        this.thread.start();
        return super.open();
    }

    public IMeasurement getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        try (IScale scale = ScaleProvider.getScale(ScaleProvider.ScaleProtocol.OVER_FOLDER, "C:\\Barmaster\\scale");){
            ScaleMeasuringInitiationWindow w = new ScaleMeasuringInitiationWindow((Shell)null, scale);
            w.setBlockOnOpen(true);
            w.open();
        }
        finally {
            Display.getCurrent().dispose();
        }
    }

    private class MeasurmentRunner
    implements Runnable {
        private MeasurmentRunner() {
        }

        @Override
        public void run() {
            boolean success = false;
            FutureTask<? extends IMeasurement> task = ScaleMeasuringInitiationWindow.this.scale.measure();
            try {
                do {
                    try {
                        Thread.sleep(400L);
                        if (Thread.currentThread().isInterrupted()) {
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                    try {
                        ScaleMeasuringInitiationWindow.this.result = task.get(100L, TimeUnit.MILLISECONDS);
                        success = true;
                        System.out.println(ScaleMeasuringInitiationWindow.this.result.getMeasurment().toPlainString());
                    }
                    catch (TimeoutException ex) {
                        System.out.println("Still waiting measurement to complete");
                    }
                } while (!success);
            }
            catch (InterruptedException | ExecutionException eex) {
                if (task != null && !task.isCancelled() && !task.isDone()) {
                    task.cancel(true);
                }
                log.log(Level.SEVERE, eex.getMessage(), eex);
                ScaleMeasuringInitiationWindow.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SWTMessage.showLocalizedErrorDialog(ScaleMeasuringInitiationWindow.this.getShell(), "Do\u0161lo je do gre\u0161ke prilikom \u010ditanja merenja!");
                    }
                });
            }
            catch (CancellationException cex) {
                System.out.println("Measurement cancelled");
            }
            if (task != null && !task.isCancelled() && !task.isDone()) {
                task.cancel(true);
            }
            ScaleMeasuringInitiationWindow.this.setReturnCode(success ? 0 : 1);
            if (ScaleMeasuringInitiationWindow.this.getShell() != null && !ScaleMeasuringInitiationWindow.this.getShell().isDisposed()) {
                ScaleMeasuringInitiationWindow.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScaleMeasuringInitiationWindow.this.close();
                    }
                });
            }
        }
    }
}

