/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.reports.beans;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RacunStavkaBean {
    private String naziv;
    private String jm;
    private BigDecimal kolicina;
    private BigDecimal cena;
    private String popust;
    private String pdvProc;
    private BigDecimal pdv;
    private BigDecimal cenaNoPdv;
    private BigDecimal iznos;

    public RacunStavkaBean() {
    }

    public RacunStavkaBean(StavkaRacuna stavka) {
        Artikal artikal = stavka.getArtikal();
        this.naziv = artikal.getName();
        this.jm = artikal.getJedinicaMere().toString();
        this.kolicina = BigDecimal.valueOf(stavka.getKolicina()).setScale(3, RoundingMode.HALF_EVEN);
        this.cena = artikal.getTip() != TipArtikla.SLOZ ? BigDecimal.valueOf(stavka.getCenaBezPopusta()).setScale(2, RoundingMode.HALF_EVEN) : BigDecimal.valueOf(stavka.getCena()).setScale(2, RoundingMode.HALF_EVEN);
        this.pdvProc = Double.valueOf(Konstante.getPdvPoPG(artikal.getPoreskaGrupa()) * 100.0) + "%";
        this.popust = new BigDecimal("100").subtract(BigDecimal.valueOf(stavka.getCena()).multiply(new BigDecimal("100")).divide(BigDecimal.valueOf(stavka.getCenaBezPopusta()), 2, RoundingMode.HALF_EVEN)) + "%";
        this.iznos = BigDecimal.valueOf(stavka.getKolicina()).multiply(BigDecimal.valueOf(stavka.getCena())).setScale(2, RoundingMode.HALF_EVEN);
        this.cenaNoPdv = this.iznos.divide(BigDecimal.ONE.add(BigDecimal.valueOf(Konstante.getPdvPoPG(artikal.getPoreskaGrupa()))), 2, RoundingMode.HALF_EVEN);
        this.pdv = this.iznos.subtract(this.cenaNoPdv).setScale(2, RoundingMode.HALF_EVEN);
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public String getJm() {
        return this.jm;
    }

    public void setJm(String jm) {
        this.jm = jm;
    }

    public BigDecimal getKolicina() {
        return this.kolicina;
    }

    public void setKolicina(BigDecimal kolicina) {
        this.kolicina = kolicina;
    }

    public BigDecimal getCena() {
        return this.cena;
    }

    public void setCena(BigDecimal cena) {
        this.cena = cena;
    }

    public String getPopust() {
        return this.popust;
    }

    public void setPopust(String popust) {
        this.popust = popust;
    }

    public String getPdvProc() {
        return this.pdvProc;
    }

    public void setPdvProc(String pdvProc) {
        this.pdvProc = pdvProc;
    }

    public BigDecimal getPdv() {
        return this.pdv;
    }

    public void setPdv(BigDecimal pdv) {
        this.pdv = pdv;
    }

    public BigDecimal getCenaNoPdv() {
        return this.cenaNoPdv;
    }

    public void setCenaNoPdv(BigDecimal cenaNoPdv) {
        this.cenaNoPdv = cenaNoPdv;
    }

    public BigDecimal getIznos() {
        return this.iznos;
    }

    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }
}

