/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.reports.JasperModels;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GenericExcelModel {
    File file;
    String folder;

    public GenericExcelModel(File file, String folder) {
        this.file = file;
        this.folder = folder;
    }

    public void generateExcelFile(String[] columns, int[] columnwidth, String sheetName, short height, List<List<Object>> datas) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetName);
        XSSFRow headerRow = this.createHeader(sheet, height, columnwidth, columns);
        this.populateRows(datas, sheet);
        this.writeToFile(workbook);
    }

    private XSSFRow createHeader(XSSFSheet sheet, short height, int[] columnwidth, String[] columns) {
        XSSFRow header = sheet.createRow(0);
        header.setHeight(height);
        for (int i = 0; i < columns.length; ++i) {
            header.createCell(i).setCellValue(columns[i]);
            sheet.setColumnWidth(i, columnwidth[i] * 80);
        }
        return header;
    }

    private void populateRows(List<List<Object>> datas, XSSFSheet sheet) {
        int rowIndex = 1;
        for (List<Object> objects : datas) {
            XSSFRow row = sheet.createRow(rowIndex);
            int cellIndex = 0;
            for (Object object : objects) {
                row.createCell(cellIndex++).setCellValue(String.valueOf(object));
            }
            ++rowIndex;
        }
    }

    private void writeToFile(XSSFWorkbook workbook) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.folder + File.separator + this.file.getName() + ".xlsx");
            workbook.write((OutputStream)fileOutputStream);
            workbook.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

