/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.reports.JasperModels;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.reports.JasperModels.GenericExcelModel;
import com.dev63.restoran.reports.JasperModels.GenericFileChooser;
import com.dev63.restoran.reports.JasperModels.GenericPdfModel;
import com.dev63.restoran.reports.JasperModels.GenericTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.swing.JRViewer;
import net.sf.jasperreports.swing.JRViewerToolbar;

public class DpuJasperCall {
    private RestoranServer server;
    private static List<List<Object>> dpuDatas;
    private String[] colNames = new String[]{"redniBroj", "naziv", "pdv", "jedinicaMere", "pocetno", "ulaz", "ukupno", "preostalo", "utroseno", "cena", "odPica", "odJela", "konzumacija", "odeljenje"};
    private int[] colWidth = new int[]{30, 100, 30, 30, 30, 30, 30, 30, 30, 50, 50, 50, 50, 50};
    private short colHeight;
    private Map<String, String> filteri;
    private Map<String, Double> iznosPoNacinimaPlacanja;
    List<List<Object>> listForExcel;

    public DpuJasperCall(List<List<Object>> dpuDatas, Map<String, Double> iznosPoNacinimaPlacanja, RestoranServer server) {
        this.iznosPoNacinimaPlacanja = iznosPoNacinimaPlacanja;
        this.server = server;
        this.filteri = new HashMap<String, String>();
        this.filteri.put("Pdf", "pdf");
        this.filteri.put("Excel", "xlsx");
        DpuJasperCall.dpuDatas = dpuDatas;
        this.listForExcel = new ArrayList<List<Object>>();
        this.listForExcel.addAll(dpuDatas);
        this.colHeight = (short)300;
    }

    public void jasperStart(String pice, String jelo, String ukupno, String konzumacija, String nazivFirme, String adresaFirme, String pibFirme, String datum, long zdBroj) {
        HashMap<String, Object> parametri = new HashMap<String, Object>();
        Connection conn = this.server.getConnection();
        parametri.put("pice1", pice);
        parametri.put("jelo", jelo);
        parametri.put("konzumacija", konzumacija);
        parametri.put("picejelo", ukupno);
        parametri.put("nazivFirme", nazivFirme);
        parametri.put("adresaFirme", adresaFirme);
        parametri.put("pibFirme", pibFirme);
        parametri.put("dpuDatum", datum);
        parametri.put("naciniPlacanja", this.iznosPoNacinimaPlacanja);
        parametri.put("connection", conn);
        parametri.put("zdBroj", zdBroj);
        try {
            GenericTableModel tableModel = new GenericTableModel(this.colNames, dpuDatas);
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)"com/dev63/restoran/reports/templates/dpuListaUtrosci.jasper"));
            final JasperPrint printJasper = JasperFillManager.fillReport((JasperReport)report, parametri, (JRDataSource)new JRTableModelDataSource((TableModel)tableModel));
            JFrame jFrame = new JFrame("Dpu Lista");
            JRViewer viewer = new JRViewer(printJasper);
            final JRViewerToolbar toolbar = (JRViewerToolbar)viewer.getComponent(0);
            JButton saveButton = (JButton)toolbar.getComponent(0);
            ActionListener[] listeners = saveButton.getActionListeners();
            for (int i = 0; i < listeners.length; ++i) {
                saveButton.removeActionListener(listeners[i]);
            }
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DpuJasperCall.this.exportToSelectedFile(toolbar, printJasper);
                }
            });
            jFrame.add((Component)viewer);
            jFrame.setSize(new Dimension(500, 400));
            jFrame.setLocationRelativeTo(null);
            jFrame.setExtendedState(jFrame.getExtendedState() | 6);
            jFrame.setDefaultCloseOperation(2);
            jFrame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportToSelectedFile(JRViewerToolbar toolbar, JasperPrint jPrint) {
        GenericFileChooser chooser = new GenericFileChooser(this.filteri);
        Map<String, Object> fromFileChooser = chooser.getMapFromFileChooser(toolbar);
        FileFilter filter = (FileFilter)fromFileChooser.get("FileFilter");
        File file = (File)fromFileChooser.get("File");
        String folder = (String)fromFileChooser.get("FileFolder");
        switch (filter.getDescription()) {
            case "Excel": {
                GenericExcelModel excelModel = new GenericExcelModel(file, folder);
                excelModel.generateExcelFile(this.colNames, this.colWidth, "dpuLista", this.colHeight, this.listForExcel);
                break;
            }
            case "Pdf": {
                System.out.println("Exportujem u pdf");
                GenericPdfModel genericPdfModel = new GenericPdfModel(file, folder, jPrint);
                break;
            }
            default: {
                System.out.println("Ne radim Nista");
            }
        }
    }
}

