/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.rekonstrukcija;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.rekonstrukcija.NormativRekonstrukcija;
import com.dev63.restoran.rekonstrukcija.StavkeRekonstrukcija;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Shell;

public class RekonstrukcijaUtrosci {
    Shell shell;
    java.util.Date datum;
    Connection connection;
    StavkeRekonstrukcija srk;
    NormativRekonstrukcija nrk;
    Map<List<Object>, DoubleSummaryStatistics> utrosciZaUpis;
    RestoranServer server;

    public RekonstrukcijaUtrosci(RestoranServer server, java.util.Date datum, Shell shell, boolean rekonstrusemZd) {
        this.shell = shell;
        this.datum = datum;
        this.server = server;
        this.connection = server.getConnection();
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.srk = new StavkeRekonstrukcija(server);
        this.nrk = new NormativRekonstrukcija(server);
        this.Rekonstruisi(rekonstrusemZd);
    }

    private void Rekonstruisi(boolean rekonstruisemZd) {
        if (rekonstruisemZd) {
            this.rekonstrukcijaZd();
        }
        Shell poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija dnevnog utro\u0161ka u toku, sa\u010dekajte sa radom");
        this.obrisiUtroske(this.datum);
        this.upisiUtroske(this.datum);
        poruka1.close();
        poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija proizvodnje u toku, sa\u010dekajte sa radom");
        this.obrisiUtroskeDokumenta(this.datum, "PR");
        this.upisiUtroskeDokumenta(this.datum, "PR");
        poruka1.close();
        poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija otpisa u toku, sa\u010dekajte sa radom");
        this.obrisiUtroskeDokumenta(this.datum, "OTP");
        this.upisiUtroskeDokumenta(this.datum, "OTP");
        poruka1.close();
        poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija UtrodskaDoc u toku, sa\u010dekajte sa radom");
        this.obrisiUtroskeDokumenta(this.datum, "UDU");
        this.upisiUtroskeDokumenta(this.datum, "UDU");
        poruka1.close();
        this.rekonstrusiAkutelanDan();
        Konstante.prikaziMessageBox(this.shell, "Rekonstrukcija je zavr\u0161ena");
    }

    private void rekonstrusiAkutelanDan() {
        System.out.println("Aktuelan daaaaaan");
        Shell poruka1 = Konstante.getPoruka2(this.shell, "Rekonstrukcija aktuelni dan");
        java.util.Date datum = this.server.getLastDateZD();
        this.srediZd(datum, true, this.server);
        this.obrisiUtroske(datum);
        this.upisiUtroske(datum);
        this.obrisiUtroskeDokumenta(datum, "PR");
        this.upisiUtroskeDokumenta(datum, "PR");
        this.obrisiUtroskeDokumenta(datum, "OTP");
        this.upisiUtroskeDokumenta(datum, "OTP");
        this.obrisiUtroskeDokumenta(datum, "UDU");
        this.upisiUtroskeDokumenta(datum, "UDU");
        this.srediZd(datum, false, this.server);
        poruka1.close();
    }

    private Map<List<Object>, DoubleSummaryStatistics> vratiUtroskeZaUpis(java.util.Date datum, String dokument) {
        double kolicina = 0.0;
        List<StavkeRekonstrukcija> listaStavki = dokument.isEmpty() ? this.srk.getStavkeRekonsrukcija(datum) : this.srk.getStavkeRekonsrukcijaDokument(datum, dokument);
        LinkedList<StavkeRekonstrukcija> konacnaListaStavki = new LinkedList<StavkeRekonstrukcija>();
        for (StavkeRekonstrukcija stavka : listaStavki) {
            kolicina = stavka.getKolicina();
            if (dokument.equals("PR")) {
                konacnaListaStavki.addAll(this.nrk.razloziArtikal(kolicina, stavka));
                continue;
            }
            if (stavka.getTip() == TipArtikla.SLOZ || stavka.getTip() == TipArtikla.DODA) {
                konacnaListaStavki.addAll(this.nrk.razloziArtikal(kolicina, stavka));
                continue;
            }
            konacnaListaStavki.add(stavka);
        }
        for (StavkeRekonstrukcija sr : konacnaListaStavki) {
            System.out.println(sr.getNaziv());
        }
        if (dokument.isEmpty()) {
            return konacnaListaStavki.stream().sorted(Comparator.comparingInt(x -> x.getZdBroj())).collect(Collectors.groupingBy(x -> Arrays.asList(x.getZdBroj(), x.getArtikal_id(), x.isCrno(), x.getOdeljenje_id()), Collectors.summarizingDouble(x -> x.getKolicina())));
        }
        return konacnaListaStavki.stream().collect(Collectors.groupingBy(x -> Arrays.asList(x.getDokument_id(), x.getArtikal_id(), x.getOdeljenje_id()), Collectors.summarizingDouble(x -> x.getKolicina())));
    }

    private void obrisiUtroske(java.util.Date datumOd) {
        Date od = new Date(datumOd.getTime());
        String deleteQuery = "delete from dnevniutrosak where zdBroj >= (select zdBroj from zd where datum = ? and pocetak = 1) ";
        try {
            PreparedStatement st = this.connection.prepareStatement(deleteQuery);
            st.setDate(1, od);
            st.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void obrisiUtroskeDokumenta(java.util.Date datumOd, String dokument) {
        Date od = new Date(datumOd.getTime());
        String deleteProizvodnjaUtrosci = "delete from proizvodnjautrosak where proizvodnja_id in (select id from proizvodnja where datum >= ?) ";
        String deleteOtpisUtrosci = "delete from otpisutrosak where otpis_id in (select id from otpis where datum >= ?) ";
        String deleteUtrosakDocUtrosci = "delete from utrosakdocutrosak where utrosakdoc_id in (select id from utrosakdoc where datum >= ?) ";
        try {
            PreparedStatement ps;
            switch (dokument) {
                case "PR": {
                    ps = this.connection.prepareStatement(deleteProizvodnjaUtrosci);
                    break;
                }
                case "OTP": {
                    ps = this.connection.prepareStatement(deleteOtpisUtrosci);
                    break;
                }
                case "UDU": {
                    ps = this.connection.prepareStatement(deleteUtrosakDocUtrosci);
                    break;
                }
                default: {
                    ps = this.connection.prepareStatement("");
                }
            }
            ps.setDate(1, od);
            ps.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void upisiUtroske(java.util.Date datum) {
        String insertQuery = "INSERT INTO dnevniutrosak (dodatno, kolicina, nabavnaCena, zdBroj, ARTIKAL_ID, ODELJENJE_ID )\nVALUES (?,?,?,?,?,?);";
        this.utrosciZaUpis = this.vratiUtroskeZaUpis(datum, "");
        try {
            PreparedStatement ps = this.connection.prepareStatement(insertQuery);
            for (Map.Entry<List<Object>, DoubleSummaryStatistics> set : this.utrosciZaUpis.entrySet()) {
                List<Object> list = set.getKey();
                System.out.println(list);
                int zdBroj = (Integer)list.get(0);
                long artikal_id = (Long)list.get(1);
                boolean crno = (Boolean)list.get(2);
                long odeljenje_id = (Long)list.get(3);
                double kolicina = set.getValue().getSum();
                ps.setBoolean(1, crno);
                ps.setDouble(2, kolicina);
                ps.setDouble(3, 0.0);
                ps.setInt(4, zdBroj);
                ps.setLong(5, artikal_id);
                ps.setLong(6, odeljenje_id);
                ps.execute();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void upisiUtroskeDokumenta(java.util.Date datum, String dokument) {
        String insertProizvodnjaUtrosci = "INSERT INTO proizvodnjautrosak ( kolicina, nabavnaCena, PROIZVODNJA_ID, ARTIKAL_ID, ODELJENJE_ID )\nVALUES (?,?,?,?,?);";
        String insertOtpisUtrosci = "INSERT INTO otpisutrosak ( kolicina, nabavnaCena, OTPIS_ID, ARTIKAL_ID, ODELJENJE_ID )\nVALUES (?,?,?,?,?);";
        String insertUtrosakDocUtrosci = "INSERT INTO utrosakdocutrosak ( kolicina, nabavnaCena, UTROSAKDOC_ID, ARTIKAL_ID, ODELJENJE_ID )\nVALUES (?,?,?,?,?);";
        this.utrosciZaUpis = this.vratiUtroskeZaUpis(datum, dokument);
        try {
            PreparedStatement ps;
            void var8_12;
            String string = dokument;
            int n = -1;
            switch (string.hashCode()) {
                case 2562: {
                    if (!string.equals("PR")) break;
                    boolean bl = false;
                    break;
                }
                case 78603: {
                    if (!string.equals("OTP")) break;
                    boolean bl = true;
                    break;
                }
                case 83878: {
                    if (!string.equals("UDU")) break;
                    int n2 = 2;
                }
            }
            switch (var8_12) {
                case 0: {
                    ps = this.connection.prepareStatement(insertProizvodnjaUtrosci);
                    break;
                }
                case 1: {
                    ps = this.connection.prepareStatement(insertOtpisUtrosci);
                    break;
                }
                case 2: {
                    ps = this.connection.prepareStatement(insertUtrosakDocUtrosci);
                    break;
                }
                default: {
                    ps = this.connection.prepareStatement("");
                }
            }
            for (Map.Entry entry : this.utrosciZaUpis.entrySet()) {
                List list = (List)entry.getKey();
                System.out.println(list);
                long dokument_id = (Long)list.get(0);
                long artikal_id = (Long)list.get(1);
                long odeljenje_id = (Long)list.get(2);
                double kolicina = ((DoubleSummaryStatistics)entry.getValue()).getSum();
                ps.setDouble(1, kolicina);
                ps.setDouble(2, 0.0);
                ps.setLong(3, dokument_id);
                ps.setLong(4, artikal_id);
                ps.setLong(5, odeljenje_id);
                ps.execute();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void rekonstrukcijaZd() {
        Shell poruka = Konstante.getPoruka2(this.shell, "Rekonstrukcija radnih dana u toku, sa\u010dekajte sa radom");
        this.server.updateZdBrojNUllzaPeriod(this.datum);
        if (this.server.getZdBrojIsNull()) {
            java.util.Date firstPrviZd = this.server.getDatumisNotNUll();
            boolean prodji = true;
            long zdBroj = this.server.getZdBrojisNotNUllMax();
            for (ZD zd : this.server.getAllZDListZdBrojNUll()) {
                if (firstPrviZd.compareTo(zd.getDatum()) != 0) {
                    firstPrviZd = zd.getDatum();
                    prodji = true;
                }
                if (prodji) {
                    zd.setZdBroj(++zdBroj);
                    prodji = false;
                } else {
                    zd.setZdBroj(zdBroj);
                }
                this.rekonstrusiZdBroj(zd);
            }
        }
        if (this.server.getRacunZdBrojIsNull()) {
            this.server.updateRacunZdBroj();
        }
        poruka.close();
    }

    private void rekonstrusiZdBroj(ZD zd) {
        String query = "update zd set zdBroj = ? where id =?";
        try {
            PreparedStatement updateStatement = this.connection.prepareStatement(query);
            updateStatement.setLong(1, zd.getZdBroj());
            updateStatement.setLong(2, zd.getId());
            updateStatement.execute();
            this.connection.commit();
            System.out.println(updateStatement);
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void srediZd(java.util.Date datum, boolean rekonstrukcija, RestoranServer server) {
        String query = "update zd SET rekonstrukcija = ? WHERE datum = ? AND pocetak = 1";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setBoolean(1, rekonstrukcija);
            ps.setDate(2, new Date(datum.getTime()));
            ps.execute();
            this.connection.commit();
            ZD zd = server.getLastOpenZD();
            System.out.println("rekonstrukcija: " + zd.getRekonstrukcija());
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }
}

