/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.patches;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.GlavniMeniPodgrupa;
import com.dev63.restoran.model.Login;
import com.dev63.restoran.model.enums.MeniPodgrupe;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MeniPodgrupaPatch {
    RestoranServer server;
    Connection connection;
    List<GlavniMeniPodgrupa> dbPodgrupe;

    public MeniPodgrupaPatch(RestoranServer server) {
        this.server = server;
        this.connection = server.getConnection();
        this.dbPodgrupe = this.getInsertedMeniPodgrupe();
    }

    public void insertMissingMeniPodgrupe() {
        MeniPodgrupe[] podgrupe;
        for (MeniPodgrupe mp : podgrupe = MeniPodgrupe.values()) {
            if (this.podgrupaIsInDataBase(mp)) continue;
            Long id = this.insertMeniPodgrupe(mp);
            for (Login login : this.server.getLogins()) {
                this.insertMeniPodgrupeLogin(mp, login, id);
            }
        }
    }

    private boolean podgrupaIsInDataBase(MeniPodgrupe mp) {
        for (GlavniMeniPodgrupa gmPg : this.dbPodgrupe) {
            if (!mp.getNaziv().equals(gmPg.getNaziv())) continue;
            return true;
        }
        return false;
    }

    private long insertMeniPodgrupe(MeniPodgrupe meniPodgrupa) {
        String query = "INSERT INTO glavnimenipodgrupa (glavniMeniId, naziv,vidljiv) VALUES (?,?,?)";
        boolean isExecuted = false;
        try {
            PreparedStatement ps = this.connection.prepareStatement(query, 1);
            ps.setLong(1, meniPodgrupa.getGrupaId());
            ps.setString(2, meniPodgrupa.getNaziv());
            ps.setBoolean(3, meniPodgrupa.isVidljiv());
            isExecuted = ps.execute();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            return rs.getLong(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private boolean insertMeniPodgrupeLogin(MeniPodgrupe meniPodgrupa, Login login, Long id) {
        String query = "INSERT INTO glavnimenipodgrupalogin (LoginId, glavniMeniPodgrupaId,podgrupaNaziv) VALUES (?,?,?)";
        boolean isExecuted = false;
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, login.getId());
            ps.setLong(2, id);
            ps.setString(3, meniPodgrupa.getNaziv());
            isExecuted = ps.execute();
            return isExecuted;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return isExecuted;
        }
    }

    private List<GlavniMeniPodgrupa> getInsertedMeniPodgrupe() {
        String query = "SELECT * FROM glavnimenipodgrupa";
        ArrayList<GlavniMeniPodgrupa> podgrupaList = new ArrayList<GlavniMeniPodgrupa>();
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GlavniMeniPodgrupa gmpg = new GlavniMeniPodgrupa(rs.getString("naziv"), rs.getLong("glavniMeniId"), rs.getBoolean("vidljiv"));
                podgrupaList.add(gmpg);
            }
            return podgrupaList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

