/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.fiscal.FiscalItem;
import com.dev63.fiscal.FiscalRecipet;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.controller.SettingController;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SerializationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriter {
    static final String FILE_DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss-SS";
    static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SS");
    public static final DateFormat format = new SimpleDateFormat("dd.MM.yy");
    static String path = SettingController.loadString(OptionBO.RMI_PUTANJA);
    static String tmp = SettingController.loadString(OptionBO.RMI_TEMP_PUTANJA);
    static final Object lock = new Object();

    private XMLWriter() {
    }

    public static synchronized void writePosRequest(Double suma, RestoranServer server) {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = null;
        try {
            domBuilder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("Kartica");
        rootElement.setTextContent("" + suma);
        newDoc.appendChild(rootElement);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = null;
        try {
            aTransformer = tranFactory.newTransformer();
            aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(newDoc);
            String path1 = tmp + d + ".xml";
            File f = new File(path1);
            while (f.exists()) {
                d = df.format(new Date());
                path1 = tmp + d + ".xml";
                f = new File(path1);
            }
            StreamResult dest = new StreamResult(f);
            aTransformer.transform(src, dest);
            Kasa k = (Kasa)SerializationUtils.clone((Serializable)server.getCurrentCounter());
            try {
                FileUtils.copyFile((File)f, (File)new File(tmp + "posterminal_" + k + "_" + d + ".xml"));
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void writeNonFiscal(List<String> blok) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("NefiskalnaStampa");
        newDoc.appendChild(rootElement);
        for (String line : blok) {
            Element c1 = newDoc.createElement("Linija");
            c1.setTextContent(line);
            rootElement.appendChild(c1);
        }
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static void printUskiGotovinskiRMI(String content) {
        try {
            String[] finalContent;
            String d = df.format(new Date());
            String line = "";
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document newDoc = domBuilder.newDocument();
            Element rootElement = newDoc.createElement("NefiskalnaStampa");
            newDoc.appendChild(rootElement);
            content = content.replace("\n", ",");
            content = content.replace("-", "*");
            for (String fc : finalContent = content.split(",")) {
                Element c1 = newDoc.createElement("Linija");
                if (fc.contains("PIB:")) {
                    fc = fc.replace("PIB:", "Poreski broj:").substring(0, 32);
                }
                c1.setTextContent(fc);
                rootElement.appendChild(c1);
            }
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(newDoc);
            String path1 = tmp + d + ".xml.tmp";
            File f = new File(path1);
            while (f.exists()) {
                d = df.format(new Date());
                path1 = tmp + d + ".xml.tmp";
                f = new File(path1);
            }
            StreamResult dest = new StreamResult(f);
            aTransformer.transform(src, dest);
            int cnt = 0;
            File f2 = new File(path + d + ".xml");
            while (!f.renameTo(f2)) {
                if (++cnt >= 100) {
                    Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                    break;
                }
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
                if (cnt % 10 != 0) continue;
                d = df.format(new Date());
                f2 = new File(path + d + ".xml");
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void writePeriodReport(Date from, Date to) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("Periodicni");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("FromDate");
        e1.setTextContent(format.format(from));
        rootElement.appendChild(e1);
        Element e2 = newDoc.createElement("ToDate");
        e2.setTextContent(format.format(to));
        rootElement.appendChild(e2);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeMemmoryReport(int from, int to, int opt) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("IzvestajIzMemorije");
        newDoc.appendChild(rootElement);
        Element e1 = newDoc.createElement("fromNo");
        e1.setTextContent("" + from);
        rootElement.appendChild(e1);
        Element e2 = newDoc.createElement("toNo");
        e2.setTextContent("" + to);
        rootElement.appendChild(e2);
        Element e3 = newDoc.createElement("option");
        e3.setTextContent("" + opt);
        rootElement.appendChild(e3);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeReport(int command) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("Izvestaj");
        rootElement.setTextContent("" + command);
        newDoc.appendChild(rootElement);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeFiscalReciept(FiscalRecipet fis, String konobar) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("FiscalRecipet");
        newDoc.appendChild(rootElement);
        for (FiscalItem f : fis.getItems()) {
            Element e1 = newDoc.createElement("FiscalItem");
            Element c1 = newDoc.createElement("Naziv");
            c1.setTextContent(f.getNaziv());
            e1.appendChild(c1);
            c1 = newDoc.createElement("Cena");
            c1.setTextContent("" + f.getCena());
            e1.appendChild(c1);
            c1 = newDoc.createElement("Kolicina");
            c1.setTextContent("" + f.getKolicina());
            e1.appendChild(c1);
            c1 = newDoc.createElement("PoreskaGrupa");
            c1.setTextContent("" + f.getPoreskaGrupa());
            e1.appendChild(c1);
            rootElement.appendChild(e1);
        }
        Element e2 = newDoc.createElement("Placanje");
        Element c1 = newDoc.createElement("Gotovina");
        c1.setTextContent("" + fis.getPlatiGotovinom());
        e2.appendChild(c1);
        c1 = newDoc.createElement("Cek");
        c1.setTextContent("" + fis.getPlatiCekom());
        e2.appendChild(c1);
        c1 = newDoc.createElement("Kartica");
        c1.setTextContent("" + fis.getPlatiKarticom());
        e2.appendChild(c1);
        rootElement.appendChild(e2);
        e2 = newDoc.createElement("Konobar");
        e2.setTextContent(konobar);
        rootElement.appendChild(e2);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeDeposit(double deposit) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("Depozit");
        newDoc.appendChild(rootElement);
        NumberFormat nf = NumberFormat.getInstance(Locale.GERMAN);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(false);
        Element c1 = newDoc.createElement("Iznos");
        c1.setTextContent(nf.format(deposit));
        rootElement.appendChild(c1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeDisplayPreview(String line1, String line2) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("PrikazNaDispleju");
        newDoc.appendChild(rootElement);
        Element c1 = newDoc.createElement("Linija1");
        c1.setTextContent(line1 == null ? "" : line1);
        rootElement.appendChild(c1);
        Element c2 = newDoc.createElement("Linija2");
        c2.setTextContent(line2 == null ? "" : line2);
        rootElement.appendChild(c2);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }

    public static synchronized void writeTimeCorrection(boolean letnje) throws Exception {
        String d = df.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("KorekcijaSata");
        newDoc.appendChild(rootElement);
        Element c1 = newDoc.createElement("LetnjeRacunanje");
        c1.setTextContent(Boolean.toString(letnje));
        rootElement.appendChild(c1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = tmp + d + ".xml.tmp";
        File f = new File(path1);
        while (f.exists()) {
            d = df.format(new Date());
            path1 = tmp + d + ".xml.tmp";
            f = new File(path1);
        }
        StreamResult dest = new StreamResult(f);
        aTransformer.transform(src, dest);
        int cnt = 0;
        File f2 = new File(path + d + ".xml");
        while (!f.renameTo(f2)) {
            if (++cnt >= 100) {
                Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", "100 retries failed. Giving up!");
                break;
            }
            Logger.getLogger(XMLWriter.class.getName()).logp(Level.OFF, "XMLWriter", "writeNonFiscal", MessageFormat.format("Retrying rename of file {0} to {1}", f.getAbsolutePath(), f2.getAbsolutePath()));
            if (cnt % 10 != 0) continue;
            d = df.format(new Date());
            f2 = new File(path + d + ".xml");
        }
    }
}

