/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import javax.swing.JTextField;

public class TextInput
extends JTextField
implements Input<String> {
    private boolean nullable = true;
    private String name;
    private String defaultValue;

    public TextInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    public TextInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public TextInput(String name, String defaultValue) {
        super(defaultValue);
        this.name = name;
        this.defaultValue = defaultValue;
        this.setDisabledTextColor(Color.BLACK);
    }

    public TextInput(String name, String defaultValue, boolean nullable) {
        super(defaultValue);
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public String getResult() throws InputException {
        String text = this.getText().trim();
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
            return null;
        }
        return text;
    }

    @Override
    public void setResult(String in) {
        if (in != null) {
            this.setText(in);
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

