/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTTextField;
import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;

public class DoubleInput2
extends SWTTextField
implements Input<Double> {
    private boolean nullable = true;
    private String name;
    private NumberFormat format = NumberFormat.getInstance(Locale.UK);
    private Double defaultValue;

    public DoubleInput2(SWTContainer parent, String name) {
        super(parent);
        this.name = name;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
    }

    public DoubleInput2(Composite parent, String name) {
        super(parent);
        this.name = name;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
    }

    public DoubleInput2(SWTContainer parent, String name, boolean nullable) {
        this(parent, name);
        this.nullable = nullable;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
    }

    public DoubleInput2(Composite parent, String name, boolean nullable) {
        this(parent, name);
        this.nullable = nullable;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
    }

    public DoubleInput2(SWTContainer parent, String name, Double defaultValue) {
        super(parent);
        this.name = name;
        this.defaultValue = defaultValue;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.setResult(defaultValue);
    }

    public DoubleInput2(Composite parent, String name, Double defaultValue) {
        super(parent);
        this.name = name;
        this.defaultValue = defaultValue;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.setResult(defaultValue);
    }

    public DoubleInput2(SWTContainer parent, String name, Double defaultValue, boolean nullable) {
        super(parent);
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.setResult(defaultValue);
    }

    public DoubleInput2(Composite parent, String name, Double defaultValue, boolean nullable) {
        super(parent);
        this.nullable = nullable;
        this.name = name;
        this.defaultValue = defaultValue;
        this.format.setGroupingUsed(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.setResult(defaultValue);
    }

    public DoubleInput2(SWTContainer parent, String name, int decimalPlaces) {
        this(parent, name);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(Composite parent, String name, int decimalPlaces) {
        this(parent, name);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(SWTContainer parent, String name, boolean nullable, int decimalPlaces) {
        this(parent, name, nullable);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(Composite parent, String name, boolean nullable, int decimalPlaces) {
        this(parent, name, nullable);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(SWTContainer parent, String name, Double defaultValue, int decimalPlaces) {
        this(parent, name, defaultValue);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(Composite parent, String name, Double defaultValue, int decimalPlaces) {
        this(parent, name, defaultValue);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(SWTContainer parent, String name, Double defaultValue, boolean nullable, int decimalPlaces) {
        this(parent, name, defaultValue, nullable);
        this.format.setMaximumFractionDigits(decimalPlaces);
    }

    public DoubleInput2(Composite parent, String name, Double defaultValue, boolean nullable, int decimalPlaces) {
        this(parent, name, defaultValue, nullable);
    }

    @Override
    public Double getResult() throws InputException {
        String text = this.getText().replace("0,", "0.").trim();
        Double ret = 0.0;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text).doubleValue();
            }
            catch (ParseException ex) {
                throw new InputException("Morate uneti validan broj na polje: " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Double in) {
        this.format.setMaximumFractionDigits(7);
        if (in != null) {
            this.getTextControl().setText(this.format.format(in));
        } else {
            this.getTextControl().setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

