/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.parts;

import com.dev63.restoran.parts.Input;
import com.dev63.restoran.parts.InputException;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextField;

public class DateInput
extends JTextField
implements Input<Date> {
    public static final String DATE_FORMAT = "dd.MM.yyyy";
    private boolean nullable = true;
    private String name;
    private SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private Date defaultValue;

    public DateInput(String name) {
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    public DateInput(String name, boolean nullable) {
        this(name);
        this.nullable = nullable;
    }

    public DateInput(String name, Date date) {
        this.name = name;
        this.defaultValue = date;
        this.setResult(date);
        this.setDisabledTextColor(Color.BLACK);
    }

    public DateInput(String name, Date date, boolean nullable) {
        this.defaultValue = date;
        this.setResult(date);
        this.nullable = nullable;
        this.name = name;
        this.setDisabledTextColor(Color.BLACK);
    }

    @Override
    public Date getResult() throws InputException {
        String text = this.getText().trim();
        Date ret = null;
        if (text.isEmpty()) {
            if (!this.nullable) {
                throw new InputException("Morate popuniti polje: " + this.name);
            }
        } else {
            try {
                ret = this.format.parse(text);
            }
            catch (ParseException ex) {
                throw new InputException("Morate uneti datum u formatu dd.MM.gggg u polje: " + this.name, ex);
            }
        }
        return ret;
    }

    @Override
    public void setResult(Date in) {
        if (in != null) {
            this.setText(this.format.format(in));
        } else {
            this.setText("");
        }
    }

    @Override
    public void clear() {
        this.setResult(this.defaultValue);
    }
}

