/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.dao;

import com.dev63.restoran.jpa.SingletonEmReference;
import com.dev63.restoran.jpa.ThreadLocalEntityManager;
import com.dev63.restoran.model.EntityObject;
import com.dev63.restoran.model.dao.EntityDAO;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;

public class DAOProducer
implements Closeable {
    private static volatile DAOProducer instance;
    private static final Logger log;
    private final EntityManagerFactory factory;
    private final SingletonEmReference emReference;
    private final ThreadLocalEntityManager sessionEm;

    private DAOProducer(EntityManagerFactory factory, SingletonEmReference emReference) {
        this.factory = factory;
        this.emReference = emReference;
        this.sessionEm = new ThreadLocalEntityManager(factory);
    }

    public <D extends EntityDAO> D produceDAO(Class<D> daoClass) {
        EntityDAO daoInstance = null;
        try {
            daoInstance = (EntityDAO)daoClass.getConstructor(EntityManagerFactory.class, SingletonEmReference.class, ThreadLocalEntityManager.class).newInstance(this.factory, this.emReference, this.sessionEm);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            log.log(Level.SEVERE, MessageFormat.format("Error instatiating DAO of class {0}.\nMessage: {1}", daoClass.getName(), ex.getMessage()), ex);
        }
        return (D)daoInstance;
    }

    public <E extends EntityObject> EntityDAO<E> produceGenericDAO(Class<E> entityClass) {
        return new GenericDAO<E>(entityClass, this.factory, this.emReference, this.sessionEm);
    }

    public static void instantiate(EntityManagerFactory factory, SingletonEmReference emReference) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        if (emReference == null) {
            throw new IllegalArgumentException("emRefference is null");
        }
        instance = new DAOProducer(factory, emReference);
    }

    public static DAOProducer instance() {
        if (instance == null) {
            throw new IllegalStateException("instance tried to be acquired before instantiation");
        }
        return instance;
    }

    @Override
    public void close() throws IOException {
        this.sessionEm.close();
    }

    static {
        log = Logger.getLogger(DAOProducer.class.getName());
    }

    private static class GenericDAO<E extends EntityObject>
    extends EntityDAO<E> {
        public GenericDAO(Class<E> entityType, EntityManagerFactory emf, SingletonEmReference singletonEmReference, ThreadLocalEntityManager sessionEm) {
            super(entityType, emf, singletonEmReference, sessionEm);
        }
    }
}

