/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.controller;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.db.BMDBConnectionPool;
import com.dev63.restoran.db.BMDBUtil;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.OptionType;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.utils.LogUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingController {
    protected static final String SELECT_SETTING_QUERY = "SELECT ID, ACTUAL FROM setting WHERE NAME = ?";

    protected static Setting loadSettingInternal(Connection conn, PreparedStatement ps, Option option) throws SQLException {
        Setting setting = null;
        try (ResultSet rs = ps.executeQuery();){
            if (rs.first()) {
                setting = new Setting();
                setting.setId(rs.getLong("ID"));
                setting.setName(option.getName());
                setting.setActual(rs.getString("ACTUAL"));
            }
        }
        return setting;
    }

    protected static Setting loadSettingInternal(Connection conn, Option option) throws SQLException {
        try (PreparedStatement ps = BMDBUtil.prepareStatement(conn, SELECT_SETTING_QUERY, option.getName().trim());){
            Setting setting = SettingController.loadSettingInternal(conn, ps, option);
            return setting;
        }
    }

    protected static Setting loadSettingInternal(Option option) throws SQLException {
        try (Connection conn = BMDBConnectionPool.instance().getConnection();){
            Setting setting = SettingController.loadSettingInternal(conn, option);
            return setting;
        }
    }

    public static List<Setting> loadAllCommonSettings() {
        LinkedList<Setting> settings = new LinkedList<Setting>();
        try (Connection conn = BMDBConnectionPool.instance().getConnection();
             PreparedStatement ps = conn.prepareStatement(SELECT_SETTING_QUERY);){
            for (Option option : Option.values()) {
                ps.setObject(1, option.getName());
                Setting setting = SettingController.loadSettingInternal(conn, ps, option);
                if (setting == null) continue;
                settings.add(setting);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SettingController.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
        return settings;
    }

    public static Setting loadSetting(Option option) {
        Setting setting = null;
        try {
            setting = SettingController.loadSettingInternal(option);
        }
        catch (Exception ex) {
            LogUtils.severe(ex, "Error loading setting", new Object[0]);
        }
        return setting;
    }

    public static Setting loadSetting(OptionBO option) {
        return BMTerminalSettings.getSetting(option);
    }

    public static Setting loadSettingOrDefault(Option option) {
        Setting setting = null;
        try {
            setting = SettingController.loadSettingInternal(option);
            if (setting == null) {
                setting = Setting.defaultSetting(option);
            }
        }
        catch (Exception ex) {
            LogUtils.severe(ex, "Error loading setting", new Object[0]);
        }
        return setting;
    }

    public static Setting loadSettingOrProvidedDefault(Option option, Object defaultValue) {
        Setting setting = null;
        try {
            setting = SettingController.loadSettingInternal(option);
            if (setting == null) {
                setting = new Setting();
                setting.setName(option.getName());
                setting.setActual(defaultValue == null ? null : defaultValue.toString());
            }
        }
        catch (Exception ex) {
            LogUtils.severe(ex, "Error loading setting", new Object[0]);
        }
        return setting;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveSetting(Option option, Object newValue) {
        if (option == null) {
            throw new IllegalArgumentException("option is null!");
        }
        String newActual = newValue == null ? null : newValue.toString();
        try (Connection conn = BMDBConnectionPool.instance().getConnection();){
            Setting setting = SettingController.loadSettingInternal(conn, option);
            if (setting == null) {
                setting = new Setting();
                setting.setName(option.getName());
            }
            setting.setActual(newActual);
            boolean ret = SettingController.saveSettingInternal(conn, setting);
            conn.commit();
            boolean bl = ret;
            return bl;
        }
        catch (Exception ex) {
            LogUtils.severe(ex, "Error saving setting {0} with value {1}", option.getName(), newValue);
            return false;
        }
    }

    public static boolean saveSetting(Setting setting) {
        if (setting == null) {
            throw new IllegalArgumentException("setting is null!");
        }
        try (Connection conn = BMDBConnectionPool.instance().getConnection();){
            SettingController.saveSettingInternal(conn, setting);
            conn.commit();
        }
        catch (Exception ex) {
            LogUtils.severe(ex, "Error saving setting {0} with value {1}", setting.getName(), setting.getActual());
        }
        return false;
    }

    protected static boolean saveSettingInternal(Connection conn, Setting setting) throws SQLException {
        Logger.getLogger(SettingController.class.getName()).log(Level.SEVERE, "SACUVAN SETTINGS " + setting.getName() + ", u vreme: " + new Date());
        try (PreparedStatement ps = SettingController.prepareChangeSettingStatement(conn, setting);){
            boolean bl = ps.execute();
            return bl;
        }
    }

    public static boolean saveSetting(OptionBO option, Object newValue) {
        String newActual = newValue == null ? null : newValue.toString();
        return BMTerminalSettings.setSetting(option, newActual);
    }

    public static Integer loadInteger(Option option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (option.getType() != OptionType.INTEGER) {
            throw new IllegalArgumentException("provided option is not integer type");
        }
        Setting setting = SettingController.loadSetting(option);
        if (setting == null) {
            return null;
        }
        Integer value = null;
        try {
            value = setting.integerValue();
        }
        catch (Exception e) {
            LogUtils.severe(e, "Error loading integer value of option {0} from actual {1}", option.name(), setting.getActual());
        }
        return value;
    }

    public static Integer loadInteger(OptionBO option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (option.getType() != OptionType.INTEGER) {
            throw new IllegalArgumentException("provided option is not integer type");
        }
        Setting setting = SettingController.loadSetting(option);
        if (setting == null) {
            return null;
        }
        Integer value = null;
        try {
            value = setting.integerValue();
        }
        catch (Exception e) {
            LogUtils.severe(e, "Error loading integer value of option {0} from actual {1}", option.name(), setting.getActual());
        }
        return value;
    }

    public static String loadString(OptionBO option) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (option.getType() != OptionType.STRING) {
            throw new IllegalArgumentException("provided option is not string type");
        }
        Setting setting = SettingController.loadSetting(option);
        if (setting == null) {
            return null;
        }
        String value = null;
        try {
            value = setting.stringValue();
        }
        catch (Exception e) {
            LogUtils.severe(e, "Error loading integer value of option {0} from actual {1}", option.name(), setting.getActual());
        }
        return value;
    }

    protected static PreparedStatement prepareChangeSettingStatement(Connection conn, Setting setting) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection is null!");
        }
        if (setting == null) {
            throw new IllegalArgumentException("Setting is null!");
        }
        if (setting.getId() == null) {
            return BMDBUtil.prepareStatement(conn, "INSERT INTO SETTING(NAME, ACTUAL) VALUES (?, ?)", setting.getName(), setting.getActual());
        }
        return BMDBUtil.prepareStatement(conn, "UPDATE SETTING SET ACTUAL = ? WHERE ID = ?", setting.getActual(), setting.getId());
    }
}

