/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model.controller;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.db.BMDBConnectionPool;
import com.dev63.restoran.db.BMDBQueryUtil;
import com.dev63.restoran.db.queries.Queries;
import com.dev63.restoran.db.queries.QueryName;
import com.dev63.restoran.izvestaji.nivelacija.NivelacijaRow;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.tax.TaxControl;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class NivelacijaController
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(NivelacijaController.class.getName());
    private final Connection connection = BMDBConnectionPool.instance().getConnection();
    private final TaxControl taxControl = TaxControl.instance();

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public List<NivelacijaRow> processData(List<NivelacijaRawData> data) {
        TreeMap pd = new TreeMap();
        data.stream().forEachOrdered(row -> {
            NivelacijaData nivelacijaData = pd.computeIfAbsent(row.artikalId, k -> NivelacijaData.initFromRaw(row));
            Optional<NivelacijaData.Stanje> last = Optional.ofNullable(nivelacijaData.stanja.peekLast());
            Boolean sameAsLast = last.map(d -> d.prodajnaCena).map(c -> c.compareTo(row.prodajnaCena) == 0).orElse(Boolean.FALSE);
            if (sameAsLast.booleanValue()) {
                last.get().kolicina = last.get().kolicina.add(row.kolicina);
                last.get().datum = row.datum;
                last.get().tip = row.tip;
            } else {
                nivelacijaData.stanja.addLast(new NivelacijaData.Stanje(row.prodajnaCena, row.kolicina, row.datum, row.tip));
            }
        });
        int[] rb = new int[]{0};
        LinkedList<NivelacijaRow> rows = new LinkedList<NivelacijaRow>();
        ((Stream)pd.values().stream().sequential()).forEachOrdered(dRow -> {
            NivelacijaData.Stanje stanje;
            NivelacijaRow row = null;
            while ((stanje = dRow.stanja.pollFirst()) != null) {
                int n = rb[0];
                rb[0] = n + 1;
                BigDecimal prethodnaKolicina = this.endLastRow(row, n, stanje);
                if ((row = this.startNewRow((NivelacijaData)dRow, stanje, prethodnaKolicina)) == null) continue;
                rows.add(row);
            }
        });
        return rows;
    }

    public List<NivelacijaRawData> loadData(Date date) {
        String query = Queries.QUERIES.get((Object)QueryName.NIVELACIJA_PODACI);
        LinkedList<NivelacijaRawData> results = new LinkedList<NivelacijaRawData>();
        try (PreparedStatement ps = BMDBQueryUtil.prepareStatement(this.connection, query, date, date, date, date, date, date, date);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                NivelacijaRawData data = new NivelacijaRawData().artikalId(rs.getLong("artikal_id")).artikalNaziv(rs.getString("artikal_naziv")).artikalCena(rs.getBigDecimal("artikal_cena")).id(rs.getLong("id")).datum(rs.getDate("datum")).prodajnaCena(rs.getBigDecimal("prodajna_cena")).kolicina(rs.getBigDecimal("kolicina")).artPg(rs.getInt("art_pg")).artJedMere(rs.getString("art_jed_mere")).tip(rs.getInt("tip"));
                results.add(data);
            }
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Greska kod ucitavanja podataka o nivelaciji", ex);
            throw new RuntimeException("Greska kod ucitavanja podataka o nivelaciji");
        }
        return results;
    }

    private BigDecimal endLastRow(NivelacijaRow row, int redniBroj, NivelacijaData.Stanje stanje) {
        if (row == null) {
            return null;
        }
        row.novaCenaSaPDVom = stanje.prodajnaCena;
        row.novaCena = this.taxControl.nettoFromBruttoUsingPercentage(stanje.prodajnaCena, row.procenatPDV);
        row.povecanjeCene = row.novaCena.subtract(row.staraCena);
        row.povecanjePDVa = row.novaCenaSaPDVom.subtract(row.novaCena).subtract(row.PDV);
        row.povecanjeRazlikeUCeni = row.povecanjeCene.multiply(row.kolicina);
        row.povecanjePoreza = row.povecanjePDVa.multiply(row.kolicina);
        row.redniBroj = redniBroj;
        return row.kolicina;
    }

    private NivelacijaRow startNewRow(NivelacijaData data, NivelacijaData.Stanje stanje, BigDecimal prethodnaKolicina) {
        if (stanje == null || stanje.tip == 2) {
            return null;
        }
        BigDecimal pKol = Optional.ofNullable(prethodnaKolicina).orElse(BigDecimal.ZERO);
        NivelacijaRow row = new NivelacijaRow();
        PoreskaGrupa pg = PoreskaGrupa.values()[data.artPg];
        row.procenatPDV = BigDecimal.valueOf(PoreskeStope.getPoreskaStopa(pg, stanje.datum).getStopa());
        row.jedinicaMere = data.artJedMere;
        row.kolicina = pKol.add(stanje.kolicina);
        row.naziv = data.artikalNaziv;
        row.staraCenaSaPDVom = stanje.prodajnaCena;
        row.PDV = this.taxControl.taxFromBruttoUsingPercentage(stanje.prodajnaCena, row.procenatPDV);
        row.staraCena = this.taxControl.nettoFromBruttoUsingPercentage(stanje.prodajnaCena, row.procenatPDV);
        return row;
    }

    public static class NivelacijaData {
        Long artikalId;
        String artikalNaziv;
        BigDecimal artikalCena;
        Integer artPg;
        String artJedMere;
        Deque<Stanje> stanja = new ArrayDeque<Stanje>();

        public static NivelacijaData initFromRaw(NivelacijaRawData raw) {
            NivelacijaData data = new NivelacijaData();
            data.artikalId = raw.artikalId;
            data.artikalNaziv = raw.artikalNaziv;
            data.artikalCena = raw.artikalCena;
            data.artPg = raw.artPg;
            data.artJedMere = raw.artJedMere;
            return data;
        }

        public static class Stanje {
            BigDecimal prodajnaCena;
            BigDecimal kolicina;
            Date datum;
            Integer tip;

            public Stanje(BigDecimal prodajnaCena, BigDecimal kolicina, Date datum, Integer tip) {
                this.prodajnaCena = prodajnaCena;
                this.kolicina = kolicina;
                this.datum = datum;
                this.tip = tip;
            }
        }
    }

    public static class NivelacijaRawData {
        Long artikalId;
        String artikalNaziv;
        BigDecimal artikalCena;
        Long id;
        Date datum;
        BigDecimal prodajnaCena;
        BigDecimal kolicina;
        Integer artPg;
        String artJedMere;
        Integer tip;

        public NivelacijaRawData artikalId(Long artikalId) {
            this.artikalId = artikalId;
            return this;
        }

        public NivelacijaRawData artikalNaziv(String artikalNaziv) {
            this.artikalNaziv = artikalNaziv;
            return this;
        }

        public NivelacijaRawData artikalCena(BigDecimal artikalCena) {
            this.artikalCena = artikalCena;
            return this;
        }

        public NivelacijaRawData id(Long id) {
            this.id = id;
            return this;
        }

        public NivelacijaRawData datum(Date datum) {
            this.datum = datum;
            return this;
        }

        public NivelacijaRawData prodajnaCena(BigDecimal prodajnaCena) {
            this.prodajnaCena = prodajnaCena;
            return this;
        }

        public NivelacijaRawData kolicina(BigDecimal kolicina) {
            this.kolicina = kolicina;
            return this;
        }

        public NivelacijaRawData artPg(Integer artPg) {
            this.artPg = artPg;
            return this;
        }

        public NivelacijaRawData artJedMere(String artJedMere) {
            this.artJedMere = artJedMere;
            return this;
        }

        public NivelacijaRawData tip(Integer tip) {
            this.tip = tip;
            return this;
        }
    }
}

