/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Knjiziv;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.TrebovanjeStavka;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Trebovanje
extends BObject
implements Knjiziv,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    private String brTrebovanja;
    @ManyToOne
    @JoinColumn
    private Odeljenje iz;
    @ManyToOne
    @JoinColumn
    private Odeljenje u;
    @ManyToOne
    @JoinColumn
    private StalniGost dobavljac;
    @ManyToOne
    @JoinColumn
    private Odeljenje narudz;
    @Temporal(value=TemporalType.DATE)
    private Date datumUnosa;
    @Temporal(value=TemporalType.DATE)
    private Date datumTrebovanja;
    private String uname;
    private String opis;
    private Boolean crno;
    private String hacapVreme;
    private String regOznaka;
    private String kontrolisao;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trebovanje", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<TrebovanjeStavka> stavke = new LinkedList<TrebovanjeStavka>();
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    private Prijemnica prijemnica;
    @Enumerated(value=EnumType.STRING)
    private TipTrebovanja tip;
    @OneToMany(mappedBy="trebovanje")
    private List<Knjizenje> knjizenja = new LinkedList<Knjizenje>();
    @Temporal(value=TemporalType.DATE)
    private Date datumValute;
    @Transient
    private Double totalBezPdv;
    @Transient
    private Double totalSaPdv;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$StalniGost;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Odeljenje;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Prijemnica;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$TipTrebovanja;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Trebovanje;

    public StalniGost getDobavljac() {
        return Trebovanje.pcGetdobavljac(this);
    }

    public void setDobavljac(StalniGost dobavljac) {
        Trebovanje.pcSetdobavljac(this, dobavljac);
    }

    public String getUname() {
        return Trebovanje.pcGetuname(this);
    }

    public void setUname(String uname) {
        Trebovanje.pcSetuname(this, uname);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        return hash += BObject.pcGetid(this) != null ? BObject.pcGetid(this).hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Prijemnica)) {
            return false;
        }
        Prijemnica other = (Prijemnica)object;
        return (BObject.pcGetid(this) != null || BObject.pcGetid(other) == null) && (BObject.pcGetid(this) == null || BObject.pcGetid(this).equals(BObject.pcGetid(other)));
    }

    public String getOpis() {
        return Trebovanje.pcGetopis(this);
    }

    public void setOpis(String opis) {
        Trebovanje.pcSetopis(this, opis);
    }

    @Override
    public String toString() {
        String iz2 = Trebovanje.pcGetiz(this) != null ? Trebovanje.pcGetiz(this).getNaziv() + " --> " : "";
        String u2 = Trebovanje.pcGetu(this).getNaziv();
        String dobavljac2 = Trebovanje.pcGetdobavljac(this) != null ? Trebovanje.pcGetdobavljac(this).getSkrNaziv() : "";
        return Konstante.getDate(Trebovanje.pcGetdatumTrebovanja(this)) + ",  " + iz2 + u2 + ",  " + dobavljac2 + ",  " + Trebovanje.pcGetuname(this) + ",  " + Konstante.getDate(Trebovanje.pcGetdatumUnosa(this));
    }

    public Odeljenje getNarudz() {
        return Trebovanje.pcGetnarudz(this);
    }

    public void setNarudz(Odeljenje narudz) {
        Trebovanje.pcSetnarudz(this, narudz);
    }

    public Odeljenje getIz() {
        return Trebovanje.pcGetiz(this);
    }

    public void setIz(Odeljenje iz) {
        Trebovanje.pcSetiz(this, iz);
    }

    public Odeljenje getU() {
        return Trebovanje.pcGetu(this);
    }

    public void setU(Odeljenje u) {
        Trebovanje.pcSetu(this, u);
    }

    public String getBrTrebovanja() {
        return Trebovanje.pcGetbrTrebovanja(this);
    }

    public void setBrTrebovanja(String brTrebovanja) {
        Trebovanje.pcSetbrTrebovanja(this, brTrebovanja);
    }

    public Date getDatumUnosa() {
        return Trebovanje.pcGetdatumUnosa(this);
    }

    public void setDatumUnosa(Date datumUnosa) {
        Trebovanje.pcSetdatumUnosa(this, datumUnosa);
    }

    public Date getDatumTrebovanja() {
        return Trebovanje.pcGetdatumTrebovanja(this);
    }

    public void setDatumTrebovanja(Date datumTrebovanja) {
        Trebovanje.pcSetdatumTrebovanja(this, datumTrebovanja);
    }

    public Boolean getCrno() {
        return Trebovanje.pcGetcrno(this);
    }

    public void setCrno(Boolean crno) {
        Trebovanje.pcSetcrno(this, crno);
    }

    public List<TrebovanjeStavka> getStavke() {
        return Trebovanje.pcGetstavke(this);
    }

    public void setStavke(List<TrebovanjeStavka> stavke) {
        Trebovanje.pcSetstavke(this, stavke);
    }

    public Prijemnica getPrijemnica() {
        return Trebovanje.pcGetprijemnica(this);
    }

    public void setPrijemnica(Prijemnica prijemnica) {
        Trebovanje.pcSetprijemnica(this, prijemnica);
    }

    public TipTrebovanja getTip() {
        return Trebovanje.pcGettip(this);
    }

    public void setTip(TipTrebovanja tip) {
        Trebovanje.pcSettip(this, tip);
    }

    public Double getTotal() {
        Double ret = 0.0;
        if (Trebovanje.pcGetstavke(this) != null) {
            for (TrebovanjeStavka ts : Trebovanje.pcGetstavke(this)) {
                ret = ret + ts.getKolicina() * ts.getKomad();
            }
        }
        return ret;
    }

    @Override
    public boolean getRealizovan() {
        boolean ret = false;
        if (Trebovanje.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Trebovanje.pcGetknjizenja(this)) {
                if (!knjizenje.getRealizovano().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public Double getRealizovaniIznos() {
        Double ret = 0.0;
        if (Trebovanje.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Trebovanje.pcGetknjizenja(this)) {
                ret = ret + (knjizenje.getRealizovaniIznos() != null ? knjizenje.getRealizovaniIznos() : 0.0);
            }
        }
        return ret;
    }

    @Override
    public void setKnjizenja(List<Knjizenje> knjizenja) {
        Trebovanje.pcSetknjizenja(this, knjizenja);
    }

    @Override
    public List<Knjizenje> getKnjizenja() {
        return Trebovanje.pcGetknjizenja(this);
    }

    public Double getTotalBezPdv() {
        return this.totalBezPdv;
    }

    public void setTotalBezPdv(Double totalBezPdv) {
        this.totalBezPdv = totalBezPdv;
    }

    public Double getTotalSaPdv() {
        return this.totalSaPdv;
    }

    public void setTotalSaPdv(Double totalSaPdv) {
        this.totalSaPdv = totalSaPdv;
    }

    public Date getDatumValute() {
        return Trebovanje.pcGetdatumValute(this);
    }

    public void setDatumValute(Date datumValute) {
        Trebovanje.pcSetdatumValute(this, datumValute);
    }

    public String getHacapVreme() {
        return Trebovanje.pcGethacapVreme(this);
    }

    public void setHacapVreme(String hacapVreme) {
        Trebovanje.pcSethacapVreme(this, hacapVreme);
    }

    public String getRegOznaka() {
        return Trebovanje.pcGetregOznaka(this);
    }

    public void setRegOznaka(String regOznaka) {
        Trebovanje.pcSetregOznaka(this, regOznaka);
    }

    public String getKontrolisao() {
        return Trebovanje.pcGetkontrolisao(this);
    }

    public void setKontrolisao(String kontrolisao) {
        Trebovanje.pcSetkontrolisao(this, kontrolisao);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = Trebovanje.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"brTrebovanja", "crno", "datumTrebovanja", "datumUnosa", "datumValute", "dobavljac", "hacapVreme", "iz", "knjizenja", "kontrolisao", "narudz", "opis", "prijemnica", "regOznaka", "stavke", "tip", "u", "uname"};
        Class[] classArray = new Class[18];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Trebovanje.class$("java.lang.Boolean"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Trebovanje.class$("java.util.Date"));
        classArray[2] = clazz4;
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Trebovanje.class$("java.util.Date"));
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Trebovanje.class$("java.util.Date"));
        Class clazz5 = class$Lcom$dev63$restoran$model$StalniGost != null ? class$Lcom$dev63$restoran$model$StalniGost : (class$Lcom$dev63$restoran$model$StalniGost = Trebovanje.class$("com.dev63.restoran.model.StalniGost"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        Class clazz6 = class$Lcom$dev63$restoran$model$Odeljenje != null ? class$Lcom$dev63$restoran$model$Odeljenje : (class$Lcom$dev63$restoran$model$Odeljenje = Trebovanje.class$("com.dev63.restoran.model.Odeljenje"));
        classArray[7] = clazz6;
        Class clazz7 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Trebovanje.class$("java.util.List"));
        classArray[8] = clazz7;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        classArray[10] = class$Lcom$dev63$restoran$model$Odeljenje != null ? class$Lcom$dev63$restoran$model$Odeljenje : (class$Lcom$dev63$restoran$model$Odeljenje = Trebovanje.class$("com.dev63.restoran.model.Odeljenje"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        Class clazz8 = class$Lcom$dev63$restoran$model$Prijemnica != null ? class$Lcom$dev63$restoran$model$Prijemnica : (class$Lcom$dev63$restoran$model$Prijemnica = Trebovanje.class$("com.dev63.restoran.model.Prijemnica"));
        classArray[12] = clazz8;
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        classArray[14] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Trebovanje.class$("java.util.List"));
        Class clazz9 = class$Lcom$dev63$restoran$model$TipTrebovanja != null ? class$Lcom$dev63$restoran$model$TipTrebovanja : (class$Lcom$dev63$restoran$model$TipTrebovanja = Trebovanje.class$("com.dev63.restoran.model.TipTrebovanja"));
        classArray[15] = clazz9;
        classArray[16] = class$Lcom$dev63$restoran$model$Odeljenje != null ? class$Lcom$dev63$restoran$model$Odeljenje : (class$Lcom$dev63$restoran$model$Odeljenje = Trebovanje.class$("com.dev63.restoran.model.Odeljenje"));
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Trebovanje.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 10, 26, 26, 26};
        Class clazz10 = class$Lcom$dev63$restoran$model$Trebovanje != null ? class$Lcom$dev63$restoran$model$Trebovanje : (class$Lcom$dev63$restoran$model$Trebovanje = Trebovanje.class$("com.dev63.restoran.model.Trebovanje"));
        PCRegistry.register((Class)clazz10, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Trebovanje", (PersistenceCapable)new Trebovanje());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.brTrebovanja = null;
        this.crno = null;
        this.datumTrebovanja = null;
        this.datumUnosa = null;
        this.datumValute = null;
        this.dobavljac = null;
        this.hacapVreme = null;
        this.iz = null;
        this.knjizenja = null;
        this.kontrolisao = null;
        this.narudz = null;
        this.opis = null;
        this.prijemnica = null;
        this.regOznaka = null;
        this.stavke = null;
        this.tip = null;
        this.u = null;
        this.uname = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Trebovanje trebovanje = new Trebovanje();
        if (bl) {
            trebovanje.pcClearFields();
        }
        trebovanje.pcStateManager = stateManager;
        trebovanje.pcCopyKeyFieldsFromObjectId(object);
        return trebovanje;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Trebovanje trebovanje = new Trebovanje();
        if (bl) {
            trebovanje.pcClearFields();
        }
        trebovanje.pcStateManager = stateManager;
        return trebovanje;
    }

    protected static int pcGetManagedFieldCount() {
        return 18 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brTrebovanja = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.crno = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.datumTrebovanja = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.datumUnosa = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.datumValute = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.dobavljac = (StalniGost)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.hacapVreme = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.iz = (Odeljenje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.knjizenja = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.kontrolisao = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.narudz = (Odeljenje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.opis = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.prijemnica = (Prijemnica)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.regOznaka = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.stavke = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.tip = (TipTrebovanja)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 16: {
                this.u = (Odeljenje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.uname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.brTrebovanja);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.crno);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumTrebovanja);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumUnosa);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datumValute);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dobavljac);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.hacapVreme);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.iz);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.knjizenja);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.kontrolisao);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.narudz);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.opis);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.prijemnica);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.regOznaka);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.stavke);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tip);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.u);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.uname);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Trebovanje trebovanje, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(trebovanje, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brTrebovanja = trebovanje.brTrebovanja;
                return;
            }
            case 1: {
                this.crno = trebovanje.crno;
                return;
            }
            case 2: {
                this.datumTrebovanja = trebovanje.datumTrebovanja;
                return;
            }
            case 3: {
                this.datumUnosa = trebovanje.datumUnosa;
                return;
            }
            case 4: {
                this.datumValute = trebovanje.datumValute;
                return;
            }
            case 5: {
                this.dobavljac = trebovanje.dobavljac;
                return;
            }
            case 6: {
                this.hacapVreme = trebovanje.hacapVreme;
                return;
            }
            case 7: {
                this.iz = trebovanje.iz;
                return;
            }
            case 8: {
                this.knjizenja = trebovanje.knjizenja;
                return;
            }
            case 9: {
                this.kontrolisao = trebovanje.kontrolisao;
                return;
            }
            case 10: {
                this.narudz = trebovanje.narudz;
                return;
            }
            case 11: {
                this.opis = trebovanje.opis;
                return;
            }
            case 12: {
                this.prijemnica = trebovanje.prijemnica;
                return;
            }
            case 13: {
                this.regOznaka = trebovanje.regOznaka;
                return;
            }
            case 14: {
                this.stavke = trebovanje.stavke;
                return;
            }
            case 15: {
                this.tip = trebovanje.tip;
                return;
            }
            case 16: {
                this.u = trebovanje.u;
                return;
            }
            case 17: {
                this.uname = trebovanje.uname;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Trebovanje trebovanje = (Trebovanje)object;
        if (trebovanje.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(trebovanje, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetbrTrebovanja(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.brTrebovanja;
        }
        int n = pcInheritedFieldCount + 0;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.brTrebovanja;
    }

    private static final void pcSetbrTrebovanja(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.brTrebovanja = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 0, trebovanje.brTrebovanja, string, 0);
    }

    private static final Boolean pcGetcrno(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.crno;
        }
        int n = pcInheritedFieldCount + 1;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.crno;
    }

    private static final void pcSetcrno(Trebovanje trebovanje, Boolean bl) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.crno = bl;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 1, (Object)trebovanje.crno, (Object)bl, 0);
    }

    private static final Date pcGetdatumTrebovanja(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.datumTrebovanja;
        }
        int n = pcInheritedFieldCount + 2;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.datumTrebovanja;
    }

    private static final void pcSetdatumTrebovanja(Trebovanje trebovanje, Date date) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.datumTrebovanja = date;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 2, (Object)trebovanje.datumTrebovanja, (Object)date, 0);
    }

    private static final Date pcGetdatumUnosa(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.datumUnosa;
        }
        int n = pcInheritedFieldCount + 3;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.datumUnosa;
    }

    private static final void pcSetdatumUnosa(Trebovanje trebovanje, Date date) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.datumUnosa = date;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 3, (Object)trebovanje.datumUnosa, (Object)date, 0);
    }

    private static final Date pcGetdatumValute(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.datumValute;
        }
        int n = pcInheritedFieldCount + 4;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.datumValute;
    }

    private static final void pcSetdatumValute(Trebovanje trebovanje, Date date) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.datumValute = date;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 4, (Object)trebovanje.datumValute, (Object)date, 0);
    }

    private static final StalniGost pcGetdobavljac(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.dobavljac;
        }
        int n = pcInheritedFieldCount + 5;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.dobavljac;
    }

    private static final void pcSetdobavljac(Trebovanje trebovanje, StalniGost stalniGost) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.dobavljac = stalniGost;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 5, (Object)trebovanje.dobavljac, (Object)stalniGost, 0);
    }

    private static final String pcGethacapVreme(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.hacapVreme;
        }
        int n = pcInheritedFieldCount + 6;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.hacapVreme;
    }

    private static final void pcSethacapVreme(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.hacapVreme = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 6, trebovanje.hacapVreme, string, 0);
    }

    private static final Odeljenje pcGetiz(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.iz;
        }
        int n = pcInheritedFieldCount + 7;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.iz;
    }

    private static final void pcSetiz(Trebovanje trebovanje, Odeljenje odeljenje) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.iz = odeljenje;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 7, (Object)trebovanje.iz, (Object)odeljenje, 0);
    }

    private static final List pcGetknjizenja(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.knjizenja;
        }
        int n = pcInheritedFieldCount + 8;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.knjizenja;
    }

    private static final void pcSetknjizenja(Trebovanje trebovanje, List list) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.knjizenja = list;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 8, trebovanje.knjizenja, (Object)list, 0);
    }

    private static final String pcGetkontrolisao(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.kontrolisao;
        }
        int n = pcInheritedFieldCount + 9;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.kontrolisao;
    }

    private static final void pcSetkontrolisao(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.kontrolisao = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 9, trebovanje.kontrolisao, string, 0);
    }

    private static final Odeljenje pcGetnarudz(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.narudz;
        }
        int n = pcInheritedFieldCount + 10;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.narudz;
    }

    private static final void pcSetnarudz(Trebovanje trebovanje, Odeljenje odeljenje) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.narudz = odeljenje;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 10, (Object)trebovanje.narudz, (Object)odeljenje, 0);
    }

    private static final String pcGetopis(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.opis;
        }
        int n = pcInheritedFieldCount + 11;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.opis;
    }

    private static final void pcSetopis(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.opis = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 11, trebovanje.opis, string, 0);
    }

    private static final Prijemnica pcGetprijemnica(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.prijemnica;
        }
        int n = pcInheritedFieldCount + 12;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.prijemnica;
    }

    private static final void pcSetprijemnica(Trebovanje trebovanje, Prijemnica prijemnica) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.prijemnica = prijemnica;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 12, (Object)trebovanje.prijemnica, (Object)prijemnica, 0);
    }

    private static final String pcGetregOznaka(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.regOznaka;
        }
        int n = pcInheritedFieldCount + 13;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.regOznaka;
    }

    private static final void pcSetregOznaka(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.regOznaka = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 13, trebovanje.regOznaka, string, 0);
    }

    private static final List pcGetstavke(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.stavke;
        }
        int n = pcInheritedFieldCount + 14;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.stavke;
    }

    private static final void pcSetstavke(Trebovanje trebovanje, List list) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.stavke = list;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 14, trebovanje.stavke, (Object)list, 0);
    }

    private static final TipTrebovanja pcGettip(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.tip;
        }
        int n = pcInheritedFieldCount + 15;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.tip;
    }

    private static final void pcSettip(Trebovanje trebovanje, TipTrebovanja tipTrebovanja) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.tip = tipTrebovanja;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 15, (Object)trebovanje.tip, (Object)tipTrebovanja, 0);
    }

    private static final Odeljenje pcGetu(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.u;
        }
        int n = pcInheritedFieldCount + 16;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.u;
    }

    private static final void pcSetu(Trebovanje trebovanje, Odeljenje odeljenje) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.u = odeljenje;
            return;
        }
        trebovanje.pcStateManager.settingObjectField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 16, (Object)trebovanje.u, (Object)odeljenje, 0);
    }

    private static final String pcGetuname(Trebovanje trebovanje) {
        if (trebovanje.pcStateManager == null) {
            return trebovanje.uname;
        }
        int n = pcInheritedFieldCount + 17;
        trebovanje.pcStateManager.accessingField(n);
        return trebovanje.uname;
    }

    private static final void pcSetuname(Trebovanje trebovanje, String string) {
        if (trebovanje.pcStateManager == null) {
            trebovanje.uname = string;
            return;
        }
        trebovanje.pcStateManager.settingStringField((PersistenceCapable)trebovanje, pcInheritedFieldCount + 17, trebovanje.uname, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

