/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.model.StampacEmulacija;
import java.nio.charset.Charset;

public enum TipStampaca {
    EPSONTMT("EPSON TM-T88IV-58", 30, 8, StampacEmulacija.ESCPOS, new byte[][]{{27, 116, 0}, {27, 116, 18}, new byte[0], new byte[0], new byte[0]}),
    EPSONTMT80("EPSON TM-T88IV-80", 42, 8, StampacEmulacija.ESCPOS, new byte[][]{{27, 116, 0}, {27, 116, 18}, new byte[0], new byte[0], new byte[0]}),
    EPP("EPP", 34, 8, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    EP50("DATECS EP-50", 32, 0, StampacEmulacija.ESCPOS, new byte[][]{{27, 116, 0}, {27, 116, 6}, new byte[0], {27, 116, 13}, new byte[0]}),
    EP60("DATECS EP-60", 36, 0, StampacEmulacija.ESCPOS, new byte[][]{{27, 116, 0}, {27, 116, 6}, new byte[0], {27, 116, 13}, new byte[0]}),
    FP550("FP550", 30, 0, StampacEmulacija.NONE, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    RMINEFISKAL("RMI Nefiskalna", 32, 0, StampacEmulacija.NONE, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    HCPBEST("HCP BEST", 16, 0, StampacEmulacija.NONE, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    HCPP2DS("HCP P2-DS", 32, 0, StampacEmulacija.NONE, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    DATECS1000("DATECS EP-1000", 34, 4, StampacEmulacija.ESCPOS, new byte[][]{{27, 116, 0}, {27, 116, 6}, new byte[0], {27, 116, 13}, new byte[0]}),
    DATECS2000("DATECS EP-2000", 34, 4, StampacEmulacija.ESCPOS_EP2000, new byte[][]{{27, 117, 0}, {27, 117, 4}, new byte[0], {27, 117, 14}, {27, 117, 17}}),
    STARTCP100("Star TCP100", 47, 0, StampacEmulacija.STAR, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    POSBANK80MM("POSBANK 80mm", 42, 4, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    POSBANK58MM("POSBANK 58mm", 32, 4, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    BIXOLON_80MM("BIXOLON 80MM", 42, 4, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    TOSHIBA_A0080MM("Toshiba A00-80MM", 42, 8, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]}),
    TOSHIBA_A0058MM("Toshiba A00-58MM", 32, 8, StampacEmulacija.ESCPOS, new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0], new byte[0]});

    private final String opis;
    private int brojKarakteraURedu;
    private int brojDodatnihLinija;
    private StampacEmulacija emulacija;
    private byte[][] codePageCommands;

    private TipStampaca(String opis, int brojKarakteraURedu, int brojDodatnihLinija, StampacEmulacija emulacija, byte[][] codePageCommands) {
        this.opis = opis;
        this.brojKarakteraURedu = brojKarakteraURedu;
        this.brojDodatnihLinija = brojDodatnihLinija;
        this.emulacija = emulacija;
        this.codePageCommands = codePageCommands;
    }

    public String getOpis() {
        return this.opis;
    }

    public int getBrojKarakteraURedu() {
        return this.brojKarakteraURedu;
    }

    public void setBrojKarakteraURedu(int brojKarakteraURedu) {
        this.brojKarakteraURedu = brojKarakteraURedu;
    }

    public int getBrojDodatnihLinija() {
        return this.brojDodatnihLinija;
    }

    public void setBrojDodatnihLinija(int brojDodatnihLinija) {
        this.brojDodatnihLinija = brojDodatnihLinija;
    }

    public StampacEmulacija getEmulacija() {
        return this.emulacija;
    }

    public byte[] getCodePageCommandForCharset(Charset cs) {
        byte[] ret = new byte[]{};
        try {
            ret = this.codePageCommands[CodePageKeyTable.getCharsetIndex(cs)];
        }
        catch (Exception e) {
            ret = new byte[]{};
        }
        return ret;
    }

    public static enum CodePageKeyTable {
        CP437(0, Charset.forName("cp437")),
        CP852(1, Charset.forName("cp852")),
        CP855(2, Charset.forName("cp855")),
        CP1250(3, Charset.forName("cp1250")),
        CP1251(4, Charset.forName("cp1251"));

        private int index;
        private Charset charset;

        private CodePageKeyTable(int index, Charset charset) {
            this.index = index;
            this.charset = charset;
        }

        public int getIndex() {
            return this.index;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public static int getCharsetIndex(Charset cs) {
            int ret = -1;
            for (CodePageKeyTable cpkt : CodePageKeyTable.values()) {
                if (!cpkt.getCharset().equals(cs)) continue;
                ret = cpkt.getIndex();
                break;
            }
            return ret;
        }
    }
}

