/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Storno;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class StornoStavka
extends BObject
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    @ManyToOne(optional=false)
    private Artikal artikal;
    @Column(nullable=false)
    private Double kolicina;
    @Column(nullable=false)
    private Double vrednost;
    @Column
    private Integer brojTure;
    @ManyToOne
    private Storno storno;
    @ManyToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="GLAVNASTAVKA_ID")
    private StornoStavka parent;
    @ManyToMany(mappedBy="parent", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<StornoStavka> children;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Artikal;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$StornoStavka;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Storno;

    public StornoStavka() {
        this.children = new LinkedList<StornoStavka>();
    }

    public StornoStavka(Artikal a, Double kolicina, Integer bt, Double vrednost) {
        this();
        this.artikal = a;
        this.kolicina = kolicina;
        this.vrednost = vrednost;
        this.brojTure = bt;
    }

    public StornoStavka(StavkaRacuna stavkaRacuna, StornoStavka parent, Storno storno) {
        if (stavkaRacuna == null) {
            throw new NullPointerException("stavkaRacuna is null");
        }
        this.storno = Objects.requireNonNull(storno, "storno is null");
        this.children = new LinkedList<StornoStavka>();
        this.artikal = stavkaRacuna.getArtikal();
        this.kolicina = stavkaRacuna.getKolicina();
        this.vrednost = stavkaRacuna.getVrednostSaPopustom();
        this.brojTure = stavkaRacuna.getTura().getBrojTure();
        this.parent = parent;
        if (stavkaRacuna.getPodStavke() != null) {
            for (StavkaRacuna child : stavkaRacuna.getPodStavke()) {
                this.children.add(new StornoStavka(child, parent, storno));
            }
        }
    }

    public Double getKolicina() {
        return StornoStavka.pcGetkolicina(this);
    }

    public Double getVrednost() {
        return StornoStavka.pcGetvrednost(this);
    }

    public void setKolicina(Double kolicina) {
        StornoStavka.pcSetkolicina(this, kolicina);
    }

    public void setVrednost(Double vrednost) {
        StornoStavka.pcSetvrednost(this, vrednost);
    }

    @Override
    public String toString() {
        return StornoStavka.pcGetartikal(this).getName() + "  " + StornoStavka.pcGetkolicina(this) + "  " + StornoStavka.pcGetvrednost(this);
    }

    public Integer getBrojTure() {
        return StornoStavka.pcGetbrojTure(this);
    }

    public void setBrojTure(Integer brojTure) {
        StornoStavka.pcSetbrojTure(this, brojTure);
    }

    public Artikal getArtikal() {
        return StornoStavka.pcGetartikal(this);
    }

    public void setArtikal(Artikal artikal) {
        StornoStavka.pcSetartikal(this, artikal);
    }

    public Storno getStorno() {
        return StornoStavka.pcGetstorno(this);
    }

    public void setStorno(Storno storno) {
        StornoStavka.pcSetstorno(this, storno);
    }

    public List<StornoStavka> getChildren() {
        return StornoStavka.pcGetchildren(this);
    }

    public void setChildren(List<StornoStavka> children) {
        StornoStavka.pcSetchildren(this, children);
    }

    public StornoStavka getParent() {
        return StornoStavka.pcGetparent(this);
    }

    public void setParent(StornoStavka parent) {
        StornoStavka.pcSetparent(this, parent);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StornoStavka other = (StornoStavka)obj;
        if (BObject.pcGetid(this) != null && BObject.pcGetid(other) != null && Objects.equals(BObject.pcGetid(this), BObject.pcGetid(other))) {
            return true;
        }
        if (!Objects.equals(StornoStavka.pcGetartikal(this), StornoStavka.pcGetartikal(other))) {
            return false;
        }
        if (!Objects.equals(StornoStavka.pcGetkolicina(this), StornoStavka.pcGetkolicina(other))) {
            return false;
        }
        if (!Objects.equals(StornoStavka.pcGetvrednost(this), StornoStavka.pcGetvrednost(other))) {
            return false;
        }
        if (!Objects.equals(StornoStavka.pcGetbrojTure(this), StornoStavka.pcGetbrojTure(other))) {
            return false;
        }
        if (!Objects.equals(StornoStavka.pcGetstorno(this), StornoStavka.pcGetstorno(other))) {
            return false;
        }
        if (!Objects.equals(StornoStavka.pcGetparent(this), StornoStavka.pcGetparent(other))) {
            return false;
        }
        return Objects.equals(StornoStavka.pcGetchildren(this), StornoStavka.pcGetchildren(other));
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(BObject.pcGetid(this));
        hash = 29 * hash + Objects.hashCode(StornoStavka.pcGetartikal(this));
        hash = 29 * hash + Objects.hashCode(StornoStavka.pcGetkolicina(this));
        hash = 29 * hash + Objects.hashCode(StornoStavka.pcGetvrednost(this));
        hash = 29 * hash + Objects.hashCode(StornoStavka.pcGetbrojTure(this));
        return hash;
    }

    public static StornoStavkaBuilder builder() {
        return new StornoStavkaBuilder();
    }

    static /* synthetic */ Artikal access$102(StornoStavka x0, Artikal x1) {
        Artikal artikal = x1;
        StornoStavka.pcSetartikal(x0, artikal);
        return artikal;
    }

    static /* synthetic */ Integer access$202(StornoStavka x0, Integer x1) {
        Integer n = x1;
        StornoStavka.pcSetbrojTure(x0, n);
        return n;
    }

    static /* synthetic */ Double access$302(StornoStavka x0, Double x1) {
        Double d = x1;
        StornoStavka.pcSetkolicina(x0, d);
        return d;
    }

    static /* synthetic */ Double access$402(StornoStavka x0, Double x1) {
        Double d = x1;
        StornoStavka.pcSetvrednost(x0, d);
        return d;
    }

    static /* synthetic */ Storno access$502(StornoStavka x0, Storno x1) {
        Storno storno = x1;
        StornoStavka.pcSetstorno(x0, storno);
        return storno;
    }

    static /* synthetic */ StornoStavka access$602(StornoStavka x0, StornoStavka x1) {
        StornoStavka stornoStavka = x1;
        StornoStavka.pcSetparent(x0, stornoStavka);
        return stornoStavka;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = StornoStavka.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"artikal", "brojTure", "children", "kolicina", "parent", "storno", "vrednost"};
        Class[] classArray = new Class[7];
        Class clazz2 = class$Lcom$dev63$restoran$model$Artikal != null ? class$Lcom$dev63$restoran$model$Artikal : (class$Lcom$dev63$restoran$model$Artikal = StornoStavka.class$("com.dev63.restoran.model.Artikal"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = StornoStavka.class$("java.lang.Integer"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = StornoStavka.class$("java.util.List"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = StornoStavka.class$("java.lang.Double"));
        classArray[3] = clazz5;
        Class clazz6 = class$Lcom$dev63$restoran$model$StornoStavka != null ? class$Lcom$dev63$restoran$model$StornoStavka : (class$Lcom$dev63$restoran$model$StornoStavka = StornoStavka.class$("com.dev63.restoran.model.StornoStavka"));
        classArray[4] = clazz6;
        Class clazz7 = class$Lcom$dev63$restoran$model$Storno != null ? class$Lcom$dev63$restoran$model$Storno : (class$Lcom$dev63$restoran$model$Storno = StornoStavka.class$("com.dev63.restoran.model.Storno"));
        classArray[5] = clazz7;
        classArray[6] = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = StornoStavka.class$("java.lang.Double"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 26, 26, 26};
        PCRegistry.register((Class)(class$Lcom$dev63$restoran$model$StornoStavka != null ? class$Lcom$dev63$restoran$model$StornoStavka : (class$Lcom$dev63$restoran$model$StornoStavka = StornoStavka.class$("com.dev63.restoran.model.StornoStavka"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"StornoStavka", (PersistenceCapable)new StornoStavka());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.artikal = null;
        this.brojTure = null;
        this.children = null;
        this.kolicina = null;
        this.parent = null;
        this.storno = null;
        this.vrednost = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        StornoStavka stornoStavka = new StornoStavka();
        if (bl) {
            stornoStavka.pcClearFields();
        }
        stornoStavka.pcStateManager = stateManager;
        stornoStavka.pcCopyKeyFieldsFromObjectId(object);
        return stornoStavka;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        StornoStavka stornoStavka = new StornoStavka();
        if (bl) {
            stornoStavka.pcClearFields();
        }
        stornoStavka.pcStateManager = stateManager;
        return stornoStavka;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = (Artikal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.brojTure = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.children = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.kolicina = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.parent = (StornoStavka)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.storno = (Storno)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.vrednost = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.artikal);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojTure);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.children);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kolicina);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parent);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.storno);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.vrednost);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(StornoStavka stornoStavka, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(stornoStavka, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.artikal = stornoStavka.artikal;
                return;
            }
            case 1: {
                this.brojTure = stornoStavka.brojTure;
                return;
            }
            case 2: {
                this.children = stornoStavka.children;
                return;
            }
            case 3: {
                this.kolicina = stornoStavka.kolicina;
                return;
            }
            case 4: {
                this.parent = stornoStavka.parent;
                return;
            }
            case 5: {
                this.storno = stornoStavka.storno;
                return;
            }
            case 6: {
                this.vrednost = stornoStavka.vrednost;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        StornoStavka stornoStavka = (StornoStavka)object;
        if (stornoStavka.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(stornoStavka, nArray[n]);
            ++n;
        }
    }

    private static final Artikal pcGetartikal(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.artikal;
        }
        int n = pcInheritedFieldCount + 0;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.artikal;
    }

    private static final void pcSetartikal(StornoStavka stornoStavka, Artikal artikal) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.artikal = artikal;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 0, (Object)stornoStavka.artikal, (Object)artikal, 0);
    }

    private static final Integer pcGetbrojTure(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.brojTure;
        }
        int n = pcInheritedFieldCount + 1;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.brojTure;
    }

    private static final void pcSetbrojTure(StornoStavka stornoStavka, Integer n) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.brojTure = n;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 1, (Object)stornoStavka.brojTure, (Object)n, 0);
    }

    private static final List pcGetchildren(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.children;
        }
        int n = pcInheritedFieldCount + 2;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.children;
    }

    private static final void pcSetchildren(StornoStavka stornoStavka, List list) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.children = list;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 2, stornoStavka.children, (Object)list, 0);
    }

    private static final Double pcGetkolicina(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.kolicina;
        }
        int n = pcInheritedFieldCount + 3;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.kolicina;
    }

    private static final void pcSetkolicina(StornoStavka stornoStavka, Double d) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.kolicina = d;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 3, (Object)stornoStavka.kolicina, (Object)d, 0);
    }

    private static final StornoStavka pcGetparent(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.parent;
        }
        int n = pcInheritedFieldCount + 4;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.parent;
    }

    private static final void pcSetparent(StornoStavka stornoStavka, StornoStavka stornoStavka2) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.parent = stornoStavka2;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 4, (Object)stornoStavka.parent, (Object)stornoStavka2, 0);
    }

    private static final Storno pcGetstorno(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.storno;
        }
        int n = pcInheritedFieldCount + 5;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.storno;
    }

    private static final void pcSetstorno(StornoStavka stornoStavka, Storno storno) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.storno = storno;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 5, (Object)stornoStavka.storno, (Object)storno, 0);
    }

    private static final Double pcGetvrednost(StornoStavka stornoStavka) {
        if (stornoStavka.pcStateManager == null) {
            return stornoStavka.vrednost;
        }
        int n = pcInheritedFieldCount + 6;
        stornoStavka.pcStateManager.accessingField(n);
        return stornoStavka.vrednost;
    }

    private static final void pcSetvrednost(StornoStavka stornoStavka, Double d) {
        if (stornoStavka.pcStateManager == null) {
            stornoStavka.vrednost = d;
            return;
        }
        stornoStavka.pcStateManager.settingObjectField((PersistenceCapable)stornoStavka, pcInheritedFieldCount + 6, (Object)stornoStavka.vrednost, (Object)d, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static class StornoStavkaBuilder {
        private StornoStavka instance = new StornoStavka();

        private StornoStavkaBuilder() {
        }

        public StornoStavkaBuilder artikal(Artikal artikal) {
            StornoStavka.access$102(this.instance, artikal);
            return this;
        }

        public StornoStavkaBuilder brojTure(Integer brojTure) {
            StornoStavka.access$202(this.instance, brojTure);
            return this;
        }

        public StornoStavkaBuilder kolicina(Double kolicina) {
            StornoStavka.access$302(this.instance, kolicina);
            return this;
        }

        public StornoStavkaBuilder vrednost(Double vrednost) {
            StornoStavka.access$402(this.instance, vrednost);
            return this;
        }

        public StornoStavkaBuilder storno(Storno storno) {
            StornoStavka.access$502(this.instance, storno);
            return this;
        }

        public StornoStavkaBuilder parent(StornoStavka parent) {
            StornoStavka.access$602(this.instance, parent);
            return this;
        }

        public StornoStavkaBuilder addChild(StornoStavka child) {
            StornoStavka.access$602(child, this.instance);
            StornoStavka.pcGetchildren(this.instance).add(child);
            return this;
        }

        public StornoStavka build() {
            StornoStavka built = this.instance;
            this.instance = null;
            return built;
        }
    }
}

