/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.constants.NumUtils;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipStorna;
import com.dev63.restoran.model.Tura;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Storno
extends BObject
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datum = new Date();
    @Column
    private Integer brojStola;
    @ManyToOne
    private Konobar konobar;
    @OneToMany(mappedBy="storno", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<StornoStavka> stavke;
    @Column(name="user")
    private String user;
    @Column(length=20)
    @Enumerated(value=EnumType.STRING)
    private TipStorna tipStorna;
    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date vremeStorniranja = new Date();
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Konobar;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$TipStorna;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Storno;

    public Storno() {
        this.tipStorna = TipStorna.PORUDZBINA;
        this.stavke = new LinkedList<StornoStavka>();
    }

    public Storno(Integer bs, Konobar k) {
        this();
        this.datum = new Date();
        this.brojStola = bs;
        this.konobar = k;
        this.tipStorna = TipStorna.PORUDZBINA;
    }

    public Storno(Konobar k, List<Tura> ture) {
        this();
        this.konobar = k;
        this.tipStorna = TipStorna.PORUDZBINA;
        if (ture != null) {
            for (Tura t : ture) {
                this.brojStola = t.getBrojStola();
                for (StavkaRacuna stavkaRacuna : t.getStavke()) {
                }
                this.datum = t.getDatum();
            }
        }
    }

    public double total() {
        double ret = 0.0;
        if (this.getStavke() == null) {
            return ret;
        }
        for (StornoStavka st : this.getStavke()) {
            ret += st.getVrednost().doubleValue();
        }
        return ret;
    }

    public void addStavka(StornoStavka ss) {
        ss.setStorno(this);
        Storno.pcGetstavke(this).add(ss);
    }

    public Integer getBrojStola() {
        return Storno.pcGetbrojStola(this);
    }

    public void setBrojStola(Integer brojStola) {
        Storno.pcSetbrojStola(this, brojStola);
    }

    public Konobar getKonobar() {
        return Storno.pcGetkonobar(this);
    }

    public void setKonobar(Konobar konobar) {
        Storno.pcSetkonobar(this, konobar);
    }

    public Date getDatum() {
        return Storno.pcGetdatum(this);
    }

    public void setDatum(Date datum) {
        Storno.pcSetdatum(this, datum);
    }

    public List<StornoStavka> getStavke() {
        return Storno.pcGetstavke(this);
    }

    public void setStavke(List<StornoStavka> stavke) {
        Storno.pcSetstavke(this, stavke);
    }

    public String getUser() {
        return Storno.pcGetuser(this);
    }

    public void setUser(String user) {
        Storno.pcSetuser(this, user);
    }

    public TipStorna getTip() {
        if (Storno.pcGettipStorna(this) == null) {
            Storno.pcSettipStorna(this, TipStorna.PORUDZBINA);
        }
        return Storno.pcGettipStorna(this);
    }

    public void setTip(TipStorna tip) {
        Storno.pcSettipStorna(this, tip);
    }

    public Date getVremeStorniranja() {
        if (Storno.pcGetvremeStorniranja(this) == null) {
            Storno.pcSetvremeStorniranja(this, Storno.pcGetdatum(this));
        }
        return Storno.pcGetvremeStorniranja(this);
    }

    public void setVremeStorniranja(Date vremeStorniranja) {
        Storno.pcSetvremeStorniranja(this, vremeStorniranja == null ? new Date() : vremeStorniranja);
    }

    public static StornoBuilder builder() {
        return new StornoBuilder();
    }

    static /* synthetic */ TipStorna access$102(Storno x0, TipStorna x1) {
        TipStorna tipStorna = x1;
        Storno.pcSettipStorna(x0, tipStorna);
        return tipStorna;
    }

    static /* synthetic */ Date access$202(Storno x0, Date x1) {
        Date date = x1;
        Storno.pcSetdatum(x0, date);
        return date;
    }

    static /* synthetic */ Date access$302(Storno x0, Date x1) {
        Date date = x1;
        Storno.pcSetvremeStorniranja(x0, date);
        return date;
    }

    static /* synthetic */ Konobar access$402(Storno x0, Konobar x1) {
        Konobar konobar = x1;
        Storno.pcSetkonobar(x0, konobar);
        return konobar;
    }

    static /* synthetic */ Integer access$502(Storno x0, Integer x1) {
        Integer n = x1;
        Storno.pcSetbrojStola(x0, n);
        return n;
    }

    static /* synthetic */ String access$602(Storno x0, String x1) {
        String string = x1;
        Storno.pcSetuser(x0, string);
        return string;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = Storno.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"brojStola", "datum", "konobar", "stavke", "tipStorna", "user", "vremeStorniranja"};
        Class[] classArray = new Class[7];
        Class clazz2 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Storno.class$("java.lang.Integer"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Storno.class$("java.util.Date"));
        classArray[1] = clazz3;
        Class clazz4 = class$Lcom$dev63$restoran$model$Konobar != null ? class$Lcom$dev63$restoran$model$Konobar : (class$Lcom$dev63$restoran$model$Konobar = Storno.class$("com.dev63.restoran.model.Konobar"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Storno.class$("java.util.List"));
        classArray[3] = clazz5;
        Class clazz6 = class$Lcom$dev63$restoran$model$TipStorna != null ? class$Lcom$dev63$restoran$model$TipStorna : (class$Lcom$dev63$restoran$model$TipStorna = Storno.class$("com.dev63.restoran.model.TipStorna"));
        classArray[4] = clazz6;
        Class clazz7 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Storno.class$("java.lang.String"));
        classArray[5] = clazz7;
        classArray[6] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Storno.class$("java.util.Date"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 10, 26, 26, 26};
        Class clazz8 = class$Lcom$dev63$restoran$model$Storno != null ? class$Lcom$dev63$restoran$model$Storno : (class$Lcom$dev63$restoran$model$Storno = Storno.class$("com.dev63.restoran.model.Storno"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Storno", (PersistenceCapable)new Storno());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.brojStola = null;
        this.datum = null;
        this.konobar = null;
        this.stavke = null;
        this.tipStorna = null;
        this.user = null;
        this.vremeStorniranja = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Storno storno = new Storno();
        if (bl) {
            storno.pcClearFields();
        }
        storno.pcStateManager = stateManager;
        storno.pcCopyKeyFieldsFromObjectId(object);
        return storno;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Storno storno = new Storno();
        if (bl) {
            storno.pcClearFields();
        }
        storno.pcStateManager = stateManager;
        return storno;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brojStola = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.datum = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.konobar = (Konobar)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.stavke = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.tipStorna = (TipStorna)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 5: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.vremeStorniranja = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojStola);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datum);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.konobar);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.stavke);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tipStorna);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.vremeStorniranja);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Storno storno, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(storno, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.brojStola = storno.brojStola;
                return;
            }
            case 1: {
                this.datum = storno.datum;
                return;
            }
            case 2: {
                this.konobar = storno.konobar;
                return;
            }
            case 3: {
                this.stavke = storno.stavke;
                return;
            }
            case 4: {
                this.tipStorna = storno.tipStorna;
                return;
            }
            case 5: {
                this.user = storno.user;
                return;
            }
            case 6: {
                this.vremeStorniranja = storno.vremeStorniranja;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Storno storno = (Storno)object;
        if (storno.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(storno, nArray[n]);
            ++n;
        }
    }

    private static final Integer pcGetbrojStola(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.brojStola;
        }
        int n = pcInheritedFieldCount + 0;
        storno.pcStateManager.accessingField(n);
        return storno.brojStola;
    }

    private static final void pcSetbrojStola(Storno storno, Integer n) {
        if (storno.pcStateManager == null) {
            storno.brojStola = n;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 0, (Object)storno.brojStola, (Object)n, 0);
    }

    private static final Date pcGetdatum(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.datum;
        }
        int n = pcInheritedFieldCount + 1;
        storno.pcStateManager.accessingField(n);
        return storno.datum;
    }

    private static final void pcSetdatum(Storno storno, Date date) {
        if (storno.pcStateManager == null) {
            storno.datum = date;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 1, (Object)storno.datum, (Object)date, 0);
    }

    private static final Konobar pcGetkonobar(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.konobar;
        }
        int n = pcInheritedFieldCount + 2;
        storno.pcStateManager.accessingField(n);
        return storno.konobar;
    }

    private static final void pcSetkonobar(Storno storno, Konobar konobar) {
        if (storno.pcStateManager == null) {
            storno.konobar = konobar;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 2, (Object)storno.konobar, (Object)konobar, 0);
    }

    private static final List pcGetstavke(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.stavke;
        }
        int n = pcInheritedFieldCount + 3;
        storno.pcStateManager.accessingField(n);
        return storno.stavke;
    }

    private static final void pcSetstavke(Storno storno, List list) {
        if (storno.pcStateManager == null) {
            storno.stavke = list;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 3, storno.stavke, (Object)list, 0);
    }

    private static final TipStorna pcGettipStorna(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.tipStorna;
        }
        int n = pcInheritedFieldCount + 4;
        storno.pcStateManager.accessingField(n);
        return storno.tipStorna;
    }

    private static final void pcSettipStorna(Storno storno, TipStorna tipStorna) {
        if (storno.pcStateManager == null) {
            storno.tipStorna = tipStorna;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 4, (Object)storno.tipStorna, (Object)tipStorna, 0);
    }

    private static final String pcGetuser(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.user;
        }
        int n = pcInheritedFieldCount + 5;
        storno.pcStateManager.accessingField(n);
        return storno.user;
    }

    private static final void pcSetuser(Storno storno, String string) {
        if (storno.pcStateManager == null) {
            storno.user = string;
            return;
        }
        storno.pcStateManager.settingStringField((PersistenceCapable)storno, pcInheritedFieldCount + 5, storno.user, string, 0);
    }

    private static final Date pcGetvremeStorniranja(Storno storno) {
        if (storno.pcStateManager == null) {
            return storno.vremeStorniranja;
        }
        int n = pcInheritedFieldCount + 6;
        storno.pcStateManager.accessingField(n);
        return storno.vremeStorniranja;
    }

    private static final void pcSetvremeStorniranja(Storno storno, Date date) {
        if (storno.pcStateManager == null) {
            storno.vremeStorniranja = date;
            return;
        }
        storno.pcStateManager.settingObjectField((PersistenceCapable)storno, pcInheritedFieldCount + 6, (Object)storno.vremeStorniranja, (Object)date, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static class StornoBuilder {
        private Storno instance = new Storno();

        private StornoBuilder() {
            Storno.access$102(this.instance, TipStorna.PORUDZBINA);
            Storno.access$202(this.instance, new Date());
            Storno.access$302(this.instance, Storno.pcGetdatum(this.instance));
        }

        public StornoBuilder konobar(Konobar konobar) {
            Storno.access$402(this.instance, konobar);
            return this;
        }

        public StornoBuilder brojStola(Integer brojStola) {
            Storno.access$502(this.instance, brojStola);
            return this;
        }

        public StornoBuilder vremeStorniranja(Date vremeStorniranja) {
            Storno.access$302(this.instance, vremeStorniranja);
            return this;
        }

        public StornoBuilder user(String user) {
            Storno.access$602(this.instance, user);
            return this;
        }

        public StornoBuilder tip(TipStorna tip) {
            Storno.access$102(this.instance, tip);
            return this;
        }

        public StornoBuilder addStavka(StornoStavka stavka) {
            stavka.setStorno(this.instance);
            Storno.pcGetstavke(this.instance).add(stavka);
            return this;
        }

        private StornoStavka addStavkaAndReturnIt(StornoStavka stavka) {
            Storno.pcGetstavke(this.instance).add(stavka);
            return stavka;
        }

        private StornoStavka.StornoStavkaBuilder buildStavka(StavkaRacuna stavka) {
            StornoStavka.StornoStavkaBuilder builder = StornoStavka.builder();
            builder.artikal(stavka.getArtikal());
            builder.brojTure(stavka.getTura().getBrojTure());
            builder.kolicina(stavka.getKolicina());
            builder.vrednost(stavka.getVrednostSaPopustom());
            builder.storno(this.instance);
            return builder;
        }

        public StornoBuilder addTura(Tura tura) {
            if (tura == null) {
                return this;
            }
            Storno.access$502(this.instance, tura.getBrojStola());
            for (StavkaRacuna stavka : tura.getStavke()) {
                if (stavka.getGlavnaStavka() != null) continue;
                StornoStavka.StornoStavkaBuilder builder = this.buildStavka(stavka);
                if (stavka.getPodStavke() != null) {
                    StornoStavka.StornoStavkaBuilder childBuilder = null;
                    for (StavkaRacuna child : stavka.getPodStavke()) {
                        childBuilder = this.buildStavka(child);
                        builder.addChild(this.addStavkaAndReturnIt(childBuilder.build()));
                        child.setKolicina(0.0);
                    }
                }
                Storno.pcGetstavke(this.instance).add(builder.build());
                stavka.setKolicina(0.0);
            }
            return this;
        }

        public StornoBuilder addStavka(StavkaRacuna stavka, Double kolicina) {
            if (stavka == null) {
                return this;
            }
            if (kolicina == null || kolicina > stavka.getKolicina()) {
                kolicina = stavka.getKolicina();
            }
            Storno.access$502(this.instance, stavka.getTura().getBrojStola());
            if (stavka.getGlavnaStavka() == null) {
                StornoStavka.StornoStavkaBuilder builder = this.buildStavka(stavka).kolicina(kolicina);
                if (stavka.getPodStavke() != null) {
                    System.out.println("ovde1");
                    for (StavkaRacuna child : stavka.getPodStavke()) {
                        Double kolicinaC = NumUtils.round(child.getKolicina() / stavka.getKolicina() * kolicina, 3);
                        StornoStavka.StornoStavkaBuilder childBuilder = this.buildStavka(child).kolicina(kolicinaC);
                        builder.addChild(this.addStavkaAndReturnIt(childBuilder.build()));
                        child.setKolicina(child.getKolicina() - kolicinaC);
                    }
                }
                this.addStavkaAndReturnIt(builder.build());
                stavka.setKolicina(stavka.getKolicina() - kolicina);
            } else {
                System.out.println("ovde2");
                StornoStavka.StornoStavkaBuilder builder = this.buildStavka(stavka.getGlavnaStavka());
                builder.kolicina(0.0);
                Double kolicinaC = NumUtils.round(kolicina, 3);
                StornoStavka.StornoStavkaBuilder childBuilder = this.buildStavka(stavka).kolicina(kolicinaC);
                builder.addChild(this.addStavkaAndReturnIt(childBuilder.build()));
                this.addStavkaAndReturnIt(builder.build());
                stavka.setKolicina(stavka.getKolicina() - kolicinaC);
            }
            return this;
        }

        public Storno build() {
            Storno built = this.instance;
            this.instance = null;
            return built;
        }
    }
}

