/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Knjiziv;
import com.dev63.restoran.model.Komitent;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.newmodel.Bill;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Racun
extends BObject
implements Knjiziv,
Bill,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    @ManyToOne
    private Konobar konobar;
    @Column(nullable=true)
    @ManyToOne
    private StalniGost stalniGost;
    @Column(nullable=true)
    @ManyToOne
    private Komitent komitent;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date datum;
    @OneToMany(mappedBy="racun", cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    private List<StavkaRacuna> stavke1;
    @OneToMany(mappedBy="racun", cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    private List<Placanje> placanja;
    @OneToMany(mappedBy="racun", cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE}, fetch=FetchType.EAGER)
    private List<Tura> ture;
    @Column(nullable=false)
    private boolean storniran;
    @Column(nullable=false)
    private Integer brojStola;
    @Column(nullable=false)
    private Boolean fiskalniOdstampan;
    @Column(columnDefinition="tinyint(1) default 0")
    private Boolean naOsnovno = false;
    @Column(columnDefinition="tinyint(1) default 0")
    private Boolean menipromet = false;
    @Column
    private String zbirnaFaktura;
    @Column(columnDefinition="INT default NULL")
    private int zbirnaFakturaId;
    @Column(columnDefinition="varchar(50) default ''")
    private String imeHotelskogGosta = "";
    @Column
    private Integer brojFakture;
    @Column
    private Integer brojRacuna;
    @Column
    private Boolean zatvoren;
    @Column
    private String crnoPlacanje;
    @Column(length=1024)
    private String napomena;
    @Column
    private Double popust = 0.0;
    @OneToOne(mappedBy="racun", optional=true, cascade={CascadeType.ALL})
    private MeniPromet meniPromet;
    @OneToMany(mappedBy="racun")
    private List<Knjizenje> knjizenja = new LinkedList<Knjizenje>();
    @ManyToOne(targetEntity=Kasa.class)
    @JoinColumn(table="kasa", name="kasa_id", referencedColumnName="id")
    private Kasa kasa;
    @Column(length=64)
    private String oznakaSobe;
    @Column
    private String brojBI;
    @Column
    private long Rezervacija_id;
    @Column
    private String brojGostiju;
    @Column
    private long zdBroj;
    @Column
    private String kanalProdaje;
    @Column
    private int DOSTAVA_ID;
    @Column
    private int DOSTAVAADRESA_ID;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Kasa;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Komitent;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Konobar;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$MeniPromet;
    static /* synthetic */ Class class$Ljava$lang$Double;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$StalniGost;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Racun;

    public Racun() {
    }

    public Racun(Racun racun) {
        this();
        this.brojFakture = racun.getBrojFakture();
        this.brojStola = racun.getBrojStola();
        this.crnoPlacanje = racun.getCrnoPlacanje();
        this.datum = racun.getDatum();
        this.fiskalniOdstampan = racun.getFiskalniOdstampan();
        this.id = racun.getId();
        this.konobar = racun.getKonobar();
        this.placanja = racun.getPlacanja();
        this.popust = racun.getPopust();
        this.stalniGost = racun.getStalniGost();
        this.stavke1 = racun.getStavke1();
        this.storniran = racun.isStorniran();
        this.ture = racun.getTure();
        this.zatvoren = racun.getZatvoren();
        this.brojRacuna = racun.getBrojRacuna();
        this.Rezervacija_id = racun.getRezervacija_id();
        this.meniPromet = racun.getMeniPromet();
    }

    public double total() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        if (this.getPopust() == 0.0) {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                ret += st.getVrednost().doubleValue();
            }
        } else {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                if (st.getArtikal().getDozvoljenPopust().booleanValue()) {
                    if (st.getRacun() == null) {
                        st.setRacun(this);
                    }
                    ret += st.getVrednostSaPopustom().doubleValue();
                    continue;
                }
                ret += st.getVrednost().doubleValue();
            }
        }
        return ret;
    }

    public double totalStampa() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        if (this.getPopust() == 0.0) {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                ret += st.getVrednost().doubleValue();
            }
        } else {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                if (st.getArtikal().getDozvoljenPopust().booleanValue()) {
                    ret += st.getVrednostSaPopustom().doubleValue();
                    continue;
                }
                ret += st.getVrednost().doubleValue();
            }
        }
        return ret;
    }

    public double totalMeniPromet() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        if (this.getPopust() == 0.0) {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                ret += st.getVrednost().doubleValue();
            }
        } else {
            for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
                if (st.getArtikal().getDozvoljenPopust().booleanValue()) {
                    if (st.getRacun() == null) {
                        st.setRacun(this);
                    }
                    ret += st.getVrednostSaPopustom().doubleValue();
                    continue;
                }
                ret += st.getVrednost().doubleValue();
            }
        }
        return ret;
    }

    public double servis() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
            if (!(st.getCena() > st.getArtikal().getCena())) continue;
            ret += st.getKolicina() * (st.getCena() - st.getArtikal().getCena());
        }
        return ret;
    }

    public double obracunatPopust() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
            if (!(st.getCena() < st.getArtikal().getCena())) continue;
            ret += st.getKolicina() * (st.getArtikal().getCena() - st.getCena());
        }
        return ret;
    }

    public double totalBezPopusta() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
            ret += st.getVrednost().doubleValue();
        }
        return ret;
    }

    public double totalBezPopustaSaCenomArtikla() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
            if (st.getArtikal() != null) {
                ret += st.getArtikal().getCena() * st.getKolicina();
                continue;
            }
            ret += st.getVrednost().doubleValue();
        }
        return ret;
    }

    public double totalSaPopustom() {
        double ret = 0.0;
        if (Racun.pcGetstavke1(this) == null) {
            return ret;
        }
        for (StavkaRacuna st : Racun.pcGetstavke1(this)) {
            ret += st.getVrednostSaPopustom().doubleValue();
        }
        return ret;
    }

    public Date getDatum() {
        return Racun.pcGetdatum(this);
    }

    public void setDatum(Date datum) {
        Racun.pcSetdatum(this, datum);
    }

    @Override
    public String toString() {
        System.out.println(Racun.pcGetdatum(this));
        System.out.println(this.getBrojStola());
        return "Racun:  datum->" + Racun.pcGetdatum(this) + ", broj stola->" + this.getBrojStola();
    }

    public Konobar getKonobar() {
        return Racun.pcGetkonobar(this);
    }

    public void setKonobar(Konobar konobar) {
        Racun.pcSetkonobar(this, konobar);
    }

    public boolean isStorniran() {
        return Racun.pcGetstorniran(this);
    }

    public void setStorniran(boolean storniran) {
        Racun.pcSetstorniran(this, storniran);
    }

    public List<Placanje> getPlacanja() {
        return Racun.pcGetplacanja(this);
    }

    public void setPlacanja(List<Placanje> placanja) {
        Racun.pcSetplacanja(this, placanja);
    }

    public Integer getBrojStola() {
        return Racun.pcGetbrojStola(this);
    }

    public void setBrojStola(Integer brojStola) {
        Racun.pcSetbrojStola(this, brojStola);
    }

    public List<Tura> getTure() {
        return Racun.pcGetture(this);
    }

    public void setTure(List<Tura> ture) {
        Racun.pcSetture(this, ture);
    }

    public Boolean getFiskalniOdstampan() {
        return Racun.pcGetfiskalniOdstampan(this);
    }

    public void setFiskalniOdstampan(Boolean fiskalniOdstampan) {
        Racun.pcSetfiskalniOdstampan(this, fiskalniOdstampan);
    }

    public Integer getBrojFakture() {
        return Racun.pcGetbrojFakture(this);
    }

    public void setBrojFakture(Integer brojFakture) {
        Racun.pcSetbrojFakture(this, brojFakture);
    }

    public List<StavkaRacuna> getStavke1() {
        return Racun.pcGetstavke1(this);
    }

    public List<StavkaRacuna> getStavke() {
        return StavkeSumarno.getSumarnoF(Racun.pcGetstavke1(this));
    }

    public void setStavke1(List<StavkaRacuna> stavke1) {
        Racun.pcSetstavke1(this, stavke1);
    }

    public Boolean getZatvoren() {
        return Racun.pcGetzatvoren(this);
    }

    public void setZatvoren(Boolean zatvoren) {
        Racun.pcSetzatvoren(this, zatvoren);
    }

    public String getCrnoPlacanje() {
        return Racun.pcGetcrnoPlacanje(this);
    }

    public void setCrnoPlacanje(String crnoPlacanje) {
        Racun.pcSetcrnoPlacanje(this, crnoPlacanje);
    }

    public Double getPopust() {
        return Optional.ofNullable(Racun.pcGetpopust(this)).orElse(0.0);
    }

    public void setPopust(Double popust) {
        Racun.pcSetpopust(this, Optional.ofNullable(popust).orElse(0.0));
    }

    public StalniGost getStalniGost() {
        return Racun.pcGetstalniGost(this);
    }

    public void setStalniGost(StalniGost stalniGost) {
        Racun.pcSetstalniGost(this, stalniGost);
    }

    public Komitent getKomitent() {
        return Racun.pcGetkomitent(this);
    }

    public void setKomitent(Komitent komitent) {
        Racun.pcSetkomitent(this, komitent);
    }

    public MeniPromet getMeniPromet() {
        return Racun.pcGetmeniPromet(this);
    }

    public void setMeniPromet(MeniPromet meniPromet) {
        Racun.pcSetmeniPromet(this, meniPromet);
    }

    public Integer getBrojRacuna() {
        return Racun.pcGetbrojRacuna(this);
    }

    public void setBrojRacuna(Integer brojRacuna) {
        Racun.pcSetbrojRacuna(this, brojRacuna);
    }

    public long getZdBroj() {
        return Racun.pcGetzdBroj(this);
    }

    public void setZdBroj(long zdBroj) {
        Racun.pcSetzdBroj(this, zdBroj);
    }

    @Override
    public boolean getRealizovan() {
        boolean ret = false;
        if (Racun.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Racun.pcGetknjizenja(this)) {
                if (!knjizenje.getRealizovano().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    @Override
    public Double getRealizovaniIznos() {
        Double ret = 0.0;
        if (Racun.pcGetknjizenja(this) != null) {
            for (Knjizenje knjizenje : Racun.pcGetknjizenja(this)) {
                ret = ret + (knjizenje.getRealizovaniIznos() != null ? knjizenje.getRealizovaniIznos() : 0.0);
            }
        }
        return ret;
    }

    @Override
    public void setKnjizenja(List<Knjizenje> knjizenja) {
        Racun.pcSetknjizenja(this, knjizenja);
    }

    @Override
    public List<Knjizenje> getKnjizenja() {
        return Racun.pcGetknjizenja(this);
    }

    public Kasa getKasa() {
        return Racun.pcGetkasa(this);
    }

    public void setKasa(Kasa kasa) {
        Racun.pcSetkasa(this, kasa);
    }

    public String getOznakaSobe() {
        return Racun.pcGetoznakaSobe(this);
    }

    public void setOznakaSobe(String oznakaSobe) {
        Racun.pcSetoznakaSobe(this, oznakaSobe);
    }

    public String getBrojBI() {
        return Racun.pcGetbrojBI(this);
    }

    public void setBrojBI(String brojBI) {
        Racun.pcSetbrojBI(this, brojBI);
    }

    public long getRezervacija_id() {
        return Racun.pcGetRezervacija_id(this);
    }

    public void setRezervacija_id(long rezervacija_id) {
        Racun.pcSetRezervacija_id(this, rezervacija_id);
    }

    public boolean isFaktura() {
        return Racun.pcGetplacanja(this) != null && Racun.pcGetplacanja(this).size() == 1 && NacinPlacanja.FAKTURA.equals((Object)((Placanje)Racun.pcGetplacanja(this).get(0)).getNacin());
    }

    @Override
    public BigDecimal getDiscountPercentage() {
        return BigDecimal.valueOf(this.getPopust());
    }

    public String getNapomena() {
        return Racun.pcGetnapomena(this);
    }

    public void setNapomena(String napomena) {
        Racun.pcSetnapomena(this, napomena);
    }

    public String getBrojGostiju() {
        return Racun.pcGetbrojGostiju(this);
    }

    public void setBrojGostiju(String brojGostiju) {
        Racun.pcSetbrojGostiju(this, brojGostiju);
    }

    public Boolean getNaOsnovno() {
        return Racun.pcGetnaOsnovno(this);
    }

    public void setNaOsnovno(Boolean naOsnovno) {
        Racun.pcSetnaOsnovno(this, naOsnovno);
    }

    public Boolean getMenipromet() {
        return Racun.pcGetmenipromet(this);
    }

    public void setMenipromet(Boolean menipromet) {
        Racun.pcSetmenipromet(this, menipromet);
    }

    public String getZbirnaFaktura() {
        return Racun.pcGetzbirnaFaktura(this);
    }

    public void setZbirnaFaktura(String zbirnaFaktura) {
        Racun.pcSetzbirnaFaktura(this, zbirnaFaktura);
    }

    public String getImeHotelskogGosta() {
        return Racun.pcGetimeHotelskogGosta(this);
    }

    public void setImeHotelskogGosta(String imeHotelskogGosta) {
        Racun.pcSetimeHotelskogGosta(this, imeHotelskogGosta);
    }

    public int getZbirnaFakturaId() {
        return Racun.pcGetzbirnaFakturaId(this);
    }

    public void setZbirnaFakturaId(int zbirnaFakturaId) {
        Racun.pcSetzbirnaFakturaId(this, zbirnaFakturaId);
    }

    public String getKanalProdaje() {
        return Racun.pcGetkanalProdaje(this);
    }

    public void setKanalProdaje(String kanalProdaje) {
        Racun.pcSetkanalProdaje(this, kanalProdaje);
    }

    public int getDOSTAVA_ID() {
        return Racun.pcGetDOSTAVA_ID(this);
    }

    public void setDOSTAVA_ID(int dOSTAVA_ID) {
        Racun.pcSetDOSTAVA_ID(this, dOSTAVA_ID);
    }

    public int getDOSTAVAADRESA_ID() {
        return Racun.pcGetDOSTAVAADRESA_ID(this);
    }

    public void setDOSTAVAADRESA_ID(int dOSTAVAADRESA_ID) {
        Racun.pcSetDOSTAVAADRESA_ID(this, dOSTAVAADRESA_ID);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = Racun.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"DOSTAVAADRESA_ID", "DOSTAVA_ID", "Rezervacija_id", "brojBI", "brojFakture", "brojGostiju", "brojRacuna", "brojStola", "crnoPlacanje", "datum", "fiskalniOdstampan", "imeHotelskogGosta", "kanalProdaje", "kasa", "knjizenja", "komitent", "konobar", "meniPromet", "menipromet", "naOsnovno", "napomena", "oznakaSobe", "placanja", "popust", "stalniGost", "stavke1", "storniran", "ture", "zatvoren", "zbirnaFaktura", "zbirnaFakturaId", "zdBroj"};
        Class[] classArray = new Class[32];
        classArray[0] = Integer.TYPE;
        classArray[1] = Integer.TYPE;
        classArray[2] = Long.TYPE;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[3] = clazz2;
        Class clazz3 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Racun.class$("java.lang.Integer"));
        classArray[4] = clazz3;
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Racun.class$("java.lang.Integer"));
        classArray[7] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Racun.class$("java.lang.Integer"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Racun.class$("java.util.Date"));
        classArray[9] = clazz4;
        Class clazz5 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Racun.class$("java.lang.Boolean"));
        classArray[10] = clazz5;
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        Class clazz6 = class$Lcom$dev63$restoran$model$Kasa != null ? class$Lcom$dev63$restoran$model$Kasa : (class$Lcom$dev63$restoran$model$Kasa = Racun.class$("com.dev63.restoran.model.Kasa"));
        classArray[13] = clazz6;
        Class clazz7 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Racun.class$("java.util.List"));
        classArray[14] = clazz7;
        Class clazz8 = class$Lcom$dev63$restoran$model$Komitent != null ? class$Lcom$dev63$restoran$model$Komitent : (class$Lcom$dev63$restoran$model$Komitent = Racun.class$("com.dev63.restoran.model.Komitent"));
        classArray[15] = clazz8;
        Class clazz9 = class$Lcom$dev63$restoran$model$Konobar != null ? class$Lcom$dev63$restoran$model$Konobar : (class$Lcom$dev63$restoran$model$Konobar = Racun.class$("com.dev63.restoran.model.Konobar"));
        classArray[16] = clazz9;
        Class clazz10 = class$Lcom$dev63$restoran$model$MeniPromet != null ? class$Lcom$dev63$restoran$model$MeniPromet : (class$Lcom$dev63$restoran$model$MeniPromet = Racun.class$("com.dev63.restoran.model.MeniPromet"));
        classArray[17] = clazz10;
        classArray[18] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Racun.class$("java.lang.Boolean"));
        classArray[19] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Racun.class$("java.lang.Boolean"));
        classArray[20] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[22] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Racun.class$("java.util.List"));
        Class clazz11 = class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = Racun.class$("java.lang.Double"));
        classArray[23] = clazz11;
        Class clazz12 = class$Lcom$dev63$restoran$model$StalniGost != null ? class$Lcom$dev63$restoran$model$StalniGost : (class$Lcom$dev63$restoran$model$StalniGost = Racun.class$("com.dev63.restoran.model.StalniGost"));
        classArray[24] = clazz12;
        classArray[25] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Racun.class$("java.util.List"));
        classArray[26] = Boolean.TYPE;
        classArray[27] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Racun.class$("java.util.List"));
        classArray[28] = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = Racun.class$("java.lang.Boolean"));
        classArray[29] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Racun.class$("java.lang.String"));
        classArray[30] = Integer.TYPE;
        classArray[31] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 10, 26, 26, 26, 26};
        Class clazz13 = class$Lcom$dev63$restoran$model$Racun != null ? class$Lcom$dev63$restoran$model$Racun : (class$Lcom$dev63$restoran$model$Racun = Racun.class$("com.dev63.restoran.model.Racun"));
        PCRegistry.register((Class)clazz13, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Racun", (PersistenceCapable)new Racun());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.DOSTAVAADRESA_ID = 0;
        this.DOSTAVA_ID = 0;
        this.Rezervacija_id = 0L;
        this.brojBI = null;
        this.brojFakture = null;
        this.brojGostiju = null;
        this.brojRacuna = null;
        this.brojStola = null;
        this.crnoPlacanje = null;
        this.datum = null;
        this.fiskalniOdstampan = null;
        this.imeHotelskogGosta = null;
        this.kanalProdaje = null;
        this.kasa = null;
        this.knjizenja = null;
        this.komitent = null;
        this.konobar = null;
        this.meniPromet = null;
        this.menipromet = null;
        this.naOsnovno = null;
        this.napomena = null;
        this.oznakaSobe = null;
        this.placanja = null;
        this.popust = null;
        this.stalniGost = null;
        this.stavke1 = null;
        this.storniran = false;
        this.ture = null;
        this.zatvoren = null;
        this.zbirnaFaktura = null;
        this.zbirnaFakturaId = 0;
        this.zdBroj = 0L;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Racun racun = new Racun();
        if (bl) {
            racun.pcClearFields();
        }
        racun.pcStateManager = stateManager;
        racun.pcCopyKeyFieldsFromObjectId(object);
        return racun;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Racun racun = new Racun();
        if (bl) {
            racun.pcClearFields();
        }
        racun.pcStateManager = stateManager;
        return racun;
    }

    protected static int pcGetManagedFieldCount() {
        return 32 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.DOSTAVAADRESA_ID = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.DOSTAVA_ID = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.Rezervacija_id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.brojBI = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.brojFakture = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.brojGostiju = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.brojRacuna = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.brojStola = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.crnoPlacanje = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.datum = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.fiskalniOdstampan = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.imeHotelskogGosta = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.kanalProdaje = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.kasa = (Kasa)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.knjizenja = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.komitent = (Komitent)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.konobar = (Konobar)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.meniPromet = (MeniPromet)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.menipromet = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.naOsnovno = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.napomena = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.oznakaSobe = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.placanja = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.popust = (Double)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.stalniGost = (StalniGost)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.stavke1 = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.storniran = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.ture = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 28: {
                this.zatvoren = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.zbirnaFaktura = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 30: {
                this.zbirnaFakturaId = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 31: {
                this.zdBroj = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.DOSTAVAADRESA_ID);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.DOSTAVA_ID);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.Rezervacija_id);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.brojBI);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojFakture);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.brojGostiju);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojRacuna);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.brojStola);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.crnoPlacanje);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datum);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.fiskalniOdstampan);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.imeHotelskogGosta);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.kanalProdaje);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kasa);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.knjizenja);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.komitent);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.konobar);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.meniPromet);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.menipromet);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.naOsnovno);
                return;
            }
            case 20: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.napomena);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.oznakaSobe);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.placanja);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.popust);
                return;
            }
            case 24: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.stalniGost);
                return;
            }
            case 25: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.stavke1);
                return;
            }
            case 26: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.storniran);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.ture);
                return;
            }
            case 28: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.zatvoren);
                return;
            }
            case 29: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.zbirnaFaktura);
                return;
            }
            case 30: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.zbirnaFakturaId);
                return;
            }
            case 31: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.zdBroj);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Racun racun, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(racun, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.DOSTAVAADRESA_ID = racun.DOSTAVAADRESA_ID;
                return;
            }
            case 1: {
                this.DOSTAVA_ID = racun.DOSTAVA_ID;
                return;
            }
            case 2: {
                this.Rezervacija_id = racun.Rezervacija_id;
                return;
            }
            case 3: {
                this.brojBI = racun.brojBI;
                return;
            }
            case 4: {
                this.brojFakture = racun.brojFakture;
                return;
            }
            case 5: {
                this.brojGostiju = racun.brojGostiju;
                return;
            }
            case 6: {
                this.brojRacuna = racun.brojRacuna;
                return;
            }
            case 7: {
                this.brojStola = racun.brojStola;
                return;
            }
            case 8: {
                this.crnoPlacanje = racun.crnoPlacanje;
                return;
            }
            case 9: {
                this.datum = racun.datum;
                return;
            }
            case 10: {
                this.fiskalniOdstampan = racun.fiskalniOdstampan;
                return;
            }
            case 11: {
                this.imeHotelskogGosta = racun.imeHotelskogGosta;
                return;
            }
            case 12: {
                this.kanalProdaje = racun.kanalProdaje;
                return;
            }
            case 13: {
                this.kasa = racun.kasa;
                return;
            }
            case 14: {
                this.knjizenja = racun.knjizenja;
                return;
            }
            case 15: {
                this.komitent = racun.komitent;
                return;
            }
            case 16: {
                this.konobar = racun.konobar;
                return;
            }
            case 17: {
                this.meniPromet = racun.meniPromet;
                return;
            }
            case 18: {
                this.menipromet = racun.menipromet;
                return;
            }
            case 19: {
                this.naOsnovno = racun.naOsnovno;
                return;
            }
            case 20: {
                this.napomena = racun.napomena;
                return;
            }
            case 21: {
                this.oznakaSobe = racun.oznakaSobe;
                return;
            }
            case 22: {
                this.placanja = racun.placanja;
                return;
            }
            case 23: {
                this.popust = racun.popust;
                return;
            }
            case 24: {
                this.stalniGost = racun.stalniGost;
                return;
            }
            case 25: {
                this.stavke1 = racun.stavke1;
                return;
            }
            case 26: {
                this.storniran = racun.storniran;
                return;
            }
            case 27: {
                this.ture = racun.ture;
                return;
            }
            case 28: {
                this.zatvoren = racun.zatvoren;
                return;
            }
            case 29: {
                this.zbirnaFaktura = racun.zbirnaFaktura;
                return;
            }
            case 30: {
                this.zbirnaFakturaId = racun.zbirnaFakturaId;
                return;
            }
            case 31: {
                this.zdBroj = racun.zdBroj;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Racun racun = (Racun)object;
        if (racun.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(racun, nArray[n]);
            ++n;
        }
    }

    private static final int pcGetDOSTAVAADRESA_ID(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.DOSTAVAADRESA_ID;
        }
        int n = pcInheritedFieldCount + 0;
        racun.pcStateManager.accessingField(n);
        return racun.DOSTAVAADRESA_ID;
    }

    private static final void pcSetDOSTAVAADRESA_ID(Racun racun, int n) {
        if (racun.pcStateManager == null) {
            racun.DOSTAVAADRESA_ID = n;
            return;
        }
        racun.pcStateManager.settingIntField((PersistenceCapable)racun, pcInheritedFieldCount + 0, racun.DOSTAVAADRESA_ID, n, 0);
    }

    private static final int pcGetDOSTAVA_ID(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.DOSTAVA_ID;
        }
        int n = pcInheritedFieldCount + 1;
        racun.pcStateManager.accessingField(n);
        return racun.DOSTAVA_ID;
    }

    private static final void pcSetDOSTAVA_ID(Racun racun, int n) {
        if (racun.pcStateManager == null) {
            racun.DOSTAVA_ID = n;
            return;
        }
        racun.pcStateManager.settingIntField((PersistenceCapable)racun, pcInheritedFieldCount + 1, racun.DOSTAVA_ID, n, 0);
    }

    private static final long pcGetRezervacija_id(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.Rezervacija_id;
        }
        int n = pcInheritedFieldCount + 2;
        racun.pcStateManager.accessingField(n);
        return racun.Rezervacija_id;
    }

    private static final void pcSetRezervacija_id(Racun racun, long l) {
        if (racun.pcStateManager == null) {
            racun.Rezervacija_id = l;
            return;
        }
        racun.pcStateManager.settingLongField((PersistenceCapable)racun, pcInheritedFieldCount + 2, racun.Rezervacija_id, l, 0);
    }

    private static final String pcGetbrojBI(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.brojBI;
        }
        int n = pcInheritedFieldCount + 3;
        racun.pcStateManager.accessingField(n);
        return racun.brojBI;
    }

    private static final void pcSetbrojBI(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.brojBI = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 3, racun.brojBI, string, 0);
    }

    private static final Integer pcGetbrojFakture(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.brojFakture;
        }
        int n = pcInheritedFieldCount + 4;
        racun.pcStateManager.accessingField(n);
        return racun.brojFakture;
    }

    private static final void pcSetbrojFakture(Racun racun, Integer n) {
        if (racun.pcStateManager == null) {
            racun.brojFakture = n;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 4, (Object)racun.brojFakture, (Object)n, 0);
    }

    private static final String pcGetbrojGostiju(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.brojGostiju;
        }
        int n = pcInheritedFieldCount + 5;
        racun.pcStateManager.accessingField(n);
        return racun.brojGostiju;
    }

    private static final void pcSetbrojGostiju(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.brojGostiju = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 5, racun.brojGostiju, string, 0);
    }

    private static final Integer pcGetbrojRacuna(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.brojRacuna;
        }
        int n = pcInheritedFieldCount + 6;
        racun.pcStateManager.accessingField(n);
        return racun.brojRacuna;
    }

    private static final void pcSetbrojRacuna(Racun racun, Integer n) {
        if (racun.pcStateManager == null) {
            racun.brojRacuna = n;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 6, (Object)racun.brojRacuna, (Object)n, 0);
    }

    private static final Integer pcGetbrojStola(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.brojStola;
        }
        int n = pcInheritedFieldCount + 7;
        racun.pcStateManager.accessingField(n);
        return racun.brojStola;
    }

    private static final void pcSetbrojStola(Racun racun, Integer n) {
        if (racun.pcStateManager == null) {
            racun.brojStola = n;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 7, (Object)racun.brojStola, (Object)n, 0);
    }

    private static final String pcGetcrnoPlacanje(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.crnoPlacanje;
        }
        int n = pcInheritedFieldCount + 8;
        racun.pcStateManager.accessingField(n);
        return racun.crnoPlacanje;
    }

    private static final void pcSetcrnoPlacanje(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.crnoPlacanje = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 8, racun.crnoPlacanje, string, 0);
    }

    private static final Date pcGetdatum(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.datum;
        }
        int n = pcInheritedFieldCount + 9;
        racun.pcStateManager.accessingField(n);
        return racun.datum;
    }

    private static final void pcSetdatum(Racun racun, Date date) {
        if (racun.pcStateManager == null) {
            racun.datum = date;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 9, (Object)racun.datum, (Object)date, 0);
    }

    private static final Boolean pcGetfiskalniOdstampan(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.fiskalniOdstampan;
        }
        int n = pcInheritedFieldCount + 10;
        racun.pcStateManager.accessingField(n);
        return racun.fiskalniOdstampan;
    }

    private static final void pcSetfiskalniOdstampan(Racun racun, Boolean bl) {
        if (racun.pcStateManager == null) {
            racun.fiskalniOdstampan = bl;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 10, (Object)racun.fiskalniOdstampan, (Object)bl, 0);
    }

    private static final String pcGetimeHotelskogGosta(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.imeHotelskogGosta;
        }
        int n = pcInheritedFieldCount + 11;
        racun.pcStateManager.accessingField(n);
        return racun.imeHotelskogGosta;
    }

    private static final void pcSetimeHotelskogGosta(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.imeHotelskogGosta = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 11, racun.imeHotelskogGosta, string, 0);
    }

    private static final String pcGetkanalProdaje(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.kanalProdaje;
        }
        int n = pcInheritedFieldCount + 12;
        racun.pcStateManager.accessingField(n);
        return racun.kanalProdaje;
    }

    private static final void pcSetkanalProdaje(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.kanalProdaje = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 12, racun.kanalProdaje, string, 0);
    }

    private static final Kasa pcGetkasa(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.kasa;
        }
        int n = pcInheritedFieldCount + 13;
        racun.pcStateManager.accessingField(n);
        return racun.kasa;
    }

    private static final void pcSetkasa(Racun racun, Kasa kasa) {
        if (racun.pcStateManager == null) {
            racun.kasa = kasa;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 13, (Object)racun.kasa, (Object)kasa, 0);
    }

    private static final List pcGetknjizenja(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.knjizenja;
        }
        int n = pcInheritedFieldCount + 14;
        racun.pcStateManager.accessingField(n);
        return racun.knjizenja;
    }

    private static final void pcSetknjizenja(Racun racun, List list) {
        if (racun.pcStateManager == null) {
            racun.knjizenja = list;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 14, racun.knjizenja, (Object)list, 0);
    }

    private static final Komitent pcGetkomitent(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.komitent;
        }
        int n = pcInheritedFieldCount + 15;
        racun.pcStateManager.accessingField(n);
        return racun.komitent;
    }

    private static final void pcSetkomitent(Racun racun, Komitent komitent) {
        if (racun.pcStateManager == null) {
            racun.komitent = komitent;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 15, (Object)racun.komitent, (Object)komitent, 0);
    }

    private static final Konobar pcGetkonobar(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.konobar;
        }
        int n = pcInheritedFieldCount + 16;
        racun.pcStateManager.accessingField(n);
        return racun.konobar;
    }

    private static final void pcSetkonobar(Racun racun, Konobar konobar) {
        if (racun.pcStateManager == null) {
            racun.konobar = konobar;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 16, (Object)racun.konobar, (Object)konobar, 0);
    }

    private static final MeniPromet pcGetmeniPromet(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.meniPromet;
        }
        int n = pcInheritedFieldCount + 17;
        racun.pcStateManager.accessingField(n);
        return racun.meniPromet;
    }

    private static final void pcSetmeniPromet(Racun racun, MeniPromet meniPromet) {
        if (racun.pcStateManager == null) {
            racun.meniPromet = meniPromet;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 17, (Object)racun.meniPromet, (Object)meniPromet, 0);
    }

    private static final Boolean pcGetmenipromet(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.menipromet;
        }
        int n = pcInheritedFieldCount + 18;
        racun.pcStateManager.accessingField(n);
        return racun.menipromet;
    }

    private static final void pcSetmenipromet(Racun racun, Boolean bl) {
        if (racun.pcStateManager == null) {
            racun.menipromet = bl;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 18, (Object)racun.menipromet, (Object)bl, 0);
    }

    private static final Boolean pcGetnaOsnovno(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.naOsnovno;
        }
        int n = pcInheritedFieldCount + 19;
        racun.pcStateManager.accessingField(n);
        return racun.naOsnovno;
    }

    private static final void pcSetnaOsnovno(Racun racun, Boolean bl) {
        if (racun.pcStateManager == null) {
            racun.naOsnovno = bl;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 19, (Object)racun.naOsnovno, (Object)bl, 0);
    }

    private static final String pcGetnapomena(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.napomena;
        }
        int n = pcInheritedFieldCount + 20;
        racun.pcStateManager.accessingField(n);
        return racun.napomena;
    }

    private static final void pcSetnapomena(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.napomena = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 20, racun.napomena, string, 0);
    }

    private static final String pcGetoznakaSobe(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.oznakaSobe;
        }
        int n = pcInheritedFieldCount + 21;
        racun.pcStateManager.accessingField(n);
        return racun.oznakaSobe;
    }

    private static final void pcSetoznakaSobe(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.oznakaSobe = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 21, racun.oznakaSobe, string, 0);
    }

    private static final List pcGetplacanja(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.placanja;
        }
        int n = pcInheritedFieldCount + 22;
        racun.pcStateManager.accessingField(n);
        return racun.placanja;
    }

    private static final void pcSetplacanja(Racun racun, List list) {
        if (racun.pcStateManager == null) {
            racun.placanja = list;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 22, racun.placanja, (Object)list, 0);
    }

    private static final Double pcGetpopust(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.popust;
        }
        int n = pcInheritedFieldCount + 23;
        racun.pcStateManager.accessingField(n);
        return racun.popust;
    }

    private static final void pcSetpopust(Racun racun, Double d) {
        if (racun.pcStateManager == null) {
            racun.popust = d;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 23, (Object)racun.popust, (Object)d, 0);
    }

    private static final StalniGost pcGetstalniGost(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.stalniGost;
        }
        int n = pcInheritedFieldCount + 24;
        racun.pcStateManager.accessingField(n);
        return racun.stalniGost;
    }

    private static final void pcSetstalniGost(Racun racun, StalniGost stalniGost) {
        if (racun.pcStateManager == null) {
            racun.stalniGost = stalniGost;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 24, (Object)racun.stalniGost, (Object)stalniGost, 0);
    }

    private static final List pcGetstavke1(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.stavke1;
        }
        int n = pcInheritedFieldCount + 25;
        racun.pcStateManager.accessingField(n);
        return racun.stavke1;
    }

    private static final void pcSetstavke1(Racun racun, List list) {
        if (racun.pcStateManager == null) {
            racun.stavke1 = list;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 25, racun.stavke1, (Object)list, 0);
    }

    private static final boolean pcGetstorniran(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.storniran;
        }
        int n = pcInheritedFieldCount + 26;
        racun.pcStateManager.accessingField(n);
        return racun.storniran;
    }

    private static final void pcSetstorniran(Racun racun, boolean bl) {
        if (racun.pcStateManager == null) {
            racun.storniran = bl;
            return;
        }
        racun.pcStateManager.settingBooleanField((PersistenceCapable)racun, pcInheritedFieldCount + 26, racun.storniran, bl, 0);
    }

    private static final List pcGetture(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.ture;
        }
        int n = pcInheritedFieldCount + 27;
        racun.pcStateManager.accessingField(n);
        return racun.ture;
    }

    private static final void pcSetture(Racun racun, List list) {
        if (racun.pcStateManager == null) {
            racun.ture = list;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 27, racun.ture, (Object)list, 0);
    }

    private static final Boolean pcGetzatvoren(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.zatvoren;
        }
        int n = pcInheritedFieldCount + 28;
        racun.pcStateManager.accessingField(n);
        return racun.zatvoren;
    }

    private static final void pcSetzatvoren(Racun racun, Boolean bl) {
        if (racun.pcStateManager == null) {
            racun.zatvoren = bl;
            return;
        }
        racun.pcStateManager.settingObjectField((PersistenceCapable)racun, pcInheritedFieldCount + 28, (Object)racun.zatvoren, (Object)bl, 0);
    }

    private static final String pcGetzbirnaFaktura(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.zbirnaFaktura;
        }
        int n = pcInheritedFieldCount + 29;
        racun.pcStateManager.accessingField(n);
        return racun.zbirnaFaktura;
    }

    private static final void pcSetzbirnaFaktura(Racun racun, String string) {
        if (racun.pcStateManager == null) {
            racun.zbirnaFaktura = string;
            return;
        }
        racun.pcStateManager.settingStringField((PersistenceCapable)racun, pcInheritedFieldCount + 29, racun.zbirnaFaktura, string, 0);
    }

    private static final int pcGetzbirnaFakturaId(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.zbirnaFakturaId;
        }
        int n = pcInheritedFieldCount + 30;
        racun.pcStateManager.accessingField(n);
        return racun.zbirnaFakturaId;
    }

    private static final void pcSetzbirnaFakturaId(Racun racun, int n) {
        if (racun.pcStateManager == null) {
            racun.zbirnaFakturaId = n;
            return;
        }
        racun.pcStateManager.settingIntField((PersistenceCapable)racun, pcInheritedFieldCount + 30, racun.zbirnaFakturaId, n, 0);
    }

    private static final long pcGetzdBroj(Racun racun) {
        if (racun.pcStateManager == null) {
            return racun.zdBroj;
        }
        int n = pcInheritedFieldCount + 31;
        racun.pcStateManager.accessingField(n);
        return racun.zdBroj;
    }

    private static final void pcSetzdBroj(Racun racun, long l) {
        if (racun.pcStateManager == null) {
            racun.zdBroj = l;
            return;
        }
        racun.pcStateManager.settingLongField((PersistenceCapable)racun, pcInheritedFieldCount + 31, racun.zdBroj, l, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

