/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.OtpisUtrosak;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Otpis
extends BObject
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    private Odeljenje odeljenje;
    @Temporal(value=TemporalType.DATE)
    private Date datum;
    private String uname;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="otpis", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<OtpisStavka> stavke = new LinkedList<OtpisStavka>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="otpis", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<OtpisUtrosak> utrosci = new LinkedList<OtpisUtrosak>();
    private String opis;
    private String broj;
    private boolean crno;
    private static int pcInheritedFieldCount = BObject.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$BObject;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Odeljenje;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lcom$dev63$restoran$model$Otpis;

    public Date getDatum() {
        return Otpis.pcGetdatum(this);
    }

    public void setDatum(Date datum) {
        Otpis.pcSetdatum(this, datum);
    }

    public Odeljenje getOdeljenje() {
        return Otpis.pcGetodeljenje(this);
    }

    public void setOdeljenje(Odeljenje odeljenje) {
        Otpis.pcSetodeljenje(this, odeljenje);
    }

    public String getOpis() {
        return Otpis.pcGetopis(this);
    }

    public void setOpis(String opis) {
        Otpis.pcSetopis(this, opis);
    }

    public List<OtpisStavka> getStavke() {
        return Otpis.pcGetstavke(this);
    }

    public void setStavke(List<OtpisStavka> stavke) {
        Otpis.pcSetstavke(this, stavke);
    }

    public String getUname() {
        return Otpis.pcGetuname(this);
    }

    public void setUname(String uname) {
        Otpis.pcSetuname(this, uname);
    }

    public boolean isCrno() {
        return Otpis.pcGetcrno(this);
    }

    public void setCrno(boolean crno) {
        Otpis.pcSetcrno(this, crno);
    }

    public double getVrednost() {
        double vrednost = 0.0;
        for (OtpisStavka so : Otpis.pcGetstavke(this)) {
            vrednost += so.getVrednost().doubleValue();
        }
        return vrednost;
    }

    @Override
    public String toString() {
        String c = this.isCrno() ? "DA" : "NE";
        return "ID: " + this.getId() + ", Broj: " + Otpis.pcGetbroj(this) + ",datum: " + this.getDatum() + ", Otpis dodatnog stanja: " + c;
    }

    public String getBroj() {
        return Otpis.pcGetbroj(this);
    }

    public void setBroj(String broj) {
        Otpis.pcSetbroj(this, broj);
    }

    public List<OtpisUtrosak> getUtrosci() {
        return Otpis.pcGetutrosci(this);
    }

    public void setUtrosci(List<OtpisUtrosak> utrosci) {
        Otpis.pcSetutrosci(this, utrosci);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        Class clazz = class$Lcom$dev63$restoran$model$BObject != null ? class$Lcom$dev63$restoran$model$BObject : (class$Lcom$dev63$restoran$model$BObject = Otpis.class$("com.dev63.restoran.model.BObject"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"broj", "crno", "datum", "odeljenje", "opis", "stavke", "uname", "utrosci"};
        Class[] classArray = new Class[8];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Otpis.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = Boolean.TYPE;
        Class clazz3 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Otpis.class$("java.util.Date"));
        classArray[2] = clazz3;
        Class clazz4 = class$Lcom$dev63$restoran$model$Odeljenje != null ? class$Lcom$dev63$restoran$model$Odeljenje : (class$Lcom$dev63$restoran$model$Odeljenje = Otpis.class$("com.dev63.restoran.model.Odeljenje"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Otpis.class$("java.lang.String"));
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Otpis.class$("java.util.List"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Otpis.class$("java.lang.String"));
        classArray[7] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Otpis.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 10, 26, 10};
        Class clazz6 = class$Lcom$dev63$restoran$model$Otpis != null ? class$Lcom$dev63$restoran$model$Otpis : (class$Lcom$dev63$restoran$model$Otpis = Otpis.class$("com.dev63.restoran.model.Otpis"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Otpis", (PersistenceCapable)new Otpis());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.broj = null;
        this.crno = false;
        this.datum = null;
        this.odeljenje = null;
        this.opis = null;
        this.stavke = null;
        this.uname = null;
        this.utrosci = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Otpis otpis = new Otpis();
        if (bl) {
            otpis.pcClearFields();
        }
        otpis.pcStateManager = stateManager;
        otpis.pcCopyKeyFieldsFromObjectId(object);
        return otpis;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Otpis otpis = new Otpis();
        if (bl) {
            otpis.pcClearFields();
        }
        otpis.pcStateManager = stateManager;
        return otpis;
    }

    protected static int pcGetManagedFieldCount() {
        return 8 + BObject.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.broj = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.crno = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.datum = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.odeljenje = (Odeljenje)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.opis = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.stavke = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.uname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.utrosci = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.broj);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.crno);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.datum);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.odeljenje);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.opis);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.stavke);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.uname);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.utrosci);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Otpis otpis, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(otpis, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.broj = otpis.broj;
                return;
            }
            case 1: {
                this.crno = otpis.crno;
                return;
            }
            case 2: {
                this.datum = otpis.datum;
                return;
            }
            case 3: {
                this.odeljenje = otpis.odeljenje;
                return;
            }
            case 4: {
                this.opis = otpis.opis;
                return;
            }
            case 5: {
                this.stavke = otpis.stavke;
                return;
            }
            case 6: {
                this.uname = otpis.uname;
                return;
            }
            case 7: {
                this.utrosci = otpis.utrosci;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Otpis otpis = (Otpis)object;
        if (otpis.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(otpis, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetbroj(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.broj;
        }
        int n = pcInheritedFieldCount + 0;
        otpis.pcStateManager.accessingField(n);
        return otpis.broj;
    }

    private static final void pcSetbroj(Otpis otpis, String string) {
        if (otpis.pcStateManager == null) {
            otpis.broj = string;
            return;
        }
        otpis.pcStateManager.settingStringField((PersistenceCapable)otpis, pcInheritedFieldCount + 0, otpis.broj, string, 0);
    }

    private static final boolean pcGetcrno(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.crno;
        }
        int n = pcInheritedFieldCount + 1;
        otpis.pcStateManager.accessingField(n);
        return otpis.crno;
    }

    private static final void pcSetcrno(Otpis otpis, boolean bl) {
        if (otpis.pcStateManager == null) {
            otpis.crno = bl;
            return;
        }
        otpis.pcStateManager.settingBooleanField((PersistenceCapable)otpis, pcInheritedFieldCount + 1, otpis.crno, bl, 0);
    }

    private static final Date pcGetdatum(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.datum;
        }
        int n = pcInheritedFieldCount + 2;
        otpis.pcStateManager.accessingField(n);
        return otpis.datum;
    }

    private static final void pcSetdatum(Otpis otpis, Date date) {
        if (otpis.pcStateManager == null) {
            otpis.datum = date;
            return;
        }
        otpis.pcStateManager.settingObjectField((PersistenceCapable)otpis, pcInheritedFieldCount + 2, (Object)otpis.datum, (Object)date, 0);
    }

    private static final Odeljenje pcGetodeljenje(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.odeljenje;
        }
        int n = pcInheritedFieldCount + 3;
        otpis.pcStateManager.accessingField(n);
        return otpis.odeljenje;
    }

    private static final void pcSetodeljenje(Otpis otpis, Odeljenje odeljenje) {
        if (otpis.pcStateManager == null) {
            otpis.odeljenje = odeljenje;
            return;
        }
        otpis.pcStateManager.settingObjectField((PersistenceCapable)otpis, pcInheritedFieldCount + 3, (Object)otpis.odeljenje, (Object)odeljenje, 0);
    }

    private static final String pcGetopis(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.opis;
        }
        int n = pcInheritedFieldCount + 4;
        otpis.pcStateManager.accessingField(n);
        return otpis.opis;
    }

    private static final void pcSetopis(Otpis otpis, String string) {
        if (otpis.pcStateManager == null) {
            otpis.opis = string;
            return;
        }
        otpis.pcStateManager.settingStringField((PersistenceCapable)otpis, pcInheritedFieldCount + 4, otpis.opis, string, 0);
    }

    private static final List pcGetstavke(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.stavke;
        }
        int n = pcInheritedFieldCount + 5;
        otpis.pcStateManager.accessingField(n);
        return otpis.stavke;
    }

    private static final void pcSetstavke(Otpis otpis, List list) {
        if (otpis.pcStateManager == null) {
            otpis.stavke = list;
            return;
        }
        otpis.pcStateManager.settingObjectField((PersistenceCapable)otpis, pcInheritedFieldCount + 5, otpis.stavke, (Object)list, 0);
    }

    private static final String pcGetuname(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.uname;
        }
        int n = pcInheritedFieldCount + 6;
        otpis.pcStateManager.accessingField(n);
        return otpis.uname;
    }

    private static final void pcSetuname(Otpis otpis, String string) {
        if (otpis.pcStateManager == null) {
            otpis.uname = string;
            return;
        }
        otpis.pcStateManager.settingStringField((PersistenceCapable)otpis, pcInheritedFieldCount + 6, otpis.uname, string, 0);
    }

    private static final List pcGetutrosci(Otpis otpis) {
        if (otpis.pcStateManager == null) {
            return otpis.utrosci;
        }
        int n = pcInheritedFieldCount + 7;
        otpis.pcStateManager.accessingField(n);
        return otpis.utrosci;
    }

    private static final void pcSetutrosci(Otpis otpis, List list) {
        if (otpis.pcStateManager == null) {
            otpis.utrosci = list;
            return;
        }
        otpis.pcStateManager.settingObjectField((PersistenceCapable)otpis, pcInheritedFieldCount + 7, otpis.utrosci, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

