/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.model;

import java.util.Locale;

public enum Country {
    SRBIJA(0, "Srbija", new Locale[]{new Locale("sr", "RS")}),
    CRNA_GORA(1, "Crna Gora", new Locale[]{new Locale("sr", "ME")}),
    MAKEDONIJA(2, "Makedonija", new Locale[]{new Locale("mk", "MK")}),
    HRVATSKA(3, "Hrvatska", new Locale[]{new Locale("hr", "HR")}),
    BIH(4, "Bosna i Hercegovina", new Locale[]{new Locale("bs", "BA")}),
    SLOVENIJA(5, "Slovenija", new Locale[]{new Locale("sl", "SI")}),
    AUSTRIJA(6, "\u00d6sterreich", new Locale[]{new Locale("de", "AT")}),
    SVAJCARSKA(7, "Schweiz/Suisse/Svizzera", new Locale[]{new Locale("de", "CH"), new Locale("fr", "CH"), new Locale("it", "CH")}),
    ALBANIA(7, "Albania", new Locale[]{new Locale("al", "AL")}),
    NEMACKA(8, "Deutschland", new Locale[]{new Locale("de", "DE")});

    private byte code;
    private String name;
    private Locale[] locales;

    private Country(byte code, String name, Locale[] locales) {
        this.code = code;
        this.name = name;
        this.locales = locales;
    }

    public byte getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public static Country findByCode(byte code) {
        Country dd = null;
        for (Country drzava : Country.values()) {
            if (drzava.getCode() != code) continue;
            dd = drzava;
            break;
        }
        return dd;
    }

    public static Country findByName(String name) {
        Country dd = null;
        for (Country drzava : Country.values()) {
            if (!drzava.getName().equals(name)) continue;
            dd = drzava;
            break;
        }
        return dd;
    }

    public static Country findByEnumName(String name) {
        Country dd = null;
        for (Country drzava : Country.values()) {
            if (!drzava.name().equals(name)) continue;
            dd = drzava;
            break;
        }
        return dd;
    }
}

