/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.license;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.license.LicLogic;
import com.dev63.restoran.license.exceptions.LicenseNotValid;
import com.dev63.restoran.license.exceptions.MacAddressReadException;
import com.dev63.restoran.model.OptionBO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicControl {
    private static final String licFolder = "./license/";

    private static String readLicenseFile(String in, byte cc) throws FileNotFoundException, IOException, MacAddressReadException, MacAddressReadException {
        String licCode = "";
        InputStreamReader fr = null;
        try {
            int c;
            File licFold = new File(licFolder);
            if (!licFold.exists()) {
                licFold.mkdir();
            }
            String ctrlCode = LicLogic.getControlCode(in, cc);
            System.out.println("ctrlCode = " + ctrlCode);
            File f = new File(licFolder, ctrlCode + ".lic");
            fr = new FileReader(f);
            while ((c = fr.read()) > -1) {
                licCode = licCode + (char)c;
            }
            fr.close();
        }
        catch (FileNotFoundException fnfex) {
            try {
                fr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw fnfex;
        }
        catch (IOException ioex) {
            try {
                fr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioex;
        }
        return licCode;
    }

    public static Date getLicenseValidity(String in, byte cc) throws FileNotFoundException, IOException, LicenseNotValid, MacAddressReadException {
        String licCode = LicControl.readLicenseFile(in, cc);
        return LicLogic.getLicenseExpiration(licCode);
    }

    public static int getLicenseType(String in, byte cc) throws FileNotFoundException, IOException, LicenseNotValid, MacAddressReadException {
        String licCode = LicControl.readLicenseFile(in, cc);
        int licT = LicLogic.getLicenseType(licCode);
        BMTerminalSettings.setSetting(OptionBO.TRENUTNI_TIP_LICENCE, Integer.toString(licT));
        return licT;
    }

    public static boolean storeLicenseData(String in, byte cc, String in2) {
        boolean ret = false;
        OutputStreamWriter fw = null;
        try {
            String ctrlCode;
            File f;
            File licFold = new File(licFolder);
            if (!licFold.exists()) {
                licFold.mkdir();
            }
            if ((f = new File(licFolder, (ctrlCode = LicLogic.getControlCode(in, cc)) + ".lic")).exists()) {
                f.delete();
            }
            fw = new FileWriter(f);
            fw.append(in2);
            fw.flush();
            fw.close();
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            try {
                fw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            System.out.println(LicControl.readLicenseFile("105917685", (byte)0));
            System.out.println(LicControl.getLicenseValidity("105917685", (byte)0));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LicControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(LicControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MacAddressReadException ex) {
            Logger.getLogger(LicControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (LicenseNotValid ex) {
            Logger.getLogger(LicControl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

