/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.stampa;

import Stampa.core.ImageCache;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.StavkaRacuna;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.LinePrint;
import org.eclipse.nebula.paperclips.core.Margins;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.BorderPrint;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.page.SimplePageDecoration;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.widgets.PrintPreview;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swt.proba.NebulaPaperClipsTester;

public class ReportPrintBuilder {
    public static String fontName = "Arial";
    public static int textSize = 7;
    public static int titleTextSize = 36;
    public static int headingSize = 9;
    public static int printMargin = 10;

    public static PagePrint createNewDocument() {
        return new PagePrint((Print)new EmptyPrint());
    }

    public static PagePrint createNewDocument(Print body) {
        return new PagePrint(body);
    }

    public static PagePrint createNewDocument(SimplePageDecoration header, Print body) {
        return new PagePrint((PageDecoration)header, body);
    }

    public static PagePrint createNewDocument(Print body, SimplePageDecoration footer) {
        return new PagePrint(body, (PageDecoration)footer);
    }

    public static PagePrint createNewDocument(SimplePageDecoration header, Print body, SimplePageDecoration footer) {
        return new PagePrint((PageDecoration)header, body, (PageDecoration)footer);
    }

    public static PagePrint createNewDocument(Print header, Print body, Print footer) {
        return new PagePrint((PageDecoration)new SimplePageDecoration(header), body, (PageDecoration)new SimplePageDecoration(footer));
    }

    public static SimplePageDecoration createPageHeader(Print header) {
        return new SimplePageDecoration(header);
    }

    public static SimplePageDecoration createPageFooter(Print footer) {
        return new SimplePageDecoration(footer);
    }

    public static Print createBody(Print[] bodyParts) {
        GridPrint body = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, 600, 100)});
        if (bodyParts.length == 0) {
            body.add((Print)new EmptyPrint());
        }
        for (Print print : bodyParts) {
            body.add(print);
        }
        return body;
    }

    public static void printToDefault(Print document, String printName) {
        PrinterData pd = PaperClips.getDefaultPrinterData();
        PrintJob pj = new PrintJob(printName, document);
        pj.setMargins(printMargin);
        PaperClips.print((PrintJob)pj, (PrinterData)pd);
    }

    public static void printToDefault(Print document, String printName, int copies) {
        PrinterData pd = PaperClips.getDefaultPrinterData();
        Printer p = new Printer(pd);
        PrintJob pj = new PrintJob(printName, document);
        pj.setMargins(printMargin);
        for (int i = 0; i < copies; ++i) {
            PaperClips.print((PrintJob)pj, (PrinterData)pd);
        }
    }

    public static void printToPrinter(PrinterData pd, Print document, String printName, int copies) {
        Printer p = new Printer(pd);
        PrintJob pj = new PrintJob(printName, document);
        pj.setMargins(printMargin);
        for (int i = 0; i < copies; ++i) {
            PaperClips.print((PrintJob)pj, (PrinterData)pd);
        }
    }

    public static Print makeTitle(String logoPath, String title) {
        GridPrint header;
        GridPrint mainPrint = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 600)});
        FontData fd = new FontData(fontName, titleTextSize, 1);
        File f = null;
        if (logoPath != null) {
            f = new File(logoPath);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(NebulaPaperClipsTester.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (fis == null) {
            header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 1)});
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
            header.add((Print)new TextPrint(title, fd, 0x1000000));
            header.add(0x1000000, (Print)new EmptyPrint(26, 26));
        } else {
            ImageData id = new ImageData((InputStream)fis);
            id = id.scaledTo(Math.round(Float.valueOf(id.width).floatValue() / Float.valueOf(id.height).floatValue() * Float.valueOf(400.0f).floatValue()), 400);
            header = new ImagePrint(id);
            ((ImagePrint)header).setDPI(300, 300);
        }
        mainPrint.add(0x1000000, 0x1000000, (Print)header, -1);
        mainPrint.add((Print)new EmptyPrint(20, 20));
        return mainPrint;
    }

    public static Print makeMenuHeader(MeniPromet mp) {
        String ukupnoIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UKUPNO") + ":";
        String cenaIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA") + ":";
        String kolicinaIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KOLICINA") + ":";
        String datumIL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM") + ":";
        String meniL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MENI") + ":";
        String mpL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_MESTO_PECATA_SKR");
        String overaL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OVERA");
        String meniI = mp.getMeni().getNaziv();
        String kolicinaI = StatLogic.getNumber02(mp.getKolicina());
        String cenaI = StatLogic.getNumber02(mp.getCena());
        String ukupnoI = StatLogic.getNumber02(mp.getTotal());
        String datumI = StatLogic.getDateString(mp.getDatum());
        GridPrint header = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 300), new GridColumn(0x1000000, -1, 300)});
        GridPrint rData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 40), new GridColumn(16384, -1, 100), new GridColumn(16384, -1, 10), new GridColumn(16384, -1, 120), new GridColumn(16384, -1, 20)});
        FontData fdf = new FontData(fontName, headingSize, 1);
        FontData fdt = new FontData(fontName, textSize, 0);
        FontData fdtb = new FontData(fontName, textSize, 1);
        FontData fdbt = new FontData(fontName, headingSize, 0);
        FontData fdbtb = new FontData(fontName, headingSize, 1);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRDLbls = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 100)});
        gpRDLbls.add(131072, (Print)new TextPrint(meniL, fdf, 16384));
        gpRDLbls.add((Print)new EmptyPrint(15, 15));
        gpRDLbls.add((Print)new TextPrint(datumIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(kolicinaIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(cenaIL, fdt, 16384));
        gpRDLbls.add((Print)new TextPrint(ukupnoIL, fdt, 16384));
        rData.add((Print)gpRDLbls);
        rData.add((Print)new EmptyPrint());
        GridPrint gpRData = new GridPrint(new GridColumn[]{new GridColumn(16384, -1, 120)});
        gpRData.add((Print)new TextPrint(meniI, fdf, 16384));
        gpRData.add((Print)new EmptyPrint(15, 15));
        gpRData.add((Print)new TextPrint(datumI, fdt, 16384));
        gpRData.add((Print)new TextPrint(kolicinaI, fdt, 16384));
        gpRData.add((Print)new TextPrint(cenaI, fdt, 16384));
        gpRData.add((Print)new TextPrint(ukupnoI, fdt, 16384));
        rData.add((Print)gpRData);
        rData.add((Print)new EmptyPrint());
        header.add((Print)rData);
        GridPrint gpBuyerRight = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 20), new GridColumn(0x1000000, -1, 240), new GridColumn(0x1000000, -1, 40)});
        gpBuyerRight.add((Print)new EmptyPrint());
        GridPrint gpBuyerData = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 240)});
        DefaultGridLook gl = new DefaultGridLook();
        gl.setHeaderBackground(new RGB(192, 192, 192));
        gl.setCellPadding(0, 3);
        gpBuyerData.setLook((GridLook)gl);
        TextPrint tp = new TextPrint("     " + overaL, fdtb, 16384);
        gpBuyerData.addHeader(16384, (Print)tp);
        LinePrint lp = new LinePrint(256);
        gpBuyerData.add((Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new EmptyPrint(20, 10));
        gpBuyerData.add(0x1000000, (Print)new LinePrint());
        gpBuyerData.add(0x1000000, (Print)new EmptyPrint(20, 10));
        gpBuyerData.add(0x1000000, (Print)new TextPrint(mpL, fdbt, 0x1000000));
        gpBuyerData.add(0x1000000, (Print)new EmptyPrint(20, 10));
        LineBorder lb = new LineBorder();
        lb.setGapSize(0);
        lb.setLineWidth(1);
        gpBuyerRight.add((Print)new BorderPrint((Print)gpBuyerData, (Border)lb));
        gpBuyerRight.add((Print)new EmptyPrint());
        header.add((Print)gpBuyerRight);
        return header;
    }

    public static Print makeDepartmentLabel(Odeljenje odeljenje) {
        String odeljenjeL = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_ODELJENJE");
        GridPrint p = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 100)});
        TextPrint depPrint = new TextPrint(odeljenjeL + ": " + odeljenje.getKratkiNaziv(), new FontData(fontName, headingSize, 1));
        p.add(16384, (Print)depPrint);
        return p;
    }

    public static Print makeUkupnoLabel(String ukupno) {
        GridPrint p = new GridPrint(new GridColumn[]{new GridColumn(0x1000000, -1, 100)});
        TextPrint depPrint = new TextPrint("Ukupno: " + ukupno, new FontData(fontName, headingSize, 1));
        p.add(131072, (Print)depPrint);
        return p;
    }

    public static Print makeItems(List<StavkaRacuna> items) {
        String rb = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_REDNI_BROJ_SKR");
        String naziv = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NAZIV");
        String jm = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_JEDINICA_MERE_SKR");
        String kolicina = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_KOLICINA");
        String cena = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_CENA");
        String popustPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POPUST");
        String pdvPC = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PDV");
        String pdvIznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_PDV");
        String cenaBPDV = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS_BEZ_PDV");
        String iznos = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZNOS");
        DefaultGridLook dgl = new DefaultGridLook();
        dgl.setCellPadding(3, 1);
        RGB lineCol = new RGB(64, 64, 64);
        GridPrint gpItems = new GridPrint(new GridColumn[]{new GridColumn(131072, -1, 20), new GridColumn(16384, -1, 160), new GridColumn(0x1000000, -1, 25), new GridColumn(131072, -1, 45), new GridColumn(131072, -1, 65), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 40), new GridColumn(131072, -1, 65), new GridColumn(131072, -1, 70), new GridColumn(131072, -1, 70)});
        gpItems.setLook((GridLook)dgl);
        LinePrint lp = new LinePrint(256, 1.0);
        lp.setRGB(lineCol);
        FontData fdt = new FontData(fontName, textSize, 0);
        gpItems.addHeader((Print)new EmptyPrint(10, 5), -1);
        gpItems.addHeader((Print)lp, -1);
        gpItems.addHeader(0x1000000, (Print)new TextPrint(rb, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(naziv, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(jm, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(kolicina, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cena, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(popustPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvPC, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(pdvIznos, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(cenaBPDV, fdt, 0x1000000));
        gpItems.addHeader(0x1000000, (Print)new TextPrint(iznos, fdt, 0x1000000));
        gpItems.addHeader((Print)lp, -1);
        int i = 0;
        for (StavkaRacuna sr : items) {
            double pdvStopa = Konstante.getPdvPoPG(sr.getArtikal().getPoreskaGrupa());
            double iznosBPdv = sr.getVrednostSaPopustom() / (1.0 + pdvStopa);
            double iznosPdv = iznosBPdv * pdvStopa;
            gpItems.add(131072, (Print)new TextPrint("" + ++i, fdt, 0x1000000));
            gpItems.add(16384, (Print)new TextPrint(sr.getNaziv(), fdt, 0x1000000));
            gpItems.add(16384, (Print)new TextPrint(sr.getArtikal().getJedinicaMere(), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber03(sr.getKolicina()), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getCena()), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getRacun().getPopust()) + "%", fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(pdvStopa * 100.0) + "%", fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(iznosPdv), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(iznosBPdv), fdt, 0x1000000));
            gpItems.add(131072, (Print)new TextPrint(StatLogic.getNumber02(sr.getVrednostSaPopustom()), fdt, 0x1000000));
        }
        gpItems.add((Print)lp, -1);
        return gpItems;
    }

    public static Print makeMenuSpecBody(MeniPromet mp) {
        Map mapa = StavkeSumarno.MakeMapForOrderPrint(mp.getRacun().getStavke1());
        Print[] bp = new Print[mapa.size() * 3 + 1];
        bp[0] = ReportPrintBuilder.makeMenuHeader(mp);
        int i = 1;
        for (Map.Entry entry : mapa.entrySet()) {
            Odeljenje odeljenje = (Odeljenje)entry.getKey();
            bp[i++] = ReportPrintBuilder.makeDepartmentLabel(odeljenje);
            List list = (List)entry.getValue();
            double ukupno = 0.0;
            for (StavkaRacuna sRacuna : list) {
                ukupno += sRacuna.getVrednostSaPopustom().doubleValue();
            }
            bp[i++] = ReportPrintBuilder.makeItems(list);
            bp[i++] = ReportPrintBuilder.makeUkupnoLabel(String.valueOf(StatLogic.round(ukupno, 2)));
        }
        return ReportPrintBuilder.createBody(bp);
    }

    public static PrintJob createPrintJob(Print print, PrinterData pData) {
        PrintJob pj = new PrintJob(pData.name, print);
        return pj;
    }

    private static void createPrintPreview(Shell shell, PrintJob pj) {
        ReportPrintBuilder.createPrintPreview(shell, pj, true);
    }

    private static void createPrintPreview(final Shell shell, PrintJob pj, boolean blockThread) {
        pj.setMargins(printMargin);
        GridLayout gl = new GridLayout();
        shell.setLayout((Layout)gl);
        PaperClips.setDebug((boolean)true);
        ToolBar toolBar = new ToolBar((Composite)shell, 0);
        ToolItem printB = new ToolItem(toolBar, 0x800008);
        printB.setImage(ImageCache.getImage("print.gif"));
        ToolItem sep1 = new ToolItem(toolBar, 2);
        sep1.setWidth(10);
        ToolItem sep2 = new ToolItem(toolBar, 2);
        sep2.setControl((Control)new Label((Composite)toolBar, 0x1000202));
        ToolItem sep3 = new ToolItem(toolBar, 2);
        sep3.setWidth(10);
        ToolItem left = new ToolItem(toolBar, 0x800008);
        left.setImage(ImageCache.getImage("previous_page.gif"));
        ToolItem sepP1 = new ToolItem(toolBar, 2);
        sepP1.setWidth(5);
        final ToolItem sepPC = new ToolItem(toolBar, 2);
        sepPC.setWidth(30);
        Text t = new Text((Composite)toolBar, 0x1000800);
        t.setEditable(false);
        sepPC.setControl((Control)t);
        ToolItem sepP2 = new ToolItem(toolBar, 2);
        sepP2.setWidth(5);
        ToolItem right = new ToolItem(toolBar, 0x800008);
        right.setImage(ImageCache.getImage("next_page.gif"));
        ToolItem sep4 = new ToolItem(toolBar, 2);
        sep4.setWidth(10);
        ToolItem sep5 = new ToolItem(toolBar, 2);
        sep5.setControl((Control)new Label((Composite)toolBar, 0x1000202));
        ToolItem sep6 = new ToolItem(toolBar, 2);
        sep6.setWidth(10);
        ToolItem scale1 = new ToolItem(toolBar, 0x800008);
        scale1.setImage(ImageCache.getImage("zoom_scale.gif"));
        ToolItem sepZ1 = new ToolItem(toolBar, 2);
        sepZ1.setWidth(5);
        ToolItem scalePlus = new ToolItem(toolBar, 0x800008);
        scalePlus.setImage(ImageCache.getImage("zoom_in.gif"));
        ToolItem sepZ2 = new ToolItem(toolBar, 2);
        sepZ2.setWidth(5);
        ToolItem scaleMinus = new ToolItem(toolBar, 0x800008);
        scaleMinus.setImage(ImageCache.getImage("zoom_out.gif"));
        ToolItem sep7 = new ToolItem(toolBar, 2);
        sep7.setWidth(10);
        ToolItem sep8 = new ToolItem(toolBar, 2);
        sep8.setControl((Control)new Label((Composite)toolBar, 0x1000202));
        ToolItem sep9 = new ToolItem(toolBar, 2);
        sep9.setWidth(10);
        ToolItem fitVer = new ToolItem(toolBar, 0x800008);
        fitVer.setImage(ImageCache.getImage("fit_vertical.gif"));
        ToolItem sepF1 = new ToolItem(toolBar, 2);
        sepF1.setWidth(5);
        ToolItem fitHor = new ToolItem(toolBar, 0x800008);
        fitHor.setImage(ImageCache.getImage("fit_horizontal.gif"));
        final ScrolledComposite sc = new ScrolledComposite((Composite)shell, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        final PrintPreview pp = new PrintPreview((Composite)sc, 0);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        pp.setFitVertical(true);
        pp.setPrintJob(pj);
        sc.setContent((Control)pp);
        shell.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                int wheelCount;
                for (wheelCount = event.count; wheelCount < 0; ++wheelCount) {
                    sc.setOrigin(sc.getOrigin().x, sc.getOrigin().y + 2);
                }
                while (wheelCount > 0) {
                    sc.setOrigin(sc.getOrigin().x, sc.getOrigin().y - 2);
                    --wheelCount;
                }
            }
        });
        shell.addListener(38, new Listener(){

            public void handleEvent(Event event) {
                int wheelCount;
                for (wheelCount = event.count; wheelCount < 0; ++wheelCount) {
                    sc.setOrigin(sc.getOrigin().x + 2, sc.getOrigin().y);
                }
                while (wheelCount > 0) {
                    sc.setOrigin(sc.getOrigin().x - 2, sc.getOrigin().y);
                    --wheelCount;
                }
            }
        });
        printB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintDialog pd = new PrintDialog(shell);
                pd.setPrinterData(pp.getPrinterData());
                PrinterData pdd = pd.open();
                if (pdd != null) {
                    pp.setPrinterData(pdd);
                    pp.update();
                    ReportPrintBuilder.printToPrinter(pdd, pp.getPrintJob().getDocument(), "BarMaster PRINT", 1);
                }
            }
        });
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setPageIndex((pp.getPageCount() + pp.getPageIndex() - 1) % pp.getPageCount());
                ((Text)sepPC.getControl()).setText(pp.getPageIndex() + 1 + "/" + pp.getPageCount());
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        left.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 2) {
                    pp.setPageIndex((pp.getPageCount() + pp.getPageIndex() - 10) % pp.getPageCount());
                    ((Text)sepPC.getControl()).setText(pp.getPageIndex() + 1 + "/" + pp.getPageCount());
                    pp.update();
                    sc.setMinSize(pp.computeSize((double)pp.getScale()));
                }
            }
        });
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setPageIndex((pp.getPageCount() + pp.getPageIndex() + 1) % pp.getPageCount());
                ((Text)sepPC.getControl()).setText(pp.getPageIndex() + 1 + "/" + pp.getPageCount());
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        right.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 2) {
                    pp.setPageIndex((pp.getPageCount() + pp.getPageIndex() + 10) % pp.getPageCount());
                    ((Text)sepPC.getControl()).setText(pp.getPageIndex() + 1 + "/" + pp.getPageCount());
                    pp.update();
                    sc.setMinSize(pp.computeSize((double)pp.getScale()));
                }
            }
        });
        scale1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setFitHorizontal(false);
                pp.setFitVertical(false);
                pp.setScale(1.0f);
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        scalePlus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setFitHorizontal(false);
                pp.setFitVertical(false);
                pp.setScale(pp.getScale() + 0.05f);
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        scaleMinus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setFitHorizontal(false);
                pp.setFitVertical(false);
                pp.setScale(pp.getScale() - 0.05f);
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        fitHor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setFitVertical(false);
                pp.setFitHorizontal(true);
                pp.setScale(1.0f);
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        fitVer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pp.setFitVertical(true);
                pp.setFitHorizontal(false);
                pp.setScale(1.0f);
                pp.update();
                sc.setMinSize(pp.computeSize((double)pp.getScale()));
            }
        });
        ((Text)sepPC.getControl()).setText(pp.getPageIndex() + 1 + "/" + pp.getPageCount());
        Konstante.centerShellOnDisplay(shell);
        shell.open();
        while (blockThread && !shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }

    public static void printPreview(Shell parent, PrintJob pj) {
        Shell s = new Shell(parent, 1264);
        ReportPrintBuilder.createPrintPreview(s, pj);
    }

    public static void printPreview(Shell parent, PrintJob pj, boolean blockThread) {
        Shell s = new Shell(parent, 1264);
        ReportPrintBuilder.createPrintPreview(s, pj, blockThread);
    }

    public static void printPreview(Display d, PrintJob pj) {
        Shell s = new Shell(d, 1264);
        ReportPrintBuilder.createPrintPreview(s, pj);
    }

    public static void printPreview(Display d, PrintJob pj, boolean blockThread) {
        Shell s = new Shell(d, 1264);
        ReportPrintBuilder.createPrintPreview(s, pj, blockThread);
    }

    public static void main(String[] args) {
        Display d = new Display();
        PrinterData pd = Printer.getDefaultPrinterData();
        Print header = ReportPrintBuilder.makeTitle(null, "Proba");
        System.out.println("header = " + header);
        PagePrint p = ReportPrintBuilder.createNewDocument(header, ReportPrintBuilder.createBody(new Print[0]), (Print)new EmptyPrint());
        ReportPrintBuilder.printPreview(d, ReportPrintBuilder.createPrintJob((Print)p, pd));
        d.dispose();
    }

    public static class NPCPrintPreview
    extends ApplicationWindow {
        private PrintJob pj;
        private int[] printMargin;
        private PrintPreview pp;
        private ScrolledComposite sc;
        private ToolItem sepPC;
        private ToolBar toolBar;

        public NPCPrintPreview(Shell parentShell) {
            super(parentShell);
            this.addMenuBar();
            this.addToolBar(0x800040);
            PaperClips.setDebug((boolean)true);
        }

        public void setPrintJob(PrintJob pj) {
            this.pj = pj;
        }

        public void setPrintMargin(int ... printMargin) {
            this.printMargin = printMargin;
        }

        protected void setUpPrintJob() {
            if (this.pj != null && this.printMargin != null) {
                Margins margins = new Margins();
                switch (this.printMargin.length) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        margins.left = margins.right = this.printMargin[0];
                        margins.bottom = margins.right;
                        margins.top = margins.right;
                        break;
                    }
                    case 2: {
                        margins.top = margins.bottom = this.printMargin[0];
                        margins.left = margins.right = this.printMargin[1];
                        break;
                    }
                    case 3: {
                        margins.top = this.printMargin[0];
                        margins.bottom = this.printMargin[1];
                        margins.left = margins.right = this.printMargin[2];
                        break;
                    }
                    default: {
                        margins.top = this.printMargin[0];
                        margins.bottom = this.printMargin[1];
                        margins.left = this.printMargin[2];
                        margins.right = this.printMargin[3];
                    }
                }
                this.pj.setMargins(margins);
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.pj == null || this.pj.getName() == null) {
                shell.setText("Print Preview");
            } else {
                shell.setText(this.pj.getName());
            }
        }

        protected Control getToolBarControl() {
            return super.getToolBarControl();
        }

        public ToolBarManager getToolBarManager() {
            return super.getToolBarManager();
        }

        protected ToolBarManager createToolBarManager(int style) {
            ToolBarManager tbm = new ToolBarManager(style);
            Action printB = new Action("Print", ImageDescriptor.createFromFile(ImageCache.class, (String)"print.gif")){

                public void run() {
                    PrintDialog pd = new PrintDialog(this.getShell());
                    pd.setPrinterData(pp.getPrinterData());
                    PrinterData pdd = pd.open();
                    if (pdd != null) {
                        pp.setPrinterData(pdd);
                        pp.update();
                        ReportPrintBuilder.printToPrinter(pdd, pp.getPrintJob().getDocument(), "BarMaster PRINT", 1);
                    }
                }
            };
            printB.setId("PrintButton");
            tbm.add((IAction)printB);
            tbm.add((IContributionItem)new Separator());
            return tbm;
        }

        protected Control createToolBarControl(Composite parent) {
            return super.createCoolBarControl(parent);
        }

        protected Control createContents(Composite parent) {
            this.setUpPrintJob();
            Composite main = new Composite(parent, 0);
            main.setBackground(parent.getDisplay().getSystemColor(9));
            FillLayout gl = new FillLayout();
            main.setLayout((Layout)gl);
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            this.sc = new ScrolledComposite(main, 768);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.pp = new PrintPreview((Composite)this.sc, 0);
            this.pp.setFitVertical(true);
            this.pp.setPrintJob(this.pj);
            this.sc.setContent((Control)this.pp);
            this.sc.setMinSize(this.pp.computeSize((double)this.pp.getScale()));
            return main;
        }
    }
}

