/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji.knjigasanka;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.Normativi.PregledIzmeneNormativa;
import com.dev63.restoran.izvestaji.knjigasanka.KnjigaSankaServer;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class KnjigaSanka {
    private RestoranServer server;
    private Display display;
    private Shell knjigaSankaShell;
    private final ResourceBundle barmasterText;
    private KnjigaSankaServer ksServer;
    private String[] kolone = new String[]{"Naziv artikla", "Po\u010detno", "Ulaz", "Izlaz", "Zavr\u0161no", "Prodajna cena", "Prodajna vrednost"};
    private Table knjigaSanka;
    String naslov;

    public KnjigaSanka(Date datum, Odeljenje odeljenje, boolean osnovna, boolean dodatna, RestoranServer server, Shell shell) {
        this.server = server;
        this.display = shell.getDisplay();
        this.knjigaSankaShell = new Shell(this.display);
        this.barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        this.ksServer = new KnjigaSankaServer(server, datum, odeljenje, osnovna, dodatna);
        this.naslov = this.barmasterText.getString("TEXT_KNJIGA_SANKA") + ": " + StatLogic.getDateString(datum);
        this.knjigaSankaShell.setLayout((Layout)this.getGridLayout(4, 0, 0));
        this.knjigaSankaShell.setText(this.naslov);
        this.knjigaSanka = this.makeTable(this.knjigaSankaShell, this.kolone);
        this.ksServer.popuniRedove(this.knjigaSanka);
        this.makePrintButton(this.knjigaSankaShell, this.knjigaSanka);
        this.makeExportButton(this.knjigaSankaShell, this.knjigaSanka);
        this.knjigaSankaShell.setEnabled(true);
        this.knjigaSankaShell.setMaximized(true);
        this.knjigaSankaShell.open();
    }

    private Table makeTable(Shell shell, String[] kolone) {
        Table table = new Table((Composite)shell, 514);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 4;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        for (int i = 0; i < kolone.length; ++i) {
            TableColumn tColumn = new TableColumn(table, 0);
            tColumn.setText(kolone[i]);
            if (i == 0) {
                tColumn.setWidth(200);
                continue;
            }
            if (i == 1 || i == 2) {
                tColumn.setWidth(70);
                continue;
            }
            tColumn.setWidth(120);
        }
        return table;
    }

    private GridLayout getGridLayout(int colNumber, int leftMargin, int topMargin) {
        GridLayout layout = new GridLayout(colNumber, false);
        layout.marginLeft = leftMargin;
        layout.marginTop = topMargin;
        return layout;
    }

    private GridData getGridData(int width, int height) {
        GridData data = new GridData(width, height);
        return data;
    }

    private Button makeExportButton(final Shell shell, final Table table) {
        Button excel = new Button((Composite)shell, 0);
        excel.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        excel.setLayoutData((Object)this.getGridData(120, 50));
        excel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(table, shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PregledIzmeneNormativa.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom kreiranja export fajla", ex);
                }
            }
        });
        return excel;
    }

    private Button makePrintButton(final Shell shell, final Table table) {
        Button stampa = new Button((Composite)shell, 0);
        stampa.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        stampa.setLayoutData((Object)this.getGridData(120, 50));
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrintHandler ph = new PrintHandler(10, false, false);
                GridPrinter gp = new GridPrinter(ph);
                gp.printTable(new TableWrapper(table), false, true, KnjigaSanka.this.naslov, shell, 9, KnjigaSanka.this.server);
            }
        });
        return stampa;
    }
}

