/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.ZbirnaFakturaModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class ZbirnaFakturaNova {
    private List<ZbirnaFakturaModel> faktureZaZbirnu;
    private RestoranServer server;
    private Shell shell;
    Connection connection;

    public ZbirnaFakturaNova(List<ZbirnaFakturaModel> faktureZaZbirnu, RestoranServer server, Shell shell) {
        this.faktureZaZbirnu = faktureZaZbirnu;
        this.server = server;
        this.connection = server.getConnection();
        this.shell = shell;
    }

    public void napraviZbirnuFakturu() {
        long zbirnaId = this.insertZbirneFakture();
        this.updatePripadajucihRacuna(zbirnaId);
        ZbirnaFakturaModel zfm = this.zbirnaPoId(zbirnaId);
        Konstante.prikaziMessageBox(this.shell, "Kreirali ste zbirnu fakturu pod rednim brojem " + zfm.getBrojZbirneFakture() + ". Iznos fakture: " + zfm.getIznosZbirneFakture());
    }

    private long insertZbirneFakture() {
        long idZbirne = -1L;
        java.sql.Date datumZbirne = new java.sql.Date(new Date().getTime());
        double sumaZbirneFakture = this.sumaZbirneFakture();
        String brojZBirne = this.server.getSetting(Option.ZBIRNA_FAKTURA_SLEDECI_BROJ).stringValue();
        String nazivKomitenta = this.nazivKomitenta();
        String query = "INSERT INTO zbirnafaktura (brojZbirneFakture, datumZbirneFakture, iznosZbirneFakture, nazivKomitenta)\r\nVALUES(?,?,?,?)";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query, 1);
            ps.setString(1, brojZBirne);
            ps.setDate(2, datumZbirne);
            ps.setDouble(3, sumaZbirneFakture);
            ps.setString(4, nazivKomitenta);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            while (rs.next()) {
                idZbirne = rs.getInt(1);
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ps.close();
            this.server.incrementSledeciBrojZajednickeFakture();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return idZbirne;
    }

    private void updatePripadajucihRacuna(long zbirnaId) {
        String racuniZaUpdate = this.racuniZaUpdate();
        String query = "UPDATE racun r SET r.zbirnaFakturaId = ? WHERE\r\nr.id IN(" + racuniZaUpdate + ")";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, zbirnaId);
            ps.executeUpdate();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ps.close();
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public static List<ZbirnaFakturaModel> getFaktureZaZbirnu(RestoranServer server, long zdBrojOd, long zdBrojDo, String naziv) {
        Connection connection = server.getConnection();
        ArrayList<ZbirnaFakturaModel> listaRacuna = new ArrayList<ZbirnaFakturaModel>();
        String query = "SELECT r.id,CAST(r.datum AS DATE) AS datum, r.brojFakture, pl.nacin, pl.iznos, sg.naziv FROM racun r \r\nJOIN placanje pl ON r.id = pl.RACUN_ID\r\nJOIN stalnigost sg ON r.STALNIGOST_ID = sg.id\r\nWHERE pl.nacin = 'FAKTURA' AND r.zdBroj BETWEEN ? AND ? AND (r.zbirnaFakturaId IS NULL or r.zbirnaFakturaId < 1) AND sg.naziv = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, zdBrojOd);
            ps.setLong(2, zdBrojDo);
            ps.setString(3, naziv);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ZbirnaFakturaModel zfModel = new ZbirnaFakturaModel();
                zfModel.setId(rs.getLong("id"));
                zfModel.setDatumZbirneFakture(rs.getDate("datum"));
                zfModel.setBrojZbirneFakture(rs.getString("brojFakture"));
                zfModel.setIznosZbirneFakture(rs.getDouble("iznos"));
                zfModel.setNazivKomitenta(rs.getString("naziv"));
                listaRacuna.add(zfModel);
            }
            return listaRacuna;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ZbirnaFakturaModel> getZbirne(RestoranServer server, Date datumOd, Date datumDo, String naziv) {
        Connection connection = server.getConnection();
        java.sql.Date odDatuma = new java.sql.Date(datumOd.getTime());
        java.sql.Date doDatuma = new java.sql.Date(datumDo.getTime());
        ArrayList<ZbirnaFakturaModel> listaZbirnihFaktura = new ArrayList<ZbirnaFakturaModel>();
        String query = "SELECT * FROM zbirnafaktura zf WHERE\r\nzf.datumZbirneFakture BETWEEN ? AND ? \r\nAND zf.nazivKomitenta = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, odDatuma);
            ps.setDate(2, doDatuma);
            ps.setString(3, naziv);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ZbirnaFakturaModel zfModel = new ZbirnaFakturaModel();
                zfModel.setId(rs.getLong("id"));
                zfModel.setDatumZbirneFakture(rs.getDate("datumZbirneFakture"));
                zfModel.setBrojZbirneFakture(rs.getString("brojZbirneFakture"));
                zfModel.setIznosZbirneFakture(rs.getDouble("iznosZbirneFakture"));
                zfModel.setNazivKomitenta(rs.getString("nazivKomitenta"));
                listaZbirnihFaktura.add(zfModel);
            }
            return listaZbirnihFaktura;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String nazivKomitenta() {
        return this.faktureZaZbirnu.get(0).getNazivKomitenta();
    }

    private String racuniZaUpdate() {
        StringBuilder sb = new StringBuilder();
        for (ZbirnaFakturaModel model : this.faktureZaZbirnu) {
            sb.append(model.getId());
            sb.append(",");
        }
        String racuniZaUpdate = sb.toString();
        return racuniZaUpdate.substring(0, racuniZaUpdate.length() - 1);
    }

    private double sumaZbirneFakture() {
        double suma = 0.0;
        for (ZbirnaFakturaModel model : this.faktureZaZbirnu) {
            suma += model.getIznosZbirneFakture();
        }
        return suma;
    }

    private ZbirnaFakturaModel zbirnaPoId(long id) {
        ZbirnaFakturaModel zfm = new ZbirnaFakturaModel();
        String query = "SELECT * FROM zbirnafaktura zf WHERE zf.id = ?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            zfm.setId(rs.getLong("id"));
            zfm.setBrojZbirneFakture(rs.getString("brojZbirneFakture"));
            zfm.setDatumZbirneFakture(rs.getDate("datumZbirneFakture"));
            zfm.setIznosZbirneFakture(rs.getDouble("iznosZbirneFakture"));
            zfm.setNazivKomitenta(rs.getString("nazivKomitenta"));
            return zfm;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

