/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ZbirnaFaktura1 {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    Date day1;
    Date day2;
    File dpu;
    Date pocetni1;
    Date krajnji1;
    List<Racun> otpremnice = new ArrayList<Racun>();

    private ZbirnaFaktura1(Shell s, Restoran r, Date d1, Date d2) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.pocetni1 = Konstante.getPocetniDatum(d1, this.server);
        this.krajnji1 = Konstante.getKrajnjiDatum(d2, this.server);
        this.otpremnice = this.server.getNeodstampaneOtpremnice(this.pocetni1, this.krajnji1);
        this.shell = new Shell(s);
        this.shell.setText("Otpremnice");
        this.shell.setMaximized(true);
        this.table = new Table((Composite)this.shell, 2848);
        this.table.setBounds(20, 20, 400, 700);
        for (Racun racun : this.otpremnice) {
            if (racun.getCrnoPlacanje() == null || !racun.getCrnoPlacanje().equals("Otpremnica") || racun.getFiskalniOdstampan().booleanValue()) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText((racun.getStalniGost() != null ? racun.getStalniGost().getNaziv() + ", " : "") + Konstante.getFullFormat(racun.getDatum()));
        }
        this.table.select(0);
        final Label text = new Label((Composite)this.shell, 2048);
        text.setBounds(440, 20, 350, 700);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = ZbirnaFaktura1.this.table.getSelectionIndex();
                String outString = "";
                double total = 0.0;
                for (StavkaRacuna sr : ZbirnaFaktura1.this.otpremnice.get(index).getStavke()) {
                    outString = outString + " " + sr.getNaziv() + " - " + sr.getKolicina() + " X " + sr.getCena() + " = " + sr.getVrednost() + "\n";
                    total += sr.getVrednost().doubleValue();
                }
                outString = outString + "\n_________________________\n\n Total: " + total;
                text.setText(outString);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                int[] selectedItems = ZbirnaFaktura1.this.table.getSelectionIndices();
                String outString = "";
                for (int loopIndex = 0; loopIndex < selectedItems.length; ++loopIndex) {
                    outString = outString + selectedItems[loopIndex] + " ";
                }
            }
        });
        Button stampa = Dugmici.getOkButton(this.shell);
        stampa.setBounds(810, 20, 120, 40);
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = 0;
                Racun racun = new Racun();
                ArrayList<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
                for (TableItem ti : ZbirnaFaktura1.this.table.getItems()) {
                    if (ti.getChecked()) {
                        for (StavkaRacuna sr : ZbirnaFaktura1.this.otpremnice.get(index).getStavke()) {
                            stavke.add(sr);
                        }
                    }
                    ++index;
                }
                racun.setStavke1(StavkeSumarno.getSumarnoF(stavke));
            }
        });
        Button izlaz = Dugmici.getCancelButton(this.shell);
        izlaz.setBounds(810, 80, 120, 40);
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ZbirnaFaktura1.this.shell.close();
            }
        });
        this.shell.open();
    }

    public static class ZbirnaFakturaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        SWTContainer parent;

        public ZbirnaFakturaInput(SWTContainer owner, Restoran r, boolean ins) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("KEPU");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            Object grupa21 = null;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.server.log("Pregled otpremnica");
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new ZbirnaFaktura1(shell2, this.restoran, this.day1, this.day2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

