/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.Faktura;
import com.dev63.restoran.sistem.FakturaRacun;
import com.dev63.restoran.stampa.FiskalniRacun;
import com.dev63.restoran.stampa.StampaKopijeRacuna1;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ZbirnaFaktura {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    Date day1;
    Date day2;
    File dpu;
    Date pocetni1;
    Date krajnji1;
    List<Racun> otpremnice = new ArrayList<Racun>();
    Label lbl;
    Racun racun;
    double chck;
    Label total;
    StalniGost komitent;

    private ZbirnaFaktura(Shell s, Restoran r, StalniGostiGrupa gr, StalniGost kom, Date d1, Date d2) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.komitent = kom;
        this.pocetni1 = Konstante.getPocetniDatum(d1, this.server);
        this.krajnji1 = Konstante.getKrajnjiDatum(d2, this.server);
        this.otpremnice = this.server.getNeodstampaneOtpremniceGost(gr, kom, this.pocetni1, this.krajnji1);
        this.shell = new Shell(s);
        this.shell.setText("Otpremnice");
        this.shell.setMaximized(true);
        Label l1 = new Label((Composite)this.shell, 0);
        l1.setBounds(20, 15, 400, 15);
        l1.setText("Otpremnice:");
        this.table = new Table((Composite)this.shell, 2848);
        this.table.setBounds(20, 35, 400, 650);
        for (Racun racun : this.otpremnice) {
            if (racun.getCrnoPlacanje() == null || !racun.getCrnoPlacanje().equals("Otpremnica") || racun.getFiskalniOdstampan().booleanValue()) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText((racun.getStalniGost() != null ? racun.getStalniGost().getNaziv() + ", " : "") + Konstante.getFullFormat(racun.getDatum()));
        }
        this.table.select(0);
        Button sa = new Button((Composite)this.shell, 8);
        sa.setText("Izaberi sve / Ponisti");
        sa.setBounds(20, 690, 120, 40);
        sa.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ZbirnaFaktura.this.table.getItem(0).getChecked()) {
                    for (TableItem ti : ZbirnaFaktura.this.table.getItems()) {
                        ti.setChecked(true);
                    }
                } else {
                    for (TableItem ti : ZbirnaFaktura.this.table.getItems()) {
                        ti.setChecked(false);
                    }
                }
                ZbirnaFaktura.this.select();
            }
        });
        sa.setEnabled(this.table.getItems().length > 0);
        this.lbl = new Label((Composite)this.shell, 0);
        this.lbl.setBounds(160, 700, 240, 40);
        this.lbl.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
        this.lbl.setText("TOTAL: 0.00");
        Label l2 = new Label((Composite)this.shell, 0);
        l2.setBounds(440, 15, 350, 15);
        l2.setText("Izabrana otpremnica:");
        final Label text = new Label((Composite)this.shell, 2048);
        text.setBounds(440, 35, 350, 300);
        Label l3 = new Label((Composite)this.shell, 0);
        l3.setBounds(440, 360, 350, 15);
        l3.setText("Zbir po artiklima izabranih otpremnica:");
        this.total = new Label((Composite)this.shell, 2048);
        this.total.setBounds(440, 380, 350, 340);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 32) {
                    ZbirnaFaktura.this.select();
                }
                int index = ZbirnaFaktura.this.table.getSelectionIndex();
                String outString = "";
                double total = 0.0;
                for (StavkaRacuna sr : ZbirnaFaktura.this.otpremnice.get(index).getStavke()) {
                    outString = outString + " " + sr.getNaziv() + " - " + sr.getKolicina() + " X " + sr.getCena() + " = " + sr.getVrednost() + "\n";
                    total += sr.getVrednost().doubleValue();
                }
                outString = outString + "\n_________________________\n\n Total: " + total;
                text.setText(outString);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                int[] selectedItems = ZbirnaFaktura.this.table.getSelectionIndices();
                String outString = "";
                for (int loopIndex = 0; loopIndex < selectedItems.length; ++loopIndex) {
                    outString = outString + selectedItems[loopIndex] + " ";
                }
            }
        });
        Button faktura = new Button((Composite)this.shell, 0);
        faktura.setBounds(810, 20, 120, 40);
        faktura.setText("FAKTURA");
        faktura.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = 0;
                for (TableItem ti : ZbirnaFaktura.this.table.getItems()) {
                    if (ti.getChecked()) {
                        Racun r = ZbirnaFaktura.this.otpremnice.get(index);
                        r.setStorniran(true);
                        ZbirnaFaktura.this.server.updateRacun(r);
                    }
                    ++index;
                }
                Faktura f = new Faktura(null, new Shell(ZbirnaFaktura.this.shell.getDisplay(), 0), ZbirnaFaktura.this.server);
                if (!f.getOtkazi()) {
                    ArrayList<Placanje> placanja = new ArrayList<Placanje>();
                    Placanje p = new Placanje();
                    p.setIznos(ZbirnaFaktura.this.chck);
                    p.setNacin(NacinPlacanja.FAKTURA);
                    p.setVreme(new Date());
                    placanja.add(p);
                    ZbirnaFaktura.this.makeRacun(ZbirnaFaktura.this.racun, placanja, ZbirnaFaktura.this.komitent);
                }
            }
        });
        Button izlaz = Dugmici.getCancelButton(this.shell);
        izlaz.setBounds(810, 80, 120, 40);
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ZbirnaFaktura.this.shell.close();
            }
        });
        this.shell.open();
    }

    public void select() {
        int index = 0;
        double kom = 0.0;
        this.chck = 0.0;
        this.racun = new Racun();
        ArrayList<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
        for (TableItem ti : this.table.getItems()) {
            if (ti.getChecked()) {
                for (StavkaRacuna sr : this.otpremnice.get(index).getStavke()) {
                    stavke.add(sr);
                }
            }
            ++index;
        }
        this.racun.setStavke1(StavkeSumarno.getSumarnoF(stavke));
        String outString = "";
        for (StavkaRacuna sr : this.racun.getStavke()) {
            outString = outString + " " + sr.getNaziv() + " - " + sr.getKolicina() + " X " + sr.getCena() + " = " + sr.getVrednost() + "\n";
            kom += sr.getKolicina().doubleValue();
            this.chck += sr.getVrednost().doubleValue();
        }
        outString = outString + "\n_________________________\n\n Ukupno komada: " + kom;
        this.total.setText(outString);
        this.lbl.setText("TOTAL: " + Konstante.getNumber2(this.chck));
    }

    public void makeRacun(Racun rac, List<Placanje> placanja, StalniGost sg) {
        this.server.refresh();
        List<StavkaRacuna> stavkeracuna = rac.getStavke1();
        if (stavkeracuna.size() < 1) {
            return;
        }
        Sto sto = new Sto();
        sto.setBlokiran(false);
        sto.setBroj(0);
        Tura tura = new Tura();
        tura.setBrojStola(0);
        tura.setDatum(new Date());
        tura.setBrojTure(this.server.sledeciBrojTure());
        tura.setPocetak(new Timestamp(0L));
        tura.setKraj(new Timestamp(0L));
        this.server.incrementBrojTure(String.valueOf(tura.getBrojTure() + 1));
        Konobar kon = this.server.getKonobar(5L);
        sto.setKonobar(kon);
        sto = this.server.addStoQuery(sto);
        tura = this.server.addTura(tura);
        for (StavkaRacuna stav : stavkeracuna) {
            stav.setTura(tura);
        }
        boolean faktura = false;
        faktura = placanja.get(0).getNacin().equals((Object)NacinPlacanja.FAKTURA);
        Racun racun = new Racun();
        racun.setStorniran(false);
        racun.setKonobar(kon);
        racun.setDatum(new Date());
        racun.setBrojStola(0);
        racun.setStavke1(stavkeracuna);
        racun.setZatvoren(Boolean.TRUE);
        racun.setPopust(0.0);
        if (placanja.size() > 0) {
            racun.setPlacanja(placanja);
        }
        if (racun.getCrnoPlacanje() != null) {
            racun.setFiskalniOdstampan(false);
            new StampaKopijeRacuna1(racun, this.restoran);
            racun.setFiskalniOdstampan(false);
        } else {
            racun.setFiskalniOdstampan(false);
            if (placanja.size() > 0) {
                try {
                    new FiskalniRacun(this.restoran).printFiscal(racun, "");
                }
                catch (FiscalException ex) {
                    Logger.getLogger(ZbirnaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(ZbirnaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SerialIOException ex) {
                    Logger.getLogger(ZbirnaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Exception ex) {
                    Logger.getLogger(ZbirnaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                racun.setFiskalniOdstampan(false);
            }
        }
        if (faktura) {
            racun.setStalniGost(sg);
            racun.setBrojFakture(this.server.sledeciBrojFakture());
        }
        racun = this.server.addRacun(racun);
        for (Placanje pl : placanja) {
            if (placanja.size() == 1) {
                pl.setIznos(racun.total());
            }
            pl.setRacun(racun);
            pl.setVreme(new Date());
            this.server.addPlacanje(pl);
        }
        for (StavkaRacuna st : stavkeracuna) {
            st.setRacun(racun);
            this.server.addStavkaRacuna(st);
            this.skidanjeNormativa(st);
        }
        this.table.removeAll();
        stavkeracuna = new ArrayList<StavkaRacuna>();
        if (faktura) {
            int bk;
            try {
                bk = this.server.getSetting(Option.BROJ_KOPIJA_FAKTURE).intValue();
            }
            catch (Exception e) {
                bk = 1;
            }
            new FakturaRacun(this.shell.getDisplay(), this.restoran, racun, this.restoran.getStope(), bk, "", false, null);
            this.server.incrementBrojFakture(String.valueOf(racun.getBrojFakture() + 1));
        }
        this.server.deleteSto(0);
        this.server.deleteTura(tura.getId());
        placanja = new ArrayList<Placanje>();
    }

    public void skidanjeNormativa(StavkaRacuna sr) {
        Artikal a = sr.getArtikal();
        SkidanjeNormativa.napraviKartice(SkidanjeNormativa.razloziArtikal(a, sr.getKolicina(), this.server, sr.getRacun().getDatum()), this.server, "", 35, null, a.getOdeljenjeNormativ());
    }

    public static class ZbirnaFakturaInput {
        private DateInput2 odDatuma;
        Button blic;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupe;
        private Combo komitent;
        Date day1;
        Date day2;
        SWTContainer parent;

        public ZbirnaFakturaInput(SWTContainer owner, Restoran r, boolean ins) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Pregled stalnih gostiju");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Stalni gosti");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label izg = new Label((Composite)grupa1, 0);
            izg.setText("Izbor grupe:");
            final List<StalniGostiGrupa> sgg = this.server.readGrupeStGosti();
            this.grupe = new Combo((Composite)grupa1, 8);
            this.grupe.setEnabled(true);
            Label izk = new Label((Composite)grupa1, 0);
            izk.setText("Izbor komitenta:");
            this.komitent = new Combo((Composite)grupa1, 8);
            this.komitent.add("Svi komitenti");
            this.komitent.select(0);
            this.komitent.setEnabled(false);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label bl = new Label((Composite)grupa1, 0);
            bl.setText("Blic pregled:");
            this.blic = new Button((Composite)grupa1, 32);
            this.blic.setSelection(true);
            this.blic.setEnabled(false);
            this.grupe.add("Sve grupe");
            for (int i = 0; i < sgg.size(); ++i) {
                this.grupe.add(sgg.get(i).getNaziv());
            }
            this.grupe.select(0);
            this.grupe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    komitent.removeAll();
                    komitent.add("Svi komitenti");
                    komitent.select(0);
                    if (grupe.getSelectionIndex() == 0) {
                        komitent.select(0);
                        komitent.setEnabled(false);
                    } else {
                        komitent.setEnabled(true);
                        List<StalniGost> gosti = server.readStalneGoste((StalniGostiGrupa)sgg.get(grupe.getSelectionIndex() - 1));
                        for (int j = 0; j < gosti.size(); ++j) {
                            komitent.add(gosti.get(j).getNaziv());
                        }
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                StalniGostiGrupa g = null;
                if (this.grupe.getSelectionIndex() > 0) {
                    g = this.server.findGrupaStGosti(this.grupe.getItem(this.grupe.getSelectionIndex()));
                }
                StalniGost k = null;
                if (this.komitent.getSelectionIndex() > 0) {
                    k = this.server.getStalniGost(this.komitent.getItem(this.komitent.getSelectionIndex()));
                }
                this.server.log("Pregled otpremnica za period: od datuma->" + this.day1 + " do datuma ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText("Pregled otpremnica za period: " + Konstante.getDate(this.day1) + " -> " + Konstante.getDate(this.day2));
                new ZbirnaFaktura(shell2, this.restoran, g, k, this.day1, this.day2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

