/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.EvidencijaZaposlenih;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TrenutnoPrijavljeniZaposleni {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<String> zaposleni = new ArrayList<String>();

    public TrenutnoPrijavljeniZaposleni(SWTContainer owner, Restoran r) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.zaposleni = this.server.readZaposleni();
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 120;
        data.heightHint = 50;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        printButton.setLayoutData((Object)gd);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(TrenutnoPrijavljeniZaposleni.this.table), false, true, String.format(TrenutnoPrijavljeniZaposleni.this.barmasterText.getString("TEXT_TRENUTNO_PRIJAVLJENI_ZAPOSLENI"), new Object[0]) + ": " + Konstante.getDate(new Date()), TrenutnoPrijavljeniZaposleni.this.shell, TrenutnoPrijavljeniZaposleni.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(TrenutnoPrijavljeniZaposleni.this.table, TrenutnoPrijavljeniZaposleni.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tc1.setWidth(90);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_IME_I_PREZIME"), new Object[0]));
        tc2.setWidth(150);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText(String.format(this.barmasterText.getString("TEXT_DOLAZAK"), new Object[0]));
        tc9.setWidth(120);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_ODLAZAK"), new Object[0]));
        tc3.setWidth(120);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_RADNOG_SATA"), new Object[0]));
        tc4.setWidth(80);
        tc4.pack();
    }

    public void insertRows() {
        Date day1 = new Date();
        Date day2 = new Date();
        Calendar c1 = Calendar.getInstance();
        c1.setTime(day1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(day2);
        int brojDana = c2.get(6) - c1.get(6);
        for (int i = 0; i < brojDana + 1; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(day1);
            Date d = c.getTime();
            new TableItem(this.table, 16384).setText(Konstante.getDate(d));
            for (EvidencijaZaposlenih e : this.server.readTrenutnoPrijavljeni()) {
                if (!this.zaposleni.contains(e.getIme())) continue;
                TableItem ti = new TableItem(this.table, 0x1000000);
                ti.setText(new String[]{"", e.getIme(), Konstante.getFullFormat(e.getDolazak()), e.getOdlazak() != null ? Konstante.getFullFormat(e.getOdlazak()) : "/", Konstante.getNumber2(e.getCenaSata())});
            }
        }
    }
}

