/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.ListaMinimumaZaliha;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaSifrarnikArtikala;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SifrarnikArtikala {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    static Shell shell;
    Composite composite;
    boolean blokirani;
    String tipovi;
    private Map<Long, String> artikli;
    private List<Artikal> listaArtikli;
    TableColumn tc0;
    TableColumn tc1;
    TableColumn tc2;
    TableColumn tc3;

    private SifrarnikArtikala(Shell s, Restoran r, final Odeljenje od, boolean sirovine, boolean potrosni, boolean poluproizvodi, boolean prodajni, boolean slozeni, boolean blokirani) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        shell = s;
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.setLayout((Layout)new GridLayout(3, false));
        this.tipovi = "";
        if (sirovine) {
            this.tipovi = this.tipovi + "'SIRO',";
        }
        if (potrosni) {
            this.tipovi = this.tipovi + "'POTR',";
        }
        if (poluproizvodi) {
            this.tipovi = this.tipovi + "'POLU',";
        }
        if (prodajni) {
            this.tipovi = this.tipovi + "'PROD',";
        }
        if (slozeni) {
            this.tipovi = this.tipovi + "'SLOZ',";
        }
        if (this.tipovi.length() > 0) {
            this.tipovi = this.tipovi.substring(0, this.tipovi.length() - 1);
        }
        this.blokirani = blokirani;
        this.table = new Table((Composite)shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 3;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        try {
            this.insertRows(od);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ListaMinimumaZaliha.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(ListaMinimumaZaliha.class.getName()).log(Level.SEVERE, null, ex);
        }
        Composite control = new Composite((Composite)shell, 0);
        control.setLayout((Layout)new GridLayout(4, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        printButton.setLayoutData((Object)gd);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(SifrarnikArtikala.this.table), false, true, "Sifrarnik artikala", shell, SifrarnikArtikala.this.server);
            }
        });
        Button printButton2 = new Button(control, 8);
        printButton2.setLayoutData((Object)gd);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText(String.format(Konstante.getBundle().getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new StampaSifrarnikArtikala(SifrarnikArtikala.this.restoran, SifrarnikArtikala.this.artikli, od);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(SifrarnikArtikala.this.table, shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button izlaz = new Button(control, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)gd1);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell.close();
            }
        });
        this.table.pack();
        shell.setMaximized(true);
        shell.open();
    }

    public void makeHeaders() {
        this.tc0 = new TableColumn(this.table, 131072);
        this.tc0.setWidth(100);
        this.tc0.setText(String.format(Konstante.getBundle().getString("TEXT_SIFRA"), new Object[0]));
        this.tc1 = new TableColumn(this.table, 16384);
        this.tc1.setWidth(250);
        this.tc1.setText(String.format(Konstante.getBundle().getString("TEXT_ARTIKAL"), new Object[0]));
        this.tc2 = new TableColumn(this.table, 131072);
        this.tc2.setWidth(100);
        this.tc2.setText(String.format(Konstante.getBundle().getString("TEXT_TIP_ARTIKLA"), new Object[0]));
        this.tc3 = new TableColumn(this.table, 131072);
        this.tc3.setWidth(100);
        this.tc3.setText(String.format(Konstante.getBundle().getString("TEXT_CENA"), new Object[0]));
    }

    public void insertRows(Odeljenje od) throws ClassNotFoundException, SQLException {
        TableItem ti = null;
        this.listaArtikli = this.server.getListaSviArtikliOdeljenje3(od, this.tipovi, this.blokirani);
        for (Artikal a : this.listaArtikli) {
            String ime = a.getName();
            String tip = a.getTip().toString();
            String barkod = a.getBarCode();
            Double cena = a.getCena();
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"" + barkod, ime, "" + tip, "" + cena});
        }
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getBarCode().compareTo(t2.getBarCode());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public static class SifrarnikArtikalaInput {
        private Restoran restoran;
        private RestoranServer server;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        Combo odeljenje;
        private Button sirovineCheck;
        private Button potrosniCheck;
        private Button poluproizvodiCheck;
        private Button prodajniCheck;
        private Button slozeniCheck;
        private Button blokiraniCheck;
        SWTContainer parent2;
        private boolean magacinVidljiv;

        public SifrarnikArtikalaInput(SWTContainer owner, Restoran r) {
            this.parent2 = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.magacinVidljiv = Boolean.parseBoolean(this.server.getSetting(Option.MAGACIN_VIDLJIV).getActual());
            this.odeljenja = this.magacinVidljiv ? this.server.readOdeljenje() : this.server.readOdeljenjeBezMag();
            Shell shell = this.parent2.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/izvestajV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_SIFRARNIK_ARTIKALA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent3 = new SWTContainer((Composite)grupa2);
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(Konstante.getBundle().getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(Konstante.getBundle().getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            Label sir = new Label((Composite)grupa2, 0);
            sir.setText(TipArtikla.SIRO.getNaziv());
            this.sirovineCheck = new Button((Composite)grupa2, 32);
            this.sirovineCheck.setSelection(true);
            Label potr = new Label((Composite)grupa2, 0);
            potr.setText(TipArtikla.POTR.getNaziv());
            this.potrosniCheck = new Button((Composite)grupa2, 32);
            this.potrosniCheck.setSelection(true);
            Label pp = new Label((Composite)grupa2, 0);
            pp.setText(TipArtikla.POLU.getNaziv());
            this.poluproizvodiCheck = new Button((Composite)grupa2, 32);
            this.poluproizvodiCheck.setSelection(true);
            Label prod = new Label((Composite)grupa2, 0);
            prod.setText(TipArtikla.PROD.getNaziv());
            this.prodajniCheck = new Button((Composite)grupa2, 32);
            this.prodajniCheck.setSelection(true);
            Label sloz = new Label((Composite)grupa2, 0);
            sloz.setText(TipArtikla.SLOZ.getNaziv());
            this.slozeniCheck = new Button((Composite)grupa2, 32);
            this.slozeniCheck.setSelection(true);
            Label blok = new Label((Composite)grupa2, 0);
            blok.setText(String.format(Konstante.getBundle().getString("TEXT_BLOKIRANI"), new Object[0]));
            this.blokiraniCheck = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            art.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent2.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                Shell shell2 = new Shell(this.parent2.getControl().getShell().getDisplay());
                new SifrarnikArtikala(shell2, this.restoran, this.o, this.sirovineCheck.getSelection(), this.potrosniCheck.getSelection(), this.poluproizvodiCheck.getSelection(), this.prodajniCheck.getSelection(), this.slozeniCheck.getSelection(), this.blokiraniCheck.getSelection());
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent2, (Object)String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]));
            }
        }
    }
}

