/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RealizacijaPoOdeljenjima {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    SimpleDateFormat format3 = new SimpleDateFormat("dd-MM-yyyy");
    private Odeljenje od;
    String novac;
    String procenat;
    String target;

    public RealizacijaPoOdeljenjima(Shell s, Restoran re, final Date d1, Date d2, Odeljenje o, String target, String novac, String procenat) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.od = o;
        this.novac = novac;
        this.procenat = procenat;
        this.target = target;
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PO_ODELJENJIMA"), new Object[0]) + " za dane " + this.format3.format(d1) + " -> " + this.format3.format(d2));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66370);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.popuniTabelu(d1, d2, this.od, target, novac, procenat);
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(RealizacijaPoOdeljenjima.this.table), false, true, String.format(RealizacijaPoOdeljenjima.this.barmasterText.getString("TEXT_REALIZACIJA_FINANSIJSKOG_PLANA"), new Object[0]) + ": " + StatLogic.getDateString(d1), RealizacijaPoOdeljenjima.this.shell, RealizacijaPoOdeljenjima.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(RealizacijaPoOdeljenjima.this.table, RealizacijaPoOdeljenjima.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(RealizacijaPoOdeljenjima.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                RealizacijaPoOdeljenjima.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]));
        tc0.setWidth(120);
        TableColumn tc01 = new TableColumn(this.table, 131072);
        tc01.setText(String.format(this.barmasterText.getString("TEXT_REALIZOVANO"), new Object[0]));
        tc01.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_TARGET"), new Object[0]));
        tc1.setWidth(100);
        TableColumn tc11 = new TableColumn(this.table, 131072);
        tc11.setText(String.format(this.barmasterText.getString("TEXT_PLANIRANA_NAGRADA"), new Object[0]));
        tc11.setWidth(120);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_PLANIRANA_NAGRADA"), new Object[0]) + "(%)");
        tc2.setWidth(130);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_NAGRADA"), new Object[0]));
        tc4.setWidth(100);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_REALIZOVANO"), new Object[0]) + "?");
        tc5.setWidth(100);
    }

    public void popuniTabelu(Date from, Date to, Odeljenje od, String target, String novac, String procenat) {
        TableItem ti;
        List<Object> svaOdeljenja = new LinkedList<Odeljenje>();
        TableItem t1 = new TableItem(this.table, 0);
        t1.setText("");
        if (od == null) {
            svaOdeljenja = this.server.readOdeljenjeBezMag();
        } else {
            svaOdeljenja.add(od);
        }
        double ukupno = 0.0;
        double ukupnoNagrada = 0.0;
        for (Odeljenje odeljenje : svaOdeljenja) {
            double realizovano = this.server.getSumOdeljenje(from, to, odeljenje);
            ukupno += realizovano;
            ti = new TableItem(this.table, 0);
            ti.setText(0, odeljenje.getNaziv());
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            ti = new TableItem(this.table, 0);
            int i = 0;
            ti.setText(i++, "");
            ti.setText(i++, Konstante.getNumber02(realizovano));
            ti.setText(i++, target);
            ti.setText(i++, novac);
            ti.setText(i++, procenat);
            double nagrada = realizovano > Double.parseDouble(target) ? (!novac.isEmpty() ? Double.parseDouble(novac) : realizovano / 100.0 * Double.parseDouble(procenat)) : 0.0;
            ti.setText(i++, Konstante.getNumber02(nagrada));
            ti.setForeground(this.shell.getDisplay().getSystemColor(3));
            if (realizovano > Double.parseDouble(target)) {
                ukupnoNagrada += !novac.isEmpty() ? Double.parseDouble(novac) : realizovano / 100.0 * Double.parseDouble(procenat);
                ti.setText(i++, "Da");
                ti.setForeground(this.shell.getDisplay().getSystemColor(2));
                continue;
            }
            ti.setText(i++, "Ne");
        }
        ti = new TableItem(this.table, 0);
        ti.setText("");
        ti = new TableItem(this.table, 131072);
        ti.setText(new String[]{String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber02(ukupno), "", "", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":", Konstante.getNumber02(ukupnoNagrada)});
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 3));
    }

    public static class RealizacijaPoOdeljenjimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        private Combo cbOdeljenje;
        private List<Odeljenje> odeljenja;
        Odeljenje odeljenje;
        TextInput2 tiTarget;
        TextInput2 tiNovac;
        TextInput2 tiProcenat;

        public RealizacijaPoOdeljenjimaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PO_ODELJENJIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data.heightHint = 140;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(2, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label izKon = new Label((Composite)grupa21, 0);
            izKon.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_ODELJENJA"), new Object[0]) + ":");
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.cbOdeljenje = new Combo((Composite)grupa21, 8);
            this.cbOdeljenje.add("Sva odeljenja");
            for (Odeljenje o : this.odeljenja) {
                this.cbOdeljenje.add(o.getNaziv());
            }
            this.cbOdeljenje.select(0);
            Label lTarget = new Label((Composite)grupa21, 0);
            lTarget.setText(String.format(this.barmasterText.getString("TEXT_PLAN"), new Object[0]) + ":");
            this.tiTarget = new TextInput2((Composite)grupa21, String.format(this.barmasterText.getString("TEXT_PLAN"), new Object[0]));
            this.tiTarget.getControl().addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (Character.isLetter(event.character)) {
                        event.doit = false;
                    }
                }
            });
            Label lNovac = new Label((Composite)grupa21, 0);
            lNovac.setText(String.format(this.barmasterText.getString("TEXT_NAGRADA"), new Object[0]) + ":");
            this.tiNovac = new TextInput2((Composite)grupa21, String.format(this.barmasterText.getString("TEXT_NAGRADA"), new Object[0]));
            Label lProcenat = new Label((Composite)grupa21, 0);
            lProcenat.setText(String.format(this.barmasterText.getString("TEXT_NAGRADA_UPROCENTIMA"), new Object[0]) + ":");
            this.tiProcenat = new TextInput2((Composite)grupa21, this.barmasterText.getString("TEXT_NAGRADA_UPROCENTIMA"));
            this.tiNovac.getControl().addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    tiProcenat.getTextControl().setText("");
                    if (Character.isLetter(event.character)) {
                        event.doit = false;
                    }
                }
            });
            this.tiProcenat.getControl().addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    tiNovac.getTextControl().setText("");
                    if (Character.isLetter(event.character)) {
                        event.doit = false;
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 100;
            data1.heightHint = 20;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            izKon.setLayoutData((Object)data);
            lNovac.setLayoutData((Object)data);
            lProcenat.setLayoutData((Object)data);
            lTarget.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data1);
            this.doDatuma.getControl().setLayoutData((Object)data1);
            this.cbOdeljenje.setLayoutData((Object)data1);
            this.tiNovac.getControl().setLayoutData((Object)data1);
            this.tiProcenat.getControl().setLayoutData((Object)data1);
            this.tiTarget.getControl().setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                String novac = this.tiNovac.getText();
                String procenat = this.tiProcenat.getText();
                String target = this.tiTarget.getText();
                this.server.log(String.format(this.barmasterText.getString("TEXT_REALIZACIJA_PO_ODELJENJIMA"), StatLogic.getDateString(this.day1)));
                this.odeljenje = this.cbOdeljenje.getText().equals("Sva odeljenja") ? null : this.server.getOdeljenje(this.cbOdeljenje.getText());
                new RealizacijaPoOdeljenjima(this.shell, this.restoran, this.day1, this.day2, this.odeljenje, target, novac, procenat);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

