/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.NabavneCene;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RadniNalog {
    private Restoran restoran;
    private RestoranServer server;
    private Display display;
    private Color headColor;
    Table table;
    Shell shell;
    Composite composite;
    Composite composite2;
    boolean isBelo;
    boolean isCrno;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    private java.util.Date date;
    private TableItem prazanRed;
    Map<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
    Map<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
    Map<Artikal, List<Artikal>> normativ_artikli = new HashMap<Artikal, List<Artikal>>();
    Map<Artikal, Double> sastojak_kolicina = new HashMap<Artikal, Double>();
    private Font f;
    private int[] params;

    private RadniNalog(Shell s, Restoran r, java.util.Date d, final Odeljenje od, boolean belo, boolean crno) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = s;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setText(String.format(Konstante.getBundle().getString("TEXT_RADNI_NALOG"), new Object[0]));
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.display = s.getDisplay();
        this.headColor = this.display.getSystemColor(15);
        this.isBelo = belo;
        this.isCrno = crno;
        this.date = d;
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy.");
        String dat = sdf.format(this.date);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
        String godina = sdf1.format(this.date);
        String ode = od != null ? od.getNaziv() : "SVA";
        this.f = new Font((Device)this.shell.getDisplay(), new FontData("Ariel", 10, 1));
        Label l = new Label((Composite)this.shell, 0);
        l.setFont(this.f);
        l.setText("Radni nalog broj " + c.get(6) + "/" + godina + "\nOdeljenje " + ode + "\nDatum: " + dat + "\n \n \nNaruceno za proizvodnju: ");
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.params = Konstante.OsDodParam(this.isBelo, this.isCrno);
        if (this.params == null) {
            Konstante.prikaziMessageBox(this.shell, String.format(Konstante.getBundle().getString("TEXT_PORUKA_UNESITE_NP"), new Object[0]));
            return;
        }
        this.makeHeaders();
        this.insertRowsNew(od);
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setLayoutData((Object)gd);
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Calendar c = Calendar.getInstance();
                c.setTime(RadniNalog.this.date);
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy.");
                String dat = sdf.format(RadniNalog.this.date);
                SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
                String godina = sdf1.format(RadniNalog.this.date);
                String ode = od != null ? od.getNaziv() : "SVA";
                RadniNalog.this.f = new Font((Device)RadniNalog.this.shell.getDisplay(), new FontData("Ariel", 12, 1));
                Label l = new Label((Composite)RadniNalog.this.shell, 0);
                l.setFont(RadniNalog.this.f);
                l.setText("Radni nalog broj " + c.get(6) + "/" + godina + "\nOdeljenje " + ode + "\nDatum: " + dat + "\n \n \nNaruceno za proizvodnju: ");
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(RadniNalog.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_RADNI_NALOG") + " broj " + c.get(6) + "/" + godina + "\nOdeljenje " + ode + "\nDatum: " + dat + "\nNaruceno za proizvodnju: ", new Object[0]), RadniNalog.this.shell, RadniNalog.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(RadniNalog.this.table, RadniNalog.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(RadniNalog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button exitButton = new Button(control, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.setLayoutData((Object)gd1);
        exitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RadniNalog.this.shell.dispose();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setWidth(160);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setWidth(250);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setWidth(130);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setWidth(130);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setWidth(170);
    }

    private void insertRowsNew(Odeljenje odeljenje) {
        this.prazanRed = new TableItem(this.table, 0);
        this.naslov(this.table, String.format(Konstante.getBundle().getString("TEXT_PRODAJA_NASLOV"), new Object[0]));
        this.koloneNaslov(this.table, "TEXT_SIFRA", "TEXT_NAZIV_ARTIKLA", "TEXT_KOLICINA", "TEXT_PRODAJNA_CENA", "TEXT_PRODAJNA_VREDNOST");
        this.prazanRed = new TableItem(this.table, 0);
        double ukupanPromet = this.upisiPrometZaRadniNalog(this.date, this.table, odeljenje.getId());
        this.sumiraj(this.table, ukupanPromet);
        this.prazanRed = new TableItem(this.table, 0);
        this.naslov(this.table, String.format(Konstante.getBundle().getString("TEXT_PROIZVODNJA_NASLOV"), new Object[0]));
        this.koloneNaslov(this.table, "TEXT_SIFRA", "TEXT_NAZIV_ARTIKLA", "TEXT_KOLICINA", "TEXT_NABAVNA_CENA_SKR", "TEXT_NABAVNA_VREDNOST_BEZ_PDV");
        this.prazanRed = new TableItem(this.table, 0);
        double ukupanPrometProizvodnja = this.upisiProizvodnjuZaRadniNalog(this.date, this.table, odeljenje, this.params[0], this.params[1]);
        this.sumiraj(this.table, ukupanPrometProizvodnja);
        this.prazanRed = new TableItem(this.table, 0);
        this.naslov(this.table, String.format(Konstante.getBundle().getString("TEXT_DOKUMENT_UTROSAK_NASLOV"), new Object[0]));
        this.koloneNaslov(this.table, "TEXT_SIFRA", "TEXT_NAZIV_ARTIKLA", "TEXT_KOLICINA", "TEXT_NABAVNA_CENA_SKR", "TEXT_NABAVNA_VREDNOST_BEZ_PDV");
        this.prazanRed = new TableItem(this.table, 0);
        double ukupanUtrosakDoc = this.upisiUtrosakDocZaRadniNalog(this.date, this.table, odeljenje, this.params[0], this.params[1]);
        this.sumiraj(this.table, ukupanUtrosakDoc);
        this.prazanRed = new TableItem(this.table, 0);
        this.naslov(this.table, String.format(Konstante.getBundle().getString("TEXT_UTROSAK_NASLOV"), new Object[0]));
        this.koloneNaslov(this.table, "TEXT_SIFRA", "TEXT_NAZIV_ARTIKLA", "TEXT_KOLICINA", "TEXT_NABAVNA_CENA_SKR", "TEXT_NABAVNA_VREDNOST_BEZ_PDV");
        this.prazanRed = new TableItem(this.table, 0);
        double ukupaniUtrosak = this.upisiUtrosakZaRadniNalog(this.date, this.table, odeljenje, this.params[0], this.params[1]);
        this.sumiraj(this.table, ukupaniUtrosak);
    }

    private double upisiPrometZaRadniNalog(java.util.Date datum, Table table, long odeljenjeId) {
        String[] upis = new String[table.getColumnCount()];
        double kolicina = 0.0;
        double cena = 0.0;
        double ukupno = 0.0;
        double vrednost = 0.0;
        String paymenCondition = "";
        if (this.isBelo && !this.isCrno) {
            paymenCondition = "AND (r.crnoPlacanje IS null\tOR  r.naOsnovno = 1)";
        } else if (!this.isBelo && this.isCrno) {
            paymenCondition = "AND (r.crnoPlacanje IS NOT null\tand  r.naOsnovno = 0)";
        }
        String query = "SELECT a.sifra ,a.name as naziv, SUM(sr.kolicina) AS kolicina, sr.cena, r.popust,\n\tROUND((sr.cena - (sr.cena * r.popust * a.dozvoljenPopust /100)),2) AS cenaSaPopustom, ao.ODELJENJA_ID\nFROM stavkaracuna sr \nJOIN racun r ON sr.RACUN_ID = r.id\nJOIN artikal a\tON sr.ARTIKAL_ID = a.id\nJOIN artikal_odeljenje ao ON sr.ARTIKAL_ID = ao.ARTIKLI_ID\t\n\tWHERE r.zdBroj = \n\t\t(SELECT z.zdBroj FROM zd z WHERE z.datum = ? AND z.pocetak = 1)  " + paymenCondition + "\tAND (r.crnoPlacanje IS null\tOR  r.naOsnovno = 1)\tAND  a.tip IN ('SLOZ','DODA') AND ao.ODELJENJA_ID = ?\nGROUP BY\ta.name, cenaSaPopustom, a.sifra, sr.cena, r.popust ORDER BY a.name";
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setDate(1, new Date(datum.getTime()));
            ps.setLong(2, odeljenjeId);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                kolicina = rs.getDouble("kolicina");
                cena = Konstante.round(rs.getDouble("cenaSaPopustom"), 2);
                vrednost = Konstante.round(kolicina * cena, 2);
                ukupno += vrednost;
                upis[0] = rs.getString("sifra");
                upis[1] = rs.getString("naziv");
                upis[2] = String.valueOf(kolicina);
                upis[3] = String.valueOf(cena);
                upis[4] = String.valueOf(vrednost);
                TableItem red = new TableItem(table, 0);
                red.setText(upis);
            }
            return ukupno;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double upisiProizvodnjuZaRadniNalog(java.util.Date datum, Table table, Odeljenje od, int belo, int crno) {
        String[] upis = new String[table.getColumnCount()];
        double kolicina = 0.0;
        double cena = 0.0;
        double ukupno = 0.0;
        double vrednost = 0.0;
        String query = "SELECT a.id, a.sifra, a.name as naziv, SUM(ps.kolicina) as kolicina FROM proizvodnjastavka ps\nJOIN proizvodnja p ON ps.PROIZVODNJA_ID = p.id\nJOIN artikal a ON ps.ARTIKAL_ID = a.id\nWHERE p.datum = ? AND p.ODELJENJE_ID = ? AND (p.crno = ? or p.crno = ?) GROUP BY a.id";
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setDate(1, new Date(datum.getTime()));
            ps.setLong(2, od.getId());
            ps.setInt(3, belo);
            ps.setInt(4, crno);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Artikal a = this.server.getArtikal(rs.getLong("id"));
                Map<String, Double> nabavneCene = NabavneCene.getPosednjaNabavna(a, datum, od, this.isCrno, this.params[0], this.params[1], this.server);
                kolicina = rs.getDouble("kolicina");
                cena = Konstante.round(nabavneCene.get("NCpoJMbezPDV"), 2);
                vrednost = Konstante.round(kolicina * cena, 2);
                ukupno += vrednost;
                upis[0] = rs.getString("sifra");
                upis[1] = rs.getString("naziv");
                upis[2] = String.valueOf(kolicina);
                upis[3] = String.valueOf(cena);
                upis[4] = String.valueOf(vrednost);
                TableItem red = new TableItem(table, 0);
                red.setText(upis);
            }
            return ukupno;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double upisiUtrosakDocZaRadniNalog(java.util.Date datum, Table table, Odeljenje od, int belo, int crno) {
        String[] upis = new String[table.getColumnCount()];
        double kolicina = 0.0;
        double cena = 0.0;
        double ukupno = 0.0;
        double vrednost = 0.0;
        String query = "SELECT a.id, a.sifra, a.name as naziv, SUM(uds.kolicina) as kolicina FROM utrosakdocstavke uds\nJOIN utrosakdoc ud ON uds.UTROSAKDOC_ID = ud.id\nJOIN artikal a ON uds.ARTIKAL_ID = a.id\nWHERE CAST(ud.datum AS DATE)= ? AND ud.ODELJENJE_ID = ? AND (ud.crno = ? or ud.crno = ?) GROUP BY a.id";
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setDate(1, new Date(datum.getTime()));
            ps.setLong(2, od.getId());
            ps.setInt(3, belo);
            ps.setInt(4, crno);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Artikal a = this.server.getArtikal(rs.getLong("id"));
                Map<String, Double> nabavneCene = NabavneCene.getPosednjaNabavna(a, datum, od, this.isCrno, this.params[0], this.params[1], this.server);
                kolicina = rs.getDouble("kolicina");
                cena = Konstante.round(nabavneCene.get("NCpoJMbezPDV"), 2);
                vrednost = Konstante.round(kolicina * cena, 2);
                ukupno += vrednost;
                upis[0] = rs.getString("sifra");
                upis[1] = rs.getString("naziv");
                upis[2] = String.valueOf(kolicina);
                upis[3] = String.valueOf(cena);
                upis[4] = String.valueOf(vrednost);
                TableItem red = new TableItem(table, 0);
                red.setText(upis);
            }
            return ukupno;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private double upisiUtrosakZaRadniNalog(java.util.Date datum, Table table, Odeljenje od, int belo, int crno) {
        String[] upis = new String[table.getColumnCount()];
        double kolicina = 0.0;
        double cena = 0.0;
        double ukupno = 0.0;
        double vrednost = 0.0;
        String queryParam = "SET @datum = ?, @odel = ?,@belo =?,  @crno = ?; ";
        String query = "SELECT id, sifra, naziv, ROUND(SUM(kolicina),4) AS kolicina FROM \n\t(SELECT a.id, a.sifra, a.name AS naziv, round(du.kolicina,4) AS kolicina  FROM dnevniutrosak du\n\t JOIN artikal a ON du.ARTIKAL_ID = a.id\n\t WHERE du.zdBroj = \n\t\t\t(SELECT z.zdBroj FROM zd z WHERE z.datum =CAST(@datum AS DATE)  order by z.id desc limit 1) \n\t\t\tAND du.ODELJENJE_ID = @odel AND (du.dodatno = @belo or du.dodatno = @crno ) AND a.tip = 'SIRO' \n\t UNION \n\t SELECT a.id, a.sifra, a.name AS naziv,  ROUND(pu.kolicina,4) AS kolicina FROM proizvodnjautrosak pu \n\t JOIN proizvodnja p ON pu.PROIZVODNJA_ID = p.id \n\t JOIN artikal a ON   pu.ARTIKAL_ID = a.id \n\t WHERE p.datum = CAST(@datum AS DATE) AND p.ODELJENJE_ID = @odel AND ( p.crno = @belo or p.crno = @crno)\n\t UNION\n\t SELECT a.id, a.sifra, a.name AS naziv,  ROUND(udu.kolicina,4) AS kolicina FROM utrosakdocutrosak udu \n\t JOIN utrosakdoc ud ON udu.UTROSAKDOC_ID = ud.id\n\t JOIN artikal a ON   udu.ARTIKAL_ID = a.id\n\t WHERE  CAST(ud.datum AS DATE) = @datum AND ud.ODELJENJE_ID = @odel AND ( ud.crno = @belo or ud.crno = @crno))\nAS trt GROUP BY id ORDER BY naziv";
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(queryParam);
            ps.setDate(1, new Date(datum.getTime()));
            ps.setLong(2, od.getId());
            ps.setInt(3, belo);
            ps.setInt(4, crno);
            System.out.println(ps);
            ps.execute();
            Statement st = this.server.getConnection().createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                Artikal a = this.server.getArtikal(rs.getLong("id"));
                Map<String, Double> nabavneCene = NabavneCene.getPosednjaNabavna(a, datum, od, this.isCrno, this.params[0], this.params[1], this.server);
                kolicina = rs.getDouble("kolicina");
                cena = Konstante.round(nabavneCene.get("NCpoJMbezPDV"), 2);
                vrednost = Konstante.round(kolicina * cena, 2);
                ukupno += vrednost;
                upis[0] = rs.getString("sifra");
                upis[1] = rs.getString("naziv");
                upis[2] = String.valueOf(kolicina);
                upis[3] = String.valueOf(cena);
                upis[4] = String.valueOf(vrednost);
                TableItem red = new TableItem(table, 0);
                red.setText(upis);
            }
            return ukupno;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private void koloneNaslov(Table table, String sifra, String naziv, String kolicina, String cena, String iznos) {
        String[] kolone = new String[table.getColumnCount()];
        kolone[0] = String.format(Konstante.getBundle().getString(sifra), new Object[0]);
        kolone[1] = String.format(Konstante.getBundle().getString(naziv), new Object[0]);
        kolone[2] = String.format(Konstante.getBundle().getString(kolicina), new Object[0]);
        kolone[3] = String.format(Konstante.getBundle().getString(cena), new Object[0]);
        kolone[4] = String.format(Konstante.getBundle().getString(iznos), new Object[0]);
        TableItem ti = new TableItem(table, 1);
        ti.setText(kolone);
    }

    private void naslov(Table table, String text) {
        TableItem ti = new TableItem(table, 1);
        ti.setText(new String[]{text, "", "", "", "", ""});
        ti.setFont(this.f);
        ti.setBackground(this.headColor);
    }

    private void sumiraj(Table table, double ukupno) {
        TableItem ti = new TableItem(table, 1);
        ukupno = Konstante.round(ukupno, 2);
        ti.setText(new String[]{"", "", "", Konstante.getBundle().getString("TEXT_UKUPNO"), String.valueOf(ukupno)});
        ti.setFont(this.f);
    }

    public void sortiraj(List<StavkaRacuna> artikli) {
        Comparator<StavkaRacuna> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<StavkaRacuna>(){

            @Override
            public int compare(StavkaRacuna t1, StavkaRacuna t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public static class RadniNalogInput {
        private DateInput2 odDatuma;
        private java.util.Date day;
        private Restoran restoran;
        private RestoranServer server;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        Combo odeljenje;
        private Button belo;
        private Button crno;
        SWTContainer parent2;
        Composite compo;

        public RadniNalogInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent2 = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            Shell shell = this.parent2.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/izvestajV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_RADNI_NALOG"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa21 = null;
            grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(4, false));
            grupa21.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_STANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_ZA_DAN"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_ZA_DAN"), new Object[0]), new java.util.Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            SWTContainer parent3 = new SWTContainer((Composite)grupa2);
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(Konstante.getBundle().getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            this.belo = new Button((Composite)grupa21, 32);
            this.belo.setText(String.format(Konstante.getBundle().getString("TEXT_OSNOVNO_STANJE"), new Object[0]));
            this.belo.setSelection(true);
            if (inspektor) {
                this.crno = new Button((Composite)grupa21, 32);
                this.crno.setText(String.format(Konstante.getBundle().getString("TEXT_DODATNO_STANJE"), new Object[0]));
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent2.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day = this.odDatuma.getResult();
                this.o = this.odeljenja.get(this.odeljenje.getSelectionIndex());
                Shell shell2 = new Shell(this.parent2.getControl().getShell().getDisplay());
                new RadniNalog(shell2, this.restoran, this.day, this.o, this.belo.getSelection(), this.crno == null ? false : this.crno.getSelection());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SWTOptionPane.showMessageDialog(this.parent2, (Object)"Greska");
            }
        }
    }
}

