/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrometPoArtiklimaPoSatima2 {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    List<Odeljenje> odeljenja;
    boolean okidac = false;

    public PrometPoArtiklimaPoSatima2(Shell s, Restoran re, Date day, Odeljenje od, List<NacinPlacanja> bela, List<CrnoPlacanje> cp, List<Kasa> kase, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.odeljenja = new LinkedList<Odeljenje>();
        this.odeljenja = od != null ? Arrays.asList(od) : this.server.readOdeljenjeBezMag();
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA_I_PO_SATIMA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day));
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        final Date d1 = this.server.getPocetni(day);
        final Date d2 = this.server.getKrajnji(day);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(d1, d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaPoSatima2.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        try {
            List<Object> racuni = new LinkedList();
            racuni = this.server.getRacuni(day, bela, cp, kase, this.odeljenja);
            HashMap<String, List<Racun>> vreme_racun = new HashMap<String, List<Racun>>();
            String sat = "00";
            for (int satNo = 0; satNo < 24; ++satNo) {
                sat = satNo == 0 ? "00" : (satNo < 10 ? "0" + satNo : "" + satNo);
                vreme_racun.put(sat, new LinkedList());
            }
            for (Racun racun : racuni) {
                String vreme = racun.getDatum().toString().substring(0, 2);
                if (!vreme_racun.containsKey(vreme)) continue;
                ((List)vreme_racun.get(vreme)).add(racun);
            }
            this.insertRows(bela, cp, d1, d2, this.odeljenja, kase, this.sifre, mz, vreme_racun);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaPoSatima2.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception vreme_racun) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PrometPoArtiklimaPoSatima2.this.table), false, true, String.format(PrometPoArtiklimaPoSatima2.this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), PrometPoArtiklimaPoSatima2.this.shell, PrometPoArtiklimaPoSatima2.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception satNo) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        printButton2.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoArtiklimaPoSatima2.this.table, PrometPoArtiklimaPoSatima2.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometPoArtiklimaPoSatima2.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoArtiklimaPoSatima2.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_SAT_OD"), new Object[0]) + "-" + String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]));
        tc0.setWidth(250);
        if (this.sifre) {
            TableColumn tc1 = new TableColumn(this.table, 131072);
            tc1.setText(String.format(this.barmasterText.getString("TEXT_SIFRA"), new Object[0]));
            tc1.setWidth(200);
        }
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc2.setWidth(250);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc3.setWidth(75);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc4.setWidth(75);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc5.setWidth(100);
        TableColumn tcv = new TableColumn(this.table, 131072);
        tcv.setText(String.format(this.barmasterText.getString("TEXT_BROJ_RACUNA"), new Object[0]));
        tcv.setWidth(100);
        TableColumn tcvp = new TableColumn(this.table, 131072);
        tcvp.setText(String.format(this.barmasterText.getString("TEXT_PROSECNA_VREDNOST"), new Object[0]));
        tcvp.setWidth(100);
    }

    private void insertSubGroupTotalRow(Table table, Double sgQuant, Double sgValue, String totalL, boolean codes, int brRacuna) {
        TableItem ti = new TableItem(table, 0);
        int idx = codes ? 2 : 1;
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber03NG(sgQuant));
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber02NG(sgValue));
        ti.setText(idx++, "" + brRacuna);
        ti.setText(idx++, Konstante.getNumber02(sgValue / (double)brRacuna));
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        ti = new TableItem(table, 0);
        this.okidac = false;
    }

    private void insertRows(List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, boolean codes, boolean mz, Map<String, List<Racun>> vreme_racun) throws Exception {
        int brRac = 0;
        int brRacTotal = 0;
        int satNo = 0;
        String sat = "00";
        while (satNo < 24) {
            sat = satNo == 0 ? "00" : (satNo < 10 ? "0" + satNo : "" + satNo);
            String totalL = Konstante.getBundle().getString("TEXT_UKUPNO");
            String total = Konstante.getBundle().getString("TEXT_TOTAL");
            double totalTot = 0.0;
            double totalKom = 0.0;
            ArrayList<Long> listaRacunId = new ArrayList<Long>();
            String lastPG = null;
            Double sgCount = 0.0;
            Double sgValue = 0.0;
            HashMap<String, Double> sgValues = new HashMap<String, Double>();
            HashMap<String, Double> sgCounts = new HashMap<String, Double>();
            LinkedList<String> sgList = new LinkedList<String>();
            int idx = 1;
            while (satNo < 24) {
                sat = satNo == 0 ? "00" : (satNo < 10 ? "0" + satNo : "" + satNo);
                int a = Integer.parseInt(sat) + 1;
                String aa = satNo <= 9 ? "0" + a : "" + a;
                String vr = sat + ":00 - " + aa + ":00";
                ++satNo;
                Long racunId = null;
                HashMap artikli = new HashMap();
                HashMap<String, Double> artikliNovi = new HashMap<String, Double>();
                double cenaSaPopustom = 0.0;
                for (Racun racun : vreme_racun.get(sat)) {
                    brRac = vreme_racun.get(sat).size();
                    racunId = racun.getId();
                    for (StavkaRacuna st : racun.getStavke1()) {
                        cenaSaPopustom = st.getCena() - st.getCena() * racun.getPopust() / 100.0;
                        System.out.println("cenaSaPopustom: " + cenaSaPopustom);
                        double vrednost = 0.0;
                        if (artikliNovi.containsKey(String.valueOf(st.getArtikal().getId()) + ":" + cenaSaPopustom)) {
                            vrednost = (Double)artikliNovi.get(String.valueOf(st.getArtikal().getId()) + ":" + cenaSaPopustom);
                        }
                        double novaVrednost = vrednost + st.getKolicina();
                        artikliNovi.put(String.valueOf(st.getArtikal().getId()) + ":" + cenaSaPopustom, novaVrednost);
                    }
                }
                for (String strArt : artikliNovi.keySet()) {
                    TableItem ti;
                    Artikal str = this.server.getArtikal(Long.valueOf(strArt.split(":")[0]));
                    if (!vreme_racun.get(sat).isEmpty()) {
                        this.okidac = true;
                    }
                    if (!artikliNovi.containsKey(strArt)) continue;
                    if (!listaRacunId.contains(racunId)) {
                        listaRacunId.add(racunId);
                    }
                    if (lastPG != null && !vr.equals(lastPG)) {
                        sgList.add(lastPG);
                        sgValues.put(lastPG, sgValue);
                        sgCounts.put(lastPG, sgCount);
                        sgCount = 0.0;
                        sgValue = 0.0;
                    }
                    if (lastPG == null || !vr.equals(lastPG)) {
                        ti = new TableItem(this.table, 0);
                        ti.setText(vr);
                        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                        lastPG = vr;
                    }
                    ti = new TableItem(this.table, 0);
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 0));
                    if (codes) {
                        String code = str.getBarCode();
                        ti.setText(idx++, code == null ? "" : code);
                    }
                    ti.setText(idx++, str.getName());
                    Double quant = (Double)artikliNovi.get(strArt);
                    Double value = Double.valueOf(strArt.split(":")[1]) * quant;
                    ti.setText(idx++, StatLogic.getNumber03NG(quant));
                    ti.setText(idx++, StatLogic.getNumber02NG(Double.valueOf(strArt.split(":")[1])));
                    ti.setText(idx++, StatLogic.getNumber02NG(value));
                    sgCount = sgCount + quant;
                    sgValue = sgValue + value;
                    idx = 1;
                }
                if (!this.okidac) continue;
                this.insertSubGroupTotalRow(this.table, sgCount, sgValue, totalL, codes, brRac);
                totalTot += sgValue.doubleValue();
                totalKom += sgCount.doubleValue();
                listaRacunId.clear();
                brRacTotal += brRac;
                brRac = 0;
            }
            TableItem t = new TableItem(this.table, 0);
            int idxa = codes ? 2 : 1;
            t.setText(idxa++, total + ":");
            t.setText(idxa++, StatLogic.getNumber03NG(totalKom));
            t.setText(idxa++, total + ":");
            t.setText(idxa++, StatLogic.getNumber03NG(totalTot));
            t.setText(idxa++, "" + brRacTotal);
            t.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            TableItem tableItem = new TableItem(this.table, 0);
        }
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PrometPoSatimaInput2 {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private ComboViewer prodajnoMesto;
        List<ProdajnoMesto> prodajnaMesta;
        private ComboViewer kasa;
        List<ProdajnoMesto> kase;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        private boolean medjuzbir;
        private Button bOd;
        private Button bDo;

        public PrometPoSatimaInput2(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.prodajnaMesta = this.server.findAllProdajnoMesto();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_SATIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(4, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, true));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_ZA_DATUM"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_ZA_DATUM"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            LinkedList<ProdajnoMesto> pmInput = new LinkedList<ProdajnoMesto>();
            pmInput.addAll(this.prodajnaMesta);
            Label pm = new Label((Composite)grupa2, 0);
            pm.setText(String.format(this.barmasterText.getString("TEXT_PRODAJNO_MESTO"), new Object[0]) + ":");
            this.prodajnoMesto = new ComboViewer((Composite)grupa2, 12);
            this.prodajnoMesto.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object o) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(o);
                    if (o instanceof List && !((List)o).isEmpty() && ((List)o).get(0) instanceof ProdajnoMesto) {
                        List pmList = (List)o;
                        list.addAll(pmList);
                    }
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object o, Object o1) {
                }
            });
            this.prodajnoMesto.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof List) {
                        return ((List)element).isEmpty() ? String.format(Konstante.getBundle().getString("TEXT_NEMA_PRODAJNIH_MESTA"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_SVA_PRODAJNA_MESTA"), new Object[0]);
                    }
                    if (element instanceof ProdajnoMesto) {
                        ProdajnoMesto pm = (ProdajnoMesto)element;
                        return pm.getNaziv();
                    }
                    return "";
                }
            });
            this.prodajnoMesto.setInput(pmInput);
            this.prodajnoMesto.setSelection((ISelection)new StructuredSelection(pmInput));
            Label kL = new Label((Composite)grupa2, 0);
            kL.setText(String.format(this.barmasterText.getString("TEXT_KASA"), new Object[0]) + ":");
            this.kasa = new ComboViewer((Composite)grupa2, 12);
            this.kasa.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object o) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(o);
                    if (o instanceof List && !((List)o).isEmpty() && ((List)o).get(0) instanceof Kasa) {
                        List pmList = (List)o;
                        list.addAll(pmList);
                    }
                    return list.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object o, Object o1) {
                }
            });
            this.kasa.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof List) {
                        return ((List)element).isEmpty() ? String.format(Konstante.getBundle().getString("TEXT_NEMA_KASE"), new Object[0]) : String.format(Konstante.getBundle().getString("TEXT_SVE_KASE"), new Object[0]);
                    }
                    if (element instanceof Kasa) {
                        Kasa pm = (Kasa)element;
                        return pm.getOznaka() == null ? pm.getHostname() : pm.getOznaka();
                    }
                    return "";
                }
            });
            this.kasa.setInput(this.server.findAllKasa());
            this.kasa.setSelection((ISelection)new StructuredSelection(this.kasa.getInput()));
            this.prodajnoMesto.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                    if (!iSel.isEmpty()) {
                        Object sel = iSel.getFirstElement();
                        if (sel instanceof ProdajnoMesto) {
                            ProdajnoMesto pm = (ProdajnoMesto)sel;
                            if (pm.getKase() != null) {
                                kasa.setInput(pm.getKase());
                                kasa.setSelection((ISelection)new StructuredSelection(pm.getKase()));
                                kasa.refresh();
                            } else {
                                kasa.setInput(new ArrayList());
                                kasa.setSelection((ISelection)new StructuredSelection(kasa.getInput()));
                                kasa.refresh();
                            }
                        } else {
                            kasa.setInput(new ArrayList());
                            kasa.setSelection((ISelection)new StructuredSelection(kasa.getInput()));
                            kasa.refresh();
                        }
                    }
                }
            });
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setData((Object)cp);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            pm.setLayoutData((Object)data);
            kL.setLayoutData((Object)data);
            this.prodajnoMesto.getCombo().setLayoutData((Object)data);
            this.kasa.getCombo().setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Object sel;
                this.day1 = this.odDatuma.getResult();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                ArrayList<Kasa> selKase = null;
                IStructuredSelection kSel = (IStructuredSelection)this.kasa.getSelection();
                if (!kSel.isEmpty() && (sel = kSel.getFirstElement()) != null && sel instanceof Kasa) {
                    Kasa k = (Kasa)sel;
                    selKase = new ArrayList<Kasa>();
                    selKase.add(k);
                }
                if (selKase == null) {
                    Object sel2;
                    ProdajnoMesto pmi = null;
                    IStructuredSelection pmSel = (IStructuredSelection)this.prodajnoMesto.getSelection();
                    if (!pmSel.isEmpty() && (sel2 = pmSel.getFirstElement()) != null && sel2 instanceof ProdajnoMesto) {
                        ProdajnoMesto pm;
                        pmi = pm = (ProdajnoMesto)sel2;
                    }
                    if (pmi != null && pmi.getKase() != null) {
                        selKase = new ArrayList();
                        selKase.addAll(pmi.getKase());
                    }
                }
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.medjuzbir = false;
                ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                for (Button b : this.crnaDugmici) {
                    CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                    if (!b.getSelection()) continue;
                    if (cp.getMedjuZbir() != null && cp.getMedjuZbir().booleanValue()) {
                        this.medjuzbir = true;
                        continue;
                    }
                    crna.add(cp);
                }
                this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_PROMETA_PO_ARTIKLIMA_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(this.day1), StatLogic.getDateString(this.day1)));
                new PrometPoArtiklimaPoSatima2(this.shell, this.restoran, this.day1, this.o, bela, crna, selKase, this.medjuzbir);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

