/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.NenaplaceniStolovi;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.IzborPodgrua2;
import com.dev63.restoran.sistem.IzborProdajnoMestoKasa;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaBlicArtikliNovi;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaNovi;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrometPoArtiklimaNovi {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    boolean sifre1;
    List<Map<String, Object>> ppaArtData;
    List<Map<String, Object>> ppaFinanceData;
    private Date d1;
    private Date d2;
    boolean poPosUnetCenama = false;
    boolean poPosCenamaKombo = false;
    private List<Kasa> kase;
    double sgQuantG = 0.0;
    double sgValueG = 0.0;
    double sgBuyingValueG = 0.0;
    double diffG = 0.0;
    Double buyingPrice = 0.0;
    long zdBrojDatumDo;
    long poslednjiZdBroj;

    public PrometPoArtiklimaNovi(Shell s, Restoran re, final Date day1, final Date day2, Odeljenje od, boolean bl, boolean ncBezPDV, boolean nc, List<NacinPlacanja> bela, final List<CrnoPlacanje> cp, List<PodgrupaArtikala> pgs, int tpg, final List<Kasa> kase, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        this.kase = kase;
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
        this.d1 = this.server.getPocetni(day1);
        this.d2 = this.server.getKrajnji(day2);
        this.zdBrojDatumDo = this.server.getZDbyDatum(day2).getZdBroj();
        this.poslednjiZdBroj = this.server.getZdBrojisNotNUllMax();
        if (this.server.isEmptyDateZDZakljucenje(this.d1, this.d2) || this.server.isBeforeDateZD(this.d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
            this.sifre1 = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_ARTIKAL_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
            this.sifre1 = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(this.d1, this.d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders(ncBezPDV, nc);
        try {
            this.insertRows(bl, bela, cp, this.d1, this.d2, od != null ? Arrays.asList(od) : this.server.readOdeljenjeBezMag(), kase, pgs == null ? this.server.readPodgrupeArtikala() : pgs, ncBezPDV, nc, this.sifre, this.sifre1, mz);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                String k = kase.toString();
                gp.printTable(new TableWrapper(PrometPoArtiklimaNovi.this.table), false, true, String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]) + " " + String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("TEXT_ZA_KASE"), new Object[0]) + " " + k + ": " + StatLogic.getDateString(day1) + "-->" + StatLogic.getDateString(day2), PrometPoArtiklimaNovi.this.shell, PrometPoArtiklimaNovi.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(PrometPoArtiklimaNovi.this.ppaArtData, PrometPoArtiklimaNovi.this.ppaFinanceData, cp, day1, day2, PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.sifre, PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton2.setLayoutData((Object)data);
        printButton2.setEnabled(!bl);
        Button printButton3 = new Button((Composite)this.shell, 72);
        try {
            printButton3.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        printButton3.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_FP"), new Object[0]));
        printButton3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PrometPoArtiklimaNovi.this.server.log(String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("LOG_ARTIKLI_PRODATI_U_DANU"), new Object[0]));
                    if (Konstante.getTipStampaca() == 1) {
                        XMLWriter.writeReport(2);
                    } else {
                        XMLWriterHCP.writeProdatiArtikli();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        printButton3.setLayoutData((Object)data);
        Button printButton4 = new Button((Composite)this.shell, 72);
        try {
            printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton4.setText(String.format(this.barmasterText.getString("TEXT_BLIC"), new Object[0]));
        printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(null, PrometPoArtiklimaNovi.this.ppaFinanceData, cp, PrometPoArtiklimaNovi.this.d1, PrometPoArtiklimaNovi.this.d2, PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.sifre, PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton4.setLayoutData((Object)data);
        Button printU = new Button((Composite)this.shell, 72);
        try {
            printU.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printU.setText(String.format(this.barmasterText.getString("TEXT_BLIC_ARTIKLI"), new Object[0]));
        printU.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaBlicArtikliNovi(PrometPoArtiklimaNovi.this.ppaArtData, PrometPoArtiklimaNovi.this.d1, PrometPoArtiklimaNovi.this.d2, PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printU.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoArtiklimaNovi.this.table, PrometPoArtiklimaNovi.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoArtiklimaNovi.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    public PrometPoArtiklimaNovi(Shell s, Restoran re, Odeljenje od, boolean bl, boolean ncBezPDV, boolean nc, List<NacinPlacanja> bela, final List<CrnoPlacanje> cp, List<PodgrupaArtikala> pgs, int tpg, final List<Kasa> kase, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        this.kase = kase;
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
            this.sifre1 = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_ARTIKAL_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
            this.sifre1 = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(this.d1, this.d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders(ncBezPDV, nc);
        try {
            this.insertRowsNow(bl, bela, cp, od != null ? Arrays.asList(od) : this.server.readOdeljenjeBezMag(), kase, pgs == null ? this.server.readPodgrupeArtikala() : pgs, ncBezPDV, nc, this.sifre, this.sifre1, mz);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                String k = kase != null ? kase.toString() : PrometPoArtiklimaNovi.this.server.getKaseAll().toString();
                gp.printTable(new TableWrapper(PrometPoArtiklimaNovi.this.table), false, true, String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]) + " " + String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("TEXT_ZA_KASE"), new Object[0]) + " " + k + ": " + StatLogic.getDateString(new Date()) + "-->" + StatLogic.getDateString(new Date()), PrometPoArtiklimaNovi.this.shell, PrometPoArtiklimaNovi.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(PrometPoArtiklimaNovi.this.ppaArtData, PrometPoArtiklimaNovi.this.ppaFinanceData, cp, new Date(), new Date(), PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.sifre, PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton2.setLayoutData((Object)data);
        printButton2.setEnabled(!bl);
        Button printButton3 = new Button((Composite)this.shell, 72);
        try {
            printButton3.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        printButton3.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_FP"), new Object[0]));
        printButton3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PrometPoArtiklimaNovi.this.server.log(String.format(PrometPoArtiklimaNovi.this.barmasterText.getString("LOG_ARTIKLI_PRODATI_U_DANU"), new Object[0]));
                    if (Konstante.getTipStampaca() == 1) {
                        XMLWriter.writeReport(2);
                    } else {
                        XMLWriterHCP.writeProdatiArtikli();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        printButton3.setLayoutData((Object)data);
        Button printButton4 = new Button((Composite)this.shell, 72);
        try {
            printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton4.setText(String.format(this.barmasterText.getString("TEXT_BLIC"), new Object[0]));
        printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(null, PrometPoArtiklimaNovi.this.ppaFinanceData, cp, PrometPoArtiklimaNovi.this.d1, PrometPoArtiklimaNovi.this.d2, PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.sifre, PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton4.setLayoutData((Object)data);
        Button printU = new Button((Composite)this.shell, 72);
        try {
            printU.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printU.setText(String.format(this.barmasterText.getString("TEXT_BLIC_ARTIKLI"), new Object[0]));
        printU.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaBlicArtikliNovi(PrometPoArtiklimaNovi.this.ppaArtData, PrometPoArtiklimaNovi.this.d1, PrometPoArtiklimaNovi.this.d2, PrometPoArtiklimaNovi.this.server.readIzvestajiStampacObject(), PrometPoArtiklimaNovi.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaNovi.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(PrometPoArtiklimaNovi.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printU.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoArtiklimaNovi.this.table, PrometPoArtiklimaNovi.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoArtiklimaNovi.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders(boolean nabavneBezPDV, boolean nabavne) {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(this.barmasterText.getString("TEXT_PODGRUPA"), new Object[0]));
        tc0.setWidth(250);
        if (this.sifre) {
            TableColumn tc1 = new TableColumn(this.table, 131072);
            tc1.setText(String.format(this.barmasterText.getString("TEXT_BARKOD"), new Object[0]));
            tc1.setWidth(200);
        }
        if (this.sifre1) {
            TableColumn tc11 = new TableColumn(this.table, 131072);
            tc11.setText(String.format(this.barmasterText.getString("TEXT_SIFRA"), new Object[0]));
            tc11.setWidth(200);
        }
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc2.setWidth(250);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc3.setWidth(75);
        if (nabavneBezPDV) {
            TableColumn tc4 = new TableColumn(this.table, 131072);
            tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_BEZ_PDVA"), new Object[0]));
            tc4.setWidth(75);
        }
        TableColumn tc4_1 = new TableColumn(this.table, 131072);
        tc4_1.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc4_1.setWidth(75);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc5.setWidth(100);
        if (nabavne) {
            TableColumn tc6 = new TableColumn(this.table, 131072);
            tc6.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]));
            tc6.setWidth(85);
            TableColumn tc7 = new TableColumn(this.table, 131072);
            tc7.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_SA_PDV"), new Object[0]));
            tc7.setWidth(100);
            TableColumn tc8 = new TableColumn(this.table, 131072);
            tc8.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA"), new Object[0]));
            tc8.setWidth(100);
            TableColumn tc8p = new TableColumn(this.table, 131072);
            tc8p.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA_U_PROCENTIMA"), new Object[0]));
            tc8p.setWidth(100);
            TableColumn tc8c = new TableColumn(this.table, 131072);
            tc8c.setText(String.format(Konstante.getBundle().getString("TEXT_KOSTANJE_PROCENAT"), new Object[0]));
            tc8c.setWidth(100);
        } else if (nabavneBezPDV) {
            TableColumn tc6 = new TableColumn(this.table, 131072);
            tc6.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]));
            tc6.setWidth(85);
            TableColumn tc7 = new TableColumn(this.table, 131072);
            tc7.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_VREDNOST_BEZ_PDV"), new Object[0]));
            tc7.setWidth(100);
            TableColumn tc8 = new TableColumn(this.table, 131072);
            tc8.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA"), new Object[0]));
            tc8.setWidth(100);
            TableColumn tc8p = new TableColumn(this.table, 131072);
            tc8p.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA_U_PROCENTIMA"), new Object[0]));
            tc8p.setWidth(100);
            TableColumn tc8c = new TableColumn(this.table, 131072);
            tc8c.setText(String.format(Konstante.getBundle().getString("TEXT_KOSTANJE_PROCENAT"), new Object[0]));
            tc8c.setWidth(100);
        }
    }

    private void loadData(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArtData, List<Map<String, Object>> ppaFinanceData, RestoranServer server, boolean codes, boolean codes1, boolean subtotal) throws Exception {
        EnumSet<NacinPlacanja> bp;
        if (ppaArtData == null) {
            throw new NullPointerException("ppaArtData argument is null");
        }
        if (ppaFinanceData == null) {
            throw new NullPointerException("ppaFinanceData argument is null");
        }
        if (server == null) {
            throw new NullPointerException("server argument is null");
        }
        ppaArtData.clear();
        ppaFinanceData.clear();
        EnumSet<NacinPlacanja> enumSet = bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
        if (!bltz) {
            server.getNewRevenueByArticlesArticleData(bp, cp, from, to, odeljenja, kase, podgrupe, ppaArtData, codes, codes1, subtotal);
        }
        server.getNewRevenueByArticlesFinanceData(bp, cp, from, to, odeljenja, kase, podgrupe, ppaFinanceData, subtotal);
    }

    private void loadDataNew(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArtData, List<Map<String, Object>> ppaFinanceData, RestoranServer server, boolean codes, boolean codes1, boolean subtotal) throws Exception {
        EnumSet<NacinPlacanja> bp;
        if (ppaArtData == null) {
            throw new NullPointerException("ppaArtData argument is null");
        }
        if (ppaFinanceData == null) {
            throw new NullPointerException("ppaFinanceData argument is null");
        }
        if (server == null) {
            throw new NullPointerException("server argument is null");
        }
        ppaArtData.clear();
        ppaFinanceData.clear();
        EnumSet<NacinPlacanja> enumSet = bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
        if (!bltz) {
            server.getNewRevenueByArticlesArticleData(bp, cp, odeljenja, kase, podgrupe, ppaArtData, codes, codes1, subtotal);
        }
        server.getNewRevenueByArticlesFinanceData(bp, cp, odeljenja, kase, podgrupe, ppaFinanceData, subtotal);
    }

    private void insertSubGroupTotalRow(Table table, Double sgQuant, Double sgValue, Double sgBuyingValue, String totalL, boolean codes, boolean codes1, boolean buyingPricesBezPDV) {
        TableItem ti = new TableItem(table, 0);
        int idx = codes ? (codes1 ? 3 : 2) : 1;
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber03NG(sgQuant));
        if (buyingPricesBezPDV) {
            ti.setText(idx++, "");
        }
        this.sgQuantG += sgQuant.doubleValue();
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber02NG(sgValue));
        this.sgValueG += sgValue.doubleValue();
        if (sgBuyingValue != null) {
            ti.setText(idx++, totalL + ":");
            ti.setText(idx++, StatLogic.getNumber02NG(sgBuyingValue));
            this.sgBuyingValueG += sgBuyingValue.doubleValue();
            ti.setText(idx++, StatLogic.getNumber02NG(sgValue - sgBuyingValue));
            this.diffG += sgValue - sgBuyingValue;
        }
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
        ti = new TableItem(table, 0);
    }

    private void reportTotalRow(Table table, Double sgQuantG, Double sgValueG, Double sgBuyingValueG, String totalL, Double diffG, boolean codes, boolean codes1, boolean buyingPricesBezPDV) {
        TableItem ti = new TableItem(table, 0);
        int idx = codes ? (codes1 ? 3 : 2) : 1;
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber03NG(sgQuantG));
        if (buyingPricesBezPDV) {
            ti.setText(idx++, "");
        }
        ti.setText(idx++, totalL + ":");
        ti.setText(idx++, StatLogic.getNumber02NG(sgValueG));
        if (sgBuyingValueG != null) {
            ti.setText(idx++, totalL + ":");
            ti.setText(idx++, StatLogic.getNumber02NG(sgBuyingValueG));
            ti.setText(idx++, StatLogic.getNumber02NG(diffG));
        }
        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
    }

    private void insertGroupTotalRow(Table table, Double pice, Double jelo) {
        TableItem ti1 = new TableItem(table, 0);
        ti1.setText("PICE: ");
        ti1.setText(StatLogic.getNumber03NG(pice) + "/n/r");
        ti1.setText("JELA: ");
        ti1.setText(StatLogic.getNumber03NG(jelo) + "/n/r");
        ti1.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
    }

    /*
     * WARNING - void declaration
     */
    private void insertRows(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, boolean buyingPricesBezPDV, boolean buyingPrices, boolean codes, boolean codes1, boolean mz) throws Exception {
        TableItem ti;
        this.loadData(bltz, belaPlacanja, cp, from, to, odeljenja, kase, podgrupe, this.ppaArtData, this.ppaFinanceData, this.server, codes, codes1, mz);
        String totalL = Konstante.getBundle().getString("TEXT_UKUPNO");
        double ukupno = 0.0;
        double neto = 0.0;
        double srvc = 0.0;
        double ppst = 0.0;
        HashMap<String, Long> racuniBR = new HashMap<String, Long>();
        EnumMap<NacinPlacanja, Double> nacinP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> servisP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> popustP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> netoP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        HashMap<String, Double> nacinPCrno = new HashMap<String, Double>();
        HashMap<String, Double> servisPCrno = new HashMap<String, Double>();
        HashMap<String, Double> popustPCrno = new HashMap<String, Double>();
        HashMap<String, Double> netoPCrno = new HashMap<String, Double>();
        for (NacinPlacanja np : belaPlacanja) {
            racuniBR.put(np.getOpis(), 0L);
            nacinP.put(np, 0.0);
            servisP.put(np, 0.0);
            popustP.put(np, 0.0);
            netoP.put(np, 0.0);
        }
        if (!bltz) {
            void var40_37;
            Double value = 0.0;
            String lastPG = null;
            Double sgCount = 0.0;
            Double sgValue = 0.0;
            Double ukupnoJelo = 0.0;
            Double ukupnoPice = 0.0;
            Object sgBuyingValueBezPDV = 0.0;
            Double d = 0.0;
            HashMap<String, Double> sgValues = new HashMap<String, Double>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, void> sgBuyingValues = new HashMap<String, void>();
            HashMap<String, Double> sgCounts = new HashMap<String, Double>();
            LinkedList<String> sgList = new LinkedList<String>();
            int idx = 1;
            for (Map<String, Object> row : this.ppaArtData) {
                Artikal a;
                String subGroup = (String)row.get("podgrupa");
                if (subGroup.equals("MENI")) {
                    System.out.println();
                }
                Long artikalId = (Long)row.get("artid");
                if (lastPG != null && !subGroup.equals(lastPG)) {
                    if (buyingPricesBezPDV || buyingPrices) {
                        if (buyingPricesBezPDV) {
                            this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)var40_37, totalL, codes, codes1, buyingPricesBezPDV);
                        } else if (buyingPrices) {
                            this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)var40_37, totalL, codes, codes1, false);
                        }
                    } else {
                        this.insertSubGroupTotalRow(this.table, sgCount, sgValue, null, totalL, codes, codes1, false);
                    }
                    sgList.add(lastPG);
                    sgValues.put(lastPG, sgValue);
                    sgCounts.put(lastPG, sgCount);
                    sgCount = 0.0;
                    sgValue = 0.0;
                    if (buyingPricesBezPDV) {
                        hashMap.put(lastPG, sgBuyingValueBezPDV);
                        sgBuyingValueBezPDV = 0.0;
                    }
                    if (buyingPrices || buyingPricesBezPDV) {
                        sgBuyingValues.put(lastPG, var40_37);
                        Double d2 = 0.0;
                    }
                }
                if (lastPG == null || !subGroup.equals(lastPG)) {
                    ti = new TableItem(this.table, 0);
                    ti.setText(subGroup);
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                    lastPG = subGroup;
                }
                ti = new TableItem(this.table, 0);
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 0));
                if (codes) {
                    String code = (String)row.get("sifra");
                    ti.setText(idx++, code == null ? "" : code);
                }
                if (codes1) {
                    String code1 = (String)row.get("sifraArtikla");
                    ti.setText(idx++, code1 == null ? "" : code1);
                }
                ti.setText(idx++, (String)row.get("artikal"));
                Double quant = (Double)row.get("kolicina");
                value = buyingPricesBezPDV ? (subGroup.equals("MENI") ? Double.valueOf(0.0) : Double.valueOf(this.server.getProdajnaCenaBezPDV(this.server.getArtikal(artikalId).getPoreskaGrupa(), (Double)row.get("vrednost")))) : (Double)row.get("vrednost");
                ti.setText(idx++, StatLogic.getNumber03NG(quant));
                if (buyingPricesBezPDV) {
                    if (subGroup.equals("MENI")) {
                        ti.setText(idx++, StatLogic.getNumber02NG(0.0));
                    } else {
                        ti.setText(idx++, StatLogic.getNumber02NG(this.server.getProdajnaCenaBezPDV(this.server.getArtikal(artikalId).getPoreskaGrupa(), (Double)row.get("cena"))));
                    }
                }
                ti.setText(idx++, StatLogic.getNumber02NG((Double)row.get("cena")));
                ti.setText(idx++, StatLogic.getNumber02NG(value));
                sgCount = sgCount + quant;
                sgValue = sgValue + value;
                if (buyingPricesBezPDV) {
                    a = this.server.getArtikal(artikalId);
                    this.buyingPrice = subGroup.equals("MENI") ? Double.valueOf(0.0) : Double.valueOf(this.getNabavnaCenaBezPDV(a, quant, this.d2) / quant);
                    Double buyingValue = this.buyingPrice * quant;
                    ti.setText(idx++, StatLogic.getNumber02NG(this.buyingPrice));
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value - buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value * 100.0 / buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(this.buyingPrice / value * 100.0));
                    Double d3 = var40_37.doubleValue() + buyingValue;
                }
                if (buyingPrices) {
                    a = this.server.getArtikal(artikalId);
                    Double buyingPrice = this.getNabavnaCena(a, quant, this.d2) / quant;
                    Double buyingValue = buyingPrice * quant;
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingPrice));
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value - buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value * 100.0 / buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingPrice / value * 100.0));
                    Double d4 = var40_37.doubleValue() + buyingValue;
                }
                idx = 1;
            }
            if (lastPG != null) {
                if (buyingPrices || buyingPricesBezPDV) {
                    if (buyingPrices) {
                        this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)var40_37, totalL, codes, codes1, false);
                    } else if (buyingPricesBezPDV) {
                        this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)var40_37, totalL, codes, codes1, buyingPricesBezPDV);
                    }
                } else {
                    this.insertSubGroupTotalRow(this.table, sgCount, sgValue, null, totalL, codes, codes1, false);
                }
                sgList.add(lastPG);
                sgValues.put(lastPG, sgValue);
                sgCounts.put(lastPG, sgCount);
                if (buyingPricesBezPDV) {
                    hashMap.put(lastPG, sgBuyingValueBezPDV);
                }
                if (buyingPrices) {
                    sgBuyingValues.put(lastPG, var40_37);
                }
            }
            HashMap grupe_KolTotal = new HashMap();
            if (!sgList.isEmpty()) {
                if (buyingPrices || buyingPricesBezPDV) {
                    if (buyingPrices) {
                        this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, this.sgBuyingValueG, totalL, this.diffG, codes, codes1, false);
                    } else if (buyingPricesBezPDV) {
                        this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, this.sgBuyingValueG, totalL, this.diffG, codes, codes1, buyingPricesBezPDV);
                    }
                } else {
                    this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, null, totalL, null, codes, codes1, false);
                }
            }
            if (!grupe_KolTotal.isEmpty()) {
                ti = new TableItem(this.table, 0);
                ti.setText("Po grupama");
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            }
            for (GrupaArtikala ga : grupe_KolTotal.keySet()) {
                double kom = (Double)((List)grupe_KolTotal.get(ga)).get(0);
                double ukpn = (Double)((List)grupe_KolTotal.get(ga)).get(1);
                ti = new TableItem(this.table, 0);
                ti.setText(0, ga.getNaziv());
                int indx = codes ? (codes1 ? 4 : 3) : 2;
                ti.setText(indx++, StatLogic.getNumber03NG(kom));
                int n = ++indx;
                ++indx;
                ti.setText(n, StatLogic.getNumber02NG(ukpn));
            }
        }
        ti = new TableItem(this.table, 0);
        String subtotalL = Konstante.getBundle().getString("TEXT_MEDJUZBIR");
        String combined = null;
        Double cNetto = 0.0;
        Double cDiscount = 0.0;
        Double cService = 0.0;
        Double cBrutto = 0.0;
        for (Map map : this.ppaFinanceData) {
            Long wpc = (Long)map.get("brojbelihplacanja");
            String string = (String)map.get("beloplacanje");
            String blackP = (String)map.get("crnoplacanje");
            Double netto = (Double)map.get("neto");
            Double discount = (Double)map.get("popust");
            Double service = (Double)map.get("servis");
            Double brutto = (Double)map.get("bruto");
            Long count = (Long)map.get("brojracuna");
            if (wpc == 0L) {
                if (blackP == null) {
                    blackP = subtotalL;
                } else {
                    racuniBR.put(blackP, count);
                }
                nacinPCrno.put(blackP, brutto);
                popustPCrno.put(blackP, discount);
                servisPCrno.put(blackP, service);
                netoPCrno.put(blackP, netto);
                continue;
            }
            if (wpc == 1L) {
                NacinPlacanja npt = NacinPlacanja.valueOf(string);
                nacinP.put(npt, brutto);
                popustP.put(npt, discount);
                servisP.put(npt, service);
                netoP.put(npt, netto);
                racuniBR.put(npt.getOpis(), count);
                continue;
            }
            combined = Konstante.getBundle().getString("TEXT_KOMBINOVANO");
            cNetto = netto;
            cDiscount = discount;
            cService = service;
            cBrutto = brutto;
            racuniBR.put(combined, count);
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]));
        ti.setText(1, String.format(Konstante.getBundle().getString("TEXT_KOLICINA_RACUNA"), new Object[0]));
        int ukupnoRacuna = 0;
        HashMap hashMap = new HashMap(racuniBR);
        for (Object np : NacinPlacanja.values()) {
            if (!hashMap.containsKey(np.getOpis())) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, np.getOpis());
            ti.setText(1, ((Long)hashMap.get(np.getOpis())).toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(np.getOpis()));
            hashMap.remove(np.getOpis());
        }
        for (CrnoPlacanje crnoPlacanje : cp) {
            String cpn = crnoPlacanje.getNaziv();
            if (!hashMap.containsKey(cpn)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, cpn);
            ti.setText(1, ((Long)hashMap.get(cpn)).toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(cpn));
            hashMap.remove(cpn);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String naziv = (String)entry.getKey();
            Long brojRacuna = (Long)entry.getValue();
            ti = new TableItem(this.table, 0);
            ti.setText(0, naziv);
            ti.setText(1, brojRacuna.toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(naziv));
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO_RACUNA"), new Object[0]).toUpperCase());
        ti.setText(1, "" + ukupnoRacuna);
        ti = new TableItem(this.table, 0);
        ti.setText(new String[]{String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0])});
        for (Object np : NacinPlacanja.values()) {
            if (!nacinP.containsKey(np)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, np.getOpis());
            ti.setText(1, StatLogic.getNumber02NG((Double)nacinP.get(np)));
            ukupno += ((Double)nacinP.get(np)).doubleValue();
        }
        for (CrnoPlacanje crnoPlacanje : cp) {
            String cpn = crnoPlacanje.getNaziv();
            if (!nacinPCrno.containsKey(cpn)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, cpn);
            ti.setText(1, Konstante.getNumber2((Double)nacinPCrno.get(cpn)));
            ukupno += ((Double)nacinPCrno.get(cpn)).doubleValue();
        }
        if (combined != null) {
            ti = new TableItem(this.table, 0);
            ti.setText(0, combined);
            ti.setText(1, StatLogic.getNumber02NG(cBrutto));
            ukupno += cBrutto.doubleValue();
        }
        if (nacinPCrno.containsKey(subtotalL)) {
            ti = new TableItem(this.table, 0);
            ti.setText(0, subtotalL);
            ukupno += ((Double)nacinPCrno.get(subtotalL)).doubleValue();
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
        ti.setText(1, Konstante.getNumber2(ukupno));
        this.table.pack();
        if (mz && this.zdBrojDatumDo == this.poslednjiZdBroj) {
            this.insertNenaplaceniStolovi(ukupno);
        }
    }

    private void insertRowsNow(boolean bltz, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, boolean buyingPricesBezPDV, boolean buyingPrices, boolean codes, boolean codes1, boolean mz) throws Exception {
        TableItem ti;
        this.loadDataNew(bltz, belaPlacanja, cp, odeljenja, kase, podgrupe, this.ppaArtData, this.ppaFinanceData, this.server, codes, codes1, mz);
        String totalL = Konstante.getBundle().getString("TEXT_UKUPNO");
        double ukupno = 0.0;
        double neto = 0.0;
        double srvc = 0.0;
        double ppst = 0.0;
        HashMap<String, Long> racuniBR = new HashMap<String, Long>();
        EnumMap<NacinPlacanja, Double> nacinP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> servisP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> popustP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        EnumMap<NacinPlacanja, Double> netoP = new EnumMap<NacinPlacanja, Double>(NacinPlacanja.class);
        HashMap<String, Double> nacinPCrno = new HashMap<String, Double>();
        HashMap<String, Double> servisPCrno = new HashMap<String, Double>();
        HashMap<String, Double> popustPCrno = new HashMap<String, Double>();
        HashMap<String, Double> netoPCrno = new HashMap<String, Double>();
        for (NacinPlacanja np : belaPlacanja) {
            racuniBR.put(np.getOpis(), 0L);
            nacinP.put(np, 0.0);
            servisP.put(np, 0.0);
            popustP.put(np, 0.0);
            netoP.put(np, 0.0);
        }
        if (!bltz) {
            String lastPG = null;
            Double sgCount = 0.0;
            Double sgValue = 0.0;
            Double ukupnoJelo = 0.0;
            Double ukupnoPice = 0.0;
            Double sgBuyingValueBezPDV = 0.0;
            Object sgBuyingValue = 0.0;
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            HashMap<String, Object> sgBuyingValues = new HashMap<String, Object>();
            HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
            LinkedList<String> sgList = new LinkedList<String>();
            int idx = 1;
            for (Map<String, Object> row : this.ppaArtData) {
                String subGroup = (String)row.get("podgrupa");
                if (subGroup.equals("MENI")) {
                    System.out.println();
                }
                Long artikalId = (Long)row.get("artid");
                if (lastPG != null && !subGroup.equals(lastPG)) {
                    this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)(buyingPrices ? sgBuyingValue : null), totalL, codes, codes1, false);
                    sgList.add(lastPG);
                    hashMap.put(lastPG, sgValue);
                    hashMap2.put(lastPG, sgCount);
                    sgCount = 0.0;
                    sgValue = 0.0;
                    if (buyingPrices) {
                        sgBuyingValues.put(lastPG, sgBuyingValue);
                        sgBuyingValue = 0.0;
                    }
                }
                if (lastPG == null || !subGroup.equals(lastPG)) {
                    ti = new TableItem(this.table, 0);
                    ti.setText(subGroup);
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                    lastPG = subGroup;
                }
                ti = new TableItem(this.table, 0);
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 0));
                if (codes) {
                    String code = (String)row.get("sifra");
                    ti.setText(idx++, code == null ? "" : code);
                }
                if (codes1) {
                    String code1 = (String)row.get("sifraArtikla");
                    ti.setText(idx++, code1 == null ? "" : code1);
                }
                ti.setText(idx++, (String)row.get("artikal"));
                Double quant = (Double)row.get("kolicina");
                Double value = (Double)row.get("vrednost");
                ti.setText(idx++, StatLogic.getNumber03NG(quant));
                if (buyingPricesBezPDV) {
                    ti.setText(idx++, StatLogic.getNumber02NG(this.server.getProdajnaCenaBezPDV(this.server.getArtikal(artikalId).getPoreskaGrupa(), (Double)row.get("cena"))));
                }
                ti.setText(idx++, StatLogic.getNumber02NG((Double)row.get("cena")));
                ti.setText(idx++, StatLogic.getNumber02NG(value));
                sgCount = sgCount + quant;
                sgValue = sgValue + value;
                if (buyingPrices) {
                    Artikal a = this.server.getArtikal(artikalId);
                    Double buyingPrice = this.getNabavnaCenaBezPDV(a, quant, this.d2) / quant;
                    Double buyingValue = buyingPrice * quant;
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingPrice));
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value - buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(value * 100.0 / buyingValue));
                    ti.setText(idx++, StatLogic.getNumber02NG(buyingPrice / value * 100.0));
                    sgBuyingValue = (Double)sgBuyingValue + buyingValue;
                }
                idx = 1;
            }
            if (lastPG != null) {
                if (buyingPrices || buyingPricesBezPDV) {
                    if (buyingPrices) {
                        this.insertSubGroupTotalRow(this.table, sgCount, sgValue, (Double)sgBuyingValue, totalL, codes, codes1, false);
                    } else if (buyingPricesBezPDV) {
                        this.insertSubGroupTotalRow(this.table, sgCount, sgValue, sgBuyingValueBezPDV, totalL, codes, codes1, buyingPricesBezPDV);
                    }
                } else {
                    this.insertSubGroupTotalRow(this.table, sgCount, sgValue, null, totalL, codes, codes1, false);
                }
            }
            HashMap grupe_KolTotal = new HashMap();
            if (!sgList.isEmpty()) {
                if (buyingPrices || buyingPricesBezPDV) {
                    if (buyingPrices) {
                        this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, this.sgBuyingValueG, totalL, this.diffG, codes, codes1, false);
                    } else if (buyingPricesBezPDV) {
                        this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, this.sgBuyingValueG, totalL, this.diffG, codes, codes1, buyingPricesBezPDV);
                    }
                } else {
                    this.reportTotalRow(this.table, this.sgQuantG, this.sgValueG, null, totalL, null, codes, codes1, false);
                }
            }
            if (!grupe_KolTotal.isEmpty()) {
                ti = new TableItem(this.table, 0);
                ti.setText("Po grupama");
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            }
            for (GrupaArtikala ga : grupe_KolTotal.keySet()) {
                double kom = (Double)((List)grupe_KolTotal.get(ga)).get(0);
                double ukpn = (Double)((List)grupe_KolTotal.get(ga)).get(1);
                ti = new TableItem(this.table, 0);
                ti.setText(0, ga.getNaziv());
                int indx = codes ? (codes1 ? 4 : 3) : 2;
                ti.setText(indx++, StatLogic.getNumber03NG(kom));
                int n = ++indx;
                ++indx;
                ti.setText(n, StatLogic.getNumber02NG(ukpn));
            }
        }
        ti = new TableItem(this.table, 0);
        String subtotalL = Konstante.getBundle().getString("TEXT_MEDJUZBIR");
        String combined = null;
        Double cNetto = 0.0;
        Double cDiscount = 0.0;
        Double cService = 0.0;
        Double cBrutto = 0.0;
        for (Map map : this.ppaFinanceData) {
            Long wpc = (Long)map.get("brojbelihplacanja");
            String string = (String)map.get("beloplacanje");
            String blackP = (String)map.get("crnoplacanje");
            Double netto = (Double)map.get("neto");
            Double discount = (Double)map.get("popust");
            Double service = (Double)map.get("servis");
            Double brutto = (Double)map.get("bruto");
            Long count = (Long)map.get("brojracuna");
            if (wpc == 0L) {
                if (blackP == null) {
                    blackP = subtotalL;
                } else {
                    racuniBR.put(blackP, count);
                }
                nacinPCrno.put(blackP, brutto);
                popustPCrno.put(blackP, discount);
                servisPCrno.put(blackP, service);
                netoPCrno.put(blackP, netto);
                continue;
            }
            if (wpc == 1L) {
                NacinPlacanja npt = NacinPlacanja.valueOf(string);
                nacinP.put(npt, brutto);
                popustP.put(npt, discount);
                servisP.put(npt, service);
                netoP.put(npt, netto);
                racuniBR.put(npt.getOpis(), count);
                continue;
            }
            combined = Konstante.getBundle().getString("TEXT_KOMBINOVANO");
            cNetto = netto;
            cDiscount = discount;
            cService = service;
            cBrutto = brutto;
            racuniBR.put(combined, count);
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]));
        ti.setText(1, String.format(Konstante.getBundle().getString("TEXT_KOLICINA_RACUNA"), new Object[0]));
        int ukupnoRacuna = 0;
        HashMap hashMap = new HashMap(racuniBR);
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!hashMap.containsKey(np.getOpis())) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, np.getOpis());
            ti.setText(1, ((Long)hashMap.get(np.getOpis())).toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(np.getOpis()));
            hashMap.remove(np.getOpis());
        }
        for (CrnoPlacanje crnoPlacanje : cp) {
            String cpn = crnoPlacanje.getNaziv();
            if (!hashMap.containsKey(cpn)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, cpn);
            ti.setText(1, ((Long)hashMap.get(cpn)).toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(cpn));
            hashMap.remove(cpn);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String naziv = (String)entry.getKey();
            Long brojRacuna = (Long)entry.getValue();
            ti = new TableItem(this.table, 0);
            ti.setText(0, naziv);
            ti.setText(1, brojRacuna.toString());
            ukupnoRacuna = (int)((long)ukupnoRacuna + (Long)hashMap.get(naziv));
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO_RACUNA"), new Object[0]).toUpperCase());
        ti.setText(1, "" + ukupnoRacuna);
        ti = new TableItem(this.table, 0);
        ti.setText(new String[]{String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0])});
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!nacinP.containsKey((Object)np)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, np.getOpis());
            ti.setText(4, StatLogic.getNumber02NG((Double)nacinP.get((Object)np)));
            ukupno += ((Double)nacinP.get((Object)np)).doubleValue();
        }
        for (CrnoPlacanje crnoPlacanje : cp) {
            String cpn = crnoPlacanje.getNaziv();
            if (!nacinPCrno.containsKey(cpn)) continue;
            ti = new TableItem(this.table, 0);
            ti.setText(0, cpn);
            ti.setText(4, Konstante.getNumber2((Double)nacinPCrno.get(cpn)));
            ukupno += ((Double)nacinPCrno.get(cpn)).doubleValue();
        }
        if (combined != null) {
            ti = new TableItem(this.table, 0);
            ti.setText(0, combined);
            ti.setText(4, StatLogic.getNumber02NG(cBrutto));
            ukupno += cBrutto.doubleValue();
        }
        if (nacinPCrno.containsKey(subtotalL)) {
            ti = new TableItem(this.table, 0);
            ti.setText(0, subtotalL);
            ti.setText(4, StatLogic.getNumber02NG((Double)nacinPCrno.get(subtotalL)));
            ukupno += ((Double)nacinPCrno.get(subtotalL)).doubleValue();
        }
        ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
        ti.setText(4, Konstante.getNumber2(ukupno));
        this.table.pack();
    }

    private void insertNenaplaceniStolovi(double ukupno) {
        List<StavkaRacuna> nenaplaceneStavke = NenaplaceniStolovi.getSviNenaplaceniStolovi(this.server);
        int brojNenaplacenihStolova = NenaplaceniStolovi.getBrojNenaplacenihStolova(this.server);
        double ukupnoNenaplaceniiStolovi = 0.0;
        if (nenaplaceneStavke.size() > 0) {
            TableItem ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_NENAPLACENI_STOLOVI"), new Object[0]).toUpperCase());
            ti = new TableItem(this.table, 0);
            ti.setText(3, String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
            ti.setText(4, String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
            ti.setText(5, String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
            ti.setText(6, String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
            ti = new TableItem(this.table, 0);
            for (StavkaRacuna stavka : nenaplaceneStavke) {
                ti = new TableItem(this.table, 0);
                ti.setText(3, stavka.getName());
                ti.setText(4, String.valueOf(stavka.getKolicina()));
                ti.setText(5, String.valueOf(stavka.getCena()));
                ti.setText(6, String.valueOf(stavka.getVrednost()));
                ukupnoNenaplaceniiStolovi += stavka.getVrednost().doubleValue();
            }
            ti = new TableItem(this.table, 0);
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_BROJ_NENAPLACENI_STOLOVI"), new Object[0]).toUpperCase());
            ti.setText(1, String.valueOf(brojNenaplacenihStolova));
            ti = new TableItem(this.table, 0);
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
            ti.setText(1, String.valueOf(ukupnoNenaplaceniiStolovi));
            ti = new TableItem(this.table, 0);
            ti.setText(0, String.format(this.barmasterText.getString("TEXT_UKUPNO_SA_NENAPLACENIM"), new Object[0]).toUpperCase());
            ti.setText(1, String.valueOf(ukupnoNenaplaceniiStolovi + ukupno));
        }
    }

    public double getNabavnaCena(Artikal art, double kolicina, Date dateTo) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, dateTo)) : a.getTrenutnaNV()) * mapa.get(a);
            }
        } else {
            if (art.getName().equals("KISELA VODA VRNJCI 0.25")) {
                System.out.println();
            }
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, dateTo)) : art.getTrenutnaNV()) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public double getNabavnaCenaBezPDV(Artikal art, double kolicina, Date dateTo) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, dateTo)) : a.getTrenutnaNV()) * mapa.get(a);
                System.out.println(mapa.get(a) + "kolicinaa");
            }
            return trNv;
        }
        trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBelaBezPDV(art, dateTo)) : art.getTrenutnaNV()) * kolicina;
        System.out.println(this.server.getLastNabavnaCenaBelaBezPDV(art, dateTo) + "iz metodeeee");
        System.out.println(art.getMera() + "  meraaaaaa  ");
        System.out.println(trNv + "pre mere");
        System.out.println((trNv *= art.getMera().doubleValue()) + "konacnaaaaa");
        return trNv;
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PrometPoArtiklimaNoviInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Button blic;
        private Button nabavneCeneBezPDV;
        private Button nabavneCene;
        private ComboViewer prodajnoMesto;
        List<ProdajnoMesto> prodajnaMesta;
        private ComboViewer kasa;
        private List<PodgrupaArtikala> podgrupe = new LinkedList<PodgrupaArtikala>();
        private List<Kasa> kase = new LinkedList<Kasa>();
        Date d1;
        Date d2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        int totalPodgrupe = 0;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        Label bk;
        private boolean medjuzbir;
        private Button jasperIzvestaj = null;
        private Button robno = null;

        /*
         * WARNING - void declaration
         */
        public PrometPoArtiklimaNoviInput(SWTContainer owner, Restoran r, boolean inspektor) {
            void var26_42;
            this.podgrupe = new ArrayList<PodgrupaArtikala>();
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.prodajnaMesta = this.server.findAllProdajnoMesto();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, true));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 40;
            Group grupa4 = new Group(panel2, 0);
            grupa4.setLayout((Layout)new GridLayout(5, false));
            grupa4.setText("Izbor izve\u0161taja");
            grupa4.setLayoutData((Object)data);
            this.robno = new Button((Composite)grupa4, 16);
            this.robno.setText("Robno");
            this.robno.setSelection(true);
            this.jasperIzvestaj = new Button((Composite)grupa4, 16);
            this.jasperIzvestaj.setText("Robno i finansijski");
            this.blic = new Button((Composite)grupa4, 16);
            this.blic.setText(String.format(this.barmasterText.getString("TEXT_BLIC_PROMET_PO_ARTIKLIMA"), new Object[0]) + ":");
            this.nabavneCeneBezPDV = new Button((Composite)grupa4, 16);
            this.nabavneCeneBezPDV.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_BEZ_PDV"), new Object[0]) + ":");
            this.nabavneCene = new Button((Composite)grupa4, 16);
            this.nabavneCene.setText(String.format(this.barmasterText.getString("TEXT_NABAVNA_CENA_SA_PDV_SKR"), new Object[0]) + ":");
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje odeljenje : this.odeljenja) {
                this.odeljenje.add(odeljenje.getNaziv());
            }
            this.odeljenje.select(0);
            Button izborKasa = new Button((Composite)grupa2, 8);
            izborKasa.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_KASA"), new Object[0]));
            izborKasa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    IzborProdajnoMestoKasa ip = new IzborProdajnoMestoKasa(mainComposite.getDisplay(), restoran);
                    kase = ip.getKase();
                    if (kase.isEmpty()) {
                        for (ProdajnoMesto ga : server.findAllProdajnoMesto()) {
                            for (Kasa pa : ga.getKase()) {
                                kase.add(pa);
                            }
                        }
                    }
                    bk.setText("Broj izabranih kasa: " + kase.size());
                }
            });
            this.bk = new Label((Composite)grupa2, 64);
            if (this.kase.isEmpty()) {
                for (ProdajnoMesto prodajnoMesto : this.server.findAllProdajnoMesto()) {
                    for (Kasa kasa : prodajnoMesto.getKase()) {
                        this.kase.add(kasa);
                    }
                }
                this.bk.setText("Broj izabranih kasa: " + this.kase.size());
            }
            Button button = new Button((Composite)grupa2, 8);
            button.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_PODGRUPA"), new Object[0]));
            button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    podgrupe = new ArrayList();
                    IzborPodgrua2 ip = new IzborPodgrua2(mainComposite.getDisplay(), restoran);
                    podgrupe = ip.getPodgrupe();
                    if (podgrupe.isEmpty()) {
                        for (GrupaArtikala ga : server.readGrupeArtikala()) {
                            for (PodgrupaArtikala pa : server.readPodgrupeArtikala(ga)) {
                                podgrupe.add(pa);
                            }
                        }
                        totalPodgrupe = podgrupe.size();
                    }
                    bp.setText(String.format(barmasterText.getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]) + ": " + podgrupe.size());
                }
            });
            this.bp = new Label((Composite)grupa2, 64);
            if (this.podgrupe.isEmpty()) {
                for (GrupaArtikala ga : this.server.readGrupeArtikala()) {
                    for (PodgrupaArtikala pa : this.server.readPodgrupeArtikala(ga)) {
                        this.podgrupe.add(pa);
                    }
                }
                this.totalPodgrupe = this.podgrupe.size();
            }
            this.bp.setText(String.format(this.barmasterText.getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]) + ": " + this.podgrupe.size());
            NacinPlacanja[] nacinPlacanjaArray = NacinPlacanja.values();
            int ga = nacinPlacanjaArray.length;
            boolean bl = false;
            while (var26_42 < ga) {
                NacinPlacanja value = nacinPlacanjaArray[var26_42];
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
                ++var26_42;
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button button2 = new Button((Composite)grupa21, 32);
                    if (cp.getNaziv().equals("MEDJUZBIR")) {
                        button2.setText(String.format(this.barmasterText.getString("TEXT_NENAPLACENI_STOLOVI"), new Object[0]));
                    } else {
                        button2.setText(cp.getNaziv());
                    }
                    button2.setData((Object)cp);
                    this.crnaDugmici.add(button2);
                }
            }
            Button button3 = Dugmici.getCancelButton((Composite)grupa3);
            button3.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 120;
            data.heightHint = 30;
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 16384;
            gridData.horizontalIndent = 10;
            gridData.widthHint = 150;
            gridData.heightHint = 30;
            od.setLayoutData((Object)data);
            izborKasa.setLayoutData((Object)data);
            button.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)gridData);
            this.doDatuma.getControl().setLayoutData((Object)gridData);
            this.blic.setLayoutData((Object)gridData);
            this.nabavneCeneBezPDV.setLayoutData((Object)gridData);
            this.nabavneCene.setLayoutData((Object)gridData);
            this.odeljenje.setLayoutData((Object)gridData);
            this.bk.setLayoutData((Object)gridData);
            this.bp.setLayoutData((Object)gridData);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            if (this.jasperIzvestaj.getSelection()) {
                try {
                    this.d1 = this.server.getPocetni(this.odDatuma.getResult());
                    this.d2 = this.server.getKrajnji(this.doDatuma.getResult());
                }
                catch (InputException inputException) {
                    // empty catch block
                }
                String filteri = "";
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button button = this.belaDugmici.get(i);
                    if (!button.getSelection()) continue;
                    filteri = filteri + (button.getText().equals("\u010cek") ? "CEK," : button.getText().toUpperCase() + ",");
                }
                for (Button button : this.crnaDugmici) {
                    if (!button.getSelection()) continue;
                    filteri = filteri + button.getText().toUpperCase() + ",";
                }
                String kaseS = "";
                for (Kasa k : this.kase) {
                    kaseS = kaseS + k.getId() + ",";
                }
                kaseS = kaseS.substring(0, kaseS.length() - 1);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                SimpleDateFormat sdf1 = new SimpleDateFormat("dd.MM.yyyy");
                SimpleDateFormat sdf2 = new SimpleDateFormat("dd.MM.yyyy");
                String odel = "";
                String pMesto = "";
                String pgrupe = "";
                for (PodgrupaArtikala pa : this.podgrupe) {
                    pgrupe = pgrupe + pa.getNaziv() + ",";
                }
                while (pgrupe.endsWith(",")) {
                    pgrupe = pgrupe.substring(0, pgrupe.length() - 1);
                }
                while (filteri.endsWith(",")) {
                    filteri = filteri.substring(0, filteri.length() - 1);
                }
                hashMap.put("title", "Promet po artiklima za period: " + sdf1.format(this.d1) + " do: " + sdf2.format(this.d2) + ". godine");
                hashMap.put("datumOd", new Timestamp(this.d1.getTime()));
                hashMap.put("datumDo", new Timestamp(this.d2.getTime()));
                hashMap.put("odeljenje", odel);
                hashMap.put("podgrupa", pgrupe);
                hashMap.put("prodajnoMesto", pMesto);
                hashMap.put("filteri", filteri);
                hashMap.put("kase", kaseS);
                try {
                    InputStream report = PrometPoArtiklimaNovi.class.getClassLoader().getResourceAsStream("com/dev63/restoran/reports/templates/PrometPoArtiklima.jasper");
                    JasperPrint jprint = JasperFillManager.fillReport((InputStream)report, hashMap, (Connection)this.server.getConnection());
                    JasperViewer.viewReport((JasperPrint)jprint, (boolean)false);
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    this.d1 = this.odDatuma.getResult();
                    this.d2 = this.doDatuma.getResult();
                    this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                    ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                    for (int i = 0; i < this.belaDugmici.size(); ++i) {
                        Button button = this.belaDugmici.get(i);
                        if (!button.getSelection()) continue;
                        bela.add(NacinPlacanja.values()[i]);
                    }
                    this.medjuzbir = false;
                    ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                    for (Button b : this.crnaDugmici) {
                        CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                        if (!b.getSelection()) continue;
                        crna.add(cp);
                        if (cp.getMedjuZbir() == null || !cp.getMedjuZbir().booleanValue()) continue;
                        this.medjuzbir = true;
                    }
                    this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_PROMETA_PO_ARTIKLIMA_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(this.d1), StatLogic.getDateString(this.d2)));
                    new PrometPoArtiklimaNovi(this.shell, this.restoran, this.d1, this.d2, this.o, this.blic.getSelection(), this.nabavneCeneBezPDV.getSelection(), this.nabavneCene.getSelection(), bela, crna, this.podgrupe, this.totalPodgrupe, this.kase, this.medjuzbir);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
                }
            }
        }
    }
}

