/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.GrupaOA;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.NPrintUtils;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrometPoArtiklima1 {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    List<GrupaOA> grupe = new ArrayList<GrupaOA>();
    List<String> crnaPlacanja;
    Map<GrupaOA, Double> mapaP = new HashMap<GrupaOA, Double>();
    Map<NacinPlacanja, Double> nacinP = new HashMap<NacinPlacanja, Double>();
    Map<String, Double> nacinPCrno = new HashMap<String, Double>();
    boolean blic;
    boolean nabavne;
    List<StavkaRacuna> stavke;
    Date day1;
    Date day2;
    boolean crno;
    boolean kombPlacanje = false;
    List<StavkaRacuna> stavkeKonacno = new ArrayList<StavkaRacuna>();
    List<Artikal> izabraniArtikli = new ArrayList<Artikal>();
    Odeljenje odeljenje;
    Button printButton4;
    double medjuzbir = 0.0;
    boolean sifre;

    public PrometPoArtiklima1(Shell s, Restoran re, final Date d1, final Date d2, Odeljenje od, boolean bl, boolean nc, boolean poGrupi, List<NacinPlacanja> bela, List<String> cp, List<GrupaOA> podg) {
        for (GrupaOA g : podg) {
            this.grupe.add(g);
        }
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.shell = s;
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZABRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.crnaPlacanja = cp;
        this.blic = bl;
        this.nabavne = nc;
        this.odeljenje = od;
        this.nacinP = new HashMap<NacinPlacanja, Double>();
        for (Object np : bela) {
            this.nacinP.put((NacinPlacanja)((Object)np), 0.0);
        }
        if (this.crnaPlacanja.size() > 0) {
            this.crno = true;
        }
        if (this.crno) {
            this.stavke = this.server.getSveStavke(this.day1, this.day2, od);
            block10: for (StavkaRacuna sr : this.stavke) {
                if (sr.getRacun().getCrnoPlacanje() == null) continue;
                for (String st : this.crnaPlacanja) {
                    if (!st.equals(sr.getRacun().getCrnoPlacanje())) continue;
                    this.stavkeKonacno.add(sr);
                    continue block10;
                }
            }
            this.nacinPCrno = this.makeMapCrno();
        } else {
            this.stavke = this.server.getStavke(this.day1, this.day2, od);
        }
        if (bela.size() > 0) {
            if (bela.size() < 4 && bela.size() > 0) {
                for (StavkaRacuna sr : this.stavke) {
                    if (sr.getRacun().getPlacanja().size() <= 1) continue;
                    Konstante.getPoruka(this.shell, String.format(Konstante.getBundle().getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_IZABRATI_SVA_4_OSNOVNA_TIPA_NAPLATE"), new Object[0]));
                    return;
                }
            } else {
                for (StavkaRacuna sr : this.stavke) {
                    if (sr.getRacun() == null || sr.getRacun().getCrnoPlacanje() != null) continue;
                    this.stavkeKonacno.add(sr);
                }
            }
        }
        if (bela.size() > 0 && bela.size() < 4) {
            for (Object np : bela) {
                for (StavkaRacuna sr : this.stavke) {
                    if (!this.getNacine(sr).contains(np)) continue;
                    this.stavkeKonacno.add(sr);
                }
            }
        }
        ArrayList<Racun> racuni = new ArrayList<Racun>();
        for (StavkaRacuna a : this.stavkeKonacno) {
            if (od != null || racuni.contains(a.getRacun())) continue;
            racuni.add(a.getRacun());
        }
        this.medjuzbir = this.server.getMedjuzbir(null, this.day1, this.day2);
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows(poGrupi);
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception sr) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PrometPoArtiklima1.this.table), false, true, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_PERSONALIZOVANI_IZVESTAJ_PRODAJE"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), PrometPoArtiklima1.this.shell, PrometPoArtiklima1.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        this.printButton4 = new Button((Composite)this.shell, 72);
        try {
            this.printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception sr) {
            // empty catch block
        }
        this.printButton4.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        this.printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Stampac stampac = PrometPoArtiklima1.this.server.readIzvestajiStampacObject();
                    int bkur = stampac.getTip().getBrojKarakteraURedu();
                    String content = "";
                    content = content + NPrintUtils.centerSplitToEnds(bkur, StatLogic.getDateString(new Date()), StatLogic.getTimeString(new Date())) + "\n";
                    content = content + NPrintUtils.centerText(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_PREGLED_PRODATIH_ARTIKALA_CAPS"), new Object[0])) + "\n";
                    content = content + NPrintUtils.centerSplitToMiddle(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_OD"), new Object[0]) + " " + StatLogic.getDateString(PrometPoArtiklima1.this.day1) + " ", String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_DO"), new Object[0]) + " " + StatLogic.getDateString(PrometPoArtiklima1.this.day2)) + "\n";
                    content = content + NPrintUtils.spaceFill(bkur) + "\n";
                    if (!PrometPoArtiklima1.this.blic) {
                        content = content + NPrintUtils.leftText(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0])) + "\n";
                        String temp = String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_PRODATO"), new Object[0]) + " ";
                        int l1 = temp.length();
                        content = content + NPrintUtils.leftText(l1, temp) + NPrintUtils.centerSplitToCenter(bkur - l1, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_CENA"), new Object[0]) + " ", String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + "\n";
                        int items = PrometPoArtiklima1.this.table.getItemCount();
                        for (int i = 0; i < items; ++i) {
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(0).length() > 2 && PrometPoArtiklima1.this.table.getItem(i).getText(4).length() == 0) {
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                content = content + NPrintUtils.centerText(bkur, PrometPoArtiklima1.this.table.getItem(i).getText(0)) + "\n";
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(0).length() == 0 && PrometPoArtiklima1.this.table.getItem(i).getText(1).length() > 2) {
                                content = content + NPrintUtils.leftText(bkur, PrometPoArtiklima1.this.table.getItem(i).getText(1)) + "\n";
                                content = content + NPrintUtils.leftText(bkur - 10 - 15, PrometPoArtiklima1.this.table.getItem(i).getText(2)) + NPrintUtils.rightText(10, PrometPoArtiklima1.this.table.getItem(i).getText(3)) + NPrintUtils.rightText(15, PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":")) {
                                content = content + NPrintUtils.rightText(bkur, "---------") + "\n";
                                content = content + NPrintUtils.rightText(bkur, PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":")) {
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                content = content + NPrintUtils.rightText(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ": " + PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(0).length() <= 2) continue;
                            content = content + NPrintUtils.leftText(bkur - 10, PrometPoArtiklima1.this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                            if (!PrometPoArtiklima1.this.table.getItem(i).getText(0).startsWith(String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_NACIN"), new Object[0]))) continue;
                            content = content + NPrintUtils.minusFill(bkur) + "\n";
                        }
                    } else {
                        content = content + NPrintUtils.centerSplitToEnds(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_GRUPA"), new Object[0]), String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0])) + "\n";
                        content = content + NPrintUtils.minusFill(bkur) + "\n";
                        int items = PrometPoArtiklima1.this.table.getItemCount();
                        for (int i = 0; i < items; ++i) {
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(0).length() > 2 && PrometPoArtiklima1.this.table.getItem(i).getText(4).length() == 0) {
                                content = content + NPrintUtils.leftText(bkur - 10, PrometPoArtiklima1.this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(3).equalsIgnoreCase(String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":")) {
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                content = content + NPrintUtils.centerText(bkur, String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ": " + PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                                content = content + NPrintUtils.minusFill(bkur) + "\n";
                                continue;
                            }
                            if (PrometPoArtiklima1.this.table.getItem(i).getText(0).length() <= 2) continue;
                            content = content + NPrintUtils.leftText(bkur - 10, PrometPoArtiklima1.this.table.getItem(i).getText(0)) + NPrintUtils.rightText(10, PrometPoArtiklima1.this.table.getItem(i).getText(4)) + "\n";
                            if (!PrometPoArtiklima1.this.table.getItem(i).getText(0).startsWith(String.format(PrometPoArtiklima1.this.barmasterText.getString("TEXT_NACIN"), new Object[0]))) continue;
                            content = content + NPrintUtils.minusFill(bkur) + "\n";
                        }
                    }
                    content = content + NPrintUtils.minusFill(bkur) + "\n";
                    NPrintUtils.printContent(content, stampac, 1);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklima1.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        });
        this.printButton4.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PrometPoArtiklima1.this.table, PrometPoArtiklima1.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrometPoArtiklima1.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(this.barmasterText.getString("TEXT_GRUPA"), new Object[0]));
        tc1.setWidth(250);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]));
        tc2.setWidth(250);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tc3.setWidth(75);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_KOMAD_SKR"), new Object[0]));
        tc4.setWidth(100);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        tc5.setWidth(150);
    }

    public void insertRows(boolean pogrupi) {
        TableItem ti;
        boolean prikaz;
        double total = 0.0;
        if (pogrupi) {
            prikaz = false;
            for (GrupaOA pg : this.grupe) {
                TableItem ti2;
                this.izabraniArtikli.clear();
                this.izabraniArtikli.addAll(pg.getAtributi());
                boolean okidac = false;
                for (StavkaRacuna sr : this.stavke) {
                    double d;
                    if (!this.izabraniArtikli.contains(sr.getArtikal())) continue;
                    okidac = true;
                    if (!sr.getRacun().getPlacanja().isEmpty() && this.nacinP.containsKey((Object)sr.getRacun().getPlacanja().get(0).getNacin())) {
                        d = this.nacinP.get((Object)sr.getRacun().getPlacanja().get(0).getNacin());
                        this.nacinP.put(sr.getRacun().getPlacanja().get(0).getNacin(), d + sr.getKolicina() * sr.getCena());
                        continue;
                    }
                    if (sr.getRacun().getCrnoPlacanje() == null || !this.nacinPCrno.containsKey(sr.getRacun().getCrnoPlacanje())) continue;
                    d = this.nacinPCrno.get(sr.getRacun().getCrnoPlacanje());
                    this.nacinPCrno.put(sr.getRacun().getCrnoPlacanje(), d + sr.getKolicina() * sr.getCena());
                }
                double totalGrupe = 0.0;
                for (StavkaRacuna stavkaRacuna : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                    if (!this.izabraniArtikli.contains(stavkaRacuna.getArtikal())) continue;
                    prikaz = true;
                    break;
                }
                if (!this.blic && prikaz) {
                    TableItem ti22 = new TableItem(this.table, 0);
                    ti22.setText(0, pg.getNaziv());
                    ti22.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                }
                for (StavkaRacuna stavkaRacuna : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                    String n;
                    if (!this.izabraniArtikli.contains(stavkaRacuna.getArtikal())) continue;
                    double kol = stavkaRacuna.getKolicina();
                    double cena = stavkaRacuna.getCena();
                    totalGrupe += kol * cena;
                    if (this.nabavne) {
                        Artikal art = stavkaRacuna.getArtikal();
                        if (art.getTip() == TipArtikla.SLOZ) {
                            List<Normativ> norms = this.server.getNormativiByLastNormativiArtikal(art.getId());
                            cena = 0.0;
                            for (Normativ n2 : norms) {
                                Artikal a22 = this.server.getArtikal(n2.getSastojak().getId());
                                if (a22.getTip() == TipArtikla.SLOZ) {
                                    List<Normativ> nn2 = this.server.getNormativiByLastNormativiArtikal(a22.getId());
                                    double c2 = 0.0;
                                    for (Normativ n22 : nn2) {
                                        c2 += this.server.getArtikal(n22.getSastojak().getId()).getTrenutnaNV() * n22.getKolicina();
                                    }
                                    cena += c2 * n2.getKolicina();
                                    continue;
                                }
                                cena += a22.getTrenutnaNV() * n2.getKolicina();
                            }
                        } else {
                            cena = art.getTrenutnaNV() * art.getMera();
                        }
                    }
                    if (this.blic || !prikaz) continue;
                    if (this.sifre) {
                        String s = stavkaRacuna.getArtikal().getBarCode() != null ? stavkaRacuna.getArtikal().getBarCode() : "";
                        n = s + " (" + stavkaRacuna.getArtikal().getName() + ")";
                    } else {
                        n = stavkaRacuna.getArtikal().getName();
                    }
                    TableItem ti3 = new TableItem(this.table, 0);
                    ti3.setText(new String[]{"", n, StatLogic.getNumber03NG(kol), StatLogic.getNumber02NG(cena), StatLogic.getNumber02NG(kol * cena)});
                }
                if (!this.blic && prikaz) {
                    ti2 = new TableItem(this.table, 0);
                    ti2.setText(3, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase() + ":");
                    ti2.setText(4, StatLogic.getNumber02NG(totalGrupe));
                    ti2 = new TableItem(this.table, 0);
                }
                if (this.blic && prikaz) {
                    ti2 = new TableItem(this.table, 0);
                    ti2.setText(new String[]{pg.getNaziv(), "", "", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase() + ":", StatLogic.getNumber02NG(totalGrupe)});
                    ti2.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                }
                prikaz = false;
                total += totalGrupe;
                if (!okidac) continue;
                TableItem tit = new TableItem(this.table, 0);
                tit = new TableItem(this.table, 0);
                tit.setText(new String[]{String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]), String.format(this.barmasterText.getString("TEXT_NETO"), new Object[0]), String.format(this.barmasterText.getString("TEXT_POPUST"), new Object[0]), String.format(this.barmasterText.getString("TEXT_SERVIS"), new Object[0]), String.format(this.barmasterText.getString("TEXT_BRUTO"), new Object[0])});
                for (NacinPlacanja np : this.nacinP.keySet()) {
                    TableItem ti4 = new TableItem(this.table, 0);
                    ti4.setText(0, np.getOpis());
                    ti4.setText(4, StatLogic.getNumber02NG(this.nacinP.get((Object)np)));
                }
            }
            if (total > 0.0) {
                ti = new TableItem(this.table, 0);
                ti.setText(3, String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":");
                ti.setText(4, StatLogic.getNumber02NG(total));
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                ti = new TableItem(this.table, 0);
            }
        } else {
            prikaz = false;
            for (GrupaOA pg : this.grupe) {
                TableItem ti3;
                this.izabraniArtikli.clear();
                this.izabraniArtikli.addAll(pg.getAtributi());
                for (StavkaRacuna sr : this.stavke) {
                    double d;
                    if (!this.izabraniArtikli.contains(sr.getArtikal())) continue;
                    if (!sr.getRacun().getPlacanja().isEmpty() && this.nacinP.containsKey((Object)sr.getRacun().getPlacanja().get(0).getNacin())) {
                        d = this.nacinP.get((Object)sr.getRacun().getPlacanja().get(0).getNacin());
                        this.nacinP.put(sr.getRacun().getPlacanja().get(0).getNacin(), d + sr.getKolicina() * sr.getCena());
                        continue;
                    }
                    if (sr.getRacun().getCrnoPlacanje() == null || !this.nacinPCrno.containsKey(sr.getRacun().getCrnoPlacanje())) continue;
                    d = this.nacinPCrno.get(sr.getRacun().getCrnoPlacanje());
                    this.nacinPCrno.put(sr.getRacun().getCrnoPlacanje(), d + sr.getKolicina() * sr.getCena());
                }
                double totalGrupe = 0.0;
                for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                    if (!this.izabraniArtikli.contains(a.getArtikal())) continue;
                    prikaz = true;
                    break;
                }
                if (!this.blic && prikaz) {
                    TableItem ti6 = new TableItem(this.table, 0);
                    ti6.setText(0, pg.getNaziv());
                    ti6.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                }
                for (StavkaRacuna a : StavkeSumarno.getSumarnoPopust(this.stavkeKonacno)) {
                    String n;
                    if (!this.izabraniArtikli.contains(a.getArtikal())) continue;
                    double d = a.getKolicina();
                    double cena = a.getCena();
                    totalGrupe += d * cena;
                    if (this.nabavne) {
                        Artikal art = a.getArtikal();
                        if (art.getTip() == TipArtikla.SLOZ) {
                            List<Normativ> norms = this.server.getNormativiByLastNormativiArtikal(art.getId());
                            cena = 0.0;
                            for (Normativ n3 : norms) {
                                Artikal a2 = this.server.getArtikal(n3.getSastojak().getId());
                                if (a2.getTip() == TipArtikla.SLOZ) {
                                    List<Normativ> nn2 = this.server.getNormativiByLastNormativiArtikal(a2.getId());
                                    double c2 = 0.0;
                                    for (Normativ n2 : nn2) {
                                        c2 += this.server.getArtikal(n2.getSastojak().getId()).getTrenutnaNV() * n2.getKolicina();
                                    }
                                    cena += c2 * n3.getKolicina();
                                    continue;
                                }
                                cena += a2.getTrenutnaNV() * n3.getKolicina();
                            }
                        } else {
                            cena = art.getTrenutnaNV() * art.getMera();
                        }
                    }
                    if (this.blic || !prikaz) continue;
                    if (this.sifre) {
                        String s = a.getArtikal().getBarCode() != null ? a.getArtikal().getBarCode() : "";
                        n = s + " (" + a.getArtikal().getName() + ")";
                    } else {
                        n = a.getArtikal().getName();
                    }
                    TableItem ti7 = new TableItem(this.table, 0);
                    ti7.setText(new String[]{"", n, StatLogic.getNumber03NG(d), StatLogic.getNumber02NG(cena), StatLogic.getNumber02NG(d * cena)});
                }
                if (!this.blic && prikaz) {
                    ti3 = new TableItem(this.table, 0);
                    ti3.setText(3, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase() + ":");
                    ti3.setText(4, StatLogic.getNumber02NG(totalGrupe));
                    ti3 = new TableItem(this.table, 0);
                }
                if (this.blic && prikaz) {
                    ti3 = new TableItem(this.table, 0);
                    ti3.setText(new String[]{pg.getNaziv(), "", "", String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]).toUpperCase() + ":", StatLogic.getNumber02NG(totalGrupe)});
                    ti3.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                }
                prikaz = false;
                total += totalGrupe;
            }
            if (total > 0.0) {
                ti = new TableItem(this.table, 0);
                ti.setText(3, String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]) + ":");
                ti.setText(4, StatLogic.getNumber02NG(total));
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                ti = new TableItem(this.table, 0);
            }
            TableItem tit = new TableItem(this.table, 0);
            tit = new TableItem(this.table, 0);
            tit.setText(new String[]{String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]), String.format(this.barmasterText.getString("TEXT_NETO"), new Object[0]), String.format(this.barmasterText.getString("TEXT_POPUST"), new Object[0]), String.format(this.barmasterText.getString("TEXT_SERVIS"), new Object[0]), String.format(this.barmasterText.getString("TEXT_BRUTO"), new Object[0])});
            for (NacinPlacanja np : this.nacinP.keySet()) {
                TableItem ti5 = new TableItem(this.table, 0);
                ti5.setText(0, np.getOpis());
                ti5.setText(4, StatLogic.getNumber02NG(this.nacinP.get((Object)np)));
            }
            if (this.crno) {
                for (String cp : this.nacinPCrno.keySet()) {
                    TableItem ti4 = new TableItem(this.table, 0);
                    ti4.setText(0, cp);
                    ti4.setText(4, StatLogic.getNumber02NG(this.nacinPCrno.get(cp)));
                }
            }
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
    }

    public Map makeMapCrno() {
        HashMap<String, Double> mapa = new HashMap<String, Double>();
        for (String cp : this.crnaPlacanja) {
            mapa.put(cp, 0.0);
        }
        return mapa;
    }

    private List<NacinPlacanja> getNacine(StavkaRacuna sr) {
        ArrayList<NacinPlacanja> n = new ArrayList<NacinPlacanja>();
        for (Placanje p : sr.getRacun().getPlacanja()) {
            n.add(p.getNacin());
        }
        return n;
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PrometPoArtiklimaInput1 {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Button blic;
        private Button nabavneCene;
        private Button poGrupi;
        private static List<GrupaOA> grupeOA;
        private Combo grupe;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        SWTContainer parent;
        Shell shell;

        public PrometPoArtiklimaInput1(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            grupeOA = this.server.getGrupeAtributa();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PERSONALIZOVANI_IZVESTAJ_PRODAJE"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 175;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, true));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            for (int i = 0; i < NacinPlacanja.values().length; ++i) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(NacinPlacanja.values()[i].getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    this.crnaDugmici.add(b);
                }
            }
            Label bl = new Label((Composite)grupa2, 0);
            bl.setText(String.format(this.barmasterText.getString("TEXT_BLIC_PROMET_PO_ARTIKLIMA"), new Object[0]) + ":");
            this.blic = new Button((Composite)grupa2, 32);
            Label nc = new Label((Composite)grupa2, 0);
            nc.setText(String.format(this.barmasterText.getString("TEXT_SA_NABAVNIM_CENAMA"), new Object[0]) + ":");
            this.nabavneCene = new Button((Composite)grupa2, 32);
            Label pg = new Label((Composite)grupa2, 0);
            pg.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_POSEBNE_GRUPE") + ":", new Object[0]));
            this.grupe = new Combo((Composite)grupa2, 4);
            this.grupe.add(String.format(this.barmasterText.getString("TEXT_SVE_GRUPE"), new Object[0]));
            for (GrupaOA pa : grupeOA) {
                pa.getNaziv();
                for (Artikal a : pa.getAtributi()) {
                    a.getName();
                }
                this.grupe.add(pa.getNaziv());
            }
            this.grupe.select(0);
            Label poGrupicheck = new Label((Composite)grupa2, 0);
            poGrupicheck.setText(String.format(this.barmasterText.getString("TEXT_PO_GRUPI"), new Object[0]) + ":");
            this.poGrupi = new Button((Composite)grupa2, 32);
            this.poGrupi.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (poGrupi.getSelection()) {
                        grupe.setEnabled(false);
                        grupe.select(0);
                    } else {
                        grupe.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            pg.setLayoutData((Object)data);
            poGrupicheck.setLayoutData((Object)data);
            this.grupe.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            bl.setLayoutData((Object)data);
            nc.setLayoutData((Object)data);
            this.blic.setLayoutData((Object)data);
            this.nabavneCene.setLayoutData((Object)data);
            this.poGrupi.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                ArrayList<String> crna = new ArrayList<String>();
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_PROMETA_PO_ARTIKLIMA_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(this.day1), StatLogic.getDateString(this.day2)));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(Konstante.getBundle().getString("TEXT_PERSONALIZOVANI_IZVESTAJ_PRODAJE"), new Object[0]) + ": " + StatLogic.getDateString(this.day1) + " -> " + StatLogic.getDateString(this.day2));
                ArrayList<GrupaOA> temp = new ArrayList<GrupaOA>();
                if (this.grupe.getSelectionIndex() != 0) {
                    GrupaOA g = grupeOA.get(this.grupe.getSelectionIndex() - 1);
                    temp.clear();
                    for (Artikal a : g.getAtributi()) {
                        a.getName();
                    }
                    temp.add(g);
                    new PrometPoArtiklima1(shell2, this.restoran, this.day1, this.day2, null, this.blic.getSelection(), this.nabavneCene.getSelection(), this.poGrupi.getSelection(), bela, crna, temp);
                } else {
                    new PrometPoArtiklima1(shell2, this.restoran, this.day1, this.day2, null, this.blic.getSelection(), this.nabavneCene.getSelection(), this.poGrupi.getSelection(), bela, crna, grupeOA);
                }
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

