/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PregledTroskovaRekapitulacija;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.GrupaTroskova;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.IzborGrupaTroskova;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PregledTroskova
extends SWTModels {
    private Restoran restoran;
    private RestoranServer server;
    private String[] kolone = new String[]{"Datum", "Grupa tro\u0161kova", "Naziv", "Iznos", "Valuta pla\u0107anja", "Datum pla\u0107anja", "Na\u010din pla\u0107anja"};
    private int[] sirinaKolona = new int[]{100, 100, 200, 100, 100, 100, 100};
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<Trosak> troskovi;
    MenuItem item1;
    Date day1;
    Date day2;
    String pretraga;

    private PregledTroskova(SWTContainer owner, Restoran r, List<GrupaTroskova> gt, Date d1, Date d2, String pretraga) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.pretraga = pretraga;
        this.day1 = d1;
        this.day2 = d2;
        this.shell = this.parent.getControl().getShell();
        this.shell.setLayout((Layout)new GridLayout(2, true));
        this.troskovi = this.server.getTroskove(d1, d2, gt, pretraga);
        this.table = this.makeTable((Composite)this.shell, this.kolone, this.sirinaKolona, 2, 2);
        this.insertRows();
        Composite control = this.makeComposite((Composite)this.shell, 3, 0, 0, 0, 0);
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)gd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledTroskova.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_TROSKOVA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(PregledTroskova.this.day1) + "-->" + StatLogic.getDateString(PregledTroskova.this.day2), PregledTroskova.this.shell, PregledTroskova.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledTroskova.this.table, PregledTroskova.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button exitButton = new Button(control, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.setLayoutData((Object)gd1);
        exitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledTroskova.this.shell.dispose();
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void insertRows() {
        double total = 0.0;
        for (Trosak t : this.troskovi) {
            total += t.getIznos();
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(new String[]{StatLogic.getDateString(t.getDan()), t.getGrupa().getNaziv(), t.getNaziv(), StatLogic.getNumber02(t.getIznos()), t.getValutaPlacanja() == null ? "" : StatLogic.getDateString(t.getValutaPlacanja()), t.getDatumPlacanja() == null ? "" : StatLogic.getDateString(t.getDatumPlacanja()), t.getNacinPlacanja()});
        }
        TableItem ti = new TableItem(this.table, 0);
        ti.setText(1, String.format(Konstante.getBundle().getString("TEXT_TOTAL"), new Object[0]));
        ti.setText(3, StatLogic.getNumber02(total));
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
    }

    public static class PregledTroskovaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Text textf;
        private Restoran restoran;
        private RestoranServer server;
        private Shell shell;
        GrupaTroskova z;
        List<GrupaTroskova> grupe;
        List<GrupaTroskova> zList;
        SWTContainer parent;
        private Button rekapitulacijaTroskova;

        public PregledTroskovaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.grupe = this.server.getGrupeTroskovaFirstLevel();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            this.zList = new LinkedList<GrupaTroskova>();
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_TROSKOVA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 115;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 200;
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label label1 = new Label((Composite)grupa2, 0);
            label1.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_GRUPA"), new Object[0]) + ":");
            final Button izborGrupa = new Button((Composite)grupa2, 8);
            izborGrupa.setText(String.format(Konstante.getBundle().getString("TEXT_IZABERI_GRUPE"), new Object[0]));
            Label labelAll = new Label((Composite)grupa2, 0);
            labelAll.setText(String.format(Konstante.getBundle().getString("TEXT_SVE_GRUPE"), new Object[0]) + ":");
            final Button sveGrupe = new Button((Composite)grupa2, 32);
            Label rekapitulacija = new Label((Composite)grupa2, 0);
            rekapitulacija.setText(String.format(Konstante.getBundle().getString("TEXT_REKAPITULACIJA"), new Object[0]) + ":");
            this.rekapitulacijaTroskova = new Button((Composite)grupa2, 32);
            Label labelGrupe = new Label((Composite)grupa2, 0);
            labelGrupe.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_IZABRANIH_GRUPA"), new Object[0]) + ":");
            final Label labelGrupeBroj = new Label((Composite)grupa2, 0);
            labelGrupeBroj.setText("0");
            Label labelText = new Label((Composite)grupa2, 0);
            labelText.setText(String.format(Konstante.getBundle().getString("TEXT_PRETRAGA"), new Object[0]) + ":");
            this.textf = new Text((Composite)grupa2, 2048);
            GridData lData = new GridData(768);
            labelGrupeBroj.setLayoutData((Object)lData);
            izborGrupa.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IzborGrupaTroskova ig = new IzborGrupaTroskova(shell, server, grupe);
                    zList = ig.getGrupe();
                    labelGrupeBroj.setText("" + zList.size());
                }
            });
            sveGrupe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (sveGrupe.getSelection()) {
                        zList = server.getGrupeTroskova();
                        for (GrupaTroskova gt : zList) {
                            System.out.println("ss >>>> " + gt.getNaziv());
                        }
                        izborGrupa.setEnabled(false);
                    } else {
                        zList = new LinkedList<GrupaTroskova>();
                        izborGrupa.setEnabled(true);
                    }
                    labelGrupeBroj.setText("" + zList.size());
                    labelGrupeBroj.redraw();
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            label1.setLayoutData((Object)data);
            izborGrupa.setLayoutData((Object)data);
            labelAll.setLayoutData((Object)data);
            rekapitulacija.setLayoutData((Object)data);
            sveGrupe.setLayoutData((Object)data);
            this.rekapitulacijaTroskova.setLayoutData((Object)data);
            labelGrupe.setLayoutData((Object)data);
            labelGrupeBroj.setLayoutData((Object)data);
            labelText.setLayoutData((Object)data);
            this.textf.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date dat1 = this.odDatuma.getResult();
                Date dat2 = this.doDatuma.getResult();
                String pretraga = this.textf.getText().length() > 0 ? this.textf.getText() : "";
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_TROSKOVA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(dat1) + " -> " + StatLogic.getDateString(dat2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                if (this.rekapitulacijaTroskova.getSelection()) {
                    new PregledTroskovaRekapitulacija(parent2, this.zList, this.server, dat1, dat2);
                } else {
                    new PregledTroskova(parent2, this.restoran, this.zList, dat1, dat2, pretraga);
                }
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

