/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.sistem.IzborPodgrupe;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.awt.Panel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledSvihNormativa {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private RestoranServer server;
    Table table;
    Shell shell;
    Map<GrupaArtikala, List<PodgrupaArtikala>> podgrupe = new HashMap<GrupaArtikala, List<PodgrupaArtikala>>();
    List<GrupaArtikala> grupe = new ArrayList<GrupaArtikala>();
    private List<Artikal> artikli = new ArrayList<Artikal>();
    Map<PodgrupaArtikala, List<Artikal>> mapaArtikli = new HashMap<PodgrupaArtikala, List<Artikal>>();
    boolean blic;
    List<Odeljenje> odeljenja;
    Odeljenje odeljenje;
    Button printButton4;
    boolean poPodgrupama;
    Panel panel;
    boolean vrednost;
    boolean poPosCenama;
    boolean poPosCenamaKombo;

    public PregledSvihNormativa(final RestoranServer server, Shell s, Restoran re, Odeljenje od, List<Artikal> artikli, boolean v) {
        this.server = server;
        if (od != null) {
            this.odeljenja = new ArrayList<Odeljenje>();
            this.odeljenje = od;
            this.odeljenja.add(od);
        } else {
            this.odeljenja = server.readOdeljenjeBezMag();
        }
        Setting sett = server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting settKombo = server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosCenama = false;
        this.poPosCenamaKombo = false;
        if (sett != null) {
            this.poPosCenama = sett.booleanValue();
        }
        this.poPosCenamaKombo = settKombo == null ? false : settKombo.booleanValue();
        this.server = server;
        this.poPodgrupama = artikli.size() > 0;
        this.vrednost = v;
        this.artikli = artikli;
        if (this.poPodgrupama) {
            for (Artikal a : artikli) {
                if (!this.grupe.contains(a.getPodgrupa().getGrupa())) {
                    this.grupe.add(a.getPodgrupa().getGrupa());
                    this.podgrupe.put(a.getPodgrupa().getGrupa(), new LinkedList());
                }
                if (!this.podgrupe.get(a.getPodgrupa().getGrupa()).contains(a.getPodgrupa())) {
                    List<PodgrupaArtikala> lpg = this.podgrupe.get(a.getPodgrupa().getGrupa());
                    lpg.add(a.getPodgrupa());
                    this.podgrupe.put(a.getPodgrupa().getGrupa(), lpg);
                    this.mapaArtikli.put(a.getPodgrupa(), new LinkedList());
                }
                List<Artikal> al = this.mapaArtikli.get(a.getPodgrupa());
                al.add(a);
                this.mapaArtikli.put(a.getPodgrupa(), al);
            }
        } else {
            for (Odeljenje odeljenje1 : this.odeljenja) {
                for (String a : server.getSlozeniArtikli(odeljenje1.getId())) {
                    Artikal ar = server.ArtikalByName(a);
                    artikli.add(ar);
                    if (!this.grupe.contains(ar.getPodgrupa().getGrupa())) {
                        this.grupe.add(ar.getPodgrupa().getGrupa());
                        this.podgrupe.put(ar.getPodgrupa().getGrupa(), new LinkedList());
                    }
                    if (!this.podgrupe.get(ar.getPodgrupa().getGrupa()).contains(ar.getPodgrupa())) {
                        List<PodgrupaArtikala> lpg = this.podgrupe.get(ar.getPodgrupa().getGrupa());
                        lpg.add(ar.getPodgrupa());
                        this.podgrupe.put(ar.getPodgrupa().getGrupa(), lpg);
                        this.mapaArtikli.put(ar.getPodgrupa(), new LinkedList());
                    }
                    List<Artikal> al = this.mapaArtikli.get(ar.getPodgrupa());
                    al.add(ar);
                    this.mapaArtikli.put(ar.getPodgrupa(), al);
                }
            }
        }
        this.server = server;
        this.shell = new Shell(s, 34912);
        this.shell.setText("Pregled svih normativa");
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception al) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledSvihNormativa.this.table), false, true, "Pregled svih normativa: ", PregledSvihNormativa.this.shell, server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception a) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledSvihNormativa.this.table, PregledSvihNormativa.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 8);
        data = new GridData(120, 50);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledSvihNormativa.this.shell.close();
            }
        });
        this.makeHeader();
        this.insertRows();
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void insertRows() {
        for (GrupaArtikala ga : this.grupe) {
            for (PodgrupaArtikala pg : this.podgrupe.get(ga)) {
                TableItem ti = new TableItem(this.table, 0x1000000);
                ti.setText(new String[]{"Podgrupa -  " + pg.getNaziv(), "", "", "", "", "", "", "", ""});
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 12, 1));
                new TableItem(this.table, 16384);
                for (Artikal a : this.mapaArtikli.get(pg)) {
                    double sumPDV = 0.0;
                    double sumBezPDV = 0.0;
                    if (a.getBlokiran().booleanValue()) continue;
                    String ime = a.getName();
                    if (ime.contains("&")) {
                        ime = ime.replace("&", " ");
                    }
                    ti = new TableItem(this.table, 16384);
                    if (this.vrednost) {
                        ti.setText(new String[]{a.getName(), a.getJedinicaMere(), StatLogic.getNumber02(a.getCena()), "", "", "", "", "", ""});
                    } else {
                        ti.setText(new String[]{a.getName(), a.getJedinicaMere(), "", ""});
                    }
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
                    List<Normativ> normativi = this.server.readNormativ(a, new Date());
                    if (normativi.size() > 0) {
                        for (Normativ normativ : normativi) {
                            ti = new TableItem(this.table, 131072);
                            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 8, 0));
                            double nabavnaCena = this.getNabavnaCena(normativ.getSastojak(), normativ.getKolicina());
                            double nabavnaCenaBezPDV = this.getNabavnaCenaBezPDV(normativ.getSastojak(), normativ.getKolicina());
                            sumPDV += nabavnaCena * normativ.getKolicina();
                            sumBezPDV += nabavnaCenaBezPDV * normativ.getKolicina();
                            if (this.vrednost) {
                                ti.setText(new String[]{normativ.getSastojak().getName(), normativ.getSastojak().getJedinicaMere(), "", StatLogic.getNumber04(normativ.getKolicina()), StatLogic.getNumber02(nabavnaCena), StatLogic.getNumber02(nabavnaCenaBezPDV), StatLogic.getNumber02(nabavnaCena * normativ.getKolicina()), StatLogic.getNumber02(nabavnaCenaBezPDV * normativ.getKolicina()), normativ.getOdeljenje().getNaziv()});
                                continue;
                            }
                            ti.setText(new String[]{normativ.getSastojak().getName(), normativ.getSastojak().getJedinicaMere(), StatLogic.getNumber04(normativ.getKolicina()), normativ.getOdeljenje().getNaziv()});
                        }
                    } else {
                        ti = new TableItem(this.table, 131072);
                        if (a.getTip().equals((Object)TipArtikla.PROD)) {
                            double nabavnaCena = this.getNabavnaCena(a, a.getMera());
                            double nabavnaCenaBezPDV = this.getNabavnaCenaBezPDV(a, a.getMera());
                            sumPDV += nabavnaCena * a.getMera();
                            sumBezPDV += nabavnaCenaBezPDV * a.getMera();
                            if (this.vrednost) {
                                ti.setText(new String[]{a.getName(), a.getJedinicaMere(), "", StatLogic.getNumber04(a.getMera()), StatLogic.getNumber02(nabavnaCena), StatLogic.getNumber02(nabavnaCenaBezPDV), StatLogic.getNumber02(nabavnaCena * a.getMera()), StatLogic.getNumber02(nabavnaCenaBezPDV * a.getMera()), a.getOdeljenje().getNaziv()});
                            } else {
                                ti.setText(new String[]{a.getName(), a.getJedinicaMere(), StatLogic.getNumber04(a.getMera()), a.getOdeljenje().getNaziv()});
                            }
                        } else if (this.vrednost) {
                            ti.setText(new String[]{"-- Nema normativa -- ", "", "", "", "", "", "", "", ""});
                        } else {
                            ti.setText(new String[]{"-- Nema normativa -- ", "", "", ""});
                        }
                        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 8, 0));
                    }
                    if (this.vrednost) {
                        ti = new TableItem(this.table, 16384);
                        ti.setText(new String[]{"", "", "", "", "", "Ukupno: ", StatLogic.getNumber02(sumPDV), StatLogic.getNumber02(sumBezPDV), ""});
                        ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 3));
                    }
                    new TableItem(this.table, 16384);
                }
            }
        }
    }

    public void makeHeader() {
        if (this.vrednost) {
            TableColumn tc1 = new TableColumn(this.table, 0x1000000);
            tc1.setText("Naziv");
            tc1.setWidth(100);
            TableColumn tc2 = new TableColumn(this.table, 0x1000000);
            tc2.setText("J.M.");
            tc2.setWidth(50);
            TableColumn tc3 = new TableColumn(this.table, 0x1000000);
            tc3.setText("Prod. cena");
            tc3.setWidth(70);
            TableColumn tc4 = new TableColumn(this.table, 0x1000000);
            tc4.setText("Kolicina");
            tc4.setWidth(60);
            TableColumn tc5 = new TableColumn(this.table, 0x1000000);
            tc5.setText("TR. nab. cena");
            tc5.setWidth(70);
            TableColumn tc6 = new TableColumn(this.table, 0x1000000);
            tc6.setText("TR. nab. cena bez PDV");
            tc6.setWidth(70);
            TableColumn tc7 = new TableColumn(this.table, 0x1000000);
            tc7.setText("Nab. vrednost");
            tc7.setWidth(70);
            TableColumn tc8 = new TableColumn(this.table, 0x1000000);
            tc8.setText("Nab. vred. bez PDV");
            tc8.setWidth(70);
            TableColumn tc9 = new TableColumn(this.table, 0x1000000);
            tc9.setText("Odeljenje");
            tc9.setWidth(80);
        } else {
            TableColumn tc1 = new TableColumn(this.table, 0x1000000);
            tc1.setText("Naziv");
            tc1.setWidth(100);
            TableColumn tc2 = new TableColumn(this.table, 0x1000000);
            tc2.setText("J.M.");
            tc2.setWidth(50);
            TableColumn tc4 = new TableColumn(this.table, 0x1000000);
            tc4.setText("Kolicina");
            tc4.setWidth(60);
            TableColumn tc9 = new TableColumn(this.table, 0x1000000);
            tc9.setText("Odeljenje");
            tc9.setWidth(80);
        }
    }

    public double izracunajNVBPDV(Artikal a) {
        double d = 0.0;
        Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(a, new HashMap<Artikal, Double>(), 1.0, this.server, null, null);
        if (a.getTip() == TipArtikla.SLOZ) {
            for (Artikal art : mapa.keySet()) {
                if (!this.poPosCenama) {
                    d += art.getTrenutnaNV() * mapa.get(art);
                    continue;
                }
                d += (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) * mapa.get(art);
            }
        } else {
            d = !this.poPosCenama ? (d += a.getTrenutnaNV().doubleValue()) : (d += this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date()));
        }
        return d;
    }

    public double izracunajNVSPDV(Artikal a) {
        double d = 0.0;
        Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(a, new HashMap<Artikal, Double>(), 1.0, this.server, null, null);
        if (a.getTip() == TipArtikla.SLOZ) {
            for (Artikal art : mapa.keySet()) {
                if (!this.poPosCenama) {
                    d += art.getTrenutnaNV() * mapa.get(art) * (1.0 + Konstante.getPdvPoPG(art.getPoreskaGrupa()));
                    continue;
                }
                d += (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) * mapa.get(art) * (1.0 + Konstante.getPdvPoPG(art.getPoreskaGrupa()));
            }
        } else {
            d = !this.poPosCenama ? (d += a.getTrenutnaNV() * (1.0 + Konstante.getPdvPoPG(a.getPoreskaGrupa()))) : (d += this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date()));
        }
        return d;
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa())));
        }
        return trNv;
    }

    public double getNabavnaCenaBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBelaBezPDV(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa())));
        }
        return trNv;
    }

    public static class PregledSvihNormativaInput {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Label bp;
        Button izborPodgrupa;
        Button brisanjePodgrupa;
        Button vrednosti;
        private List<Artikal> listaArtikala = new LinkedList<Artikal>();

        public PregledSvihNormativaInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.server = r.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image promet = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(promet);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)promet));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_SVIH_NORMATIVA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
            Button uputstvo = new Button(panel1, 8);
            Image manImg = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
            uputstvo.setImage(manImg);
            uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 200;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(this.barmasterText.getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            this.izborPodgrupa = new Button((Composite)grupa2, 8);
            this.izborPodgrupa.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_ARTIKALA"), new Object[0]));
            this.izborPodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    odeljenje.select(0);
                    odeljenje.setEnabled(false);
                    IzborPodgrupe ip = new IzborPodgrupe(shell.getDisplay(), server);
                    listaArtikala = ip.getArtikliIzlaz();
                    bp.setText(String.format(barmasterText.getString("TEXT_BROJ_IZABRANIH_ARTIKALA"), new Object[0]) + ": " + listaArtikala.size());
                }
            });
            this.bp = new Label((Composite)grupa2, 0);
            this.bp.setText(String.format(this.barmasterText.getString("TEXT_BROJ_IZABRANIH_ARTIKALA"), new Object[0]) + ": " + this.listaArtikala.size());
            this.brisanjePodgrupa = new Button((Composite)grupa2, 8);
            this.brisanjePodgrupa.setText(String.format(this.barmasterText.getString("TEXT_PONISTI_IZBOR_ARTIKALA"), new Object[0]));
            this.brisanjePodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    listaArtikala = new ArrayList();
                    odeljenje.setEnabled(true);
                    bp.setText(String.format(barmasterText.getString("TEXT_BROJ_IZABRANIH_ARTIKALA"), new Object[0]) + ": " + listaArtikala.size());
                }
            });
            Label v = new Label((Composite)grupa2, 0);
            v.setText(String.format(this.barmasterText.getString("TEXT_PRIKAZ_CENA_I_VREDNOSTI"), new Object[0]) + ":");
            this.vrednosti = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 200;
            data.heightHint = 40;
            data.verticalIndent = 5;
            this.izborPodgrupa.setLayoutData((Object)data);
            this.bp.setLayoutData((Object)data);
            v.setLayoutData((Object)data);
            this.vrednosti.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 200;
            data.heightHint = 40;
            data.horizontalSpan = 2;
            data.verticalIndent = 5;
            this.brisanjePodgrupa.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
            Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
            new PregledSvihNormativa(this.server, shell2, this.restoran, this.o, this.listaArtikala, this.vrednosti.getSelection());
        }
    }
}

