/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.comparators.StalniGostNazivComparator;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledStalnihGostiju {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    SortedMap<StalniGost, List<Racun>> sgRacuni;
    Date day1;
    Date day2;
    private boolean saNabavnimCenama;
    private boolean poProdajnimCenama;
    private boolean poPosUnetCenama = false;
    private boolean poPosCenamaKombo = false;

    public PregledStalnihGostiju(Shell sh, Restoran rest, StalniGostiGrupa gr, StalniGost kom, Konobar konobar, final Date d1, final Date d2, List<NacinPlacanja> bela, List<String> crna, boolean saNabavnimCenama, boolean stalniGosti) {
        List<Racun> racuniTemp;
        this.saNabavnimCenama = saNabavnimCenama;
        this.poProdajnimCenama = stalniGosti;
        this.restoran = rest;
        this.server = this.restoran.getServer();
        Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
        Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
        this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
        this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        this.shell = sh;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(Konstante.getBundle().getString("PORUKA_ZA_IZABRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        try {
            racuniTemp = this.server.getRacuniStalni(gr, kom, konobar, this.day1, this.day2);
        }
        catch (Exception ex) {
            Logger.getLogger(PregledStalnihGostiju.class.getName()).log(Level.INFO, "Greska kod citanja racuna za stalne goste " + ex.getMessage(), ex);
            racuniTemp = new LinkedList<Racun>();
        }
        System.out.println("racuniTemp = " + racuniTemp.size());
        this.sgRacuni = new TreeMap<StalniGost, List<Racun>>(new StalniGostNazivComparator());
        for (Racun r : racuniTemp) {
            if (r.getCrnoPlacanje() == null) {
                if (bela.size() < 4 && r.getPlacanja().size() > 1) {
                    Konstante.getPoruka3(this.shell, String.format(Konstante.getBundle().getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_IZABRATI_SVA_4_OSNOVNA_TIPA_NAPLATE"), new Object[0]));
                    return;
                }
                if (!bela.contains((Object)r.getPlacanja().get(0).getNacin())) continue;
                if (!this.sgRacuni.containsKey(r.getStalniGost())) {
                    this.sgRacuni.put(r.getStalniGost(), new LinkedList<Racun>(Arrays.asList(r)));
                    continue;
                }
                ((List)this.sgRacuni.get(r.getStalniGost())).add(r);
                continue;
            }
            if (!crna.contains(r.getCrnoPlacanje())) continue;
            if (!this.sgRacuni.containsKey(r.getStalniGost())) {
                this.sgRacuni.put(r.getStalniGost(), new LinkedList<Racun>(Arrays.asList(r)));
                continue;
            }
            ((List)this.sgRacuni.get(r.getStalniGost())).add(r);
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 3;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows(konobar);
        Composite control1 = new Composite((Composite)this.shell, 0);
        control1.setLayout((Layout)new GridLayout(3, false));
        control1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 4, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control1, 8);
        printButton.setLayoutData((Object)gd);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledStalnihGostiju.this.day2.after(new Date()) && PregledStalnihGostiju.this.server.getStolove().size() > 0) {
                    Konstante.getPoruka(PregledStalnihGostiju.this.shell, String.format(Konstante.getBundle().getString("PORUKA_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    return;
                }
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledStalnihGostiju.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), PregledStalnihGostiju.this.shell, PregledStalnihGostiju.this.server);
            }
        });
        Button export = new Button(control1, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledStalnihGostiju.this.table, PregledStalnihGostiju.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button izlaz = new Button(control1, 8);
        gd = new GridData(131072, 4, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        gd.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)gd);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledStalnihGostiju.this.shell.close();
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_GOST"), new Object[0]));
        tc4.setWidth(140);
        TableColumn tc1 = new TableColumn(this.table, 0x1000000);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        tc1.setWidth(140);
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(Konstante.getBundle().getString("TEXT_VREME"), new Object[0]));
        tc6.setWidth(140);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA"), new Object[0]));
        tc2.pack();
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0]));
        tc9.setWidth(140);
        if (this.saNabavnimCenama) {
            TableColumn tc99 = new TableColumn(this.table, 0x1000000);
            tc99.setText(String.format(Konstante.getBundle().getString("TEXT_SA_NABAVNOM_CENOM_BEZ_PDV"), new Object[0]));
            tc99.setWidth(180);
            TableColumn tc991 = new TableColumn(this.table, 0x1000000);
            tc991.setText(String.format(Konstante.getBundle().getString("TEXT_SA_NABAVNOM_CENOM"), new Object[0]));
            tc991.setWidth(140);
        }
        if (this.poProdajnimCenama) {
            TableColumn tc999 = new TableColumn(this.table, 0x1000000);
            tc999.setText(String.format(Konstante.getBundle().getString("TEXT_PO_PRODAJNIM_CENAMA"), new Object[0]));
            tc999.setWidth(140);
        }
        TableColumn tc33 = new TableColumn(this.table, 0x1000000);
        tc33.setText(String.format(Konstante.getBundle().getString("TEXT_STAVKA_RACUNA"), new Object[0]));
        tc33.setWidth(170);
        TableColumn kon = new TableColumn(this.table, 0x1000000);
        kon.setText(String.format(Konstante.getBundle().getString("TEXT_KONOBAR"), new Object[0]));
        kon.setWidth(120);
    }

    private void insertRows(Konobar konobar) {
        double total = 0.0;
        double ukupno = 0.0;
        double nvTotal = 0.0;
        double nvTotalPdv = 0.0;
        double ukupnoNabavno = 0.0;
        double ukupnoNabavnoPdv = 0.0;
        double ukupnoProdajno = 0.0;
        for (Map.Entry<StalniGost, List<Racun>> entry : this.sgRacuni.entrySet()) {
            total = 0.0;
            StalniGost stalniGost = entry.getKey();
            List<Racun> racuni = entry.getValue();
            double sgTotal = 0.0;
            double sgNvTotal = 0.0;
            for (Racun r : racuni) {
                int i = 0;
                total += r.total();
                sgTotal += r.totalBezPopusta();
                TableItem ti = new TableItem(this.table, 0);
                if (r.total() == 0.0) {
                    ti.setForeground(this.shell.getDisplay().getSystemColor(3));
                }
                double nv = 0.0;
                double nvPdv = 0.0;
                ti.setText(i++, r.getStalniGost() != null ? r.getStalniGost().getNaziv() : "");
                ti.setText(i++, Konstante.getDate(r.getDatum()));
                ti.setText(i++, Konstante.getTime(r.getDatum()));
                ti.setText(i++, r.getBrojRacuna() != null ? r.getBrojRacuna().toString() : "");
                ti.setText(i++, Konstante.getNumber2(r.total()));
                List<StavkaRacuna> temp = r.getStavke();
                for (StavkaRacuna sr : temp == null || temp.isEmpty() ? this.server.getStavke(r) : temp) {
                    TableItem tis = new TableItem(this.table, 0);
                    nv += this.getNabavnaCena(sr.getArtikal(), sr.getKolicina());
                    nvPdv += this.getNabavnaCenaPdv(sr.getArtikal(), sr.getKolicina());
                    tis.setText(this.saNabavnimCenama ? (this.poProdajnimCenama ? 8 : 7) : (this.poProdajnimCenama ? 6 : 5), sr.getKolicina() + "x " + sr.getNaziv());
                    ukupnoProdajno += sr.getArtikal().getCena() * sr.getKolicina();
                }
                System.out.println("ukupnoProdajno " + ukupnoProdajno);
                if (this.saNabavnimCenama) {
                    ti.setText(i++, Konstante.getNumber2(nv));
                    ti.setText(i++, Konstante.getNumber2(nvPdv));
                }
                if (this.poProdajnimCenama) {
                    ti.setText(i++, Konstante.getNumber02(r.totalBezPopusta()));
                }
                ti.setText(1 + i++, konobar != null ? konobar.getPunoime() : r.getKonobar().getPunoime());
                nvTotal += nv;
                nvTotalPdv += nvPdv;
            }
            int y = 3;
            TableItem ti = new TableItem(this.table, 0);
            ti.setBackground(this.shell.getDisplay().getSystemColor(15));
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            ti.setText(y++, String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
            ti.setText(y++, StatLogic.getNumber02NG(total));
            if (this.saNabavnimCenama) {
                ti.setText(y++, StatLogic.getNumber02NG(nvTotal));
                ti.setText(y++, StatLogic.getNumber02NG(nvTotalPdv));
            }
            if (this.poProdajnimCenama) {
                ti.setText(y++, StatLogic.getNumber02NG(sgTotal));
            }
            ti = new TableItem(this.table, 0);
            ukupno += total;
            ukupnoNabavno += nvTotal;
            ukupnoNabavnoPdv += nvTotalPdv;
        }
        int z = 3;
        if (this.sgRacuni.size() > 1) {
            TableItem ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            ti.setForeground(this.shell.getDisplay().getSystemColor(9));
            ti.setText(z++, String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
            ti.setText(z++, StatLogic.getNumber02NG(ukupno));
            if (this.saNabavnimCenama) {
                ti.setText(z++, StatLogic.getNumber02NG(ukupnoNabavno));
                ti.setText(z++, StatLogic.getNumber02NG(ukupnoNabavnoPdv));
            }
            if (this.poProdajnimCenama) {
                ti.setText(z++, StatLogic.getNumber02NG(ukupnoProdajno));
            }
        }
    }

    public double getNabavnaCenaPdv(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? Konstante.getPdvPoPG(a.getPoreskaGrupa()) : 0.0)) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? Konstante.getPdvPoPG(art.getPoreskaGrupa()) : 0.0)) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public static class PregledStalnihGostijuInput {
        private DateInput2 odDatuma;
        Button nc;
        Button sg;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupe;
        private ComboViewer cvGrupe;
        private List<StalniGostiGrupa> cvGrupeInput;
        private Combo komitent;
        private ComboViewer cvKomitent;
        private List<Konobar> cvKonobariInput;
        private Combo konobar;
        private ComboViewer cvKonobar;
        private String sviKomitentiL;
        private List<StalniGost> cvKomitentInput;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        SWTContainer parent;

        public PregledStalnihGostijuInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.sviKomitentiL = String.format(Konstante.getBundle().getString("TEXT_SVI_KOMITENTI"), new Object[0]);
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = null;
            try {
                img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            }
            catch (Exception exception) {
                // empty catch block
            }
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_STALNI_GOSTI"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 90;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(6, true));
            grupa21.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label izg = new Label((Composite)grupa1, 0);
            izg.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_GRUPE"), new Object[0]) + ":");
            this.cvGrupeInput = this.server.readGrupeStGosti();
            this.cvGrupe = new ComboViewer((Composite)grupa1, 8);
            this.cvGrupe.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof StalniGostiGrupa) {
                        StalniGostiGrupa sgg = (StalniGostiGrupa)element;
                        return sgg.getNaziv() == null ? "" : sgg.getNaziv();
                    }
                    if (element.equals(cvGrupe.getInput())) {
                        return String.format(Konstante.getBundle().getString("TEXT_SVE_GRUPE"), new Object[0]);
                    }
                    return "";
                }
            });
            this.cvGrupe.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof StalniGostiGrupa)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.grupe = this.cvGrupe.getCombo();
            this.grupe.setEnabled(true);
            this.cvGrupe.setInput(this.cvGrupeInput);
            this.cvGrupe.setSelection((ISelection)new StructuredSelection(this.cvGrupe.getInput()));
            Label izk = new Label((Composite)grupa1, 0);
            izk.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_KOMITENTA"), new Object[0]) + ":");
            this.cvKomitent = new ComboViewer((Composite)grupa1, 8);
            this.cvKomitent.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof StalniGost) {
                        StalniGost sg = (StalniGost)element;
                        return sg.getNaziv() == null ? "" : sg.getNaziv();
                    }
                    if (element.equals(cvKomitent.getInput())) {
                        return sviKomitentiL;
                    }
                    return "";
                }
            });
            this.cvKomitent.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof StalniGost)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.komitent = this.cvKomitent.getCombo();
            this.cvKomitentInput = new LinkedList<StalniGost>();
            this.cvKomitent.setInput(this.cvKomitentInput);
            this.cvKomitent.setSelection((ISelection)new StructuredSelection(this.cvKomitent.getInput()));
            this.komitent.setEnabled(false);
            Label izKon = new Label((Composite)grupa1, 0);
            izKon.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_KONOBARA"), new Object[0]) + ":");
            this.cvKonobariInput = this.server.readKonobar();
            this.cvKonobar = new ComboViewer((Composite)grupa1, 8);
            this.cvKonobar.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Konobar) {
                        Konobar k = (Konobar)element;
                        return k.getPunoime() == null ? "" : k.getPunoime();
                    }
                    if (element.equals(cvKonobar.getInput())) {
                        return String.format(Konstante.getBundle().getString("TEXT_SVI_KONOBARI"), new Object[0]);
                    }
                    return "";
                }
            });
            this.cvKonobar.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof Konobar)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.konobar = this.cvKonobar.getCombo();
            this.konobar.setEnabled(true);
            this.cvKonobar.setInput(this.cvKonobariInput);
            this.cvKonobar.setSelection((ISelection)new StructuredSelection(this.cvKonobar.getInput()));
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label ncl = new Label((Composite)grupa1, 0);
            ncl.setText(ResourceBundle.getBundle("barmasterText").getString("TEXT_SA_NABAVNOM_CENOM") + ":");
            this.nc = new Button((Composite)grupa1, 32);
            this.nc.setSelection(false);
            Label sg1 = new Label((Composite)grupa1, 0);
            sg1.setText(ResourceBundle.getBundle("barmasterText").getString("TEXT_PO_PRODAJNIM_CENAMA") + ":");
            this.sg = new Button((Composite)grupa1, 32);
            this.sg.setSelection(false);
            this.cvGrupe.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection iSel = (IStructuredSelection)event.getSelection();
                    cvKomitentInput.clear();
                    if (iSel.isEmpty() || !(iSel.getFirstElement() instanceof StalniGostiGrupa)) {
                        cvKomitent.getCombo().setEnabled(false);
                    } else {
                        StalniGostiGrupa sgg = (StalniGostiGrupa)iSel.getFirstElement();
                        cvKomitentInput.addAll(sgg.getStalniGosti());
                        cvKomitent.getCombo().setEnabled(true);
                    }
                    cvKomitent.refresh();
                    this.sortKomitent();
                    cvKomitent.setSelection((ISelection)new StructuredSelection(cvKomitent.getInput()));
                }
            });
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                b.setEnabled(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setSelection(true);
                    b.setEnabled(true);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.cvGrupe.getCombo().setLayoutData((Object)data);
            this.cvKomitent.getCombo().setLayoutData((Object)data);
            this.cvKonobar.getCombo().setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.nc.setLayoutData((Object)data);
            this.sg.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void sortKomitent() {
            this.cvKomitent.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals(sviKomitentiL)) {
                        return -1;
                    }
                    if (o2.equals(sviKomitentiL)) {
                        return 1;
                    }
                    return o1.compareToIgnoreCase(o2);
                }
            }));
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                StalniGostiGrupa g = null;
                IStructuredSelection gSel = (IStructuredSelection)this.cvGrupe.getSelection();
                if (!gSel.isEmpty() && gSel.getFirstElement() instanceof StalniGostiGrupa) {
                    g = (StalniGostiGrupa)gSel.getFirstElement();
                }
                StalniGost k = null;
                IStructuredSelection kSel = (IStructuredSelection)this.cvKomitent.getSelection();
                if (!kSel.isEmpty() && kSel.getFirstElement() instanceof StalniGost) {
                    k = (StalniGost)kSel.getFirstElement();
                }
                Konobar konobar = null;
                IStructuredSelection konSel = (IStructuredSelection)this.cvKonobar.getSelection();
                if (!konSel.isEmpty() && konSel.getFirstElement() instanceof Konobar) {
                    konobar = (Konobar)konSel.getFirstElement();
                }
                System.out.println("konobar " + konobar);
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                ArrayList<String> crna = new ArrayList<String>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                    System.out.println("belo " + b.getText());
                }
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.server.log(String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]).toLowerCase() + "->" + this.day1 + " " + String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(this.day1) + " -> " + StatLogic.getDateString(this.day2));
                new PregledStalnihGostiju(shell2, this.restoran, g, k, konobar, this.day1, this.day2, bela, crna, this.nc.getSelection(), this.sg.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

