/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.izvestaji.stampa.ReportPrintBuilder;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class PregledMeniPrometa {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    private Table table;
    private TableViewer mpViewer;
    private TableViewer srViewer;
    private Shell shell;
    private List<MeniPromet> prometi;
    private Date day1;
    private Date day2;
    private Meni m;
    private List<Meni> mList;
    private List<NacinPlacanja> belaP;
    private List<String> crnaP;
    private boolean menuSort;

    public PregledMeniPrometa(Shell owner, Restoran r, final Date d1, final Date d2, Meni chosenMenu, List<NacinPlacanja> bela, List<String> crnaPl) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = new Shell(owner, 34032);
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_PROMETA_MENIJA"), new Object[0]) + " " + String.format(this.barmasterText.getString("TEXT_ZA_PERIOD"), new Object[0]) + " " + String.format(this.barmasterText.getString("TEXT_OD"), new Object[0]).toLowerCase() + " " + StatLogic.getDateString(d1) + String.format(this.barmasterText.getString("TEXT_DO"), new Object[0]).toLowerCase() + " " + StatLogic.getDateString(d2));
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        if (this.m == null) {
            this.mList = this.server.getAllMenus();
        } else {
            this.mList = new LinkedList<Meni>();
            this.mList.add(this.m);
        }
        this.belaP = bela;
        this.crnaP = crnaPl;
        try {
            this.prometi = new LinkedList<MeniPromet>();
            if (!this.belaP.isEmpty()) {
                this.prometi.addAll(this.server.findAllMeniPrometBelo(this.day1, this.day2, this.mList, this.belaP));
            }
            if (!this.crnaP.isEmpty()) {
                this.prometi.addAll(this.server.findAllMeniPrometCrno(this.day1, this.day2, this.mList, this.crnaP));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final Composite cAll = new Composite((Composite)this.shell, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout(2, false));
        Composite gmp = new Composite(cAll, 0);
        TableColumnLayout tcl = new TableColumnLayout();
        gmp.setLayout((Layout)tcl);
        gmp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mpViewer = new TableViewer(gmp, 66308);
        this.mpViewer.getTable().setHeaderVisible(true);
        this.mpViewer.getTable().setLinesVisible(true);
        TableViewerColumn tvmp1 = new TableViewerColumn(this.mpViewer, 16384);
        tvmp1.getColumn().setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tcl.setColumnData((Widget)tvmp1.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        tvmp1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(StatLogic.getDateString(mp.getDatum()));
            }
        });
        TableViewerColumn tvmp11 = new TableViewerColumn(this.mpViewer, 16384);
        tvmp11.getColumn().setText(String.format(this.barmasterText.getString("TEXT_VREME"), new Object[0]));
        tcl.setColumnData((Widget)tvmp11.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true));
        tvmp11.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(StatLogic.getTimeString(mp.getDatum()));
            }
        });
        TableViewerColumn tvmp2 = new TableViewerColumn(this.mpViewer, 16384);
        tvmp2.getColumn().setText(String.format(this.barmasterText.getString("TEXT_MENI"), new Object[0]));
        tcl.setColumnData((Widget)tvmp2.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 50, true));
        tvmp2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(mp.getMeni().getNaziv());
            }
        });
        TableViewerColumn tvmp3 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp3.getColumn().setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tcl.setColumnData((Widget)tvmp3.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true));
        tvmp3.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(mp.getKolicina()));
            }
        });
        TableViewerColumn tvmp4 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp4.getColumn().setText(String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]));
        tcl.setColumnData((Widget)tvmp4.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true));
        tvmp4.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(mp.getCena()));
            }
        });
        TableViewerColumn tvmp5 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp5.getColumn().setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
        tcl.setColumnData((Widget)tvmp5.getColumn(), (ColumnLayoutData)new ColumnPixelData(70, true));
        tvmp5.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(mp.getTotal()));
            }
        });
        TableViewerColumn tvmp555 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp555.getColumn().setText(String.format(this.barmasterText.getString("TEXT_SERVIS"), new Object[0]) + "/" + String.format(this.barmasterText.getString("TEXT_POPUST"), new Object[0]));
        tcl.setColumnData((Widget)tvmp555.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 60, true));
        tvmp555.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText((mp.getRacun().getPopust() > 0.0 ? "-" : "+") + StatLogic.getNumber02NG(Math.abs(mp.getRacun().getPopust())));
            }
        });
        TableViewerColumn tvmp55 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp55.getColumn().setText(String.format(this.barmasterText.getString("TEXT_NACIN_PLACANJA"), new Object[0]));
        tcl.setColumnData((Widget)tvmp55.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 70, true));
        tvmp55.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                if (mp.getRacun().getPlacanja() == null || mp.getRacun().getPlacanja().isEmpty()) {
                    vc.setText(mp.getRacun().getCrnoPlacanje());
                } else if (mp.getRacun().getPlacanja().size() > 1) {
                    vc.setText(String.format(PregledMeniPrometa.this.barmasterText.getString("TEXT_KOMBINOVANO"), new Object[0]));
                } else if (mp.getRacun().getPlacanja().size() == 1) {
                    vc.setText(mp.getRacun().getPlacanja().get(0).getNacin().getOpis());
                }
            }
        });
        TableViewerColumn tvmp6 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp6.getColumn().setText(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        tcl.setColumnData((Widget)tvmp6.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 80, true));
        tvmp6.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(mp.getRacun().getKonobar().getSkrIme());
            }
        });
        TableViewerColumn tvmp7 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp7.getColumn().setText(String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]));
        tcl.setColumnData((Widget)tvmp7.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 40, true));
        tvmp7.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(Konstante.getNazivStola(mp.getRacun().getBrojStola(), PregledMeniPrometa.this.server));
            }
        });
        TableViewerColumn tvmp8 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp8.getColumn().setText(String.format(this.barmasterText.getString("TEXT_BROJ_RACUNA"), new Object[0]));
        tcl.setColumnData((Widget)tvmp8.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        tvmp8.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(mp.getRacun().getBrojRacuna().toString());
            }
        });
        TableViewerColumn tvmp9 = new TableViewerColumn(this.mpViewer, 131072);
        tvmp9.getColumn().setText(String.format(this.barmasterText.getString("TEXT_GOST"), new Object[0]));
        tcl.setColumnData((Widget)tvmp9.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true));
        tvmp9.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                MeniPromet mp = (MeniPromet)vc.getElement();
                vc.setText(mp.getRacun().getStalniGost() != null ? mp.getRacun().getStalniGost().getNaziv() : "");
            }
        });
        this.mpViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mpViewer.setInput(this.prometi);
        final Group gsr = new Group(cAll, 0);
        gsr.setText(String.format(this.barmasterText.getString("TEXT_ARTIKLI"), new Object[0]));
        gsr.setLayout((Layout)new GridLayout());
        gsr.setLayoutData((Object)new GridData(4, 4, false, true));
        Button back = new Button((Composite)gsr, 0x1000008);
        back.setText(">>>");
        back.setLayoutData((Object)new GridData(4, 4, true, false));
        this.srViewer = new TableViewer((Composite)gsr, 66052);
        this.srViewer.getTable().setHeaderVisible(true);
        this.srViewer.getTable().setLinesVisible(true);
        this.srViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn tvsr1 = new TableViewerColumn(this.srViewer, 16384);
        tvsr1.getColumn().setText(String.format(this.barmasterText.getString("TEXT_NAZIV"), new Object[0]));
        tvsr1.getColumn().setWidth(150);
        tvsr1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                vc.setText(sr.getNaziv());
            }
        });
        TableViewerColumn tvsr2 = new TableViewerColumn(this.srViewer, 131072);
        tvsr2.getColumn().setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
        tvsr2.getColumn().setWidth(60);
        tvsr2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(sr.getKolicina()));
            }
        });
        TableViewerColumn tvsr3 = new TableViewerColumn(this.srViewer, 131072);
        tvsr3.getColumn().setText(String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]));
        tvsr3.getColumn().setWidth(60);
        tvsr3.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(sr.getCena()));
            }
        });
        TableViewerColumn tvsr4 = new TableViewerColumn(this.srViewer, 131072);
        tvsr4.getColumn().setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
        tvsr4.getColumn().setWidth(80);
        tvsr4.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell vc) {
                StavkaRacuna sr = (StavkaRacuna)vc.getElement();
                vc.setText(StatLogic.getNumber02NG(sr.getVrednostSaPopustom()));
            }
        });
        this.srViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ((GridData)gsr.getLayoutData()).widthHint = 0;
        gsr.setVisible(false);
        this.mpViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                if (iSel.size() > 0) {
                    MeniPromet mp = (MeniPromet)iSel.getFirstElement();
                    if (mp != null && mp.getRacun() != null && mp.getRacun().getStavke1() != null) {
                        List<StavkaRacuna> listaStavki = mp.getRacun().getStavke();
                        PregledMeniPrometa.this.srViewer.setInput(listaStavki);
                        PregledMeniPrometa.this.srViewer.refresh();
                        ((GridData)gsr.getLayoutData()).widthHint = -1;
                        gsr.setVisible(true);
                        cAll.layout();
                    } else {
                        ((GridData)gsr.getLayoutData()).widthHint = 0;
                        gsr.setVisible(false);
                        cAll.layout();
                    }
                }
            }
        });
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((GridData)gsr.getLayoutData()).widthHint = 0;
                gsr.setVisible(false);
                cAll.layout();
            }
        });
        this.shell.setBackgroundMode(2);
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(6, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 16777288);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.setLayoutData((Object)rd);
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledMeniPrometa.this.mpViewer.getTable()), false, true, String.format(PregledMeniPrometa.this.barmasterText.getString("TEXT_PREGLED_PROMETA_MENIJA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " --> " + StatLogic.getDateString(d2), PregledMeniPrometa.this.shell, PregledMeniPrometa.this.server);
            }
        });
        Button export = new Button(cc, 16777288);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledMeniPrometa.this.mpViewer.getTable(), PregledMeniPrometa.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button printSpec = new Button(cc, 16777288);
        try {
            printSpec.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printSpec.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_SPECIFIKACIJE_MENIJA"), new Object[0]));
        printSpec.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MeniPromet mp = null;
                try {
                    IStructuredSelection iSel = (IStructuredSelection)PregledMeniPrometa.this.mpViewer.getSelection();
                    if (!iSel.isEmpty()) {
                        mp = (MeniPromet)iSel.getFirstElement();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
                if (mp == null) {
                    return;
                }
                Setting logoPathS = PregledMeniPrometa.this.server.getSetting(Option.LOGO_ZAGLAVLJA_FAKTURE);
                String logoPath = logoPathS != null ? logoPathS.stringValue() : null;
                Setting titleS = PregledMeniPrometa.this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE);
                String title = titleS != null ? titleS.stringValue() : "";
                ReportPrintBuilder.printPreview(PregledMeniPrometa.this.shell, ReportPrintBuilder.createPrintJob((Print)ReportPrintBuilder.createNewDocument(ReportPrintBuilder.makeTitle(logoPath, title), ReportPrintBuilder.makeMenuSpecBody(mp), (Print)new EmptyPrint()), Printer.getDefaultPrinterData()));
            }
        });
        printSpec.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledMeniPrometa.this.shell.close();
            }
        });
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(this.barmasterText.getString("TEXT_IZNOS"), new Object[0]));
        tc2.setWidth(70);
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        tc9.setWidth(70);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc3.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        tc3.pack();
        TableColumn tc4 = new TableColumn(this.table, 0x1000000);
        tc4.setText(String.format(this.barmasterText.getString("TEXT_VREME"), new Object[0]));
        tc4.pack();
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]));
        tc6.setWidth(40);
        TableColumn tc44 = new TableColumn(this.table, 0x1000000);
        tc44.setText(String.format(this.barmasterText.getString("TEXT_BROJ"), new Object[0]));
        tc44.setWidth(40);
        TableColumn tc7 = new TableColumn(this.table, 0x1000000);
        tc7.setText(String.format(this.barmasterText.getString("TEXT_GOTOVINA"), new Object[0]));
        tc7.pack();
        TableColumn tc12 = new TableColumn(this.table, 0x1000000);
        tc12.setText(String.format(this.barmasterText.getString("TEXT_CEK"), new Object[0]));
        tc12.pack();
        TableColumn tc13 = new TableColumn(this.table, 0x1000000);
        tc13.setText(String.format(this.barmasterText.getString("TEXT_KARTICA"), new Object[0]));
        tc13.pack();
        TableColumn tc14 = new TableColumn(this.table, 0x1000000);
        tc14.setText(String.format(this.barmasterText.getString("TEXT_FAKTURA"), new Object[0]));
        tc14.pack();
        TableColumn tc16 = new TableColumn(this.table, 0x1000000);
        tc16.setText(String.format(this.barmasterText.getString("TEXT_ZATVOREN"), new Object[0]));
        tc16.setWidth(40);
        TableColumn tc10 = new TableColumn(this.table, 0x1000000);
        tc10.setText(String.format(this.barmasterText.getString("TEXT_GOST"), new Object[0]));
        tc10.pack();
        TableColumn tc11 = new TableColumn(this.table, 16384);
        tc11.setText(String.format(this.barmasterText.getString("TEXT_ARTIKLI"), new Object[0]));
        tc11.setWidth(100);
    }

    private void insertRows() {
    }

    public Map makeMap() {
        HashMap<NacinPlacanja, Double> mapa = new HashMap<NacinPlacanja, Double>();
        mapa.put(NacinPlacanja.GOTOVINA, 0.0);
        mapa.put(NacinPlacanja.CEK, 0.0);
        mapa.put(NacinPlacanja.KARTICA, 0.0);
        mapa.put(NacinPlacanja.FAKTURA, 0.0);
        return mapa;
    }

    public static class PregledMeniPrometaInput {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo meni;
        private Combo konobar;
        Konobar k;
        Meni m;
        NacinPlacanja np = null;
        List<Meni> menus;
        List<Konobar> konobari;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        private Shell shell;

        public PregledMeniPrometaInput(Shell shellica, Restoran r, boolean inspektor) {
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.menus = this.server.getAllMenus();
            this.konobari = this.server.readKonobar();
            this.shell = shellica;
            this.shell.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_PROMETA_MENIJA"), new Object[0]));
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_PROMETA_MENIJA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(4, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(this.barmasterText.getString("TEXT_MENI"), new Object[0]) + ":");
            this.meni = new Combo((Composite)grupa2, 8);
            this.meni.add(String.format(this.barmasterText.getString("TEXT_SVI_MENIJI"), new Object[0]));
            for (Meni men : this.menus) {
                this.meni.add(men.getNaziv());
            }
            this.meni.select(0);
            for (int i = 0; i < NacinPlacanja.values().length; ++i) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(NacinPlacanja.values()[i].getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    if (cp.getNaziv().equals("Medjuzbir")) continue;
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.meni.setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
        }

        private void cancel() {
            this.shell.dispose();
        }

        private void ok() {
            try {
                Date day1 = this.odDatuma.getResult();
                Date day2 = this.doDatuma.getResult();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                ArrayList<String> crna = new ArrayList<String>();
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                this.m = this.meni.getSelectionIndex() == 0 ? null : this.menus.get(this.meni.getSelectionIndex() - 1);
                this.server.log(String.format(this.barmasterText.getString("LOG_PREGLED_PROMETA_MENIJA"), new Object[0]) + ": " + String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + " -> " + StatLogic.getDateString(day1) + " " + String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.shell, 1264);
                shell2.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_PROMETA_MENIJA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day1) + " -> " + StatLogic.getDateString(day2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledMeniPrometa(this.shell, this.restoran, day1, day2, this.m, bela, crna);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.shell, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

