/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.EvidencijaZaposlenih;
import com.dev63.restoran.model.GrupaZaposlenih;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PregledDolazakaZaposlenih {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    SWTContainer parent;
    Shell shell;
    Composite composite;
    List<String> zaposleni = new ArrayList<String>();
    Map<String, Integer> mapa = new HashMap<String, Integer>();
    Map<String, Double> mapa2 = new HashMap<String, Double>();
    MenuItem item1;
    Date day1;
    Date day2;
    String z;
    GrupaZaposlenih grupa;
    boolean sumarno;
    Color red;

    private PregledDolazakaZaposlenih(SWTContainer owner, Restoran r, final Date day1, final Date day2, GrupaZaposlenih g1, String z1, boolean sum) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.parent = owner;
        this.shell = this.parent.getControl().getShell();
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout());
        this.red = this.shell.getDisplay().getSystemColor(19);
        this.day1 = day1;
        this.day2 = day2;
        this.z = z1;
        this.grupa = g1;
        this.sumarno = sum;
        if (this.grupa == null) {
            this.zaposleni = this.server.readZaposleni();
        } else if (this.z == null) {
            this.zaposleni = this.server.readZaposleni(this.grupa);
        } else {
            this.zaposleni.add(this.z);
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 120;
        data.heightHint = 50;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        printButton.setLayoutData((Object)gd);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledDolazakaZaposlenih.this.table), false, true, String.format(PregledDolazakaZaposlenih.this.barmasterText.getString("TEXT_PREGLED_DOLAZAKA_ZAPOSLENIH"), new Object[0]) + ": " + Konstante.getDate(day1) + "-->" + Konstante.getDate(day2), PregledDolazakaZaposlenih.this.shell, PregledDolazakaZaposlenih.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(PregledDolazakaZaposlenih.this.table, PregledDolazakaZaposlenih.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        if (!this.sumarno) {
            TableColumn tc1 = new TableColumn(this.table, 131072);
            tc1.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
            tc1.setWidth(90);
            TableColumn tc2 = new TableColumn(this.table, 131072);
            tc2.setText(String.format(this.barmasterText.getString("TEXT_IME_I_PREZIME"), new Object[0]));
            tc2.setWidth(150);
            TableColumn tc9 = new TableColumn(this.table, 131072);
            tc9.setText(String.format(this.barmasterText.getString("TEXT_DOLAZAK"), new Object[0]));
            tc9.setWidth(120);
            TableColumn tc3 = new TableColumn(this.table, 131072);
            tc3.setText(String.format(this.barmasterText.getString("TEXT_ODLAZAK"), new Object[0]));
            tc3.setWidth(120);
            TableColumn tc4 = new TableColumn(this.table, 131072);
            tc4.setText(String.format(this.barmasterText.getString("TEXT_CENA_RADNOG_SATA"), new Object[0]));
            tc4.setWidth(80);
        } else {
            TableColumn tc5 = new TableColumn(this.table, 131072);
            tc5.setText(String.format(this.barmasterText.getString("TEXT_IME_I_PREZIME"), new Object[0]));
            tc5.setWidth(120);
            TableColumn tc6 = new TableColumn(this.table, 131072);
            tc6.setText(String.format(this.barmasterText.getString("TEXT_MINUTA_UKUPNO"), new Object[0]));
            tc6.setWidth(90);
            TableColumn tc7 = new TableColumn(this.table, 131072);
            tc7.setText(String.format(this.barmasterText.getString("TEXT_CENA_SATA_PO_MINUTU"), new Object[0]));
            tc7.setWidth(90);
            TableColumn tc12 = new TableColumn(this.table, 131072);
            tc12.setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
            tc12.setWidth(120);
        }
    }

    public void insertRows() {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(this.day1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(this.day2);
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        int brojDana = c2.get(6) - c1.get(6);
        for (int i = 0; i < brojDana + 1; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(this.day1);
            c.set(6, c.get(6) + i);
            Date d = c.getTime();
            if (!this.sumarno) {
                new TableItem(this.table, 16384).setText(Konstante.getDate(d));
            }
            for (EvidencijaZaposlenih e : this.server.readEvidencijaZaposlenih(d)) {
                if (!this.zaposleni.contains(e.getIme())) continue;
                if (!this.sumarno) {
                    TableItem ti = new TableItem(this.table, 0x1000000);
                    ti.setText(new String[]{"", e.getIme(), Konstante.getFullFormat(e.getDolazak()), e.getOdlazak() != null ? Konstante.getFullFormat(e.getOdlazak()) : "/", Konstante.getNumber2(e.getCenaSata())});
                    if (!e.isOdjavljen()) {
                        ti.setBackground(this.red);
                    }
                }
                calendar1.setTime(e.getDolazak());
                if (e.getOdlazak() != null) {
                    calendar2.setTime(e.getOdlazak());
                } else {
                    calendar2.setTime(new Date());
                }
                long milliseconds1 = calendar1.getTimeInMillis();
                long milliseconds2 = calendar2.getTimeInMillis();
                long diff = milliseconds2 - milliseconds1;
                int diffMinutes = (int)(diff / 60000L);
                if (this.mapa.get(e.getIme()) != null) {
                    int l = this.mapa.get(e.getIme());
                    this.mapa.put(e.getIme(), l + diffMinutes);
                    this.mapa2.put(e.getIme(), this.mapa2.get(e.getIme()) + (double)diffMinutes * (e.getCenaSata() / 60.0));
                    continue;
                }
                this.mapa.put(e.getIme(), diffMinutes);
                this.mapa2.put(e.getIme(), (double)diffMinutes * (e.getCenaSata() / 60.0));
            }
        }
        new TableItem(this.table, 0);
        new TableItem(this.table, 0);
        if (!this.sumarno) {
            new TableItem(this.table, 0).setText(new String[]{String.format(this.barmasterText.getString("TEXT_IME_I_PREZIME"), new Object[0]), String.format(this.barmasterText.getString("TEXT_UKUPNO_RADNIH_MINUTA"), new Object[0]), String.format(this.barmasterText.getString("TEXT_UKUPNA_VREDNOST"), new Object[0])});
        }
        for (String s : this.mapa.keySet()) {
            new TableItem(this.table, 16384).setText(new String[]{s, this.mapa.get(s).toString(), Konstante.getNumber2(this.mapa2.get(s))});
        }
    }

    public static class PregledDolazakaZaposlenihInput2 {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupa;
        private Combo zap;
        private Button sumarno;
        GrupaZaposlenih g;
        String z;
        boolean sum;
        Date d1;
        Date d2;
        List<GrupaZaposlenih> grupe;
        List<String> zaposleni;
        SWTContainer parent;

        public PregledDolazakaZaposlenihInput2(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.grupe = this.server.getGrupeZaposlenih();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_DOLAZAKA_ZAPOSLENIH"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText(String.format(this.barmasterText.getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
            Button uputstvo = new Button(panel1, 8);
            Image manImg = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif");
            uputstvo.setImage(manImg);
            uputstvo.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)manImg));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label label1 = new Label((Composite)grupa2, 0);
            label1.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_GRUPE"), new Object[0]) + ":");
            this.grupa = new Combo((Composite)grupa2, 2572);
            Label label2 = new Label((Composite)grupa2, 0);
            label2.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_ZAPOSLENOG"), new Object[0]) + ": ");
            this.zap = new Combo((Composite)grupa2, 2568);
            this.grupa.add(String.format(this.barmasterText.getString("TEXT_SVE_GRUPE"), new Object[0]));
            for (GrupaZaposlenih gz : this.grupe) {
                this.grupa.add(gz.getNaziv());
            }
            this.grupa.select(0);
            this.grupa.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (grupa.getSelectionIndex() > 0) {
                        GrupaZaposlenih gz = grupe.get(grupa.getSelectionIndex() - 1);
                        zaposleni = server.readZaposleni(gz);
                        zap.removeAll();
                        zap.add(String.format(barmasterText.getString("TEXT_SVI_ZAPOSLENI"), new Object[0]));
                        for (String z : zaposleni) {
                            zap.add(z);
                        }
                        zap.select(0);
                    }
                }
            });
            Label s = new Label((Composite)grupa2, 64);
            s.setText(String.format(this.barmasterText.getString("TEXT_SUMARNO_ZAPOSLENI"), new Object[0]));
            this.sumarno = new Button((Composite)grupa2, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            label1.setLayoutData((Object)data);
            label2.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.zap.setLayoutData((Object)data);
            this.grupa.setLayoutData((Object)data);
            this.sumarno.setLayoutData((Object)data);
            s.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.d1 = this.odDatuma.getResult();
                this.d2 = this.doDatuma.getResult();
                this.sum = this.sumarno.getSelection();
                if (this.grupa.getSelectionIndex() == 0) {
                    this.g = null;
                    this.z = null;
                } else {
                    this.g = this.grupe.get(this.grupa.getSelectionIndex() - 1);
                    this.z = this.zap.getSelectionIndex() == 0 ? null : this.zaposleni.get(this.zap.getSelectionIndex() - 1);
                }
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_DOLAZAKA_ZAPOSLENIH_ZA_PERIOD"), new Object[0]) + ": " + Konstante.getDate(this.d1) + " -> " + Konstante.getDate(this.d2));
                SWTContainer parent2 = new SWTContainer((Composite)shell2);
                new PregledDolazakaZaposlenih(parent2, this.restoran, this.d1, this.d2, this.g, this.z, this.sum);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

