/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.LogRecord;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PregledDnevnika {
    Restoran restoran;
    private RestoranServer server;
    public SWTContainer parent;
    Shell shell;

    private PregledDnevnika(Shell s, Restoran rest, final Date day, final Date day2) {
        this.restoran = rest;
        this.server = this.restoran.getServer();
        this.shell = s;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, true));
        this.shell.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_DNEVNIKA"), new Object[0]));
        List<LogRecord> list = this.server.dnevnikZaDane(day, day2);
        final Table table = new Table((Composite)this.shell, 768);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        tc1.setWidth(90);
        TableColumn tc2 = new TableColumn(table, 0);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_VREME"), new Object[0]));
        tc2.setWidth(60);
        TableColumn tc3 = new TableColumn(table, 0);
        tc3.setText(String.format(Konstante.getBundle().getString("TEXT_KORISNIK"), new Object[0]));
        tc3.setWidth(80);
        TableColumn tc4 = new TableColumn(table, 0);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_ZAPIS"), new Object[0]));
        tc4.setWidth(500);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        data = new GridData(16384, 0x1000000, true, false);
        data.widthHint = 120;
        data.heightHint = 50;
        Button printButton = new Button((Composite)this.shell, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setLayoutData((Object)data);
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_DNEVNIKA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(day) + " --> " + StatLogic.getDateString(day2), PregledDnevnika.this.shell, PregledDnevnika.this.server);
            }
        });
        data = new GridData(131072, 0x1000000, true, false);
        data.widthHint = 120;
        data.heightHint = 50;
        Button exitButton = new Button((Composite)this.shell, 8);
        exitButton.setLayoutData((Object)data);
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledDnevnika.this.shell.dispose();
            }
        });
        for (LogRecord lr : list) {
            new TableItem(table, 0).setText(new String[]{Konstante.getDate(lr.getDan()), Konstante.getTime(lr.getVreme()), lr.getUname(), lr.getWhat()});
        }
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public static class PregledDnevnikaInput2 {
        private DateInput2 datum;
        private DateInput2 doDatuma;
        Restoran hostel;
        private RestoranServer server;
        public SWTContainer parent;
        public Shell shell;
        private Text reci;

        public PregledDnevnikaInput2(SWTContainer parent, Restoran hostel) {
            this.parent = parent;
            this.hostel = hostel;
            this.server = hostel.getServer();
            this.shell = parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/dnevnikV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 664 - slika.getImage().getBounds().width;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_DNEVNIKA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.datum = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.shell));
            Label doL = new Label((Composite)grupa1, 0);
            doL.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            doL.setLayoutData((Object)data);
            od.setLayoutData((Object)data);
            this.datum.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                Date day = this.datum.getResult();
                Date day2 = this.doDatuma.getResult();
                this.server.log(String.format(Konstante.getBundle().getString("TEXT_PREGLED_DNEVNIKA"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + StatLogic.getDateString(day) + " -> " + String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + StatLogic.getDateString(day2));
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new PregledDnevnika(shell2, this.hostel, day, day2);
            }
            catch (Exception ex) {
                Konstante.getPoruka(this.shell, ex.getMessage());
            }
        }
    }
}

