/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.io.InputStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PoslovnaKnjigaUgostitelja
extends Shell {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private RestoranServer server;
    Composite mainComposite;
    private DateInput2 datum;

    public PoslovnaKnjigaUgostitelja(SWTContainer owner, Restoran r) {
        super(65536);
        this.server = r.getServer();
        this.setParent(owner.getComposite());
        this.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)this.getShell(), 768);
        this.mainComposite = new Composite((Composite)sc, 0);
        sc.setContent((Control)this.mainComposite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.mainComposite.setLayout((Layout)new GridLayout(4, false));
        Label slika = new Label(this.mainComposite, 0);
        Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
        slika.setImage(img);
        Group grpDnevniList = new Group(this.mainComposite, 0);
        GridData gd_grpDnevniList = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_grpDnevniList.widthHint = 200;
        gd_grpDnevniList.minimumWidth = 200;
        grpDnevniList.setLayoutData((Object)gd_grpDnevniList);
        grpDnevniList.setText("Poslovna knjiga ugotitelja");
        Group grpIzborDatuma = new Group(this.mainComposite, 0);
        grpIzborDatuma.setLayout((Layout)new GridLayout(4, false));
        GridData gd_grpIzborDatuma = new GridData(4, 0x1000000, false, false, 4, 1);
        gd_grpIzborDatuma.heightHint = 50;
        gd_grpIzborDatuma.widthHint = 670;
        grpIzborDatuma.setLayoutData((Object)gd_grpIzborDatuma);
        grpIzborDatuma.setText("Izbor datuma");
        Label lblIzborDatuma = new Label((Composite)grpIzborDatuma, 0);
        lblIzborDatuma.setBounds(0, 0, 55, 15);
        lblIzborDatuma.setText("Za datum:");
        new Label((Composite)grpIzborDatuma, 0);
        this.datum = new DateInput2((Composite)grpIzborDatuma, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        new Label((Composite)grpIzborDatuma, 0);
        new Label((Composite)grpIzborDatuma, 0);
        Group grupa3 = new Group(this.mainComposite, 0);
        grupa3.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grupa3 = new GridData(4, 0x1000000, false, false, 4, 1);
        gd_grupa3.heightHint = 50;
        grupa3.setLayoutData((Object)gd_grupa3);
        this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, this.getShell()));
        Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
        cancelButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PoslovnaKnjigaUgostitelja.this.cancel();
            }
        });
        Button okButt = Dugmici.getOkButton((Composite)grupa3);
        okButt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PoslovnaKnjigaUgostitelja.this.ok();
            }
        });
        this.createContents();
        this.mainComposite.layout();
        sc.setMinSize(this.mainComposite.computeSize(-1, -1));
        SWTContainerClass.setDimension(this.getShell());
        this.getShell().open();
    }

    protected void createContents() {
        this.setText("Poslovna knjiga ugostitelja");
        this.setSize(709, 437);
    }

    protected void checkSubclass() {
    }

    private void cancel() {
        this.dispose();
    }

    private void ok() {
        if (!this.server.hasProcedure("kpu_knjiga")) {
            this.server.createProcedureKpu_Knjiga();
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.datum.getResult());
            int year = cal.get(1);
            hm.put("title", "POSLOVNA KNJIGA U UGOSTITELJSKIM OBJEKTIMA\nZa godinu " + String.valueOf(year));
            hm.put("godina", year);
            hm.put("DatumKPU", new SimpleDateFormat("yyyy-MM-dd").format(this.datum.getResult()));
            hm.put("naziv", this.server.getSetting(Option.PREDUZECE_NAZIV).stringValue() + " - " + this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE).stringValue());
            hm.put("objekat", this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue());
            hm.put("objekatAdresa", this.server.getSetting(Option.OBJEKAT_ADRESA).stringValue());
            hm.put("objekatMesto", this.server.getSetting(Option.OBJEKAT_MESTO).stringValue());
            hm.put("objekatPib", this.server.getSetting(Option.OBJEKAT_PIB).stringValue());
            Connection con = this.server.getConnection();
            InputStream report = PrometSvihKonobara.class.getClassLoader().getResourceAsStream("com/dev63/restoran/reports/templates/PoslovnaKnjigaUgostitelja.jasper");
            JasperPrint jprint = JasperFillManager.fillReport((InputStream)report, hm, (Connection)con);
            if (jprint.getPages().isEmpty()) {
                SWTOptionPane.showMessageDialog(this.getShell(), (Object)"Nema podataka za izabrani dan.", "Prazan dokument.", 2);
            } else {
                JasperViewer.viewReport((JasperPrint)jprint, (boolean)false);
            }
        }
        catch (InputException | JRException ex) {
            ex.printStackTrace();
            SWTOptionPane.showMessageDialog(this.getShell(), (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
        }
    }
}

