/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.sistem.IzborPodgrua2;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MaloprodajniCenovnik {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    static List<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
    List<GrupaArtikala> grupe = new ArrayList<GrupaArtikala>();
    Button printButton4;
    boolean poPodgrupama;
    boolean saNabavnimCenama;
    Map<PodgrupaArtikala, Double> mapaPG = new HashMap<PodgrupaArtikala, Double>();

    private MaloprodajniCenovnik(Shell s, Restoran r, boolean saNabavnimCenama) {
        this.poPodgrupama = podgrupe.size() > 0;
        this.saNabavnimCenama = saNabavnimCenama;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = s;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setText(String.format(Konstante.getBundle().getString("TEXT_MALOPRODAJNI_CENOVNIK"), new Object[0]));
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 5;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite cc = new Composite((Composite)this.shell, 0);
        cc.setLayoutData((Object)new GridData(4, 4, true, false));
        cc.setLayout((Layout)new GridLayout(6, false));
        GridData rd = new GridData(120, 50);
        Button printButton = new Button(cc, 8);
        printButton.setImage(ImageCache.getImage("print.gif"));
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PrintHandler ph = new PrintHandler(9, true, true);
                GridPrinter gp = new GridPrinter(ph);
                gp.printTable(new TableWrapper(MaloprodajniCenovnik.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_MALOPRODAJNI_CENOVNIK"), new Object[0]), MaloprodajniCenovnik.this.shell, MaloprodajniCenovnik.this.server);
            }
        });
        printButton.setLayoutData((Object)rd);
        Button export = new Button(cc, 8);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(MaloprodajniCenovnik.this.table, MaloprodajniCenovnik.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)rd);
        Button izlaz = new Button(cc, 8);
        rd = new GridData(120, 50);
        rd.horizontalAlignment = 131072;
        rd.grabExcessHorizontalSpace = true;
        izlaz.setLayoutData((Object)rd);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MaloprodajniCenovnik.this.shell.close();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc1 = new TableColumn(this.table, 16384);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_ARTIKAL"), new Object[0]));
        tc1.setWidth(250);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_PRODAJNA_CENA_SKR"), new Object[0]));
        tc2.setWidth(100);
        if (this.saNabavnimCenama) {
            TableColumn tc3 = new TableColumn(this.table, 131072);
            tc3.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_PO_JEDINICI_MERE_SKR"), new Object[0]));
            tc3.setWidth(100);
            tc3.pack();
            TableColumn tc31 = new TableColumn(this.table, 131072);
            tc31.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_PO_JEDINICI_MERE_SKR_PDV"), new Object[0]));
            tc31.setWidth(100);
            tc31.pack();
            TableColumn tc4 = new TableColumn(this.table, 131072);
            tc4.setText(String.format(Konstante.getBundle().getString("TEXT_NABAVNA_CENA_PO_NORMATIV_MERI_SKR"), new Object[0]));
            tc4.setWidth(100);
            tc4.pack();
        }
    }

    public void insertRows() {
        boolean poPosCenama = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA).booleanValue();
        boolean poPosCenamaKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO).booleanValue();
        System.out.println("poPosCenama " + poPosCenama);
        System.out.println("poPosCenamaKombo " + poPosCenamaKombo);
        if (this.poPodgrupama) {
            Comparator<PodgrupaArtikala> SENIORITY_ORDER = null;
            SENIORITY_ORDER = new Comparator<PodgrupaArtikala>(){

                @Override
                public int compare(PodgrupaArtikala t1, PodgrupaArtikala t2) {
                    return t1.getNaziv().compareTo(t2.getNaziv());
                }
            };
            Collections.sort(podgrupe, SENIORITY_ORDER);
            for (PodgrupaArtikala pg : podgrupe) {
                TableItem ti = new TableItem(this.table, 16384);
                ti.setText(pg.getNaziv());
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
                for (Artikal a : this.server.readArtikalByPgNoBlocked(pg)) {
                    ti = new TableItem(this.table, 131072);
                    String[] tiText = new String[this.saNabavnimCenama ? 5 : 2];
                    tiText[0] = a.getName();
                    tiText[1] = Konstante.getNumber2(a.getCena());
                    if (this.saNabavnimCenama) {
                        double porez;
                        double ncPoJMTmp;
                        Double kolicina;
                        Artikal sastojak;
                        double ncPoNM;
                        double ncPoJM;
                        double ncPoJMpdv = 0.0;
                        if (a.getTip() == TipArtikla.SLOZ) {
                            ncPoJM = 0.0;
                            ncPoNM = 0.0;
                            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziArtikal(a, 1.0, this.server, new Date());
                            for (Map.Entry<Artikal, Double> entry : mapa.entrySet()) {
                                sastojak = entry.getKey();
                                kolicina = entry.getValue();
                                ncPoJMTmp = kolicina * (poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(sastojak) : this.server.getLastNabavnaCenaBelaBezPDV(sastojak, new Date())) : sastojak.getTrenutnaNV());
                                ncPoJM += ncPoJMTmp;
                                ncPoNM += ncPoJMTmp * a.getMera();
                            }
                            porez = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                            ncPoJMpdv = ncPoJM * porez;
                            tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                            tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                            tiText[4] = ncPoNM > 0.0 ? Konstante.getNumber2(ncPoNM) : "";
                        } else if (a.getTip() == TipArtikla.POLU) {
                            ncPoJM = 0.0;
                            ncPoNM = 0.0;
                            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziArtikalPoluproizvod(a, 1.0, this.server, new Date());
                            for (Map.Entry<Artikal, Double> entry : mapa.entrySet()) {
                                sastojak = entry.getKey();
                                kolicina = entry.getValue();
                                ncPoJMTmp = kolicina * (poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(sastojak) : this.server.getLastNabavnaCenaBelaBezPDV(sastojak, new Date())) : sastojak.getTrenutnaNV());
                                ncPoJM += ncPoJMTmp;
                                ncPoNM += ncPoJMTmp * a.getMera();
                            }
                            porez = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                            ncPoJMpdv = ncPoJM * porez;
                            tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                            tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                            tiText[4] = ncPoNM > 0.0 ? Konstante.getNumber2(ncPoNM) : "";
                        } else {
                            ncPoJM = poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) : a.getTrenutnaNV();
                            double porez2 = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                            ncPoJMpdv = ncPoJM * porez2;
                            double ncPoNM2 = ncPoJM * a.getMera();
                            tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                            tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                            tiText[4] = ncPoNM2 > 0.0 ? Konstante.getNumber2(ncPoNM2) : "";
                        }
                    }
                    ti.setText(tiText);
                    ti.setFont(FontCache.getFont("Arial", 7, 0));
                }
            }
        } else {
            for (GrupaArtikala ga : this.server.readGrupeNazivPrikazNaEkran()) {
                TableItem ti = new TableItem(this.table, 16384);
                ti.setText(ga.getNaziv());
                ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
                for (PodgrupaArtikala pg : this.server.readPodgrupeArtikala(ga)) {
                    ti = new TableItem(this.table, 16384);
                    ti.setText(pg.getNaziv());
                    ti.setFont(Konstante.getFont(this.shell.getDisplay(), 9, 1));
                    for (Artikal a : this.server.ArtikliZaFO(pg)) {
                        double ncPoJMpdv = 0.0;
                        ti = new TableItem(this.table, 131072);
                        String[] tiText = new String[this.saNabavnimCenama ? 5 : 2];
                        tiText[0] = a.getName();
                        tiText[1] = Konstante.getNumber2(a.getCena());
                        if (this.saNabavnimCenama) {
                            double porez;
                            double ncPoJMTmp;
                            Double kolicina;
                            Artikal sastojak;
                            double ncPoNM;
                            double ncPoJM;
                            if (a.getTip() == TipArtikla.SLOZ) {
                                ncPoJM = 0.0;
                                ncPoNM = 0.0;
                                Map<Artikal, Double> mapa = SkidanjeNormativa.razloziArtikal(a, 1.0, this.server, new Date());
                                for (Map.Entry<Artikal, Double> entry : mapa.entrySet()) {
                                    sastojak = entry.getKey();
                                    kolicina = entry.getValue();
                                    ncPoJMTmp = kolicina * (poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(sastojak) : this.server.getLastNabavnaCenaBela(sastojak, new Date())) : sastojak.getTrenutnaNV());
                                    ncPoJM += ncPoJMTmp;
                                    ncPoNM += ncPoJMTmp * a.getMera();
                                }
                                porez = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                                ncPoJMpdv = ncPoJM * porez;
                                tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                                tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                                tiText[4] = ncPoNM > 0.0 ? Konstante.getNumber2(ncPoNM) : "";
                            } else if (a.getTip() == TipArtikla.POLU) {
                                ncPoJM = 0.0;
                                ncPoNM = 0.0;
                                Map<Artikal, Double> mapa = SkidanjeNormativa.razloziArtikalPoluproizvod(a, 1.0, this.server, new Date());
                                for (Map.Entry<Artikal, Double> entry : mapa.entrySet()) {
                                    sastojak = entry.getKey();
                                    kolicina = entry.getValue();
                                    ncPoJMTmp = kolicina * (poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(sastojak) : this.server.getLastNabavnaCenaBela(sastojak, new Date())) : sastojak.getTrenutnaNV());
                                    ncPoJM += ncPoJMTmp;
                                    ncPoNM += ncPoJMTmp * a.getMera();
                                }
                                porez = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                                ncPoJMpdv = ncPoJM * porez;
                                tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                                tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                                tiText[4] = ncPoNM > 0.0 ? Konstante.getNumber2(ncPoNM) : "";
                            } else {
                                ncPoJM = poPosCenama ? (poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV();
                                double porez3 = a.getPoreskaGrupa().getMetalinkCode() == 3 ? 1.2 : 1.1;
                                ncPoJMpdv = ncPoJM * porez3;
                                double ncPoNM3 = ncPoJM * a.getMera();
                                tiText[2] = ncPoJM > 0.0 ? Konstante.getNumber2(ncPoJM) : "";
                                tiText[3] = ncPoJMpdv > 0.0 ? Konstante.getNumber2(ncPoJMpdv) : "";
                                tiText[4] = ncPoNM3 > 0.0 ? Konstante.getNumber2(ncPoNM3) : "";
                            }
                        }
                        ti.setText(tiText);
                        ti.setFont(FontCache.getFont("Arial", 7, 0));
                    }
                }
                ti = new TableItem(this.table, 0);
            }
        }
    }

    public static class MaloprodajniCenovnikInput {
        private Restoran restoran;
        private RestoranServer server;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        Shell shell;
        Label bp;
        final Button bSaNC;

        public MaloprodajniCenovnikInput(SWTContainer owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_MALOPRODAJNI_CENOVNIK"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 160;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            final String brIzbPodg = String.format(Konstante.getBundle().getString("TEXT_BROJ_IZABRANIH_PODGRUPA"), new Object[0]);
            Button izborPodgrupa = new Button((Composite)grupa2, 8);
            izborPodgrupa.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_PODGRUPA"), new Object[0]));
            izborPodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    podgrupe = new ArrayList<PodgrupaArtikala>();
                    IzborPodgrua2 ip = new IzborPodgrua2(shell.getDisplay(), restoran);
                    podgrupe = ip.getPodgrupe();
                    bp.setText(brIzbPodg + ": " + podgrupe.size());
                }
            });
            this.bp = new Label((Composite)grupa2, 0);
            this.bp.setText(brIzbPodg + ": " + podgrupe.size());
            Button brisanjePodgrupa = new Button((Composite)grupa2, 8);
            brisanjePodgrupa.setText(String.format(Konstante.getBundle().getString("TEXT_PONISTI_IZBOR_PODGRUPA"), new Object[0]));
            brisanjePodgrupa.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    podgrupe = new ArrayList<PodgrupaArtikala>();
                    bp.setText(brIzbPodg + ": " + podgrupe.size());
                }
            });
            Label emp = new Label((Composite)grupa2, 0);
            Label sep = new Label((Composite)grupa2, 258);
            GridData sepGD = new GridData(768);
            sepGD.horizontalSpan = 2;
            sep.setLayoutData((Object)sepGD);
            this.bSaNC = new Button((Composite)grupa2, 32);
            this.bSaNC.setText(String.format(Konstante.getBundle().getString("TEXT_SA_NABAVNIM_CENAMA"), new Object[0]));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
            new MaloprodajniCenovnik(shell2, this.restoran, this.bSaNC.getSelection());
        }
    }
}

