/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.PreostalaKolicina;
import com.dev63.restoran.sistem.XLSExporter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListaMinimumaZaliha {
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    Composite composite;
    Composite composite2;
    boolean sviArtikli;
    boolean isBelo;
    boolean isCrno;
    List<Artikal> artikli2 = new ArrayList<Artikal>();
    private Map<Long, Artikal> artikli;

    private ListaMinimumaZaliha(Shell s, Restoran r, Odeljenje od, boolean svi, boolean belo, boolean crno) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shell = s;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.sviArtikli = svi;
        this.isBelo = belo;
        this.isCrno = crno;
        if (!belo && !crno) {
            return;
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        try {
            this.insertRows(od);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ListaMinimumaZaliha.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(ListaMinimumaZaliha.class.getName()).log(Level.SEVERE, null, ex);
        }
        Composite control = new Composite((Composite)this.shell, 0);
        control.setLayout((Layout)new GridLayout(3, false));
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 8, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control, 8);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setLayoutData((Object)gd);
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(ListaMinimumaZaliha.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_LISTA_MINIMUMA_ZALIHA"), new Object[0]), ListaMinimumaZaliha.this.shell, ListaMinimumaZaliha.this.server);
            }
        });
        Button export = new Button(control, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(ListaMinimumaZaliha.this.table, ListaMinimumaZaliha.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button exitButton = new Button(control, 8);
        GridData gd1 = new GridData(131072, 8, true, false);
        gd1.heightHint = 50;
        gd1.widthHint = 150;
        gd1.horizontalAlignment = 131072;
        exitButton.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        exitButton.setLayoutData((Object)gd1);
        exitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListaMinimumaZaliha.this.shell.dispose();
            }
        });
        this.table.pack();
        this.shell.setMaximized(true);
        this.shell.open();
    }

    public void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV_ODELJENJA"), new Object[0]));
        tc0.pack();
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
        tc1.pack();
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_TRENUTNA_KOLICINA"), new Object[0]));
        tc2.pack();
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText(String.format(Konstante.getBundle().getString("TEXT_MINIMALNA_KOLICINA"), new Object[0]));
        tc3.pack();
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_RAZLIKA"), new Object[0]));
        tc4.pack();
    }

    public void insertRows(Odeljenje od) throws ClassNotFoundException, SQLException {
        double pk = 0.0;
        double mk = 0.0;
        double razlika = 0.0;
        List<Object> odeljenja = new ArrayList<Odeljenje>();
        if (od == null) {
            odeljenja = this.server.readOdeljenje();
        } else {
            odeljenja.add(od);
        }
        for (Odeljenje odeljenje : odeljenja) {
            this.artikli = this.server.getArtikliBezSlozOdeljenjeOrderedByNameJPA(odeljenje.getId());
            this.artikli2.clear();
            for (Artikal a : this.artikli.values()) {
                this.artikli2.add(a);
            }
            this.sortiraj(this.artikli2);
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(new String[]{odeljenje.getNaziv(), "", "", "", ""});
            for (Artikal a : this.artikli2) {
                if (this.isBelo && this.isCrno) {
                    pk = PreostalaKolicina.izracunajZalihe(a, odeljenje, this.server);
                } else if (this.isBelo && !this.isCrno) {
                    pk = PreostalaKolicina.izracunajZaliheB(a, odeljenje, this.server);
                } else if (!this.isBelo && this.isCrno) {
                    pk = PreostalaKolicina.izracunajZaliheC(a, odeljenje, this.server);
                }
                mk = a.getMinLager() != null ? a.getMinLager() : 0.0;
                razlika = pk - mk;
                if (this.sviArtikli) {
                    ti = new TableItem(this.table, 0);
                    ti.setText(new String[]{"", a.getName(), "" + pk, "" + mk, "" + razlika});
                    if (!(razlika <= 0.0)) continue;
                    ti.setForeground(this.shell.getDisplay().getSystemColor(3));
                    continue;
                }
                if (!(razlika <= 0.0)) continue;
                ti = new TableItem(this.table, 0);
                ti.setText(new String[]{"", a.getName(), "" + pk, "" + mk, "" + razlika});
                ti.setForeground(this.shell.getDisplay().getSystemColor(3));
            }
        }
    }

    public void sortiraj(List<Artikal> artikli) {
        Comparator<Artikal> SENIORITY_ORDER = null;
        SENIORITY_ORDER = new Comparator<Artikal>(){

            @Override
            public int compare(Artikal t1, Artikal t2) {
                return t1.getName().compareTo(t2.getName());
            }
        };
        Collections.sort(artikli, SENIORITY_ORDER);
    }

    public static class ListaMinimumaZalihaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupa;
        private Combo zap;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        Combo odeljenje;
        private Button artikli;
        private Button belo;
        private Button crno;
        SWTContainer parent2;
        Composite compo;
        private boolean magacinVidljiv;

        public ListaMinimumaZalihaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent2 = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.magacinVidljiv = Boolean.parseBoolean(this.server.getSetting(Option.MAGACIN_VIDLJIV).getActual());
            this.odeljenja = this.magacinVidljiv ? this.server.readOdeljenje() : this.server.readOdeljenjeBezMag();
            Shell shell = this.parent2.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/izvestajV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_LISTA_MINIMUMA_ZALIHA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa21 = null;
            grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(4, false));
            grupa21.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_STANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent3 = new SWTContainer((Composite)grupa2);
            Label art = new Label((Composite)grupa2, 0);
            art.setText(String.format(Konstante.getBundle().getString("TEXT_ODELJENJE"), new Object[0]) + ":");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add(String.format(Konstante.getBundle().getString("TEXT_SVA_PROIZVODNA_MESTA"), new Object[0]));
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            Label mi = new Label((Composite)grupa2, 0);
            mi.setText(String.format(Konstante.getBundle().getString("TEXT_SVI_ARTIKLI"), new Object[0]));
            this.artikli = new Button((Composite)grupa2, 32);
            this.belo = new Button((Composite)grupa21, 32);
            this.belo.setText(String.format(Konstante.getBundle().getString("TEXT_OSNOVNO_STANJE"), new Object[0]));
            this.belo.setSelection(true);
            if (inspektor) {
                this.crno = new Button((Composite)grupa21, 32);
                this.crno.setText(String.format(Konstante.getBundle().getString("TEXT_DODATNO_STANJE"), new Object[0]));
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            art.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent2.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                Shell shell2 = new Shell(this.parent2.getControl().getShell().getDisplay());
                new ListaMinimumaZaliha(shell2, this.restoran, this.o, this.artikli.getSelection(), this.belo.getSelection(), this.crno == null ? false : this.crno.getSelection());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SWTOptionPane.showMessageDialog(this.parent2, (Object)"Greska");
            }
        }
    }
}

