/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.NabavneCene;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.izvestaji.StanjeZalihaUtrosci;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Popis;
import com.dev63.restoran.model.StavkaPopisa;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.sistem.ZaliheUtrosciModel;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IzvestajOStanjuZalihaUtrosciServer {
    double pocetnoOsnovno = 0.0;
    double pocetnoDodatno = 0.0;
    double zavrsnoOsnovno = 0.0;
    double zavrsnoDodatno = 0.0;
    double ulazOsnovno = 0.0;
    double ulazDodatno = 0.0;
    double pocetno = 0.0;
    double zavrsno = 0.0;
    double ulaz = 0.0;
    double izlaz = 0.0;
    double ncJMbezPdvOsnovna = 0.0;
    double ncJMsaPdvOsnovna = 0.0;
    double pcOsnovna = 0.0;
    double pcOsnovnaBezPdv = 0.0;
    double ncJMbezPdvDodatna = 0.0;
    double ncJMsaPdvDodatna = 0.0;
    double pcDodatna = 0.0;
    double pcDodatnaBezPdv = 0.0;
    int ubacenArtikal;
    int ubArtikalOd;
    double nvPocetnoSaPdv = 0.0;
    double nvPocetnoBezPdv = 0.0;
    double nvUlazSaPdv = 0.0;
    double nvUlazBezPdv = 0.0;
    double nvIzlazSaPdv = 0.0;
    double nvIzlazBezPdv = 0.0;
    double nvZavrsnoSaPdv = 0.0;
    double nvZavrsnoBezPdv = 0.0;
    double pvSaPdv = 0.0;
    double pvBezPdv = 0.0;
    double totNvPocetnoSaPdv = 0.0;
    double totNvPocetnoBezPdv = 0.0;
    double totNvPocetnoSaPdvPo10 = 0.0;
    double totNvPocetnoSaPdvPo20 = 0.0;
    double totNvPocetnoBezPdvPo10 = 0.0;
    double totNvPocetnoBezPdvPo20 = 0.0;
    double totNvUlazSaPdv = 0.0;
    double totNvUlazBezPdv = 0.0;
    double totNvUlazSaPdvPo10 = 0.0;
    double totNvUlazSaPdvPo20 = 0.0;
    double totNvUlazBezPdvPo10 = 0.0;
    double totNvUlazBezPdvPo20 = 0.0;
    double totNvIzlazSaPdv = 0.0;
    double totNvIzlazBezPdv = 0.0;
    double totNvIzlazSaPdvPo10 = 0.0;
    double totNvIzlazSaPdvPo20 = 0.0;
    double totNvIzlazBezPdvPo10 = 0.0;
    double totNvIzlazBezPdvPo20 = 0.0;
    double totNvZavrsnoSaPdv = 0.0;
    double totNvZavrsnoBezPdv = 0.0;
    double totNvZavrsnoSaPdvPo10 = 0.0;
    double totNvZavrsnoSaPdvPo20 = 0.0;
    double totNvZavrsnoBezPdvPo10 = 0.0;
    double totNvZavrsnoBezPdvPo20 = 0.0;
    double totPvSaPdv = 0.0;
    double totPvBezPdv = 0.0;
    double totProdajnaVrSaPdvPo10 = 0.0;
    double totProdajnaVrSaPdvPo20 = 0.0;
    double totProdajnaVrBezPdvPo10 = 0.0;
    double totProdajnaVrBezPdvPo20 = 0.0;
    Map<String, Double> ncOsnovne;
    Map<String, Double> ncDodatne;
    Map<Integer, String> mapa;
    List<Popis> popisiOsnovno;
    List<Popis> popisiDodatno;
    private RestoranServer server;
    private Connection connection;
    private boolean colPocetno;
    private boolean colUlaz;
    private boolean colIzlaz;
    private boolean colZavrsno;
    private boolean barKod;
    private boolean finansijskiPrikaz;
    private boolean poPoslednjoj;
    private boolean promene;
    private boolean izbaciNulu;
    private Display display;
    private int[] osDodParam;

    public IzvestajOStanjuZalihaUtrosciServer(RestoranServer server, boolean colPocetno, boolean colUlaz, boolean colIzlaz, boolean colZavrsno, boolean barKod, boolean finansijskiPrikaz, boolean poPoslednjoj, boolean promene, boolean izbaciNulu, Display display, int[] osDodParam) {
        this.server = server;
        this.connection = server.getConnection();
        this.colPocetno = colPocetno;
        this.colUlaz = colUlaz;
        this.colIzlaz = colIzlaz;
        this.colZavrsno = colZavrsno;
        this.barKod = barKod;
        this.finansijskiPrikaz = finansijskiPrikaz;
        this.poPoslednjoj = poPoslednjoj;
        this.promene = promene;
        this.izbaciNulu = izbaciNulu;
        this.mapa = this.getMapaKolona();
        this.display = display;
        this.osDodParam = osDodParam;
    }

    public void popuniRedoveBezPodgrupa(java.util.Date day1, java.util.Date day2, Table table, Odeljenje o, boolean isBelo, boolean isCrno) {
        List<Artikal> artikliZaIvestaj = this.getArtikliZaliheBezPodgrupa(o, false);
        List<ZaliheUtrosciModel> redovi = StanjeZalihaUtrosci.getZalihePoUtroscima(this.connection, day1, day2, o, 0, -1);
        this.popisiOsnovno = this.getPopis(day1, day2, false, o);
        this.popisiDodatno = this.getPopis(day1, day2, true, o);
        this.ubacenArtikal = 0;
        this.resetujTotalNv();
        TableItem OdeljenjeItem = new TableItem(table, 0);
        String[] odeljenjeValues = new String[]{o.getNaziv()};
        OdeljenjeItem.setText(odeljenjeValues);
        Color colorRed = this.display.getSystemColor(3);
        Font font1 = new Font((Device)this.display, "Tahoma", 8, 1);
        for (Artikal artikal : artikliZaIvestaj) {
            if (isBelo) {
                this.getOsnovnaStanja(day1, day2, artikal, o);
                if (this.finansijskiPrikaz) {
                    this.getNabavneCeneOsnovne(artikal, day1, day2, false, o);
                }
            }
            if (isCrno) {
                this.getDodatnaStanja(day1, day2, artikal, o);
                if (this.finansijskiPrikaz) {
                    this.getNabavneCeneDodatne(artikal, day1, day2, true, o);
                }
            }
            this.sumirajDodatnoOsnovno();
            if (this.filterCheck(artikal, this.ulaz, this.izlaz, this.zavrsno)) continue;
            String[] values = isBelo && isCrno || isBelo ? this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvOsnovna, this.ncJMsaPdvOsnovna, this.pcOsnovna, this.pcOsnovnaBezPdv) : this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvDodatna, this.ncJMsaPdvDodatna, this.pcDodatna, this.pcDodatnaBezPdv);
            TableItem item = new TableItem(table, 0);
            if (this.zavrsno < 0.0) {
                item.setForeground(colorRed);
                item.setFont(font1);
            }
            item.setText(values);
            ++this.ubacenArtikal;
        }
        TableItem total = new TableItem(table, 0);
        if (this.finansijskiPrikaz) {
            String[] totalValues = this.getTotalValues("TOTAL:", table, this.totNvPocetnoSaPdv, this.totNvPocetnoBezPdv, this.totNvUlazSaPdv, this.totNvUlazBezPdv, this.totNvIzlazSaPdv, this.totNvIzlazBezPdv, this.totNvZavrsnoSaPdv, this.totNvZavrsnoBezPdv, this.totPvSaPdv, this.totPvBezPdv);
            total.setText(totalValues);
            String[] totalValues10 = this.getTotalValues("Po 10%", table, this.totNvPocetnoSaPdvPo10, this.totNvPocetnoBezPdvPo10, this.totNvUlazSaPdvPo10, this.totNvUlazBezPdvPo10, this.totNvIzlazSaPdvPo10, this.totNvIzlazBezPdvPo10, this.totNvZavrsnoSaPdvPo10, this.totNvZavrsnoBezPdvPo10, this.totProdajnaVrSaPdvPo10, this.totProdajnaVrBezPdvPo10);
            TableItem total10 = new TableItem(table, 0);
            total10.setText(totalValues10);
            String[] totalValues20 = this.getTotalValues("Po 20%", table, this.totNvPocetnoSaPdvPo20, this.totNvPocetnoBezPdvPo20, this.totNvUlazSaPdvPo20, this.totNvUlazBezPdvPo20, this.totNvIzlazSaPdvPo20, this.totNvIzlazBezPdvPo20, this.totNvZavrsnoSaPdvPo20, this.totNvZavrsnoBezPdvPo20, this.totProdajnaVrSaPdvPo20, this.totProdajnaVrBezPdvPo20);
            TableItem total20 = new TableItem(table, 0);
            total20.setText(totalValues20);
        }
        if (this.ubacenArtikal < 1) {
            table.remove(table.indexOf(OdeljenjeItem));
            table.remove(table.indexOf(total));
        }
    }

    public void popuniRedoveBezPodgrupaZbirno(java.util.Date day1, java.util.Date day2, Table table, boolean isBelo, boolean isCrno, List<Odeljenje> odeljenjaInput) {
        StringBuilder sb = new StringBuilder();
        List<Artikal> artikliZaIvestaj = this.getArtikliZaliheBezPodgrupa(null, true);
        for (Odeljenje o : odeljenjaInput) {
            sb.append(o.getNaziv());
            sb.append(", ");
        }
        TableItem OdeljenjeItem = new TableItem(table, 0);
        String[] odeljenjeValues = new String[]{sb.toString()};
        OdeljenjeItem.setText(odeljenjeValues);
        Color colorRed = this.display.getSystemColor(3);
        Font font1 = new Font((Device)this.display, "Tahoma", 8, 1);
        for (Artikal artikal : artikliZaIvestaj) {
            List<Odeljenje> odeljenjaArtikla = this.getOdeljenjaZaArtikal(artikal.getId());
            this.resetujStanje();
            for (Odeljenje o : odeljenjaArtikla) {
                this.popisiOsnovno = this.getPopis(day1, day2, false, o);
                this.popisiDodatno = this.getPopis(day1, day2, true, o);
                if (!odeljenjaInput.contains(o)) continue;
                if (isBelo) {
                    this.getOsnovnoZbirno(day1, day2, artikal, o);
                }
                if (!isCrno) continue;
                this.getDodatnoZbirno(day1, day2, artikal, o);
            }
            this.sumirajDodatnoOsnovno();
            if (this.filterCheck(artikal, this.ulaz, this.izlaz, this.zavrsno)) continue;
            String[] values = isBelo && isCrno || isBelo ? this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvOsnovna, this.ncJMsaPdvOsnovna, this.pcOsnovna, this.pcOsnovnaBezPdv) : this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvDodatna, this.ncJMsaPdvDodatna, this.pcDodatna, this.pcDodatnaBezPdv);
            TableItem item = new TableItem(table, 0);
            if (this.zavrsno < 0.0) {
                item.setForeground(colorRed);
                item.setFont(font1);
            }
            item.setText(values);
            ++this.ubacenArtikal;
        }
        if (this.ubacenArtikal < 1) {
            table.remove(table.indexOf(OdeljenjeItem));
        }
    }

    private List<Artikal> getArtikliZaliheBezPodgrupa(Odeljenje o, boolean zbirno) {
        String query = zbirno ? "SELECT a.id, a.name, a.jedinicaMere, a.barCode, a.tip, a.poreskaGrupa from artikal a  WHERE a.tiP NOT IN ('SLOZ', 'DODA') order by  a.name ;" : "SELECT a.id, a.name,a.jedinicaMere, a.barCode, a.tip, a.poreskaGrupa from artikal a WHERE a.id IN (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID =?)  AND a.tiP NOT IN ('SLOZ', 'DODA') order by field (tip,'PROD','POLU','SIRO'),name ";
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        try {
            PreparedStatement ps = this.connection.prepareStatement(query);
            if (!zbirno) {
                ps.setLong(1, o.getId());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Artikal artikal = this.server.getArtikal(rs.getLong("id"));
                artikli.add(artikal);
            }
            return artikli;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Odeljenje> getOdeljenjaZaArtikal(Long id) {
        String query = "SELECT * FROM artikal_odeljenje ao WHERE ao.ARTIKLI_ID = ?";
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Odeljenje o = this.server.getOdeljenje(rs.getLong("ODELJENJA_ID"));
                odeljenja.add(o);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return odeljenja;
    }

    public void popuniRedoveSaPodgrupama(java.util.Date day1, java.util.Date day2, Table table, Odeljenje o, boolean isBelo, boolean isCrno, List<PodgrupaArtikala> podgrupe) {
        Map<String, List<Artikal>> podgrupaArtikal = this.getArtikliZaliheSaPodgrupama(o, podgrupe, false);
        this.resetujTotalNv();
        this.ubArtikalOd = 0;
        this.popisiOsnovno = this.getPopis(day1, day2, false, o);
        this.popisiDodatno = this.getPopis(day1, day2, true, o);
        for (Map.Entry<String, List<Artikal>> e : podgrupaArtikal.entrySet()) {
            this.ubacenArtikal = 0;
            TableItem OdeljenjeItem = new TableItem(table, 0);
            String[] odeljenjeValues = new String[]{o.getNaziv() + " - " + e.getKey()};
            OdeljenjeItem.setText(odeljenjeValues);
            this.resetujNabavnevrednosti();
            Color colorRed = this.display.getSystemColor(3);
            Font font1 = new Font((Device)this.display, "Tahoma", 8, 1);
            for (Artikal artikal : e.getValue()) {
                if (isBelo) {
                    this.getOsnovnaStanja(day1, day2, artikal, o);
                    if (this.finansijskiPrikaz) {
                        this.getNabavneCeneOsnovne(artikal, day1, day2, false, o);
                    }
                }
                if (isCrno) {
                    this.getDodatnaStanja(day1, day2, artikal, o);
                    if (this.finansijskiPrikaz) {
                        this.getNabavneCeneDodatne(artikal, day1, day2, true, o);
                    }
                }
                this.sumirajDodatnoOsnovno();
                if (this.filterCheck(artikal, this.ulaz, this.izlaz, this.zavrsno)) continue;
                String[] values = isBelo && isCrno || isBelo ? this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvOsnovna, this.ncJMsaPdvOsnovna, this.pcOsnovna, this.pcOsnovnaBezPdv) : this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvDodatna, this.ncJMsaPdvDodatna, this.pcDodatna, this.pcDodatnaBezPdv);
                TableItem item = new TableItem(table, 0);
                item.setText(values);
                if (this.zavrsno < 0.0) {
                    item.setForeground(colorRed);
                    item.setFont(font1);
                }
                ++this.ubacenArtikal;
                ++this.ubArtikalOd;
            }
            TableItem totalPodgrupe = new TableItem(table, 0);
            TableItem prazanRed = new TableItem(table, 0);
            if (this.finansijskiPrikaz) {
                String[] totalPodgrupeValues = this.getTotalValues("UKUPNO:", table, this.nvPocetnoSaPdv, this.nvPocetnoBezPdv, this.nvUlazSaPdv, this.nvUlazBezPdv, this.nvIzlazSaPdv, this.nvIzlazBezPdv, this.nvZavrsnoSaPdv, this.nvZavrsnoBezPdv, this.pvSaPdv, this.pvBezPdv);
                totalPodgrupe.setText(totalPodgrupeValues);
            }
            if (this.ubacenArtikal >= 1) continue;
            table.remove(table.indexOf(OdeljenjeItem));
            table.remove(table.indexOf(totalPodgrupe));
            table.remove(table.indexOf(prazanRed));
        }
        if (this.finansijskiPrikaz) {
            String[] totalValues = this.getTotalValues("TOTAL:", table, this.totNvPocetnoSaPdv, this.totNvPocetnoBezPdv, this.totNvUlazSaPdv, this.totNvUlazBezPdv, this.totNvIzlazSaPdv, this.totNvIzlazBezPdv, this.totNvZavrsnoSaPdv, this.totNvZavrsnoBezPdv, this.totPvSaPdv, this.totPvBezPdv);
            TableItem total = new TableItem(table, 0);
            total.setText(totalValues);
            String[] totalValues10 = this.getTotalValues("Po 10%", table, this.totNvPocetnoSaPdvPo10, this.totNvPocetnoBezPdvPo10, this.totNvUlazSaPdvPo10, this.totNvUlazBezPdvPo10, this.totNvIzlazSaPdvPo10, this.totNvIzlazBezPdvPo10, this.totNvZavrsnoSaPdvPo10, this.totNvZavrsnoBezPdvPo10, this.totProdajnaVrSaPdvPo10, this.totProdajnaVrBezPdvPo10);
            TableItem total10 = new TableItem(table, 0);
            total10.setText(totalValues10);
            String[] totalValues20 = this.getTotalValues("Po 20%", table, this.totNvPocetnoSaPdvPo20, this.totNvPocetnoBezPdvPo20, this.totNvUlazSaPdvPo20, this.totNvUlazBezPdvPo20, this.totNvIzlazSaPdvPo20, this.totNvIzlazBezPdvPo20, this.totNvZavrsnoSaPdvPo20, this.totNvZavrsnoBezPdvPo20, this.totProdajnaVrSaPdvPo20, this.totProdajnaVrBezPdvPo20);
            TableItem total20 = new TableItem(table, 0);
            total20.setText(totalValues20);
            if (this.ubArtikalOd < 1) {
                table.remove(table.indexOf(total));
            }
        }
    }

    public void popuniRedoveSaPodgrupamaZbirno(java.util.Date day1, java.util.Date day2, Table table, boolean isBelo, boolean isCrno, List<PodgrupaArtikala> podgrupe) {
        Map<String, List<Artikal>> podgrupaArtikal = this.getArtikliZaliheSaPodgrupama(null, podgrupe, true);
        for (Map.Entry<String, List<Artikal>> e : podgrupaArtikal.entrySet()) {
            TableItem podgrupeItem = new TableItem(table, 0);
            String[] podgrupeValues = new String[]{e.getKey()};
            podgrupeItem.setText(podgrupeValues);
            this.ubacenArtikal = 0;
            Color colorRed = this.display.getSystemColor(3);
            Font font1 = new Font((Device)this.display, "Tahoma", 8, 1);
            for (Artikal artikal : e.getValue()) {
                List<Odeljenje> odeljenjaArtikla = this.getOdeljenjaZaArtikal(artikal.getId());
                this.resetujStanje();
                for (Odeljenje odeljenje : odeljenjaArtikla) {
                    this.popisiOsnovno = this.getPopis(day1, day2, false, odeljenje);
                    this.popisiDodatno = this.getPopis(day1, day2, true, odeljenje);
                    if (isBelo) {
                        this.getOsnovnoZbirno(day1, day2, artikal, odeljenje);
                    }
                    if (!isCrno) continue;
                    this.getDodatnoZbirno(day1, day2, artikal, odeljenje);
                }
                this.sumirajDodatnoOsnovno();
                if (this.filterCheck(artikal, this.ulaz, this.izlaz, this.zavrsno)) continue;
                String[] values = isBelo && isCrno || isBelo ? this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvOsnovna, this.ncJMsaPdvOsnovna, this.pcOsnovna, this.pcOsnovnaBezPdv) : this.getColumnValues(table, artikal, this.pocetno, this.ulaz, this.izlaz, this.zavrsno, this.ncJMbezPdvDodatna, this.ncJMsaPdvDodatna, this.pcDodatna, this.pcDodatnaBezPdv);
                TableItem item = new TableItem(table, 0);
                item.setText(values);
                item.setFont(font1);
                if (this.zavrsno < 0.0) {
                    item.setForeground(colorRed);
                }
                ++this.ubacenArtikal;
            }
            if (this.ubacenArtikal >= 1) continue;
            table.remove(table.indexOf(podgrupeItem));
        }
    }

    private Map<String, List<Artikal>> getArtikliZaliheSaPodgrupama(Odeljenje odeljenje, List<PodgrupaArtikala> podgrupe, boolean zbirno) {
        LinkedHashMap<String, List<Artikal>> podgrupeArtikli = new LinkedHashMap<String, List<Artikal>>();
        String query = zbirno ? "SELECT a.id, a.name,a.jedinicaMere, a.barCode, a.tip from artikal a WHERE  a.PODGRUPA_ID =?  AND a.tiP NOT IN ('SLOZ', 'DODA') order by field (tip,'PROD','POLU','SIRO'),name" : " SELECT a.id, a.name,a.jedinicaMere, a.barCode, a.tip from artikal a WHERE a.id IN (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID =?) AND a.PODGRUPA_ID =?  AND a.tiP NOT IN ('SLOZ', 'DODA')  order by field (tip,'PROD','POLU','SIRO'),name";
        for (PodgrupaArtikala pa : podgrupe) {
            ArrayList<Artikal> artikli = new ArrayList<Artikal>();
            try {
                PreparedStatement ps = this.connection.prepareStatement(query);
                if (zbirno) {
                    ps.setLong(1, pa.getId());
                } else {
                    ps.setLong(1, odeljenje.getId());
                    ps.setLong(2, pa.getId());
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Artikal artikal = this.server.getArtikal(rs.getLong("id"));
                    artikli.add(artikal);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (artikli.size() <= 0) continue;
            podgrupeArtikli.put(pa.getNaziv(), artikli);
        }
        return podgrupeArtikli;
    }

    public List<PodgrupaArtikala> getPodgrupaZalihe() {
        ArrayList<PodgrupaArtikala> podgrupe = new ArrayList<PodgrupaArtikala>();
        String query = "SELECT * FROM podgrupaartikala pa ORDER BY pa.prioritet";
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                PodgrupaArtikala pa = new PodgrupaArtikala();
                pa.setId(rs.getLong("id"));
                pa.setNaziv(rs.getString("naziv"));
                pa.setPrioritet(rs.getInt("prioritet"));
                podgrupe.add(pa);
            }
            return podgrupe;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getColumnValues(Table table, Artikal a, double pocetno, double ulaz, double izlaz, double zavrsno, double ncBezpdv, double ncSaPdv, double pcSaPdv, double pcBezPdv) {
        int start = 0;
        TableColumn[] kolone = table.getColumns();
        String[] red = new String[kolone.length];
        this.nvPocetnoSaPdv += Konstante.round(pocetno * ncSaPdv, 2);
        this.nvPocetnoBezPdv += Konstante.round(pocetno * ncBezpdv, 2);
        this.totNvPocetnoSaPdv += Konstante.round(pocetno * ncSaPdv, 2);
        this.totNvPocetnoBezPdv += Konstante.round(pocetno * ncBezpdv, 2);
        this.nvUlazSaPdv += Konstante.round(ulaz * ncSaPdv, 2);
        this.nvUlazBezPdv += Konstante.round(ulaz * ncBezpdv, 2);
        this.totNvUlazSaPdv += Konstante.round(ulaz * ncSaPdv, 2);
        this.totNvUlazBezPdv += Konstante.round(ulaz * ncBezpdv, 2);
        this.nvIzlazSaPdv += Konstante.round(izlaz * ncSaPdv, 2);
        this.nvIzlazBezPdv += Konstante.round(izlaz * ncBezpdv, 2);
        this.totNvIzlazSaPdv += Konstante.round(izlaz * ncSaPdv, 2);
        this.totNvIzlazBezPdv += Konstante.round(izlaz * ncBezpdv, 2);
        this.nvZavrsnoSaPdv += Konstante.round(zavrsno * ncSaPdv, 2);
        this.nvZavrsnoBezPdv += Konstante.round(zavrsno * ncBezpdv, 2);
        this.totNvZavrsnoSaPdv += Konstante.round(zavrsno * ncSaPdv, 2);
        this.totNvZavrsnoBezPdv += Konstante.round(zavrsno * ncBezpdv, 2);
        this.pvSaPdv += Konstante.round(zavrsno / a.getMera() * pcSaPdv, 2);
        this.pvBezPdv += Konstante.round(zavrsno / a.getMera() * pcBezPdv, 2);
        this.totPvSaPdv += Konstante.round(zavrsno / a.getMera() * pcSaPdv, 2);
        this.totPvBezPdv += Konstante.round(zavrsno / a.getMera() * pcBezPdv, 2);
        if (a.getPoreskaGrupa() == PoreskaGrupa.GRUPA_DJ) {
            this.totNvPocetnoSaPdvPo20 += Konstante.round(pocetno * ncSaPdv, 2);
            this.totNvPocetnoBezPdvPo20 += Konstante.round(pocetno * ncBezpdv, 2);
            this.totNvUlazSaPdvPo20 += Konstante.round(ulaz * ncSaPdv, 2);
            this.totNvUlazBezPdvPo20 += Konstante.round(ulaz * ncBezpdv, 2);
            this.totNvIzlazSaPdvPo20 += Konstante.round(izlaz * ncSaPdv, 2);
            this.totNvIzlazBezPdvPo20 += Konstante.round(izlaz * ncBezpdv, 2);
            this.totNvZavrsnoSaPdvPo20 += Konstante.round(zavrsno * ncSaPdv, 2);
            this.totNvZavrsnoBezPdvPo20 += Konstante.round(zavrsno * ncBezpdv, 2);
            this.totProdajnaVrSaPdvPo20 += Konstante.round(zavrsno / a.getMera() * pcSaPdv, 2);
            this.totProdajnaVrBezPdvPo20 += Konstante.round(zavrsno / a.getMera() * pcBezPdv, 2);
        } else if (a.getPoreskaGrupa() == PoreskaGrupa.GRUPA_E) {
            this.totNvPocetnoSaPdvPo10 += Konstante.round(pocetno * ncSaPdv, 2);
            this.totNvPocetnoBezPdvPo10 += Konstante.round(pocetno * ncBezpdv, 2);
            this.totNvUlazSaPdvPo10 += Konstante.round(ulaz * ncSaPdv, 2);
            this.totNvUlazBezPdvPo10 += Konstante.round(ulaz * ncBezpdv, 2);
            this.totNvIzlazSaPdvPo10 += Konstante.round(izlaz * ncSaPdv, 2);
            this.totNvIzlazBezPdvPo10 += Konstante.round(izlaz * ncBezpdv, 2);
            this.totNvZavrsnoSaPdvPo10 += Konstante.round(zavrsno * ncSaPdv, 2);
            this.totNvZavrsnoBezPdvPo10 += Konstante.round(zavrsno * ncBezpdv, 2);
            this.totProdajnaVrSaPdvPo10 += Konstante.round(zavrsno / a.getMera() * pcSaPdv, 2);
            this.totProdajnaVrBezPdvPo10 += Konstante.round(zavrsno / a.getMera() * pcBezPdv, 2);
        }
        block44: for (int i = start; i < kolone.length; ++i) {
            switch (this.mapa.get(i)) {
                case "": {
                    red[i] = "";
                    continue block44;
                }
                case "naziv": {
                    red[i] = a.getName();
                    continue block44;
                }
                case "barkod": {
                    red[i] = a.getBarCode();
                    continue block44;
                }
                case "jedinicamere": {
                    red[i] = a.getJedinicaMere();
                    continue block44;
                }
                case "pocetno": {
                    red[i] = String.valueOf(Konstante.round(pocetno, 4));
                    continue block44;
                }
                case "ulaz": {
                    red[i] = String.valueOf(Konstante.round(ulaz, 4));
                    continue block44;
                }
                case "izlaz": {
                    red[i] = String.valueOf(Konstante.round(izlaz, 4));
                    continue block44;
                }
                case "zavrsno": {
                    red[i] = String.valueOf(Konstante.round(zavrsno, 4));
                    continue block44;
                }
                case "pocetnoVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(pocetno * ncSaPdv, 2));
                    continue block44;
                }
                case "pocetnoVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(pocetno * ncBezpdv, 2));
                    continue block44;
                }
                case "ulazVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(ulaz * ncSaPdv, 2));
                    continue block44;
                }
                case "ulazVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(ulaz * ncBezpdv, 2));
                    continue block44;
                }
                case "izlazVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(izlaz * ncSaPdv, 2));
                    continue block44;
                }
                case "izlazVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(izlaz * ncBezpdv, 2));
                    continue block44;
                }
                case "zavrsnoVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(zavrsno * ncSaPdv, 2));
                    continue block44;
                }
                case "zavrsnoVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(zavrsno * ncBezpdv, 2));
                    continue block44;
                }
                case "prodajnaVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(zavrsno / a.getMera() * pcSaPdv, 2));
                    continue block44;
                }
                case "prodajnaVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(zavrsno / a.getMera() * pcBezPdv, 2));
                    continue block44;
                }
                case "nabavnaPoJmSaPdv": {
                    red[i] = String.valueOf(ncSaPdv);
                    continue block44;
                }
                case "nabavnaPoJmBezPdv": {
                    red[i] = String.valueOf(ncBezpdv);
                    continue block44;
                }
                default: {
                    red[i] = "nema";
                }
            }
        }
        return red;
    }

    private String[] getTotalValues(String naslov, Table table, double nvPocetnoSaPdv, double nvPocetnoBezPdv, double nvUlazSaPdv, double nvUlazBezPdv, double nvIzlazSaPdv, double nvIzlazBezPdv, double nvZavrsnoSaPdv, double nvZavrsnoBezPdv, double pvSaPdv, double pvBezPdv) {
        int start = 0;
        TableColumn[] kolone = table.getColumns();
        String[] red = new String[kolone.length];
        block44: for (int i = start; i < kolone.length; ++i) {
            switch (this.mapa.get(i)) {
                case "": {
                    red[i] = naslov;
                    continue block44;
                }
                case "naziv": {
                    red[i] = "";
                    continue block44;
                }
                case "barkod": {
                    red[i] = "";
                    continue block44;
                }
                case "jedinicamere": {
                    red[i] = "";
                    continue block44;
                }
                case "pocetno": {
                    red[i] = "";
                    continue block44;
                }
                case "ulaz": {
                    red[i] = "";
                    continue block44;
                }
                case "izlaz": {
                    red[i] = "";
                    continue block44;
                }
                case "zavrsno": {
                    red[i] = "";
                    continue block44;
                }
                case "pocetnoVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(nvPocetnoSaPdv, 4));
                    continue block44;
                }
                case "pocetnoVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(nvPocetnoBezPdv, 4));
                    continue block44;
                }
                case "ulazVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(nvUlazSaPdv, 4));
                    continue block44;
                }
                case "ulazVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(nvUlazBezPdv, 4));
                    continue block44;
                }
                case "izlazVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(nvIzlazSaPdv, 4));
                    continue block44;
                }
                case "izlazVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(nvIzlazBezPdv, 4));
                    continue block44;
                }
                case "zavrsnoVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(nvZavrsnoSaPdv, 4));
                    continue block44;
                }
                case "zavrsnoVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(nvZavrsnoBezPdv, 4));
                    continue block44;
                }
                case "prodajnaVrSaPdv": {
                    red[i] = String.valueOf(Konstante.round(pvSaPdv, 4));
                    continue block44;
                }
                case "prodajnaVrBezPdv": {
                    red[i] = String.valueOf(Konstante.round(pvBezPdv, 4));
                    continue block44;
                }
                case "nabavnaPoJmSaPdv": {
                    red[i] = "";
                    continue block44;
                }
                case "nabavnaPoJmBezPdv": {
                    red[i] = "";
                    continue block44;
                }
                default: {
                    red[i] = "nema";
                }
            }
        }
        return red;
    }

    private Map<Integer, String> getMapaKolona() {
        HashMap<Integer, String> mapaKolona = new HashMap<Integer, String>();
        int colPoz = 0;
        mapaKolona.put(colPoz, "");
        mapaKolona.put(++colPoz, "naziv");
        if (this.barKod) {
            mapaKolona.put(++colPoz, "barkod");
        }
        mapaKolona.put(++colPoz, "jedinicamere");
        if (this.colPocetno) {
            mapaKolona.put(++colPoz, "pocetno");
            if (this.finansijskiPrikaz) {
                mapaKolona.put(++colPoz, "pocetnoVrSaPdv");
                mapaKolona.put(++colPoz, "pocetnoVrBezPdv");
            }
        }
        if (this.colUlaz) {
            mapaKolona.put(++colPoz, "ulaz");
            if (this.finansijskiPrikaz) {
                mapaKolona.put(++colPoz, "ulazVrSaPdv");
                mapaKolona.put(++colPoz, "ulazVrBezPdv");
            }
        }
        if (this.colIzlaz) {
            mapaKolona.put(++colPoz, "izlaz");
            if (this.finansijskiPrikaz) {
                mapaKolona.put(++colPoz, "izlazVrSaPdv");
                mapaKolona.put(++colPoz, "izlazVrBezPdv");
            }
        }
        if (this.colZavrsno) {
            mapaKolona.put(++colPoz, "zavrsno");
            if (this.finansijskiPrikaz) {
                mapaKolona.put(++colPoz, "zavrsnoVrSaPdv");
                mapaKolona.put(++colPoz, "zavrsnoVrBezPdv");
                mapaKolona.put(++colPoz, "prodajnaVrSaPdv");
                mapaKolona.put(++colPoz, "prodajnaVrBezPdv");
                mapaKolona.put(++colPoz, "nabavnaPoJmBezPdv");
                mapaKolona.put(++colPoz, "nabavnaPoJmSaPdv");
            }
        }
        return mapaKolona;
    }

    private boolean isBlokiran(Artikal a, double ulaz, double izlaz) {
        if (a.getBlokiran().booleanValue() && a.getTip() == TipArtikla.SIRO) {
            return true;
        }
        return a.getBlokiran() != false && ulaz == 0.0 && izlaz == 0.0;
    }

    private boolean isPromenjen(double ulaz, double izlaz) {
        if (this.colUlaz && !this.colIzlaz && !this.colPocetno && !this.colZavrsno && ulaz == 0.0) {
            return true;
        }
        if (this.colIzlaz && !this.colUlaz && !this.colPocetno && !this.colZavrsno && izlaz == 0.0) {
            return true;
        }
        return ulaz == 0.0 && izlaz == 0.0;
    }

    private boolean isZavrsnoNula(double zavrsno) {
        return zavrsno == 0.0;
    }

    private boolean filterCheck(Artikal artikal, double ulaz, double izlaz, double zavrsno) {
        if (this.isBlokiran(artikal, ulaz, izlaz)) {
            return true;
        }
        if (this.promene && this.isPromenjen(ulaz, izlaz)) {
            return true;
        }
        return this.izbaciNulu && this.isZavrsnoNula(zavrsno);
    }

    private void getOsnovnaStanja(java.util.Date day1, java.util.Date day2, Artikal artikal, Odeljenje o) {
        double razlika = 0.0;
        if (this.popisiOsnovno.size() > 0) {
            razlika = this.getPopisRazlika(artikal, this.popisiOsnovno);
        }
        this.pocetnoOsnovno = this.server.getSumBelo(Konstante.getYesterdayDate(day1), o, artikal, false, true);
        this.zavrsnoOsnovno = this.server.getSumBelo(day2, o, artikal, false, false);
        this.ulazOsnovno = this.server.getNabavljenaKolicina(artikal, day1, day2, o, false) + razlika;
    }

    private void getDodatnaStanja(java.util.Date day1, java.util.Date day2, Artikal artikal, Odeljenje o) {
        double razlika = 0.0;
        if (this.popisiDodatno.size() > 0) {
            razlika = this.getPopisRazlika(artikal, this.popisiDodatno);
        }
        this.pocetnoDodatno = this.server.getSumBelo(Konstante.getYesterdayDate(day1), o, artikal, true, true);
        this.zavrsnoDodatno = this.server.getSumBelo(day2, o, artikal, true, false);
        this.ulazDodatno = this.server.getNabavljenaKolicina(artikal, day1, day2, o, true) + razlika;
    }

    private void getOsnovnoZbirno(java.util.Date day1, java.util.Date day2, Artikal artikal, Odeljenje odeljenje) {
        double razlika = 0.0;
        if (this.popisiOsnovno.size() > 0) {
            razlika = this.getPopisRazlika(artikal, this.popisiOsnovno);
        }
        this.pocetnoOsnovno += this.server.getSumBelo(Konstante.getYesterdayDate(day1), odeljenje, artikal, false, true);
        this.zavrsnoOsnovno += this.server.getSumBelo(day2, odeljenje, artikal, false, false);
        this.ulazOsnovno = this.ulazOsnovno + this.server.getNabavljenaKolicina(artikal, day1, day2, odeljenje, false) + razlika;
    }

    private void getDodatnoZbirno(java.util.Date day1, java.util.Date day2, Artikal artikal, Odeljenje odeljenje) {
        double razlika = 0.0;
        if (this.popisiDodatno.size() > 0) {
            razlika = this.getPopisRazlika(artikal, this.popisiDodatno);
        }
        this.pocetnoDodatno += this.server.getSumBelo(Konstante.getYesterdayDate(day1), odeljenje, artikal, true, true);
        this.zavrsnoDodatno += this.server.getSumBelo(day2, odeljenje, artikal, true, false);
        this.ulazDodatno = this.ulazDodatno + this.server.getNabavljenaKolicina(artikal, day1, day2, odeljenje, true) + razlika;
    }

    private void sumirajDodatnoOsnovno() {
        this.pocetno = this.pocetnoOsnovno + this.pocetnoDodatno;
        this.zavrsno = this.zavrsnoOsnovno + this.zavrsnoDodatno;
        this.ulaz = this.ulazOsnovno + this.ulazDodatno;
        this.izlaz = this.pocetno + this.ulaz - this.zavrsno;
    }

    private void getNabavneCeneDodatne(Artikal artikal, java.util.Date day1, java.util.Date day2, boolean dodatno, Odeljenje o) {
        java.util.Date poslednjiDatum = o.getNaziv().equals("MAGACIN") ? NabavneCene.getPoslednjiDatumPrijemnice(artikal, this.server) : NabavneCene.getPoslednjiDatumTrebovanja(artikal, this.server);
        if (this.poPoslednjoj) {
            this.ncDodatne = NabavneCene.getPosednjaNabavna(artikal, day2, o, dodatno, this.osDodParam[0], this.osDodParam[1], this.server);
            if (this.ncDodatne.size() > 0) {
                this.ncJMbezPdvDodatna = this.ncDodatne.get("NCpoJMbezPDV");
                this.ncJMsaPdvDodatna = this.ncDodatne.get("NCpoJMsaPDV");
                if (poslednjiDatum != null && day2.after(poslednjiDatum)) {
                    this.pcOsnovna = artikal.getCena();
                    this.pcOsnovnaBezPdv = this.server.getProdajnaCenaBezPDV(artikal.getPoreskaGrupa(), artikal.getCena());
                } else {
                    this.pcOsnovna = this.ncOsnovne.get("PCsaPDV");
                    this.pcOsnovnaBezPdv = this.ncOsnovne.get("PCbezPDV");
                }
            }
        } else {
            this.ncDodatne = NabavneCene.getProsecnaNabavna(artikal, day1, day2, o, dodatno, this.server);
            if (this.ncDodatne.get("NCpoJMbezPDV") == 0.0) {
                this.ncDodatne = NabavneCene.getPosednjaNabavna(artikal, day2, o, dodatno, this.osDodParam[0], this.osDodParam[1], this.server);
            }
            if (this.ncDodatne.size() > 0) {
                this.ncJMbezPdvDodatna = this.ncDodatne.get("NCpoJMbezPDV");
                this.ncJMsaPdvDodatna = this.ncDodatne.get("NCpoJMsaPDV");
                this.pcDodatna = this.ncDodatne.get("PCsaPDV");
                this.pcDodatnaBezPdv = this.ncDodatne.get("PCbezPDV");
            }
        }
    }

    private void getNabavneCeneOsnovne(Artikal artikal, java.util.Date day1, java.util.Date day2, boolean dodatno, Odeljenje o) {
        java.util.Date poslednjiDatum = o.getNaziv().equals("MAGACIN") ? NabavneCene.getPoslednjiDatumPrijemnice(artikal, this.server) : NabavneCene.getPoslednjiDatumTrebovanja(artikal, this.server);
        if (this.poPoslednjoj) {
            this.ncOsnovne = NabavneCene.getPosednjaNabavna(artikal, day2, o, dodatno, this.osDodParam[0], this.osDodParam[1], this.server);
            if (this.ncOsnovne.size() > 0) {
                this.ncJMbezPdvOsnovna = this.ncOsnovne.get("NCpoJMbezPDV");
                this.ncJMsaPdvOsnovna = this.ncOsnovne.get("NCpoJMsaPDV");
                if (poslednjiDatum != null && day2.after(poslednjiDatum)) {
                    this.pcOsnovna = artikal.getCena();
                    this.pcOsnovnaBezPdv = this.server.getProdajnaCenaBezPDV(artikal.getPoreskaGrupa(), artikal.getCena());
                } else {
                    this.pcOsnovna = this.ncOsnovne.get("PCsaPDV");
                    this.pcOsnovnaBezPdv = this.ncOsnovne.get("PCbezPDV");
                }
            }
        } else {
            this.ncOsnovne = NabavneCene.getProsecnaNabavna(artikal, day1, day2, o, dodatno, this.server);
            if (this.ncOsnovne.get("NCpoJMbezPDV") == 0.0) {
                this.ncOsnovne = NabavneCene.getPosednjaNabavna(artikal, day2, o, dodatno, this.osDodParam[0], this.osDodParam[1], this.server);
            }
            if (this.ncOsnovne.size() > 0) {
                this.ncJMbezPdvOsnovna = this.ncOsnovne.get("NCpoJMbezPDV");
                this.ncJMsaPdvOsnovna = this.ncOsnovne.get("NCpoJMsaPDV");
                this.pcOsnovna = this.ncOsnovne.get("PCsaPDV");
                this.pcOsnovnaBezPdv = this.ncOsnovne.get("PCbezPDV");
            }
        }
    }

    private void resetujStanje() {
        this.pocetnoOsnovno = 0.0;
        this.pocetnoDodatno = 0.0;
        this.zavrsnoOsnovno = 0.0;
        this.zavrsnoDodatno = 0.0;
        this.ulazOsnovno = 0.0;
        this.ulazDodatno = 0.0;
    }

    private void resetujNabavnevrednosti() {
        this.nvPocetnoSaPdv = 0.0;
        this.nvPocetnoBezPdv = 0.0;
        this.nvUlazSaPdv = 0.0;
        this.nvUlazBezPdv = 0.0;
        this.nvIzlazSaPdv = 0.0;
        this.nvIzlazBezPdv = 0.0;
        this.nvZavrsnoSaPdv = 0.0;
        this.nvZavrsnoBezPdv = 0.0;
        this.pvSaPdv = 0.0;
        this.pvBezPdv = 0.0;
    }

    private void resetujTotalNv() {
        this.totNvPocetnoSaPdv = 0.0;
        this.totNvPocetnoBezPdv = 0.0;
        this.totNvUlazSaPdv = 0.0;
        this.totNvUlazBezPdv = 0.0;
        this.totNvIzlazSaPdv = 0.0;
        this.totNvIzlazBezPdv = 0.0;
        this.totNvZavrsnoSaPdv = 0.0;
        this.totNvZavrsnoBezPdv = 0.0;
        this.totPvSaPdv = 0.0;
        this.totPvBezPdv = 0.0;
        this.totNvPocetnoSaPdvPo20 = 0.0;
        this.totNvPocetnoBezPdvPo20 = 0.0;
        this.totNvUlazSaPdvPo20 = 0.0;
        this.totNvUlazBezPdvPo20 = 0.0;
        this.totNvIzlazSaPdvPo20 = 0.0;
        this.totNvIzlazBezPdvPo20 = 0.0;
        this.totNvZavrsnoSaPdvPo20 = 0.0;
        this.totNvZavrsnoBezPdvPo20 = 0.0;
        this.totProdajnaVrSaPdvPo20 = 0.0;
        this.totProdajnaVrBezPdvPo20 = 0.0;
        this.totNvPocetnoSaPdvPo10 = 0.0;
        this.totNvPocetnoBezPdvPo10 = 0.0;
        this.totNvUlazSaPdvPo10 = 0.0;
        this.totNvUlazBezPdvPo10 = 0.0;
        this.totNvIzlazSaPdvPo10 = 0.0;
        this.totNvIzlazBezPdvPo10 = 0.0;
        this.totNvZavrsnoSaPdvPo10 = 0.0;
        this.totNvZavrsnoBezPdvPo10 = 0.0;
        this.totProdajnaVrSaPdvPo10 = 0.0;
        this.totProdajnaVrBezPdvPo10 = 0.0;
    }

    private List<Popis> getPopis(java.util.Date day1, java.util.Date day2, boolean dodatno, Odeljenje o) {
        String query = "SELECT * FROM popis p WHERE p.datum > ? AND p.datum <= ? AND p.sravnjenje = 1 AND p.crno =? AND p.ODELJENJE_ID = ?";
        ArrayList<Popis> listaPopisa = new ArrayList<Popis>();
        try {
            PreparedStatement ps = this.server.getConnection().prepareStatement(query);
            ps.setDate(1, new Date(day1.getTime()));
            ps.setDate(2, new Date(day2.getTime()));
            ps.setBoolean(3, dodatno);
            ps.setLong(4, o.getId());
            ResultSet rSet = ps.executeQuery();
            while (rSet.next()) {
                Popis popis = new Popis();
                popis.setId(rSet.getLong("id"));
                popis.setDatum(rSet.getDate("datum"));
                popis.setStavke(this.server.getStavkePopisa(popis, false));
                listaPopisa.add(popis);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return listaPopisa;
    }

    public double getPopisRazlika(Artikal artikal, List<Popis> popisi) {
        double razlika = 0.0;
        for (Popis popis : popisi) {
            for (StavkaPopisa stavka : popis.getStavke()) {
                if (stavka.getArtikal().getId() != artikal.getId()) continue;
                razlika += stavka.getRazlika().doubleValue();
            }
        }
        return razlika;
    }
}

