/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DPU {
    RestoranServer server;
    Date datum;
    boolean isDanasnji;
    Map<PodgrupaArtikala, List<Artikal>> pice;
    Map<PodgrupaArtikala, List<Artikal>> jelo;
    Map<PodgrupaArtikala, List<Artikal>> piceSiro;
    Map<PodgrupaArtikala, List<Artikal>> jeloSiro;
    Font font8 = FontFactory.getFont((String)"Helvetica", (float)9.0f);
    Font font8Bold = FontFactory.getFont((String)"Helvetica-Bold", (float)9.0f);
    float[] kolone = new float[]{11.0f, 35.0f, 11.0f, 16.0f, 15.0f, 21.0f, 14.0f, 11.0f, 14.0f, 16.0f, 8.0f, 8.0f, 17.0f};
    int count = 0;

    private DPU(Shell shell, Restoran restoran, Date d1, Odeljenje od, boolean b, boolean sir, boolean be, boolean cr, boolean mz) {
        this.isDanasnji = !Konstante.getOnlyDate(d1).before(Konstante.getOnlyDate(new Date()));
        this.server = restoran.getServer();
        this.datum = d1;
        if (this.server.isBeforeDateZD(this.datum)) {
            Konstante.getPoruka3(shell, "Za izbrani period nema podataka!");
            return;
        }
        Shell poruka = Konstante.getPoruka2(shell);
        shell.setEnabled(false);
        File dpu = new File("C:\\BarMaster\\Reports\\DPU-" + Konstante.getDate(this.datum) + "txt");
        Document document = new Document(PageSize.A4, 0.0f, 0.0f, 20.0f, 20.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(dpu));
            document.open();
            document.add((Element)this.headerT());
            document.add((Element)this.head2());
        }
        catch (Exception ex) {
            Logger.getLogger(DPU.class.getName()).log(Level.SEVERE, null, ex);
        }
        List<Object> odeljenja = new ArrayList<Odeljenje>();
        this.server.refresh();
        if (od != null) {
            odeljenja.add(od);
        } else {
            odeljenja = this.server.readOdeljenjeBezMag();
        }
        for (Odeljenje odeljenje : odeljenja) {
            this.pice = new HashMap<PodgrupaArtikala, List<Artikal>>();
            this.jelo = new HashMap<PodgrupaArtikala, List<Artikal>>();
            this.piceSiro = new HashMap<PodgrupaArtikala, List<Artikal>>();
            this.jeloSiro = new HashMap<PodgrupaArtikala, List<Artikal>>();
            List<PodgrupaArtikala> podgrupe = this.server.readPodgrupeArtikala();
            for (PodgrupaArtikala pa : podgrupe) {
                ArrayList artikli = new ArrayList();
                this.pice.put(pa, artikli);
                this.jelo.put(pa, artikli);
                this.piceSiro.put(pa, artikli);
                this.jeloSiro.put(pa, artikli);
            }
            List<Artikal> artikli = this.server.ArtikliZaFO();
            for (Artikal artikal : artikli) {
                List<Artikal> temp;
                if (artikal.getTip() == TipArtikla.PROD || artikal.getTip() == TipArtikla.SLOZ) {
                    if (artikal.getPice().booleanValue()) {
                        temp = this.pice.get(artikal.getPodgrupa());
                        temp.add(artikal);
                        this.pice.put(artikal.getPodgrupa(), temp);
                        continue;
                    }
                    if (!artikal.getJelo().booleanValue()) continue;
                    temp = this.jelo.get(artikal.getPodgrupa());
                    temp.add(artikal);
                    this.jelo.put(artikal.getPodgrupa(), temp);
                    continue;
                }
                if (artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
                if (artikal.getPice().booleanValue()) {
                    temp = this.piceSiro.get(artikal.getPodgrupa());
                    temp.add(artikal);
                    this.piceSiro.put(artikal.getPodgrupa(), temp);
                    continue;
                }
                if (!artikal.getJelo().booleanValue()) continue;
                temp = this.jeloSiro.get(artikal.getPodgrupa());
                temp.add(artikal);
                this.jeloSiro.put(artikal.getPodgrupa(), temp);
            }
            try {
                document.add((Element)this.customTable(odeljenje, this.pice, this.jelo, this.piceSiro, this.jeloSiro));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.utrosci();
        }
        try {
            document.add((Element)this.footerT());
            document.close();
            poruka.close();
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(dpu);
            }
        }
        catch (Exception ex) {
            poruka.close();
            Konstante.getPoruka(shell, "Dokument za izabrani datum je otvoren!");
        }
    }

    public PdfPTable customTable(Odeljenje odeljenje, Map<PodgrupaArtikala, List<Artikal>> pice, Map<PodgrupaArtikala, List<Artikal>> jelo, Map<PodgrupaArtikala, List<Artikal>> piceSiro, Map<PodgrupaArtikala, List<Artikal>> jeloSiro) {
        HashMap ulazi = new HashMap();
        PdfPTable table = new PdfPTable(13);
        PdfPCell cell = table.getDefaultCell();
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBorderWidth(0.1f);
        cell.setPadding(0.0f);
        PdfPCell naslov = new PdfPCell(new Phrase(odeljenje.getNaziv()));
        naslov.setColspan(13);
        naslov.setHorizontalAlignment(1);
        table.addCell(naslov);
        for (PodgrupaArtikala pa : pice.keySet()) {
            PdfPCell podnaslov = new PdfPCell(new Phrase(pa.getNaziv()));
            podnaslov.setColspan(12);
            podnaslov.setHorizontalAlignment(0);
            table.addCell(new PdfPCell(new Phrase("")));
            table.addCell(podnaslov);
            for (Artikal art : pice.get(pa)) {
                ++this.count;
                table.addCell(new Phrase("" + this.count, this.font8));
                table.addCell(new Phrase(art.getName(), this.font8));
                table.addCell(new Phrase(Konstante.getPdvPoPG(art.getPoreskaGrupa()) + " %", this.font8));
                table.addCell(new Phrase(art.getJedinicaMere(), this.font8));
                if (art.getTip() == TipArtikla.SLOZ) {
                    table.addCell(new Phrase("0.0", this.font8));
                }
                table.addCell(new Phrase("NABAV", this.font8));
                table.addCell(new Phrase("5+6", this.font8));
                table.addCell(new Phrase("kraj", this.font8));
                table.addCell(new Phrase("devet", this.font8));
                table.addCell(new Phrase(art.getCena() + "", this.font8));
                table.addCell(new Phrase("pice", this.font8));
                table.addCell(new Phrase("jelo", this.font8));
                table.addCell(new Phrase("0.00", this.font8));
            }
        }
        try {
            table.setWidths(this.kolone);
        }
        catch (DocumentException ex) {
            Logger.getLogger(DPU.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table;
    }

    public PdfPTable naslovTable(String naslov) {
        PdfPTable table = new PdfPTable(1);
        PdfPCell cell = table.getDefaultCell();
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBorder(0);
        cell.setPadding(6.0f);
        table.addCell(new Phrase(naslov));
        return table;
    }

    public PdfPTable footerT() {
        PdfPTable table3 = new PdfPTable(3);
        PdfPCell pc = table3.getDefaultCell();
        pc.setHorizontalAlignment(1);
        pc.setBorder(0);
        table3.addCell(new Phrase("\n\n\n"));
        table3.addCell(new Phrase(""));
        table3.addCell(new Phrase(""));
        table3.addCell(new Phrase("SASTAVIO"));
        table3.addCell(new Phrase(""));
        table3.addCell(new Phrase("ODGOVORNO LICE"));
        table3.addCell(new Phrase("____________________"));
        table3.addCell(new Phrase(""));
        table3.addCell(new Phrase("____________________"));
        return table3;
    }

    public PdfPTable headerT() {
        PdfPTable table = new PdfPTable(2);
        PdfPCell c1 = table.getDefaultCell();
        c1.setBorder(0);
        c1.setHorizontalAlignment(1);
        PdfPCell cell1 = new PdfPCell(new Phrase(this.server.getSetting(Option.PREDUZECE_NAZIV) != null ? this.server.getSetting(Option.PREDUZECE_NAZIV).stringValue() : "", this.font8Bold));
        cell1.setHorizontalAlignment(0);
        cell1.setBorder(0);
        table.addCell(cell1);
        cell1 = new PdfPCell(new Phrase("DNEVNI OBRACUN", this.font8Bold));
        cell1.setHorizontalAlignment(1);
        cell1.setBorder(0);
        table.addCell(cell1);
        cell1 = new PdfPCell(new Phrase(this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE) != null ? this.server.getSetting(Option.NAZIV_POSLOVNE_JEDINICE).stringValue() : "", this.font8Bold));
        cell1.setHorizontalAlignment(0);
        cell1.setBorder(0);
        table.addCell(cell1);
        cell1 = new PdfPCell(new Phrase("PROMETA I ZALIHA U UGOSTITELJSTVU", this.font8Bold));
        cell1.setHorizontalAlignment(1);
        cell1.setBorder(0);
        table.addCell(cell1);
        cell1 = new PdfPCell(new Phrase(this.server.getSetting(Option.OBJEKAT_NAZIV) != null ? this.server.getSetting(Option.OBJEKAT_NAZIV).stringValue() : "", this.font8Bold));
        cell1.setBorder(0);
        cell1.setHorizontalAlignment(0);
        table.addCell(cell1);
        table.addCell(new Phrase("ZA DAN " + Konstante.getDate(this.datum) + " GOD", this.font8Bold));
        try {
            table.setWidths(new float[]{2.0f, 3.0f});
        }
        catch (DocumentException ex) {
            Logger.getLogger(DPU.class.getName()).log(Level.SEVERE, null, ex);
        }
        table.addCell("\n\n");
        table.addCell("");
        return table;
    }

    public PdfPTable head2() {
        PdfPTable table2 = new PdfPTable(13);
        PdfPCell cell = table2.getDefaultCell();
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setBorderWidth(0.1f);
        cell.setPadding(0.0f);
        table2.addCell(new Phrase("Redni\nbroj", this.font8));
        table2.addCell(new Phrase("Naziv jela i pica za\nkonzumaciju na\n licu mesta", this.font8));
        table2.addCell(new Phrase("Stopa\nPDV", this.font8));
        table2.addCell(new Phrase("Jedinica\nmere", this.font8));
        table2.addCell(new Phrase("Preneta\nkolicina", this.font8));
        table2.addCell(new Phrase("Nabavljena\nkolicina", this.font8));
        table2.addCell(new Phrase("Ukupno\n(5+6)", this.font8));
        table2.addCell(new Phrase("Zalihe na\nkraju\ndana", this.font8));
        table2.addCell(new Phrase("Utrosena\nkolicina u\ntoku dana\n(7-8)", this.font8));
        table2.addCell(new Phrase("Prodajna\ncena po\njedinici mere\nsa PDV", this.font8));
        PdfPTable tableB = new PdfPTable(2);
        tableB.getDefaultCell().setHorizontalAlignment(1);
        PdfPCell c = new PdfPCell(new Phrase("Ostvareni promet od\n usluga (9x10)", this.font8));
        c.setColspan(2);
        c.setHorizontalAlignment(1);
        c.setVerticalAlignment(5);
        c.setBorderWidth(0.1f);
        tableB.addCell(c);
        tableB.addCell(new Phrase("od\npica", this.font8));
        tableB.addCell(new Phrase("od\njela", this.font8));
        PdfPCell add = new PdfPCell(tableB);
        add.setColspan(2);
        table2.addCell(add);
        table2.addCell(new Phrase("Prodajna\nvrednost jela i\npica za\nkonzumaciju\nna licu mesta\n(6x10)", this.font8));
        table2.addCell(new Phrase("1", this.font8));
        table2.addCell(new Phrase("2", this.font8));
        table2.addCell(new Phrase("3", this.font8));
        table2.addCell(new Phrase("4", this.font8));
        table2.addCell(new Phrase("5", this.font8));
        table2.addCell(new Phrase("6", this.font8));
        table2.addCell(new Phrase("7", this.font8));
        table2.addCell(new Phrase("8", this.font8));
        table2.addCell(new Phrase("9", this.font8));
        table2.addCell(new Phrase("10", this.font8));
        table2.addCell(new Phrase("11", this.font8));
        table2.addCell(new Phrase("12", this.font8));
        table2.addCell(new Phrase("13", this.font8));
        try {
            table2.setWidths(this.kolone);
        }
        catch (DocumentException ex) {
            Logger.getLogger(DPU.class.getName()).log(Level.SEVERE, null, ex);
        }
        return table2;
    }

    public void utrosci() {
        if (this.isDanasnji) {
            // empty if block
        }
    }

    public void makeRows(PdfPTable table2, List<String[]> lista) {
        Font font8 = FontFactory.getFont((String)"Helvetica", (float)9.0f);
        for (String[] s : lista) {
            table2.addCell(new Phrase(s[0], font8));
            table2.addCell(new Phrase(s[1], font8));
            table2.addCell(new Phrase(s[2], font8));
            table2.addCell(new Phrase(s[3], font8));
            table2.addCell(new Phrase(s[4], font8));
        }
    }

    public static class DPUInput {
        private DateInput2 odDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo odeljenje;
        private Button blic;
        private Button sirovine;
        Date day1;
        Odeljenje o;
        List<Odeljenje> odeljenja;
        SWTContainer parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        boolean saPromenama;
        boolean siroPrikaz;
        private Button belo;
        private Button crno;
        private Button medjuzbir;
        boolean iscrno;
        boolean inspekcija;
        boolean bel;
        boolean cr;
        boolean medjz;

        public DPUInput(SWTContainer owner, Restoran r, boolean ins) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.iscrno = this.server.readCrnaPlacanjaIzvestaji().size() > 0;
            this.inspekcija = ins;
            this.odeljenja = this.server.readOdeljenjeBezMag();
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Dnevni promet ugostitelja");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za unos, pregled i ispravku.\n Za vise informacija kliknite na ikonicu tehnickog uputstva ->");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter izvestaja");
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 70;
            Group grupa21 = null;
            if (!this.inspekcija) {
                grupa21 = new Group(panel2, 0);
                grupa21.setLayout((Layout)new GridLayout(4, false));
                grupa21.setText("Filter nacina placanja");
                grupa21.setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Za dan:");
            this.odDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText("Odeljenje:");
            this.odeljenje = new Combo((Composite)grupa2, 8);
            this.odeljenje.add("Sva proizvodna mesta");
            for (Odeljenje ode : this.odeljenja) {
                this.odeljenje.add(ode.getNaziv());
            }
            this.odeljenje.select(0);
            this.blic = new Button((Composite)grupa2, 32);
            this.blic.setText("Samo sa promenama");
            this.sirovine = new Button((Composite)grupa2, 32);
            this.sirovine.setSelection(true);
            this.sirovine.setText("Prikaz sirovina");
            if (!this.inspekcija) {
                this.belo = new Button((Composite)grupa21, 32);
                this.belo.setText("Osnovna placanja");
                this.belo.setSelection(true);
                if (this.iscrno) {
                    this.crno = new Button((Composite)grupa21, 32);
                    this.crno.setText("Dodatna placanja");
                }
                this.medjuzbir = new Button((Composite)grupa21, 32);
                this.medjuzbir.setText("Medjuzbir");
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odeljenje.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.saPromenama = this.blic.getSelection();
                this.siroPrikaz = this.sirovine.getSelection();
                this.o = this.odeljenje.getSelectionIndex() == 0 ? null : this.odeljenja.get(this.odeljenje.getSelectionIndex() - 1);
                if (this.inspekcija) {
                    this.bel = true;
                    this.cr = false;
                    this.medjz = false;
                    if (this.day1.equals(Konstante.getOnlyDate(new Date()))) {
                        this.medjz = true;
                    }
                } else {
                    this.bel = this.belo.getSelection();
                    this.cr = false;
                    if (this.iscrno) {
                        this.cr = this.crno.getSelection();
                    }
                    this.medjz = this.medjuzbir.getSelection();
                }
                this.server.log("Pregled DPU za dan->" + this.day1);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new DPU(shell2, this.restoran, this.day1, this.o, this.saPromenama, this.siroPrikaz, this.bel, this.cr, this.medjz);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

