/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaTopArtikliPoPodgrupama;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaBlicArtikliNovi;
import com.dev63.restoran.stampa.StampaPrometPoArtiklimaNovi;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AnalizaProdajePoSatima {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    List<Map<String, Object>> ppaArtData;
    List<Map<String, Object>> ppaFinanceData;

    public AnalizaProdajePoSatima(Shell s, Restoran re, final Date d1, final Date d2, List<NacinPlacanja> bela, final List<CrnoPlacanje> cp, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_SATIMA_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(d1) + " -> " + StatLogic.getDateString(d2));
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(d1, d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        try {
            this.insertRows(bela, cp, d1, d2);
        }
        catch (Exception ex) {
            Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(AnalizaProdajePoSatima.this.table), false, true, String.format(AnalizaProdajePoSatima.this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_SATIMA"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), AnalizaProdajePoSatima.this.shell, AnalizaProdajePoSatima.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(AnalizaProdajePoSatima.this.table, AnalizaProdajePoSatima.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button printButton2 = new Button((Composite)this.shell, 72);
        try {
            printButton2.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception tc) {
            // empty catch block
        }
        printButton2.setText(String.format(this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
        printButton2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(AnalizaProdajePoSatima.this.ppaArtData, AnalizaProdajePoSatima.this.ppaFinanceData, cp, d1, d2, AnalizaProdajePoSatima.this.server.readIzvestajiStampacObject(), AnalizaProdajePoSatima.this.sifre, AnalizaProdajePoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(AnalizaProdajePoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton2.setVisible(false);
        printButton2.setLayoutData((Object)data);
        Button printButton3 = new Button((Composite)this.shell, 72);
        try {
            printButton3.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton3.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_FP"), new Object[0]));
        printButton3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    AnalizaProdajePoSatima.this.server.log(String.format(AnalizaProdajePoSatima.this.barmasterText.getString("LOG_ARTIKLI_PRODATI_U_DANU"), new Object[0]));
                    if (Konstante.getTipStampaca() == 1) {
                        XMLWriter.writeReport(2);
                    } else {
                        XMLWriterHCP.writeProdatiArtikli();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        printButton3.setVisible(false);
        printButton3.setLayoutData((Object)data);
        Button printButton4 = new Button((Composite)this.shell, 72);
        try {
            printButton4.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton4.setText(String.format(this.barmasterText.getString("TEXT_BLIC"), new Object[0]));
        printButton4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaNovi(null, AnalizaProdajePoSatima.this.ppaFinanceData, cp, d1, d2, AnalizaProdajePoSatima.this.server.readIzvestajiStampacObject(), AnalizaProdajePoSatima.this.sifre, AnalizaProdajePoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(AnalizaProdajePoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printButton4.setVisible(false);
        printButton4.setLayoutData((Object)data);
        Button printU = new Button((Composite)this.shell, 72);
        try {
            printU.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printU.setText(String.format(this.barmasterText.getString("TEXT_BLIC_ARTIKLI"), new Object[0]));
        printU.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    new StampaPrometPoArtiklimaBlicArtikliNovi(AnalizaProdajePoSatima.this.ppaArtData, d1, d2, AnalizaProdajePoSatima.this.server.readIzvestajiStampacObject(), AnalizaProdajePoSatima.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(AnalizaProdajePoSatima.this.shell, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STAMPANJA_PROMETA_PO_ARTIKLIMA"), new Object[0]));
                }
            }
        });
        printU.setVisible(false);
        printU.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AnalizaProdajePoSatima.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText("Datum");
        tc0.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText("00-01");
        tc1.setWidth(100);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText("01-02");
        tc2.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("02-03");
        tc3.setWidth(100);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("03-04");
        tc4.setWidth(100);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("04-05");
        tc5.setWidth(100);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("05-06");
        tc6.setWidth(100);
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText("06-07");
        tc7.setWidth(100);
        TableColumn tc8 = new TableColumn(this.table, 131072);
        tc8.setText("07-08");
        tc8.setWidth(100);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("08-09");
        tc9.setWidth(100);
        TableColumn tc10 = new TableColumn(this.table, 131072);
        tc10.setText("09-10");
        tc10.setWidth(100);
        TableColumn tc11 = new TableColumn(this.table, 131072);
        tc11.setText("10-11");
        tc11.setWidth(100);
        TableColumn tc12 = new TableColumn(this.table, 131072);
        tc12.setText("11-12");
        tc12.setWidth(100);
        TableColumn tc13 = new TableColumn(this.table, 131072);
        tc13.setText("12-13");
        tc13.setWidth(100);
        TableColumn tc14 = new TableColumn(this.table, 131072);
        tc14.setText("13-14");
        tc14.setWidth(100);
        TableColumn tc15 = new TableColumn(this.table, 131072);
        tc15.setText("14-15");
        tc15.setWidth(100);
        TableColumn tc16 = new TableColumn(this.table, 131072);
        tc16.setText("15-16");
        tc16.setWidth(100);
        TableColumn tc17 = new TableColumn(this.table, 131072);
        tc17.setText("16-17");
        tc17.setWidth(100);
        TableColumn tc18 = new TableColumn(this.table, 131072);
        tc18.setText("17-18");
        tc18.setWidth(100);
        TableColumn tc19 = new TableColumn(this.table, 131072);
        tc19.setText("18-19");
        tc19.setWidth(100);
        TableColumn tc20 = new TableColumn(this.table, 131072);
        tc20.setText("19-20");
        tc20.setWidth(100);
        TableColumn tc21 = new TableColumn(this.table, 131072);
        tc21.setText("20-21");
        tc21.setWidth(100);
        TableColumn tc22 = new TableColumn(this.table, 131072);
        tc22.setText("21-22");
        tc22.setWidth(100);
        TableColumn tc23 = new TableColumn(this.table, 131072);
        tc23.setText("22-23");
        tc23.setWidth(100);
        TableColumn tc24 = new TableColumn(this.table, 131072);
        tc24.setText("23-24");
        tc24.setWidth(100);
        TableColumn tc25 = new TableColumn(this.table, 131072);
        tc25.setText("Ukupno");
        tc25.setWidth(100);
    }

    public static List<Date> getDaysBetweenDates(Date startdate, Date enddate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startdate);
        GregorianCalendar calendarNew = new GregorianCalendar();
        calendarNew.setTime(enddate);
        ((Calendar)calendarNew).add(5, 1);
        while (calendar.getTime().before(calendarNew.getTime())) {
            Date result = calendar.getTime();
            dates.add(result);
            ((Calendar)calendar).add(5, 1);
        }
        return dates;
    }

    private void insertRows(List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to) throws Exception {
        List<Date> listaDate = AnalizaProdajePoSatima.getDaysBetweenDates(from, to);
        this.popuniTabelu(listaDate, belaPlacanja, cp);
    }

    public void popuniTabelu(List<Date> lista, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp) throws Exception {
        for (int j = 0; j < lista.size(); ++j) {
            Date krajnji;
            EnumSet<NacinPlacanja> bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date pocetni = this.server.getPocetni(lista.get(j));
            List<Map<String, Object>> listaVrednosti = this.server.getAnalizaProdajePoSatima(pocetni, krajnji = this.server.getKrajnji(lista.get(j)), bp, cp);
            if (listaVrednosti.isEmpty()) continue;
            TableItem item = new TableItem(this.table, 0);
            for (int i = 0; i < listaVrednosti.size(); ++i) {
                item.setText(0, format.format(lista.get(j)));
                item.setText(1, Konstante.getNumber02((Double)listaVrednosti.get(i).get("0-1")));
                item.setText(2, Konstante.getNumber02((Double)listaVrednosti.get(i).get("1-2")));
                item.setText(3, Konstante.getNumber02((Double)listaVrednosti.get(i).get("2-3")));
                item.setText(4, Konstante.getNumber02((Double)listaVrednosti.get(i).get("3-4")));
                item.setText(5, Konstante.getNumber02((Double)listaVrednosti.get(i).get("4-5")));
                item.setText(6, Konstante.getNumber02((Double)listaVrednosti.get(i).get("5-6")));
                item.setText(7, Konstante.getNumber02((Double)listaVrednosti.get(i).get("6-7")));
                item.setText(8, Konstante.getNumber02((Double)listaVrednosti.get(i).get("7-8")));
                item.setText(9, Konstante.getNumber02((Double)listaVrednosti.get(i).get("8-9")));
                item.setText(10, Konstante.getNumber02((Double)listaVrednosti.get(i).get("9-10")));
                item.setText(11, Konstante.getNumber02((Double)listaVrednosti.get(i).get("10-11")));
                item.setText(12, Konstante.getNumber02((Double)listaVrednosti.get(i).get("11-12")));
                item.setText(13, Konstante.getNumber02((Double)listaVrednosti.get(i).get("12-13")));
                item.setText(14, Konstante.getNumber02((Double)listaVrednosti.get(i).get("13-14")));
                item.setText(15, Konstante.getNumber02((Double)listaVrednosti.get(i).get("14-15")));
                item.setText(16, Konstante.getNumber02((Double)listaVrednosti.get(i).get("15-16")));
                item.setText(17, Konstante.getNumber02((Double)listaVrednosti.get(i).get("16-17")));
                item.setText(18, Konstante.getNumber02((Double)listaVrednosti.get(i).get("17-18")));
                item.setText(19, Konstante.getNumber02((Double)listaVrednosti.get(i).get("18-19")));
                item.setText(20, Konstante.getNumber02((Double)listaVrednosti.get(i).get("19-20")));
                item.setText(21, Konstante.getNumber02((Double)listaVrednosti.get(i).get("20-21")));
                item.setText(22, Konstante.getNumber02((Double)listaVrednosti.get(i).get("21-22")));
                item.setText(23, Konstante.getNumber02((Double)listaVrednosti.get(i).get("22-23")));
                item.setText(24, Konstante.getNumber02((Double)listaVrednosti.get(i).get("23-24")));
                item.setText(25, Konstante.getNumber02((Double)listaVrednosti.get(i).get("Ukupno")));
            }
        }
        double rez1 = 0.0;
        double rez2 = 0.0;
        double rez3 = 0.0;
        double rez4 = 0.0;
        double rez5 = 0.0;
        double rez6 = 0.0;
        double rez7 = 0.0;
        double rez8 = 0.0;
        double rez9 = 0.0;
        double rez10 = 0.0;
        double rez11 = 0.0;
        double rez12 = 0.0;
        double rez13 = 0.0;
        double rez14 = 0.0;
        double rez15 = 0.0;
        double rez16 = 0.0;
        double rez17 = 0.0;
        double rez18 = 0.0;
        double rez19 = 0.0;
        double rez20 = 0.0;
        double rez21 = 0.0;
        double rez22 = 0.0;
        double rez23 = 0.0;
        double rez24 = 0.0;
        double ukupno = 0.0;
        double prosecno = 0.0;
        for (TableItem ti : this.table.getItems()) {
            rez1 += ti.getText(1) != "" ? Double.parseDouble(ti.getText(1)) : 0.0;
            rez2 += ti.getText(2) != "" ? Double.parseDouble(ti.getText(2)) : 0.0;
            rez3 += ti.getText(3) != "" ? Double.parseDouble(ti.getText(3)) : 0.0;
            rez4 += ti.getText(4) != "" ? Double.parseDouble(ti.getText(4)) : 0.0;
            rez5 += ti.getText(5) != "" ? Double.parseDouble(ti.getText(5)) : 0.0;
            rez6 += ti.getText(6) != "" ? Double.parseDouble(ti.getText(6)) : 0.0;
            rez7 += ti.getText(7) != "" ? Double.parseDouble(ti.getText(7)) : 0.0;
            rez8 += ti.getText(8) != "" ? Double.parseDouble(ti.getText(8)) : 0.0;
            rez9 += ti.getText(9) != "" ? Double.parseDouble(ti.getText(9)) : 0.0;
            rez10 += ti.getText(10) != "" ? Double.parseDouble(ti.getText(10)) : 0.0;
            rez11 += ti.getText(11) != "" ? Double.parseDouble(ti.getText(11)) : 0.0;
            rez12 += ti.getText(12) != "" ? Double.parseDouble(ti.getText(12)) : 0.0;
            rez13 += ti.getText(13) != "" ? Double.parseDouble(ti.getText(13)) : 0.0;
            rez14 += ti.getText(14) != "" ? Double.parseDouble(ti.getText(14)) : 0.0;
            rez15 += ti.getText(15) != "" ? Double.parseDouble(ti.getText(15)) : 0.0;
            rez16 += ti.getText(16) != "" ? Double.parseDouble(ti.getText(16)) : 0.0;
            rez17 += ti.getText(17) != "" ? Double.parseDouble(ti.getText(17)) : 0.0;
            rez18 += ti.getText(18) != "" ? Double.parseDouble(ti.getText(18)) : 0.0;
            rez19 += ti.getText(19) != "" ? Double.parseDouble(ti.getText(19)) : 0.0;
            rez20 += ti.getText(20) != "" ? Double.parseDouble(ti.getText(20)) : 0.0;
            rez21 += ti.getText(21) != "" ? Double.parseDouble(ti.getText(21)) : 0.0;
            rez22 += ti.getText(22) != "" ? Double.parseDouble(ti.getText(22)) : 0.0;
            rez23 += ti.getText(23) != "" ? Double.parseDouble(ti.getText(23)) : 0.0;
            rez24 += ti.getText(24) != "" ? Double.parseDouble(ti.getText(24)) : 0.0;
            ukupno += ti.getText(25) != "" ? Double.parseDouble(ti.getText(25)) : 0.0;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText("");
        item = new TableItem(this.table, 0);
        item.setBackground(Display.getCurrent().getSystemColor(15));
        String[] st = new String[]{"Ukupno: ", Konstante.getNumber02(rez1), Konstante.getNumber02(rez2), Konstante.getNumber02(rez3), Konstante.getNumber02(rez4), Konstante.getNumber02(rez5), Konstante.getNumber02(rez6), Konstante.getNumber02(rez7), Konstante.getNumber02(rez8), Konstante.getNumber02(rez9), Konstante.getNumber02(rez10), Konstante.getNumber02(rez11), Konstante.getNumber02(rez12), Konstante.getNumber02(rez13), Konstante.getNumber02(rez14), Konstante.getNumber02(rez15), Konstante.getNumber02(rez16), Konstante.getNumber02(rez17), Konstante.getNumber02(rez18), Konstante.getNumber02(rez19), Konstante.getNumber02(rez20), Konstante.getNumber02(rez21), Konstante.getNumber02(rez22), Konstante.getNumber02(rez23), Konstante.getNumber02(rez24), Konstante.getNumber02(ukupno)};
        item.setText(st);
        int i = 1;
        double najveci = 0.0;
        HashMap<Double, Integer> mapa = new HashMap<Double, Integer>();
        for (String s : st) {
            if (s.equals("Ukupno: ") || s.equals(st[st.length - 1]) || s.equals(st[st.length - 2])) continue;
            double d = Double.valueOf(s);
            if (d > najveci) {
                najveci = d;
                mapa.put(najveci, i);
            }
            ++i;
        }
        item.setForeground(((Integer)mapa.get(najveci)).intValue(), Display.getCurrent().getSystemColor(3));
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AnalizaProdajePoSatimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        int totalPodgrupe = 0;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        private boolean medjuzbir;

        public AnalizaProdajePoSatimaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_SATIMA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setData((Object)cp);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 100;
            data1.heightHint = 20;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data1);
            this.doDatuma.getControl().setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.medjuzbir = false;
                ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                for (Button b : this.crnaDugmici) {
                    CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                    if (!b.getSelection()) continue;
                    if (cp.getMedjuZbir() != null && cp.getMedjuZbir().booleanValue()) {
                        this.medjuzbir = true;
                        continue;
                    }
                    crna.add(cp);
                }
                this.server.log(String.format(this.barmasterText.getString("LOG_ANALIZA_PRODAJE_PO_SATIMA_ZA_PERIOD_OD_DATUMA_DO_DATUMA"), StatLogic.getDateString(this.day1), StatLogic.getDateString(this.day2)));
                new AnalizaProdajePoSatima(this.shell, this.restoran, this.day1, this.day2, bela, crna, this.medjuzbir);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

