/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaTopArtikliPoPodgrupama;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AnalizaProdajePoNedelji {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    private Restoran restoran;
    private RestoranServer server;
    Table table;
    Shell shell;
    boolean sifre;
    List<Map<String, Object>> ppaArtData;
    List<Map<String, Object>> ppaFinanceData;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AnalizaProdajePoNedelji(Shell s, Restoran re, final Date d1, Date d3, List<NacinPlacanja> bela, List<CrnoPlacanje> cp, boolean mz) {
        this.restoran = re;
        this.server = this.restoran.getServer();
        this.server.refresh();
        this.shell = new Shell(s, 34912);
        this.ppaArtData = new LinkedList<Map<String, Object>>();
        this.ppaFinanceData = new LinkedList<Map<String, Object>>();
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_NEDELJI"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-> +7dana ---> " + StatLogic.getDateString(d3) + "-> +7dana");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        c1.set(5, c1.get(5) + 6);
        final Date d2 = c1.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d3);
        c2.set(5, c2.get(5) + 6);
        Date d4 = c2.getTime();
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2) && this.server.isEmptyDateZD(d3, d4) || this.server.isBeforeDateZD(d4)) {
            Konstante.getPoruka3(this.shell, String.format(this.barmasterText.getString("PORUKA_ZA_IZBRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        try {
            this.sifre = this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
        }
        catch (Exception e) {
            this.sifre = false;
        }
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(7, false));
        if (!bela.isEmpty() && bela.size() < NacinPlacanja.values().length) {
            try {
                if (this.server.hasCombinedPayments(d1, d2)) {
                    SWTMessage.showLocalizedMessageDialog(this.shell, this.barmasterText.getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_DA_IZABERETE_SVA_4_OSNOVNA_TIPA_NAPLATE"));
                    return;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PrometPoArtiklimaTopArtikliPoPodgrupama.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedWarningDialog(this.shell, Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_PROVERE_KOMBINOVANE_NAPLATE"));
            }
        }
        this.table = new Table((Composite)this.shell, 66370);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 7;
        this.table.setLayoutData((Object)data);
        this.makeHeaders(d1, d2, d3, d4);
        try {
            this.insertRows(bela, cp, d1, d2, d3, d4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (TableColumn tc : this.table.getColumns()) {
            tc.pack();
        }
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 120;
        data.horizontalAlignment = 16384;
        Button printButton = new Button((Composite)this.shell, 72);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(this.barmasterText.getString("TEXT_STAMPA_A4"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(AnalizaProdajePoNedelji.this.table), false, true, String.format(AnalizaProdajePoNedelji.this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_NEDELJI"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), AnalizaProdajePoNedelji.this.shell, AnalizaProdajePoNedelji.this.server);
            }
        });
        printButton.setLayoutData((Object)data);
        Button export = new Button((Composite)this.shell, 72);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(this.barmasterText.getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(AnalizaProdajePoNedelji.this.table, AnalizaProdajePoNedelji.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        export.setLayoutData((Object)data);
        Button izlaz = new Button((Composite)this.shell, 72);
        izlaz.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AnalizaProdajePoNedelji.this.shell.close();
            }
        });
        data = new GridData();
        data.heightHint = 50;
        data.widthHint = 150;
        data.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)data);
        this.shell.setMaximized(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void makeHeaders(Date d1, Date d2, Date d3, Date d4) {
        SimpleDateFormat format1 = new SimpleDateFormat("dd-MM-yy");
        TableColumn tc0 = new TableColumn(this.table, 131072);
        tc0.setText("Dan");
        tc0.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 131072);
        tc1.setText(format1.format(d1) + " do " + format1.format(d2));
        tc1.setWidth(100);
        TableColumn tc2 = new TableColumn(this.table, 131072);
        tc2.setText(format1.format(d3) + " do " + format1.format(d4));
        tc2.setWidth(100);
        TableColumn tc3 = new TableColumn(this.table, 131072);
        tc3.setText("%");
        tc3.setWidth(60);
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText("Broj racuna P1");
        tc4.setWidth(100);
        TableColumn tc5 = new TableColumn(this.table, 131072);
        tc5.setText("Broj racuna P2");
        tc5.setWidth(100);
        TableColumn tc6 = new TableColumn(this.table, 131072);
        tc6.setText("%");
        tc6.setWidth(100);
        TableColumn tc7 = new TableColumn(this.table, 131072);
        tc7.setText("Prosecan iznos racuna P1");
        tc7.setWidth(100);
        TableColumn tc8 = new TableColumn(this.table, 131072);
        tc8.setText("Prosecan iznos racuna P2");
        tc8.setWidth(100);
        TableColumn tc9 = new TableColumn(this.table, 131072);
        tc9.setText("%");
        tc9.setWidth(100);
    }

    public static List<Date> getDaysBetweenDates(Date startdate, Date enddate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startdate);
        GregorianCalendar calendarNew = new GregorianCalendar();
        calendarNew.setTime(enddate);
        ((Calendar)calendarNew).add(5, 1);
        while (calendar.getTime().before(calendarNew.getTime())) {
            Date result = calendar.getTime();
            dates.add(result);
            ((Calendar)calendar).add(5, 1);
        }
        return dates;
    }

    private void insertRows(List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp, Date from, Date to, Date fromPick, Date toPick) throws Exception {
        List<Date> listaDate = AnalizaProdajePoNedelji.getDaysBetweenDates(from, to);
        List<Date> listaDatePick = AnalizaProdajePoNedelji.getDaysBetweenDates(fromPick, toPick);
        this.popuniTabelu(listaDate, listaDatePick, belaPlacanja, cp);
    }

    public void popuniTabelu(List<Date> lista, List<Date> listaPick, List<NacinPlacanja> belaPlacanja, List<CrnoPlacanje> cp) {
        int i;
        String dayOfWeek;
        List<Map<String, Object>> listaVrednosti;
        Date d2;
        Date d1;
        EnumSet<NacinPlacanja> bp;
        int j;
        HashMap<String, Double> dani = new HashMap<String, Double>();
        String[] days = new String[]{"Ponedeljak", "Utorak", "Sreda", "Cetvrtak", "Petak", "Subota", "Nedelja"};
        double PonedeljakCurrent = 0.0;
        double PonedeljakPick = 0.0;
        double PonedeljakRacun = 0.0;
        double PonedeljakRacunPick = 0.0;
        double UtorakCurrent = 0.0;
        double UtorakPick = 0.0;
        double UtorakRacun = 0.0;
        double UtorakRacunPick = 0.0;
        double SredaCurrent = 0.0;
        double SredaPick = 0.0;
        double SredaRacun = 0.0;
        double SredaRacunPick = 0.0;
        double CetvrtakCurrent = 0.0;
        double CetvrtakPick = 0.0;
        double CetvrtakRacun = 0.0;
        double CetvrtakRacunPick = 0.0;
        double PetakCurrent = 0.0;
        double PetakPick = 0.0;
        double PetakRacun = 0.0;
        double PetakRacunPick = 0.0;
        double SubotaCurrent = 0.0;
        double SubotaPick = 0.0;
        double SubotaRacun = 0.0;
        double SubotaRacunPick = 0.0;
        double NedeljaCurrent = 0.0;
        double NedeljaPick = 0.0;
        double NedeljaRacun = 0.0;
        double NedeljaRacunPick = 0.0;
        for (j = 0; j < lista.size(); ++j) {
            bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
            d1 = this.server.getPocetni(lista.get(j));
            d2 = this.server.getKrajnji(lista.get(j));
            listaVrednosti = this.server.getAnalizaProdajePoNedeljama(d1, d2, bp, cp);
            dayOfWeek = new SimpleDateFormat("EEEE", Locale.ENGLISH).format(lista.get(j).getTime());
            for (i = 0; i < listaVrednosti.size(); ++i) {
                if (dayOfWeek.equals("Monday")) {
                    PonedeljakCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    PonedeljakRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Tuesday")) {
                    UtorakCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    UtorakRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Wednesday")) {
                    SredaCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    SredaRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Thursday")) {
                    CetvrtakCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    CetvrtakRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Friday")) {
                    PetakCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    PetakRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Saturday")) {
                    SubotaCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    SubotaRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (!dayOfWeek.equals("Sunday")) continue;
                NedeljaCurrent = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                NedeljaRacun = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
            }
        }
        for (j = 0; j < listaPick.size(); ++j) {
            bp = belaPlacanja.isEmpty() ? EnumSet.noneOf(NacinPlacanja.class) : EnumSet.copyOf(belaPlacanja);
            d1 = this.server.getPocetni(listaPick.get(j));
            d2 = this.server.getKrajnji(listaPick.get(j));
            listaVrednosti = this.server.getAnalizaProdajePoNedeljama(d1, d2, bp, cp);
            dayOfWeek = new SimpleDateFormat("EEEE", Locale.ENGLISH).format(listaPick.get(j).getTime());
            for (i = 0; i < listaVrednosti.size(); ++i) {
                if (dayOfWeek.equals("Monday")) {
                    PonedeljakPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    PonedeljakRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Tuesday")) {
                    UtorakPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    UtorakRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Wednesday")) {
                    SredaPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    SredaRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Thursday")) {
                    CetvrtakPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    CetvrtakRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Friday")) {
                    PetakPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    PetakRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (dayOfWeek.equals("Saturday")) {
                    SubotaPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                    SubotaRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
                    continue;
                }
                if (!dayOfWeek.equals("Sunday")) continue;
                NedeljaPick = (Double)listaVrednosti.get(i).get("Promet_Prvi");
                NedeljaRacunPick = ((Long)listaVrednosti.get(i).get("Broj racuna prvi")).longValue();
            }
        }
        dani.put("Ponedeljak", PonedeljakCurrent);
        dani.put("PonedeljakPick", PonedeljakPick);
        dani.put("PonedeljakRacun", PonedeljakRacun);
        dani.put("PonedeljakRacunPick", PonedeljakRacunPick);
        dani.put("Utorak", UtorakCurrent);
        dani.put("UtorakPick", UtorakPick);
        dani.put("UtorakRacun", UtorakRacun);
        dani.put("UtorakRacunPick", UtorakRacunPick);
        dani.put("Sreda", SredaCurrent);
        dani.put("SredaPick", SredaPick);
        dani.put("SredaRacun", SredaRacun);
        dani.put("SredaRacunPick", SredaRacunPick);
        dani.put("Cetvrtak", CetvrtakCurrent);
        dani.put("CetvrtakPick", CetvrtakPick);
        dani.put("CetvrtakRacun", CetvrtakRacun);
        dani.put("CetvrtakRacunPick", CetvrtakRacunPick);
        dani.put("Petak", PetakCurrent);
        dani.put("PetakPick", PetakPick);
        dani.put("PetakRacun", PetakRacun);
        dani.put("PetakRacunPick", PetakRacunPick);
        dani.put("Subota", SubotaCurrent);
        dani.put("SubotaPick", SubotaPick);
        dani.put("SubotaRacun", SubotaRacun);
        dani.put("SubotaRacunPick", SubotaRacunPick);
        dani.put("Nedelja", NedeljaCurrent);
        dani.put("NedeljaPick", NedeljaPick);
        dani.put("NedeljaRacun", NedeljaRacun);
        dani.put("NedeljaRacunPick", NedeljaRacunPick);
        for (int i2 = 0; i2 < days.length; ++i2) {
            TableItem item = new TableItem(this.table, 0);
            if (days[i2].equals("Ponedeljak")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Ponedeljak"));
                item.setText(2, "" + dani.get("PonedeljakPick"));
                if ((Double)dani.get("Ponedeljak") == 0.0 && (Double)dani.get("PonedeljakPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Ponedeljak") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("PonedeljakPick") / (Double)dani.get("PonedeljakRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("PonedeljakPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Ponedeljak") / (Double)dani.get("PonedeljakRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("PonedeljakPick") / (Double)dani.get("Ponedeljak")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("PonedeljakRacunPick") / (Double)dani.get("PonedeljakRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Ponedeljak") / (Double)dani.get("PonedeljakRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("PonedeljakPick") / (Double)dani.get("PonedeljakRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Ponedeljak") / (Double)dani.get("PonedeljakRacun") / ((Double)dani.get("PonedeljakPick") / (Double)dani.get("PonedeljakRacunPick"))));
                }
                item.setText(4, "" + dani.get("PonedeljakRacun"));
                item.setText(5, "" + dani.get("PonedeljakRacunPick"));
                continue;
            }
            if (days[i2].equals("Utorak")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Utorak"));
                item.setText(2, "" + dani.get("UtorakPick"));
                if ((Double)dani.get("Utorak") == 0.0 && (Double)dani.get("UtorakPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Utorak") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("UtorakPick") / (Double)dani.get("UtorakRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("UtorakPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Utorak") / (Double)dani.get("UtorakRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("UtorakPick") / (Double)dani.get("Utorak")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("UtorakRacunPick") / (Double)dani.get("UtorakRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Utorak") / (Double)dani.get("UtorakRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("UtorakPick") / (Double)dani.get("UtorakRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Utorak") / (Double)dani.get("UtorakRacun") / ((Double)dani.get("UtorakPick") / (Double)dani.get("UtorakRacunPick"))));
                }
                item.setText(4, "" + dani.get("UtorakRacun"));
                item.setText(5, "" + dani.get("UtorakRacunPick"));
                continue;
            }
            if (days[i2].equals("Sreda")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Sreda"));
                item.setText(2, "" + dani.get("SredaPick"));
                if ((Double)dani.get("Sreda") == 0.0 && (Double)dani.get("SredaPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Sreda") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("SredaPick") / (Double)dani.get("SredaRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("SredaPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Sreda") / (Double)dani.get("SredaRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("SredaPick") / (Double)dani.get("Sreda")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("SredaRacunPick") / (Double)dani.get("SredaRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Sreda") / (Double)dani.get("SredaRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("SredaPick") / (Double)dani.get("SredaRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Sreda") / (Double)dani.get("SredaRacun") / ((Double)dani.get("SredaPick") / (Double)dani.get("SredaRacunPick"))));
                }
                item.setText(4, "" + dani.get("SredaRacun"));
                item.setText(5, "" + dani.get("SredaRacunPick"));
                continue;
            }
            if (days[i2].equals("Cetvrtak")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Cetvrtak"));
                item.setText(2, "" + dani.get("CetvrtakPick"));
                if ((Double)dani.get("Cetvrtak") == 0.0 && (Double)dani.get("CetvrtakPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Cetvrtak") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("CetvrtakPick") / (Double)dani.get("CetvrtakRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("CetvrtakPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Cetvrtak") / (Double)dani.get("CetvrtakRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("CetvrtakPick") / (Double)dani.get("Cetvrtak")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("CetvrtakRacunPick") / (Double)dani.get("CetvrtakRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Cetvrtak") / (Double)dani.get("CetvrtakRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("CetvrtakPick") / (Double)dani.get("CetvrtakRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Cetvrtak") / (Double)dani.get("CetvrtakRacun") / ((Double)dani.get("CetvrtakPick") / (Double)dani.get("CetvrtakRacunPick"))));
                }
                item.setText(4, "" + dani.get("CetvrtakRacun"));
                item.setText(5, "" + dani.get("CetvrtakRacunPick"));
                continue;
            }
            if (days[i2].equals("Petak")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Petak"));
                item.setText(2, "" + dani.get("PetakPick"));
                if ((Double)dani.get("Petak") == 0.0 && (Double)dani.get("PetakPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Petak") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("PetakPick") / (Double)dani.get("PetakRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("PetakPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Petak") / (Double)dani.get("PetakRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("PetakPick") / (Double)dani.get("Petak")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("PetakRacunPick") / (Double)dani.get("PetakRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Petak") / (Double)dani.get("PetakRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("PetakPick") / (Double)dani.get("PetakRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Petak") / (Double)dani.get("PetakRacun") / ((Double)dani.get("PetakPick") / (Double)dani.get("PetakRacunPick"))));
                }
                item.setText(4, "" + dani.get("PetakRacun"));
                item.setText(5, "" + dani.get("PetakRacunPick"));
                continue;
            }
            if (days[i2].equals("Subota")) {
                item.setText(0, days[i2]);
                item.setText(1, "" + dani.get("Subota"));
                item.setText(2, "" + dani.get("SubotaPick"));
                if ((Double)dani.get("Subota") == 0.0 && (Double)dani.get("SubotaPick") == 0.0) {
                    item.setText(3, "0");
                    item.setText(6, "0");
                    item.setText(7, "0");
                    item.setText(8, "0");
                    item.setText(9, "0");
                } else if ((Double)dani.get("Subota") == 0.0) {
                    item.setText(3, "-100");
                    item.setText(6, "-100");
                    item.setText(7, "0");
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("SubotaPick") / (Double)dani.get("SubotaRacunPick")));
                    item.setText(9, "-100");
                } else if ((Double)dani.get("SubotaPick") == 0.0) {
                    item.setText(3, "100");
                    item.setText(6, "100");
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Subota") / (Double)dani.get("SubotaRacun")));
                    item.setText(8, "0");
                    item.setText(9, "100");
                } else {
                    item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("SubotaPick") / (Double)dani.get("Subota")));
                    item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("SubotaRacunPick") / (Double)dani.get("SubotaRacun")));
                    item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Subota") / (Double)dani.get("SubotaRacun")));
                    item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("SubotaPick") / (Double)dani.get("SubotaRacunPick")));
                    item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Subota") / (Double)dani.get("SubotaRacun") / ((Double)dani.get("SubotaPick") / (Double)dani.get("SubotaRacunPick"))));
                }
                item.setText(4, "" + dani.get("SubotaRacun"));
                item.setText(5, "" + dani.get("SubotaRacunPick"));
                continue;
            }
            if (!days[i2].equals("Nedelja")) continue;
            item.setText(0, days[i2]);
            item.setText(1, "" + dani.get("Nedelja"));
            item.setText(2, "" + dani.get("NedeljaPick"));
            if ((Double)dani.get("Nedelja") == 0.0 && (Double)dani.get("NedeljaPick") == 0.0) {
                item.setText(3, "0");
                item.setText(6, "0");
                item.setText(7, "0");
                item.setText(8, "0");
                item.setText(9, "0");
            } else if ((Double)dani.get("Nedelja") == 0.0) {
                item.setText(3, "-100");
                item.setText(6, "-100");
                item.setText(7, "0");
                item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("NedeljaPick") / (Double)dani.get("NedeljaRacunPick")));
                item.setText(9, "-100");
            } else if ((Double)dani.get("NedeljaPick") == 0.0) {
                item.setText(3, "100");
                item.setText(6, "100");
                item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Nedelja") / (Double)dani.get("NedeljaRacun")));
                item.setText(8, "0");
                item.setText(9, "100");
            } else {
                item.setText(3, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("NedeljaPick") / (Double)dani.get("Nedelja")));
                item.setText(6, "" + StatLogic.getNumber02(100.0 - 100.0 * (Double)dani.get("NedeljaRacunPick") / (Double)dani.get("NedeljaRacun")));
                item.setText(7, "" + StatLogic.getNumber02((Double)dani.get("Nedelja") / (Double)dani.get("NedeljaRacun")));
                item.setText(8, "" + StatLogic.getNumber02((Double)dani.get("NedeljaPick") / (Double)dani.get("NedeljaRacunPick")));
                item.setText(9, "" + StatLogic.getNumber02((Double)dani.get("Nedelja") / (Double)dani.get("NedeljaRacun") / ((Double)dani.get("NedeljaPick") / (Double)dani.get("NedeljaRacunPick"))));
            }
            item.setText(4, "" + dani.get("NedeljaRacun"));
            item.setText(5, "" + dani.get("NedeljaRacunPick"));
        }
    }

    public class NameComparator
    implements Comparator<Artikal> {
        @Override
        public int compare(Artikal o1, Artikal o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AnalizaProdajePoSatimaInput {
        private final ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private DateInput2 odDatumaLast;
        private DateInput2 doDatumaLast;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day3;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        Odeljenje o;
        int totalPodgrupe = 0;
        SWTContainer parent;
        Shell shell;
        Composite mainComposite;
        Label bp;
        private boolean medjuzbir;

        public AnalizaProdajePoSatimaInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = this.parent.getControl().getShell();
            this.shell.setLayout((Layout)new FillLayout());
            ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
            this.mainComposite = new Composite((Composite)sc, 0);
            sc.setContent((Control)this.mainComposite);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            this.mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite(this.mainComposite, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            Composite panel2 = new Composite(this.mainComposite, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)this.mainComposite.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_NEDELJI"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData(4, 4, false, false);
            data.widthHint = 670;
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 80;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(8, false));
            grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_NEDELJE"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_NEDELJE"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 55;
            Label odLast = new Label((Composite)grupa1, 0);
            odLast.setText(String.format(this.barmasterText.getString("TEXT_DO_NEDELJE"), new Object[0]) + ":");
            this.odDatumaLast = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_NEDELJE"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatumaLast.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatumaLast, this.shell));
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setData((Object)cp);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 100;
            data.heightHint = 30;
            GridData data1 = new GridData();
            data1.horizontalAlignment = 16384;
            data1.horizontalIndent = 10;
            data1.widthHint = 100;
            data1.heightHint = 20;
            od.setLayoutData((Object)data);
            odLast.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data1);
            this.odDatumaLast.getControl().setLayoutData((Object)data1);
            this.mainComposite.layout();
            sc.setMinSize(this.mainComposite.computeSize(-1, -1));
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day3 = this.odDatumaLast.getResult();
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                }
                this.medjuzbir = false;
                ArrayList<CrnoPlacanje> crna = new ArrayList<CrnoPlacanje>();
                for (Button b : this.crnaDugmici) {
                    CrnoPlacanje cp = (CrnoPlacanje)b.getData();
                    if (!b.getSelection()) continue;
                    if (cp.getMedjuZbir() != null && cp.getMedjuZbir().booleanValue()) {
                        this.medjuzbir = true;
                        continue;
                    }
                    crna.add(cp);
                }
                this.server.log(String.format(this.barmasterText.getString("TEXT_ANALIZA_PRODAJE_PO_NEDELJI"), StatLogic.getDateString(this.day1) + "+7dana", StatLogic.getDateString(this.day3) + "+7dana"));
                new AnalizaProdajePoNedelji(this.shell, this.restoran, this.day1, this.day3, bela, crna, this.medjuzbir);
            }
            catch (Exception ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(this.barmasterText.getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

