/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.izvestaji;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.comparators.StalniGostNazivComparator;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.XLSExporter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AnalizaPotrosnjeStalniGosti {
    private Restoran restoran;
    private RestoranServer server;
    Shell shell;
    Composite composite;
    SortedMap<StalniGost, List<Racun>> sgRacuni;
    Date day1;
    Date day2;
    private boolean saNabavnimCenama;
    private boolean poProdajnimCenama;
    private static double cifra1;
    private static double cifra2;
    private TableEditor editor;
    private Table table;
    private TableItem item;
    private TableItem previousItem;
    private int indexOfSelected = 0;
    private boolean selection = false;
    private List<StalniGost> sgLista;
    List<StalniGost> gosti = new LinkedList<StalniGost>();

    public AnalizaPotrosnjeStalniGosti(Shell sh, Restoran rest, StalniGostiGrupa gr, StalniGost kom, final Date d1, final Date d2, List<NacinPlacanja> bela, List<String> crna, boolean saNabavnimCenama, boolean stalniGosti, double c1, double c2) {
        List<Racun> racuniTemp;
        this.saNabavnimCenama = saNabavnimCenama;
        this.poProdajnimCenama = stalniGosti;
        this.restoran = rest;
        this.server = this.restoran.getServer();
        cifra1 = c1;
        cifra2 = c2;
        this.shell = sh;
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.sgLista = new LinkedList<StalniGost>();
        if (this.server.isEmptyDateZD(d1, d2) || this.server.isBeforeDateZD(d2)) {
            Konstante.getPoruka3(this.shell, String.format(Konstante.getBundle().getString("PORUKA_ZA_IZABRANI_PERIOD_NEMA_PODATAKA"), new Object[0]));
            return;
        }
        this.day1 = Konstante.getPocetniDatum(d1, this.server);
        this.day2 = Konstante.getKrajnjiDatum(d2, this.server);
        try {
            racuniTemp = this.server.getRacuniStalni(gr, kom, this.day1, this.day2);
        }
        catch (Exception ex) {
            Logger.getLogger(AnalizaPotrosnjeStalniGosti.class.getName()).log(Level.INFO, "Greska kod citanja racuna za stalne goste " + ex.getMessage(), ex);
            racuniTemp = new LinkedList<Racun>();
        }
        System.out.println("racuniTemp = " + racuniTemp.size());
        this.sgRacuni = new TreeMap<StalniGost, List<Racun>>(new StalniGostNazivComparator());
        for (Racun r : racuniTemp) {
            if (r.getCrnoPlacanje() == null) {
                if (bela.size() < 4 && r.getPlacanja().size() > 1) {
                    Konstante.getPoruka3(this.shell, String.format(Konstante.getBundle().getString("PORUKA_ZBOG_KOMBINOVANOG_NACINA_NAPLATE_MORATE_IZABRATI_SVA_4_OSNOVNA_TIPA_NAPLATE"), new Object[0]));
                    return;
                }
                if (!bela.contains((Object)r.getPlacanja().get(0).getNacin())) continue;
                if (!this.sgRacuni.containsKey(r.getStalniGost())) {
                    this.sgRacuni.put(r.getStalniGost(), new LinkedList<Racun>(Arrays.asList(r)));
                    continue;
                }
                ((List)this.sgRacuni.get(r.getStalniGost())).add(r);
                continue;
            }
            if (!crna.contains(r.getCrnoPlacanje())) continue;
            if (!this.sgRacuni.containsKey(r.getStalniGost())) {
                this.sgRacuni.put(r.getStalniGost(), new LinkedList<Racun>(Arrays.asList(r)));
                continue;
            }
            ((List)this.sgRacuni.get(r.getStalniGost())).add(r);
        }
        this.table = new Table((Composite)this.shell, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.horizontalSpan = 3;
        this.table.setLayoutData((Object)data);
        this.makeHeaders();
        this.insertRows();
        Composite control1 = new Composite((Composite)this.shell, 0);
        control1.setLayout((Layout)new GridLayout(3, false));
        control1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData gd = new GridData(16384, 4, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        Button printButton = new Button(control1, 8);
        printButton.setLayoutData((Object)gd);
        try {
            printButton.setImage(ImageCache.getImage("print.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        printButton.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (AnalizaPotrosnjeStalniGosti.this.day2.after(new Date()) && AnalizaPotrosnjeStalniGosti.this.server.getStolove().size() > 0) {
                    Konstante.getPoruka(AnalizaPotrosnjeStalniGosti.this.shell, String.format(Konstante.getBundle().getString("PORUKA_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    return;
                }
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(AnalizaPotrosnjeStalniGosti.this.table), false, true, String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU"), new Object[0]) + ": " + StatLogic.getDateString(d1) + "-->" + StatLogic.getDateString(d2), AnalizaPotrosnjeStalniGosti.this.shell, AnalizaPotrosnjeStalniGosti.this.server);
            }
        });
        Button export = new Button(control1, 8);
        export.setLayoutData((Object)gd);
        try {
            export.setImage(ImageCache.getImage("xls-icon.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        export.setText(String.format(Konstante.getBundle().getString("TEXT_EXCEL_IZVOZ"), new Object[0]));
        export.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    XLSExporter.exportTable(AnalizaPotrosnjeStalniGosti.this.table, AnalizaPotrosnjeStalniGosti.this.shell);
                }
                catch (IOException ex) {
                    Logger.getLogger(PrometSvihKonobara.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        Button izlaz = new Button(control1, 8);
        gd = new GridData(131072, 4, false, false);
        gd.heightHint = 50;
        gd.widthHint = 150;
        gd.horizontalAlignment = 131072;
        izlaz.setLayoutData((Object)gd);
        izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        izlaz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AnalizaPotrosnjeStalniGosti.this.shell.close();
            }
        });
        this.addEditor(this.table);
        this.shell.setMaximized(true);
        this.shell.open();
    }

    private void makeHeaders() {
        TableColumn tc4 = new TableColumn(this.table, 131072);
        tc4.setText(String.format(Konstante.getBundle().getString("TEXT_GOST"), new Object[0]));
        tc4.setWidth(140);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        tc2.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_RACUNA"), new Object[0]));
        tc2.pack();
        TableColumn tc9 = new TableColumn(this.table, 0x1000000);
        tc9.setText(String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0]));
        tc9.setWidth(140);
        TableColumn tc1 = new TableColumn(this.table, 0x1000000);
        tc1.setText(String.format(Konstante.getBundle().getString("TEXT_PROSECAN_IZNOS"), new Object[0]));
        tc1.setWidth(140);
        if (this.saNabavnimCenama) {
            TableColumn tc99 = new TableColumn(this.table, 0x1000000);
            tc99.setText(String.format(Konstante.getBundle().getString("TEXT_SA_NABAVNOM_CENOM"), new Object[0]));
            tc99.setWidth(140);
        }
        if (this.poProdajnimCenama) {
            TableColumn tc999 = new TableColumn(this.table, 0x1000000);
            tc999.setText(String.format(Konstante.getBundle().getString("TEXT_PO_PRODAJNIM_CENAMA"), new Object[0]));
            tc999.setWidth(140);
        }
        TableColumn tc6 = new TableColumn(this.table, 0x1000000);
        tc6.setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_GOSTIJU_PO_RACUNU"), new Object[0]));
        tc6.setWidth(140);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc3.setText(String.format(Konstante.getBundle().getString("TEXT_POPUST"), new Object[0]));
        tc3.setWidth(140);
    }

    private void insertRows() {
        double total = 0.0;
        double totali = 0.0;
        double ukupnoNabavno = 0.0;
        for (Map.Entry<StalniGost, List<Racun>> entry : this.sgRacuni.entrySet()) {
            double nvTotal = 0.0;
            double ukupnoProdajno = 0.0;
            int brojRacuna = 0;
            StalniGost stalniGost = entry.getKey();
            this.gosti.add(stalniGost);
            List<Racun> racuni = entry.getValue();
            brojRacuna = racuni.size();
            double sgTotal = 0.0;
            double sgNvTotal = 0.0;
            double brRacuna = 0.0;
            double totalPoGostu = 0.0;
            double nabavna = 0.0;
            double brojGostiju = 0.0;
            for (Racun r : racuni) {
                double prodajna = 0.0;
                double nv = 0.0;
                totali += r.total();
                totalPoGostu += r.total();
                if (r.getBrojGostiju() == null || r.getBrojGostiju().equals("")) {
                    r.setBrojGostiju("1");
                }
                brojGostiju += r.getBrojGostiju() != null ? (double)Integer.parseInt(r.getBrojGostiju()) : 0.0;
                brRacuna += brRacuna;
                sgTotal += r.totalBezPopusta();
                if (this.poProdajnimCenama) {
                    prodajna += r.totalBezPopusta();
                }
                List<StavkaRacuna> temp = r.getStavke();
                if (!this.saNabavnimCenama) continue;
                for (StavkaRacuna sr : temp == null || temp.isEmpty() ? this.server.getStavke(r) : temp) {
                    double nc = 0.0;
                    if (sr.getArtikal().getTip().equals((Object)TipArtikla.PROD) | sr.getArtikal().getTip().equals((Object)TipArtikla.SIRO)) {
                        nc = sr.getArtikal().getTrenutnaNV() * sr.getKolicina();
                    } else {
                        double ncPoJMpdv = 0.0;
                        if (sr.getArtikal().getTip() == TipArtikla.SLOZ) {
                            double ncPoJM = 0.0;
                            double ncPoNM = 0.0;
                            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziArtikal(sr.getArtikal(), 1.0, this.server, sr.getRacun().getDatum());
                            for (Map.Entry<Artikal, Double> entrya : mapa.entrySet()) {
                                Artikal sastojak = entrya.getKey();
                                Double kolicina = entrya.getValue();
                                double ncPoJMTmp = kolicina * this.server.getLastNabavnaCenaBela(sastojak, new Date());
                                ncPoJM += ncPoJMTmp;
                                nc += ncPoJMTmp * sr.getArtikal().getMera();
                            }
                        } else {
                            nc = this.server.getLastNabavnaCenaBela(sr.getArtikal(), new Date());
                            nc = nc * (1.0 + Konstante.getPdvPoPG(sr.getArtikal().getPoreskaGrupa())) * sr.getKolicina();
                        }
                    }
                    nv += nc;
                }
                ukupnoProdajno += prodajna;
                nvTotal += nv;
            }
            if (cifra1 > 0.0 && cifra2 > 0.0) {
                if (totalPoGostu < cifra1 || totalPoGostu > cifra2) continue;
                total += totalPoGostu;
                this.sgLista.add(entry.getKey());
            }
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, entry.getKey().getNaziv());
            ti.setFont(Konstante.getFont(this.shell.getDisplay(), 10, 1));
            ti = new TableItem(this.table, 0);
            int i = 0;
            ti.setText(i++, "");
            ti.setText(i++, "" + brojRacuna);
            ti.setText(i++, Konstante.getNumber2(totalPoGostu));
            ti.setText(i++, Konstante.getNumber2(totalPoGostu / (double)brojRacuna));
            if (this.saNabavnimCenama) {
                ti.setText(i++, Konstante.getNumber2(nvTotal));
            }
            if (this.poProdajnimCenama) {
                ti.setText(i++, Konstante.getNumber02(ukupnoProdajno));
            }
            ti.setText(i++, Konstante.getNumber2(brojGostiju != 0.0 ? brojGostiju : 0.0));
            ti.setText(i++, entry.getKey().getPopust().toString());
            ukupnoNabavno += nvTotal;
        }
        TableItem ti = new TableItem(this.table, 0);
        ti = new TableItem(this.table, 0);
        ti.setText(1, String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]).toUpperCase());
        if (cifra1 > 0.0 && cifra2 > 0.0) {
            ti.setText(2, StatLogic.getNumber02NG(total));
        } else {
            ti.setText(2, StatLogic.getNumber02NG(totali));
        }
        if (this.saNabavnimCenama) {
            ti.setText(4, StatLogic.getNumber02NG(ukupnoNabavno));
        }
    }

    public void addEditor(final Table table) {
        table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("Cena");
                AnalizaPotrosnjeStalniGosti.this.item = (TableItem)event.item;
                AnalizaPotrosnjeStalniGosti.this.indexOfSelected = table.indexOf(AnalizaPotrosnjeStalniGosti.this.item);
                AnalizaPotrosnjeStalniGosti.this.updatePopust(AnalizaPotrosnjeStalniGosti.this.item, table);
                AnalizaPotrosnjeStalniGosti.this.selection = true;
            }
        });
    }

    protected void updatePopust(TableItem ti, final Table table) {
        if (ti != null) {
            table.setSelection(ti);
        } else {
            table.setSelection(-1);
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.previousItem = this.editor.getItem();
        }
        if (this.item == null) {
            return;
        }
        Text newEditor = new Text((Composite)table, 0);
        newEditor.setText(this.item.getText(this.saNabavnimCenama ? (this.poProdajnimCenama ? 7 : 6) : (this.poProdajnimCenama ? 6 : 5)));
        Double oldPopust = StatLogic.parseNumber01Suppress(this.item.getText(this.saNabavnimCenama ? (this.poProdajnimCenama ? 7 : 6) : (this.poProdajnimCenama ? 6 : 5))).doubleValue();
        System.out.println("CENA je " + this.item.getText(this.saNabavnimCenama ? (this.poProdajnimCenama ? 7 : 6) : (this.poProdajnimCenama ? 6 : 5)));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)AnalizaPotrosnjeStalniGosti.this.editor.getEditor();
                if (!text.getText().isEmpty()) {
                    AnalizaPotrosnjeStalniGosti.this.editor.getItem().setText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5), StatLogic.getNumber01NG(StatLogic.parseDouble01Suppress(text.getText())));
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, this.item, this.saNabavnimCenama ? (this.poProdajnimCenama ? 7 : 6) : (this.poProdajnimCenama ? 6 : 5));
        Listener list = new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000002 && e.type == 2) {
                    table.showSelection();
                    double razlika = StatLogic.parseNumber01Suppress(AnalizaPotrosnjeStalniGosti.this.item.getText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5))).doubleValue();
                    AnalizaPotrosnjeStalniGosti.this.item.setText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5), StatLogic.getNumber01NG(razlika));
                    e.widget.dispose();
                    AnalizaPotrosnjeStalniGosti.this.item = AnalizaPotrosnjeStalniGosti.this.item.getParent().getItem(AnalizaPotrosnjeStalniGosti.this.indexOfSelected);
                    AnalizaPotrosnjeStalniGosti.this.item.getParent().select(AnalizaPotrosnjeStalniGosti.this.indexOfSelected);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (AnalizaPotrosnjeStalniGosti.this.selection) {
                        AnalizaPotrosnjeStalniGosti.this.selection = false;
                        return;
                    }
                    if (e.type == 31) {
                        return;
                    }
                    if (e.type != 2) {
                        return;
                    }
                    System.out.println("enter brate");
                    Control oldEditor = AnalizaPotrosnjeStalniGosti.this.editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    System.out.println(table.getSelectionIndex());
                    StalniGost sg = null;
                    sg = cifra1 > 0.0 && cifra2 > 0.0 ? AnalizaPotrosnjeStalniGosti.this.server.getStalniGost(((StalniGost)AnalizaPotrosnjeStalniGosti.this.sgLista.get((table.getSelectionIndex() - 1) / 2)).getId()) : AnalizaPotrosnjeStalniGosti.this.server.getStalniGost(AnalizaPotrosnjeStalniGosti.this.gosti.get((table.getSelectionIndex() - 1) / 2).getId());
                    sg = (StalniGost)AnalizaPotrosnjeStalniGosti.this.server.getBase().find(StalniGost.class, (Object)sg.getId());
                    sg.setPopust(StatLogic.parseNumber01Suppress(AnalizaPotrosnjeStalniGosti.this.item.getText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5))).doubleValue());
                    AnalizaPotrosnjeStalniGosti.this.server.updateStalni(sg);
                } else if (e.keyCode == 0x1000001 && e.type == 2) {
                    table.showSelection();
                    double novaKolicina = StatLogic.parseNumber01Suppress(AnalizaPotrosnjeStalniGosti.this.item.getText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5))).doubleValue();
                    AnalizaPotrosnjeStalniGosti.this.item.setText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5), StatLogic.getNumber01NG(novaKolicina));
                    e.widget.dispose();
                    AnalizaPotrosnjeStalniGosti.this.item = AnalizaPotrosnjeStalniGosti.this.item.getParent().getItem(AnalizaPotrosnjeStalniGosti.this.indexOfSelected);
                    AnalizaPotrosnjeStalniGosti.this.item.getParent().select(AnalizaPotrosnjeStalniGosti.this.indexOfSelected);
                } else {
                    if (e.keyCode == 9 && e.type == 31 && (e.stateMask & 0x10000) != 0) {
                        return;
                    }
                    if (e.keyCode == 9 && e.type == 31) {
                        System.out.println("tab brate");
                        table.showSelection();
                        double novaKolicina = StatLogic.parseNumber01Suppress(AnalizaPotrosnjeStalniGosti.this.item.getText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5))).doubleValue();
                        AnalizaPotrosnjeStalniGosti.this.item.setText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5), StatLogic.getNumber01NG(novaKolicina));
                    } else {
                        if (e.type == 31 && e.keyCode == 27) {
                            if (AnalizaPotrosnjeStalniGosti.this.item != null && !AnalizaPotrosnjeStalniGosti.this.editor.getEditor().isDisposed()) {
                                table.showSelection();
                                double novaKolicina = StatLogic.parseNumber01Suppress(AnalizaPotrosnjeStalniGosti.this.item.getText(5)).doubleValue();
                                AnalizaPotrosnjeStalniGosti.this.item.setText(AnalizaPotrosnjeStalniGosti.this.saNabavnimCenama ? (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 7 : 6) : (AnalizaPotrosnjeStalniGosti.this.poProdajnimCenama ? 6 : 5), StatLogic.getNumber01NG(novaKolicina));
                                e.widget.dispose();
                                AnalizaPotrosnjeStalniGosti.this.item = null;
                            }
                            e.doit = false;
                            return;
                        }
                        if (e.type == 31) {
                            e.doit = false;
                            return;
                        }
                    }
                }
            }
        };
        newEditor.addListener(2, list);
        newEditor.addListener(31, list);
    }

    public static class AnalizaPotrosnjeStalniGostiInput {
        private DateInput2 odDatuma;
        Button nc;
        Button sg;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo grupe;
        private ComboViewer cvGrupe;
        private List<StalniGostiGrupa> cvGrupeInput;
        private Combo komitent;
        private ComboViewer cvKomitent;
        private String sviKomitentiL;
        private List<StalniGost> cvKomitentInput;
        Date day1;
        Date day2;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();
        SWTContainer parent;
        private TextInput2 cifraOd;
        private TextInput2 cifraDo;

        public AnalizaPotrosnjeStalniGostiInput(SWTContainer owner, Restoran r, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.sviKomitentiL = String.format(Konstante.getBundle().getString("TEXT_SVI_KOMITENTI"), new Object[0]);
            final Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = null;
            try {
                img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/prometV.gif");
            }
            catch (Exception exception) {
                // empty catch block
            }
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_ANALIZA_POTROSNJE_STALNOG_GOSTA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            Label uputstvo = new Label(panel1, 8);
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(Konstante.getBundle().getString("TEXT_STALNI_GOSTI"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 90;
            Group grupa21 = new Group(panel2, 0);
            grupa21.setLayout((Layout)new GridLayout(4, true));
            grupa21.setText(String.format(Konstante.getBundle().getString("TEXT_FILTER_NACINA_PLACANJA"), new Object[0]));
            grupa21.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label izg = new Label((Composite)grupa1, 0);
            izg.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_GRUPE"), new Object[0]) + ":");
            this.cvGrupeInput = this.server.readGrupeStGosti();
            this.cvGrupe = new ComboViewer((Composite)grupa1, 8);
            this.cvGrupe.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof StalniGostiGrupa) {
                        StalniGostiGrupa sgg = (StalniGostiGrupa)element;
                        return sgg.getNaziv() == null ? "" : sgg.getNaziv();
                    }
                    if (element.equals(cvGrupe.getInput())) {
                        return String.format(Konstante.getBundle().getString("TEXT_SVE_GRUPE"), new Object[0]);
                    }
                    return "";
                }
            });
            this.cvGrupe.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof StalniGostiGrupa)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.grupe = this.cvGrupe.getCombo();
            this.grupe.setEnabled(true);
            this.cvGrupe.setInput(this.cvGrupeInput);
            this.cvGrupe.setSelection((ISelection)new StructuredSelection(this.cvGrupe.getInput()));
            Label izk = new Label((Composite)grupa1, 0);
            izk.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_KOMITENTA"), new Object[0]) + ":");
            this.cvKomitent = new ComboViewer((Composite)grupa1, 8);
            this.cvKomitent.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof StalniGost) {
                        StalniGost sg = (StalniGost)element;
                        return sg.getNaziv() == null ? "" : sg.getNaziv();
                    }
                    if (element.equals(cvKomitent.getInput())) {
                        return sviKomitentiL;
                    }
                    return "";
                }
            });
            this.cvKomitent.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    LinkedList<Object> elements = new LinkedList<Object>();
                    elements.add(inputElement);
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        for (Object element : list) {
                            if (!(element instanceof StalniGost)) continue;
                            elements.add(element);
                        }
                    }
                    return elements.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.komitent = this.cvKomitent.getCombo();
            this.cvKomitentInput = new LinkedList<StalniGost>();
            this.cvKomitent.setInput(this.cvKomitentInput);
            this.cvKomitent.setSelection((ISelection)new StructuredSelection(this.cvKomitent.getInput()));
            this.komitent.setEnabled(false);
            Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]), new Date(), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label odCif = new Label((Composite)grupa1, 0);
            odCif.setText(String.format(Konstante.getBundle().getString("TEXT_POTROSNJA"), new Object[0]) + " " + String.format(Konstante.getBundle().getString("TEXT_OD"), new Object[0]) + ":");
            this.cifraOd = new TextInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_OD"), new Object[0]));
            Label doCif = new Label((Composite)grupa1, 0);
            doCif.setText(String.format(Konstante.getBundle().getString("TEXT_POTROSNJA"), new Object[0]) + " " + String.format(Konstante.getBundle().getString("TEXT_DO"), new Object[0]) + ":");
            this.cifraDo = new TextInput2(parent2, String.format(Konstante.getBundle().getString("TEXT_DO"), new Object[0]));
            Label ncl = new Label((Composite)grupa1, 0);
            ncl.setText(ResourceBundle.getBundle("barmasterText").getString("TEXT_SA_NABAVNOM_CENOM") + ":");
            this.nc = new Button((Composite)grupa1, 32);
            this.nc.setSelection(false);
            Label sg1 = new Label((Composite)grupa1, 0);
            sg1.setText(ResourceBundle.getBundle("barmasterText").getString("TEXT_PO_PRODAJNIM_CENAMA") + ":");
            this.sg = new Button((Composite)grupa1, 32);
            this.sg.setSelection(false);
            this.cvGrupe.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection iSel = (IStructuredSelection)event.getSelection();
                    cvKomitentInput.clear();
                    if (iSel.isEmpty() || !(iSel.getFirstElement() instanceof StalniGostiGrupa)) {
                        cvKomitent.getCombo().setEnabled(false);
                    } else {
                        StalniGostiGrupa sgg = (StalniGostiGrupa)iSel.getFirstElement();
                        cvKomitentInput.addAll(sgg.getStalniGosti());
                        cvKomitent.getCombo().setEnabled(true);
                    }
                    cvKomitent.refresh();
                    this.sortKomitent();
                    cvKomitent.setSelection((ISelection)new StructuredSelection(cvKomitent.getInput()));
                }
            });
            for (NacinPlacanja value : NacinPlacanja.values()) {
                Button b = new Button((Composite)grupa21, 32);
                b.setText(value.getOpis());
                b.setSelection(true);
                b.setEnabled(true);
                this.belaDugmici.add(b);
            }
            if (inspektor) {
                for (CrnoPlacanje cp : this.server.readCrnaPlacanjaIzvestaji()) {
                    Button b = new Button((Composite)grupa21, 32);
                    b.setText(cp.getNaziv());
                    b.setSelection(true);
                    b.setEnabled(true);
                    this.crnaDugmici.add(b);
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        boolean da;
                        if ((cifraOd.getResult().equals("") || cifraDo.getResult().equals("")) && !(da = Konstante.getPorukaDaNe(shell, "Ako ne popunite polja za potrosnju, \ndobicete SVU potrosnju. Da li to zelite?").isOdgovorPozitivan())) {
                            return;
                        }
                    }
                    catch (InputException e1) {
                        e1.printStackTrace();
                    }
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            izk.setLayoutData((Object)data);
            izg.setLayoutData((Object)data);
            ncl.setLayoutData((Object)data);
            sg1.setLayoutData((Object)data);
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            odCif.setLayoutData((Object)data);
            doCif.setLayoutData((Object)data);
            this.cvGrupe.getCombo().setLayoutData((Object)data);
            this.cvKomitent.getCombo().setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.cifraOd.getControl().setLayoutData((Object)data);
            this.cifraDo.getControl().setLayoutData((Object)data);
            this.nc.setLayoutData((Object)data);
            this.sg.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void sortKomitent() {
            this.cvKomitent.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals(sviKomitentiL)) {
                        return -1;
                    }
                    if (o2.equals(sviKomitentiL)) {
                        return 1;
                    }
                    return o1.compareToIgnoreCase(o2);
                }
            }));
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                StalniGostiGrupa g = null;
                IStructuredSelection gSel = (IStructuredSelection)this.cvGrupe.getSelection();
                if (!gSel.isEmpty() && gSel.getFirstElement() instanceof StalniGostiGrupa) {
                    g = (StalniGostiGrupa)gSel.getFirstElement();
                }
                StalniGost k = null;
                IStructuredSelection kSel = (IStructuredSelection)this.cvKomitent.getSelection();
                if (!kSel.isEmpty() && kSel.getFirstElement() instanceof StalniGost) {
                    k = (StalniGost)kSel.getFirstElement();
                }
                ArrayList<NacinPlacanja> bela = new ArrayList<NacinPlacanja>();
                ArrayList<String> crna = new ArrayList<String>();
                for (int i = 0; i < this.belaDugmici.size(); ++i) {
                    Button b = this.belaDugmici.get(i);
                    if (!b.getSelection()) continue;
                    bela.add(NacinPlacanja.values()[i]);
                    System.out.println("belo " + b.getText());
                }
                for (Button b : this.crnaDugmici) {
                    if (!b.getSelection()) continue;
                    crna.add(b.getText());
                }
                cifra1 = !this.cifraOd.getResult().isEmpty() ? Double.parseDouble(this.cifraOd.getResult()) : 0.0;
                cifra2 = !this.cifraDo.getResult().isEmpty() ? Double.parseDouble(this.cifraDo.getResult()) : 0.0;
                this.server.log(String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU"), new Object[0]) + ": " + String.format(Konstante.getBundle().getString("TEXT_OD_DATUMA"), new Object[0]).toLowerCase() + "->" + this.day1 + " " + String.format(Konstante.getBundle().getString("TEXT_DO_DATUMA"), new Object[0]) + " ->" + this.day2);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                shell2.setText(String.format(Konstante.getBundle().getString("TEXT_PREGLED_STALNIH_GOSTIJU_ZA_PERIOD"), new Object[0]) + ": " + StatLogic.getDateString(this.day1) + " -> " + StatLogic.getDateString(this.day2));
                new AnalizaPotrosnjeStalniGosti(shell2, this.restoran, g, k, this.day1, this.day2, bela, crna, this.nc.getSelection(), this.sg.getSelection(), cifra1, cifra2);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]), 2);
            }
        }
    }
}

