/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.hosts;

import com.dev63.restoran.hosts.Host;
import com.dev63.restoran.model.Setting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class HostHandler {
    private Properties property = this.makeProperty(this.fileName);
    private String fileName = "config/hosts.conf";

    public Properties makeProperty(String fileName) {
        File f = new File(fileName);
        Charset defaultCS = Charset.forName("UTF-8");
        if (!f.exists()) {
            try {
                f.createNewFile();
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, defaultCS);
                Properties temp = new Properties();
                Host host = new Host("Localhost", "Localhost", "localhost", "restoran", "root", "928374");
                temp.setProperty(host.getKey(), host.makeValue());
                temp.store(fos, "");
                osw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileInputStream fis = null;
        Properties prop = null;
        try {
            fis = new FileInputStream(fileName);
            prop = new Properties();
            prop.load(fis);
            fis.close();
            return prop;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void insertHost(Host host) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileName);
            this.property.setProperty(host.getKey(), host.makeValue());
            this.property.store(fos, "");
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readHosts() {
        this.property.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.out.println("Key : " + k + ", Value : " + v)));
    }

    public void editKey(String oldKey, Host host) {
        FileOutputStream fos = null;
        String key = "";
        try {
            fos = new FileOutputStream(this.fileName);
            Enumeration<?> enums = this.property.propertyNames();
            while (enums.hasMoreElements()) {
                key = (String)enums.nextElement();
                if (!key.equals(oldKey)) continue;
                this.property.remove(key);
                this.property.setProperty(host.getKey(), host.makeValue());
                break;
            }
            this.property.store(fos, "");
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void populateTable(Table table) {
        table.removeAll();
        Enumeration<?> enums = this.property.propertyNames();
        while (enums.hasMoreElements()) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, (String)enums.nextElement());
        }
        table.setSelection(0);
    }

    public Host getHostForEdit(String key) {
        String[] values = this.property.getProperty(key).split("~");
        Host editHost = new Host();
        editHost.setKey(key);
        editHost.setHostAddress(values[1]);
        editHost.setHostShemaName(values[2]);
        editHost.setHostUser(values[3]);
        try {
            editHost.setHostPassword(Setting.decrypt(values[4]));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        return editHost;
    }

    public boolean isExsistingHost(String keyForCheck) {
        String key = "";
        Enumeration<?> enums = this.property.propertyNames();
        while (enums.hasMoreElements()) {
            key = (String)enums.nextElement();
            if (!key.toLowerCase().equals(keyForCheck.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void deleteHost(String deleteKey) {
        FileOutputStream fos = null;
        String key = "";
        try {
            fos = new FileOutputStream(this.fileName);
            Enumeration<?> enums = this.property.propertyNames();
            while (enums.hasMoreElements()) {
                key = (String)enums.nextElement();
                if (!key.toLowerCase().equals(deleteKey.toLowerCase())) continue;
                this.property.remove(key);
                break;
            }
            this.property.store(fos, "");
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

