/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.hosts;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTModels;
import com.dev63.restoran.hosts.Host;
import com.dev63.restoran.hosts.HostHandler;
import com.dev63.restoran.swt.resources.ImageCache;
import java.util.ResourceBundle;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostChoiceNew
extends SWTModels {
    RestoranServer server;
    private final ResourceBundle barmasterText;
    private Shell shell;
    private Display display;
    private String shellName;
    private String[] columns;
    private int[] columnsWidths;
    private HostHandler hHandler;
    private Host host;
    String oldKey;

    public HostChoiceNew(RestoranServer server) {
        this.server = server;
        this.hHandler = new HostHandler();
        this.display = Display.getDefault();
        this.barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        this.shellName = this.barmasterText.getString("TEXT_PREGLED_HOSTOVA");
        this.host = null;
        this.oldKey = "";
        this.columns = new String[1];
        this.columnsWidths = new int[1];
        this.columns[0] = this.barmasterText.getString("TEXT_NAZIV_HOSTA");
        this.columnsWidths[0] = 150;
        this.shell = this.makeShell(400, 400, new Shell(), this.shellName, 2);
        this.shellSetCenter(this.shell);
        this.shell.setBackground(this.display.getSystemColor(1));
        this.showHostsView();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public Host getHost() {
        return this.host;
    }

    public Shell getShell() {
        return this.shell;
    }

    private void showHostsView() {
        final Table hostTable = this.makeTable((Composite)this.shell, this.columns, this.columnsWidths, 1, 3);
        hostTable.setBackground(this.display.getSystemColor(1));
        final Composite buttons = this.makeComposite((Composite)this.shell, 1, 200, 150, 1, 1, 15, 5, 5, 15);
        buttons.setBackground(this.display.getSystemColor(1));
        buttons.setVisible(false);
        hostTable.setLinesVisible(false);
        Button newHost = this.makeButton(buttons, 0, 0, 0, 0, this.barmasterText.getString("TEXT_NOVI_HOST"));
        Button editHost = this.makeButton(buttons, 0, 0, 0, 0, this.barmasterText.getString("TEXT_IZMENA_HOSTA"));
        Button deleteHost = this.makeButton(buttons, 0, 0, 0, 0, this.barmasterText.getString("TEXT_BRISANJE_HOSTA"));
        Image image2 = ImageCache.getImage("BMaster-kvadrat.png");
        this.makeLabel((Composite)this.shell, "", 200, 100, image2, 1, 1);
        Composite confirmCancel = this.makeComposite((Composite)this.shell, 2, 200, 70, 1, 1, 5, 5, 5, 5);
        confirmCancel.setBackground(this.display.getSystemColor(1));
        Button cancel = this.makeButton(confirmCancel, 0, 0, 0, 0, this.barmasterText.getString("TEXT_OTKAZI"));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                System.exit(0);
            }
        });
        Button confirm = this.makeButton(confirmCancel, 0, 0, 0, 0, this.barmasterText.getString("TEXT_POTVRDI"));
        confirm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = hostTable.getSelection()[0];
                HostChoiceNew.this.host = HostChoiceNew.this.hHandler.getHostForEdit(item.getText(0));
                HostChoiceNew.this.shell.close();
            }
        });
        hostTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000A) {
                    buttons.setVisible(!buttons.isVisible());
                }
            }
        });
        newHost.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HostChoiceNew.this.openNewHostWindow(hostTable, false);
            }
        });
        editHost.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                HostChoiceNew.this.openNewHostWindow(hostTable, true);
            }
        });
        deleteHost.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = hostTable.getSelection()[0];
                HostChoiceNew.this.hHandler.deleteHost(item.getText(0));
                HostChoiceNew.this.hHandler.populateTable(hostTable);
            }
        });
        this.hHandler.populateTable(hostTable);
    }

    private void openNewHostWindow(final Table table, final boolean hostEdit) {
        TableItem item;
        String title = this.barmasterText.getString("TEXT_NOVI_HOST");
        if (hostEdit) {
            title = this.barmasterText.getString("TEXT_IZMENA_HOSTA");
        }
        final Shell newHostWindow = this.makeShell(350, 300, this.shell, title, 2);
        this.shellSetCenter(newHostWindow);
        this.makeLabel((Composite)newHostWindow, this.barmasterText.getString("TEXT_NAZIV_HOSTA"), 80, 30, null, 1, 1);
        final Text tfHostName = this.makeTextField((Composite)newHostWindow, "", 200, 30, true, 1, 1);
        this.makeLabel((Composite)newHostWindow, this.barmasterText.getString("TEXT_ADRESA"), 80, 30, null, 1, 1);
        final Text tfHostAddress = this.makeTextField((Composite)newHostWindow, "", 200, 30, true, 1, 1);
        this.makeLabel((Composite)newHostWindow, this.barmasterText.getString("TEXT_NAZIV_BAZE"), 80, 30, null, 1, 1);
        final Text tfHostDb = this.makeTextField((Composite)newHostWindow, "", 200, 30, true, 1, 1);
        this.makeLabel((Composite)newHostWindow, this.barmasterText.getString("TEXT_USER_NAME"), 80, 30, null, 1, 1);
        final Text tfHostUser = this.makeTextField((Composite)newHostWindow, "", 200, 30, true, 1, 1);
        this.makeLabel((Composite)newHostWindow, this.barmasterText.getString("TEXT_SIFRA"), 80, 30, null, 1, 1);
        final Text tfHostPass = this.makePassField((Composite)newHostWindow, "", 200, 30, true, 1, 1);
        if (hostEdit && (item = table.getSelection()[0]) != null) {
            Host editHost = this.hHandler.getHostForEdit(item.getText(0));
            tfHostName.setText(editHost.getKey());
            tfHostAddress.setText(editHost.getHostAddress());
            tfHostDb.setText(editHost.getHostShemaName());
            tfHostUser.setText(editHost.getHostUser());
            tfHostPass.setText(editHost.getHostPassword());
            this.oldKey = tfHostName.getText();
        }
        this.makeLabel((Composite)newHostWindow, "", 0, 0, null, 1, 1);
        Composite confirmCancel = this.makeComposite((Composite)newHostWindow, 2, 10, 10, 10, 10);
        Button cancel = this.makeButton(confirmCancel, 80, 35, 0, 0, this.barmasterText.getString("TEXT_OTKAZI"));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                newHostWindow.close();
            }
        });
        Button confirm = this.makeButton(confirmCancel, 80, 35, 0, 0, this.barmasterText.getString("TEXT_POTVRDI"));
        confirm.addListener(13, new Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleEvent(Event event) {
                if (HostChoiceNew.this.isFieldEmpty(tfHostName, tfHostAddress, tfHostDb, tfHostUser, tfHostPass)) {
                    Konstante.prikaziMessageBox(newHostWindow, HostChoiceNew.this.barmasterText.getString("TEXT_MORATE_POPUNITI_SVA_POLJA"));
                    return;
                }
                Host host = new Host(tfHostName.getText(), tfHostName.getText(), tfHostAddress.getText(), tfHostDb.getText(), tfHostUser.getText(), tfHostPass.getText());
                if (hostEdit) {
                    if (HostChoiceNew.this.oldKey.equals(tfHostName.getText())) {
                        HostChoiceNew.this.hHandler.insertHost(host);
                    } else {
                        if (HostChoiceNew.this.hHandler.isExsistingHost(host.getKey())) {
                            Konstante.prikaziMessageBox(newHostWindow, HostChoiceNew.this.barmasterText.getString("PORUKA_HOST_SA_IMENOM_POSTOJI"));
                            return;
                        }
                        HostChoiceNew.this.hHandler.editKey(HostChoiceNew.this.oldKey, host);
                    }
                } else {
                    if (HostChoiceNew.this.hHandler.isExsistingHost(host.getKey())) {
                        Konstante.prikaziMessageBox(newHostWindow, HostChoiceNew.this.barmasterText.getString("PORUKA_HOST_SA_IMENOM_POSTOJI"));
                        return;
                    }
                    HostChoiceNew.this.hHandler.insertHost(host);
                }
                HostChoiceNew.this.hHandler.populateTable(table);
                newHostWindow.close();
            }
        });
        newHostWindow.open();
        this.shell.setEnabled(false);
        while (!newHostWindow.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.shell.setEnabled(true);
    }

    @Override
    public void shellSetCenter(Shell shell) {
        Monitor primary = this.display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    private boolean isFieldEmpty(Text hostName, Text hostAddress, Text hostDb, Text hostUser, Text hostPass) {
        if (hostName.getText().trim().isEmpty()) {
            return true;
        }
        if (hostAddress.getText().trim().isEmpty()) {
            return true;
        }
        if (hostDb.getText().trim().isEmpty()) {
            return true;
        }
        if (hostUser.getText().trim().isEmpty()) {
            return true;
        }
        return hostPass.getText().trim().isEmpty();
    }
}

